/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;

public class HotSpotToSVMScope<T extends Enum<T>>
implements AutoCloseable {
    private static final ThreadLocal<HotSpotToSVMScope<?>> topScope = new ThreadLocal();
    private final JNI.JNIEnv env;
    private final HotSpotToSVMScope<?> parent;
    private HotSpotToSVMScope<?> leaf;
    HSObject locals;
    private final Enum<T> id;
    private JNI.JObject objResult;

    public static JNI.JNIEnv env() {
        return HotSpotToSVMScope.scope().env;
    }

    public JNI.JNIEnv getEnv() {
        return this.env;
    }

    public static HotSpotToSVMScope<?> scopeOrNull() {
        HotSpotToSVMScope<?> scope = topScope.get();
        if (scope == null) {
            return null;
        }
        return scope.leaf;
    }

    public static HotSpotToSVMScope<?> scope() {
        HotSpotToSVMScope<?> scope = topScope.get();
        if (scope == null) {
            throw new IllegalStateException("Not in the scope of an SVM call");
        }
        return scope.leaf;
    }

    public <P extends Enum<P>> HotSpotToSVMScope<P> narrow(Class<P> scopeIdType) {
        if (this.id.getClass() != scopeIdType) {
            throw new ClassCastException("Expected HotSpotToSVMScope type is " + scopeIdType + " but actual type is " + this.id.getClass());
        }
        return this;
    }

    public HotSpotToSVMScope(Enum<T> id, JNI.JNIEnv env) {
        JNIUtil.trace(1, "HS->SVM[enter]: %s", id);
        this.id = id;
        HotSpotToSVMScope top = topScope.get();
        this.env = env;
        if (top == null) {
            JNIUtil.PushLocalFrame(env, 64);
            top = this;
            this.parent = null;
            topScope.set(this);
        } else {
            if (top.env != this.env) {
                throw new IllegalStateException("Cannot mix JNI scopes: " + this + " and " + top);
            }
            this.parent = top.leaf;
        }
        top.leaf = this;
    }

    public void setObjectResult(JNI.JObject obj) {
        this.objResult = obj;
    }

    public <R extends JNI.JObject> R getObjectResult() {
        return (R)this.objResult;
    }

    @Override
    public void close() {
        HSObject.invalidate(this.locals);
        if (this.parent == null) {
            if (topScope.get() != this) {
                throw new IllegalStateException("Unexpected JNI scope: " + topScope.get());
            }
            topScope.set(null);
            this.objResult = JNIUtil.PopLocalFrame(this.env, this.objResult);
        } else {
            HotSpotToSVMScope<?> top = this.parent;
            while (top.parent != null) {
                top = top.parent;
            }
            top.leaf = this.parent;
        }
        JNIUtil.trace(1, "HS->SVM[ exit]: %s", this.id);
    }

    int depth() {
        int depth = 0;
        HotSpotToSVMScope<?> ancestor = this.parent;
        while (ancestor != null) {
            ++depth;
            ancestor = ancestor.parent;
        }
        return depth;
    }

    public String toString() {
        return "SVMCall[" + this.depth() + "]@" + Long.toHexString(this.env.rawValue());
    }
}

