/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;

public abstract class HSObject {
    private final JNI.JObject handle;
    private final Cleaner cleaner;
    private HSObject next;
    private static final Set<Cleaner> CLEANERS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ReferenceQueue<HSObject> CLEANERS_QUEUE = new ReferenceQueue();

    protected HSObject(JNI.JNIEnv env, JNI.JObject handle) {
        HSObject.cleanHandles(env);
        if (Assertions.assertionsEnabled() || JNIUtil.tracingAt(1)) {
            HSObject.checkNonExistingGlobalReference(env, handle);
        }
        this.handle = JNIUtil.NewGlobalRef(env, handle, this.getClass().getSimpleName());
        this.cleaner = new Cleaner(this, this.handle);
        CLEANERS.add(this.cleaner);
        this.next = null;
    }

    protected <T extends Enum<T>> HSObject(HotSpotToSVMScope<T> scope, JNI.JObject handle) {
        this.handle = handle;
        this.next = scope.locals;
        scope.locals = this;
        this.cleaner = null;
    }

    static int invalidate(HSObject head) {
        HSObject o = head;
        int count = 0;
        while (o != null) {
            HSObject next = o.next;
            o.next = o;
            o = next;
            ++count;
        }
        return count;
    }

    public JNI.JObject getHandle() {
        if (this.next == this) {
            throw new IllegalArgumentException("Reclaimed JNI reference: " + this);
        }
        return this.handle;
    }

    public String toString() {
        return String.format("%s[0x%x]", this.getClass().getSimpleName(), this.handle.rawValue());
    }

    public void release(JNI.JNIEnv env) {
        if (this.cleaner != null) {
            assert (this.next == null || this.next == this);
            this.next = this;
            this.cleaner.clean(env);
        }
    }

    public static void cleanHandles(JNI.JNIEnv env) {
        Cleaner cleaner;
        while ((cleaner = (Cleaner)CLEANERS_QUEUE.poll()) != null) {
            cleaner.clean(env);
        }
    }

    private static void checkNonExistingGlobalReference(JNI.JNIEnv env, JNI.JObject handle) {
        for (Cleaner cleaner : CLEANERS) {
            if (!JNIUtil.IsSameObject(env, handle, cleaner.handle)) continue;
            throw new IllegalArgumentException("Global JNI handle already exists for object referenced by " + handle.rawValue());
        }
    }

    static /* synthetic */ ReferenceQueue access$100() {
        return CLEANERS_QUEUE;
    }

    static /* synthetic */ Set access$200() {
        return CLEANERS;
    }

    private static final class Cleaner
    extends PhantomReference<HSObject> {
        private final JNI.JObject handle;

        Cleaner(HSObject referent, JNI.JObject handle) {
            super(referent, CLEANERS_QUEUE);
            this.handle = handle;
        }

        void clean(JNI.JNIEnv env) {
            if (CLEANERS.remove(this)) {
                JNIUtil.DeleteGlobalRef(env, this.handle);
            }
        }
    }
}

