/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.snapshot.diff;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.lib.common.CommonUtils;
import org.graalvm.visualvm.lib.profiler.SnapshotResultsWindow;
import org.graalvm.visualvm.profiling.snapshot.diff.SnapshotDiffContainer;
import org.graalvm.visualvm.uisupport.UISupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class SnapshotDiffView
extends DataSourceView {
    private static final Logger LOGGER = Logger.getLogger(SnapshotDiffView.class.getName());
    private SnapshotResultsWindow sdw = null;

    public SnapshotDiffView(SnapshotDiffContainer snapshotDiff) {
        super((DataSource)snapshotDiff, NbBundle.getMessage(SnapshotDiffView.class, (String)"LBL_Snapshots_Comparison"), ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/diff.png", (boolean)true), 0x7FFFFFFE, true);
    }

    protected void removed() {
        if (this.sdw != null) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Method method = SnapshotDiffView.this.sdw.getClass().getDeclaredMethod("componentClosed", new Class[0]);
                        if (method != null) {
                            method.setAccessible(true);
                            method.invoke((Object)SnapshotDiffView.this.sdw, new Object[0]);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        LOGGER.throwing(SnapshotDiffView.class.getName(), "removed", noSuchMethodException);
                    }
                    catch (SecurityException securityException) {
                        LOGGER.throwing(SnapshotDiffView.class.getName(), "removed", securityException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        LOGGER.throwing(SnapshotDiffView.class.getName(), "removed", illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOGGER.throwing(SnapshotDiffView.class.getName(), "removed", illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        LOGGER.throwing(SnapshotDiffView.class.getName(), "removed", invocationTargetException);
                    }
                    SnapshotDiffView.this.sdw = null;
                }
            });
        }
    }

    protected DataViewComponent createComponent() {
        SnapshotDiffContainer snapshotDiff = (SnapshotDiffContainer)this.getDataSource();
        return new DataViewComponent(new MasterViewSupport().getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
    }

    private class MasterViewSupport
    extends JPanel {
        private MasterViewSupport() {
        }

        public DataViewComponent.MasterView getMasterView() {
            try {
                JComponent memoryDiffPanel = (JComponent)SnapshotDiffView.this.sdw.getComponent(0);
                memoryDiffPanel.setOpaque(false);
                final JToolBar toolBar = (JToolBar)memoryDiffPanel.getComponent(1);
                toolBar.setOpaque(false);
                ((JComponent)toolBar.getComponent(0)).setOpaque(false);
                ((JComponent)toolBar.getComponent(1)).setOpaque(false);
                ((JComponent)toolBar.getComponent(3)).setOpaque(false);
                ((JComponent)toolBar.getComponent(4)).setOpaque(false);
                ((JComponent)toolBar.getComponent(5)).setOpaque(false);
                JPanel toolbarSpacer = new JPanel(null){

                    @Override
                    public Dimension getPreferredSize() {
                        if (UISupport.isGTKLookAndFeel() || UISupport.isNimbusLookAndFeel()) {
                            int currentWidth = toolBar.getSize().width;
                            int minimumWidth = toolBar.getMinimumSize().width;
                            int extraWidth = currentWidth - minimumWidth;
                            return new Dimension(Math.max(extraWidth, 0), 0);
                        }
                        return super.getPreferredSize();
                    }
                };
                toolbarSpacer.setOpaque(false);
                Component descriptionLabel = toolBar.getComponent(7);
                toolBar.remove(descriptionLabel);
                toolBar.remove(6);
                toolBar.add(toolbarSpacer);
                toolBar.add(descriptionLabel);
            }
            catch (Exception memoryDiffPanel) {
                // empty catch block
            }
            SnapshotDiffView.this.sdw.setPreferredSize(new Dimension(1, 1));
            SnapshotDiffContainer snapshotDiff = (SnapshotDiffContainer)SnapshotDiffView.this.getDataSource();
            String caption = NbBundle.getMessage(SnapshotDiffView.class, (String)"DESCR_Snapshots_Comparison", (Object[])new Object[]{DataSourceDescriptorFactory.getDescriptor((DataSource)snapshotDiff.getSnapshot1()).getName(), DataSourceDescriptorFactory.getDescriptor((DataSource)snapshotDiff.getSnapshot2()).getName()});
            return new DataViewComponent.MasterView(caption, null, (JComponent)SnapshotDiffView.this.sdw);
        }
    }
}

