/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.llvm;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.LLVM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.core.llvm.LLVMGenerator;
import org.graalvm.compiler.core.llvm.LLVMIRBuilder;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerTestNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.java.TypeSwitchNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.NodeValueMap;

public abstract class NodeLLVMBuilder
implements NodeLIRBuilderTool {
    protected final LLVMGenerator gen;
    protected final LLVMIRBuilder builder;
    private final DebugInfoBuilder debugInfoBuilder;
    private Map<Node, LLVMUtils.LLVMValueWrapper> valueMap = new HashMap<Node, LLVMUtils.LLVMValueWrapper>();
    private Map<ValuePhiNode, LLVM.LLVMValueRef> backwardsPhi = new HashMap<ValuePhiNode, LLVM.LLVMValueRef>();
    private long startPatchpointID = -1L;

    protected NodeLLVMBuilder(StructuredGraph graph, LLVMGenerator gen, BiFunction<NodeValueMap, DebugContext, DebugInfoBuilder> debugInfoProvider) {
        this.gen = gen;
        this.builder = gen.getBuilder();
        this.debugInfoBuilder = debugInfoProvider.apply((NodeValueMap)this, graph.getDebug());
        gen.getBuilder().addMainFunction(gen.getLLVMFunctionType(graph.method(), true));
        for (Block block : graph.getLastSchedule().getCFG().getBlocks()) {
            gen.appendBasicBlock(block);
        }
    }

    public LLVMGenerator getLIRGeneratorTool() {
        return this.gen;
    }

    private LLVM.LLVMTypeRef getLLVMType(ValueNode node) {
        return this.gen.getLLVMType(node.stamp(NodeView.DEFAULT));
    }

    public void doBlock(Block block, StructuredGraph graph, BlockMap<List<Node>> blockMap) {
        this.gen.beginBlock(block);
        if (block == graph.getLastSchedule().getCFG().getStartBlock()) {
            assert (block.getPredecessorCount() == 0);
            this.startPatchpointID = LLVMIRBuilder.nextPatchpointId.getAndIncrement();
            this.gen.getLLVMResult().setStartPatchpointID(this.startPatchpointID);
            this.builder.buildStackmap(this.builder.constantLong(this.startPatchpointID), new LLVM.LLVMValueRef[0]);
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                LLVM.LLVMValueRef paramValue = this.builder.getParam(this.getParamIndex(param.index()));
                this.setResult((ValueNode)param, paramValue);
            }
            this.gen.allocateRegisterSlots();
            if (this.gen.getDebugLevel() >= 1) {
                this.gen.indent();
                ArrayList<JavaKind> printfTypes = new ArrayList<JavaKind>();
                ArrayList<LLVM.LLVMValueRef> printfArgs = new ArrayList<LLVM.LLVMValueRef>();
                for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                    printfTypes.add(param.getStackKind());
                    printfArgs.add(this.llvmOperand((Node)param));
                }
                String functionName = this.builder.getFunctionName();
                this.gen.emitPrintf("In " + (String)functionName, printfTypes.toArray(new JavaKind[0]), printfArgs.toArray(new LLVM.LLVMValueRef[0]));
            }
        } else {
            assert (block.getPredecessorCount() > 0);
            AbstractBeginNode begin = block.getBeginNode();
            if (begin instanceof AbstractMergeNode) {
                AbstractMergeNode merge = (AbstractMergeNode)begin;
                for (ValuePhiNode phiNode : merge.valuePhis()) {
                    ArrayList<LLVM.LLVMValueRef> forwardPhis = new ArrayList<LLVM.LLVMValueRef>();
                    ArrayList<LLVM.LLVMBasicBlockRef> forwardBlocks = new ArrayList<LLVM.LLVMBasicBlockRef>();
                    LLVM.LLVMTypeRef phiType = this.getLLVMType((ValueNode)phiNode);
                    boolean hasBackwardIncomingEdges = false;
                    for (Block predecessor : (Block[])block.getPredecessors()) {
                        if (this.gen.getLLVMResult().isProcessed((AbstractBlockBase<?>)predecessor)) {
                            ValueNode phiValue = phiNode.valueAt((AbstractEndNode)predecessor.getEndNode());
                            LLVM.LLVMValueRef value = this.llvmOperand((Node)phiValue);
                            LLVM.LLVMBasicBlockRef parentBlock = this.gen.getBlockEnd(predecessor);
                            forwardPhis.add(value);
                            forwardBlocks.add(parentBlock);
                            continue;
                        }
                        hasBackwardIncomingEdges = true;
                    }
                    LLVM.LLVMValueRef[] incomingValues = forwardPhis.toArray(new LLVM.LLVMValueRef[0]);
                    LLVM.LLVMBasicBlockRef[] incomingBlocks = forwardBlocks.toArray(new LLVM.LLVMBasicBlockRef[0]);
                    LLVM.LLVMValueRef phi = this.builder.buildPhi(phiType, incomingValues, incomingBlocks);
                    if (hasBackwardIncomingEdges) {
                        this.backwardsPhi.put(phiNode, phi);
                    }
                    this.setResult((ValueNode)phiNode, phi);
                }
            }
        }
        if (this.gen.getDebugLevel() >= 2) {
            this.gen.emitPrintf("In block " + block.toString());
        }
        for (Node node : (List)blockMap.get((AbstractBlockBase)block)) {
            if (!(node instanceof ValueNode) || this.valueMap.containsKey(node)) continue;
            ValueNode valueNode = (ValueNode)node;
            try {
                if (this.gen.getDebugLevel() >= 3) {
                    this.gen.emitPrintf(valueNode.toString());
                }
                this.doRoot(valueNode);
            }
            catch (GraalError e) {
                throw GraalGraphError.transformAndAddContext((GraalError)e, (Node)valueNode);
            }
            catch (Throwable e) {
                throw new GraalGraphError(e).addContext((Node)valueNode);
            }
        }
        if (this.builder.blockTerminator(this.gen.getBlockEnd(block)) == null) {
            NodeIterable successors = block.getEndNode().successors();
            assert (successors.count() == block.getSuccessorCount());
            if (block.getSuccessorCount() != 1) {
                throw new GraalError("Block without BlockEndOp: " + block.getEndNode());
            }
            this.builder.buildBranch(this.gen.getBlock(block.getFirstSuccessor()));
        }
        this.gen.getLLVMResult().setProcessed((AbstractBlockBase<?>)block);
    }

    protected abstract int getParamIndex(int var1);

    public void matchBlock(Block b, StructuredGraph graph, StructuredGraph.ScheduleResult blockMap) {
    }

    private void doRoot(ValueNode instr) {
        DebugContext debug = instr.getDebug();
        debug.log("Visiting %s", (Object)instr);
        this.emitNode(instr);
        debug.log("Operand for %s = %s", (Object)instr, (Object)this.operand((Node)instr));
    }

    private void emitNode(ValueNode node) {
        if (node.getDebug().isLogEnabled() && node.stamp(NodeView.DEFAULT).isEmpty()) {
            node.getDebug().log("This node has an empty stamp, we are emitting dead code(?): %s", (Object)node);
        }
        this.setSourcePosition(node.getNodeSourcePosition());
        if (!(node instanceof LIRLowerable)) {
            throw GraalError.shouldNotReachHere((String)("node is not LIRLowerable: " + node));
        }
        ((LIRLowerable)node).generate((NodeLIRBuilderTool)this);
    }

    void finish() {
        this.gen.getLLVMResult().setBitcode(this.builder.getBitcode());
    }

    public void emitIf(IfNode i) {
        LLVM.LLVMValueRef condition = this.emitCondition(i.condition());
        LLVM.LLVMBasicBlockRef thenBlock = this.gen.getBlock(i.trueSuccessor());
        LLVM.LLVMBasicBlockRef elseBlock = this.gen.getBlock(i.falseSuccessor());
        LLVM.LLVMValueRef instr = this.builder.buildIf(condition, thenBlock, elseBlock);
        int trueProbability = NodeLLVMBuilder.expandProbability(i.getTrueSuccessorProbability());
        int falseProbability = NodeLLVMBuilder.expandProbability(1.0 - i.getTrueSuccessorProbability());
        LLVM.LLVMValueRef branchWeights = this.builder.branchWeights(this.builder.constantInt(trueProbability), this.builder.constantInt(falseProbability));
        this.builder.setMetadata(instr, "prof", branchWeights);
    }

    private static int expandProbability(double probability) {
        return (int)(probability * 2.147483647E9);
    }

    protected LLVM.LLVMValueRef emitCondition(LogicNode condition) {
        if (condition instanceof IsNullNode) {
            return this.builder.buildIsNull(this.llvmOperand((Node)((IsNullNode)condition).getValue()));
        }
        if (condition instanceof LogicConstantNode) {
            return this.builder.constantBoolean(((LogicConstantNode)condition).getValue());
        }
        if (condition instanceof CompareNode) {
            CompareNode compareNode = (CompareNode)condition;
            return this.builder.buildCompare(compareNode.condition().asCondition(), this.llvmOperand((Node)compareNode.getX()), this.llvmOperand((Node)compareNode.getY()), compareNode.unorderedIsTrue());
        }
        if (condition instanceof IntegerTestNode) {
            IntegerTestNode integerTestNode = (IntegerTestNode)condition;
            LLVM.LLVMValueRef and = this.builder.buildAnd(this.llvmOperand((Node)integerTestNode.getX()), this.llvmOperand((Node)integerTestNode.getY()));
            return this.builder.buildIsNull(and);
        }
        throw GraalError.shouldNotReachHere((String)("logic node: " + condition.getClass().getName()));
    }

    public void emitConditional(ConditionalNode conditional) {
        Value tVal = this.operand((Node)conditional.trueValue());
        Value fVal = this.operand((Node)conditional.falseValue());
        this.setResult((ValueNode)conditional, (Value)this.emitConditional(conditional.condition(), tVal, fVal));
    }

    private Variable emitConditional(LogicNode node, Value trueValue, Value falseValue) {
        if (node instanceof IsNullNode) {
            IsNullNode isNullNode = (IsNullNode)node;
            return this.gen.emitIsNullMove(this.operand((Node)isNullNode.getValue()), trueValue, falseValue);
        }
        if (node instanceof CompareNode) {
            CompareNode compare = (CompareNode)node;
            return this.gen.emitConditionalMove(null, this.operand((Node)compare.getX()), this.operand((Node)compare.getY()), compare.condition().asCondition(), compare.unorderedIsTrue(), trueValue, falseValue);
        }
        if (node instanceof LogicConstantNode) {
            return this.gen.emitMove(((LogicConstantNode)node).getValue() ? trueValue : falseValue);
        }
        if (node instanceof IntegerTestNode) {
            IntegerTestNode test = (IntegerTestNode)node;
            return this.gen.emitIntegerTestMove(this.operand((Node)test.getX()), this.operand((Node)test.getY()), trueValue, falseValue);
        }
        throw GraalError.unimplemented((String)node.toString());
    }

    public void emitSwitch(SwitchNode switchNode) {
        if (switchNode instanceof TypeSwitchNode) {
            this.emitTypeSwitch((TypeSwitchNode)switchNode);
            return;
        }
        int numCases = switchNode.keyCount();
        LLVM.LLVMValueRef[] values = new LLVM.LLVMValueRef[numCases];
        LLVM.LLVMBasicBlockRef[] blocks = new LLVM.LLVMBasicBlockRef[numCases];
        LLVM.LLVMValueRef[] weights = new LLVM.LLVMValueRef[numCases + 1];
        int defaultProbability = NodeLLVMBuilder.expandProbability(switchNode.probability(switchNode.defaultSuccessor()));
        weights[0] = this.builder.constantInt(defaultProbability);
        for (int i = 0; i < numCases; ++i) {
            JavaConstant key = (JavaConstant)switchNode.keyAt(i);
            values[i] = this.builder.constantInt(key.asInt());
            blocks[i] = this.gen.getBlock(switchNode.keySuccessor(i));
            int keyProbability = NodeLLVMBuilder.expandProbability(switchNode.probability(switchNode.keySuccessor(i)));
            weights[i + 1] = this.builder.constantInt(keyProbability);
        }
        LLVM.LLVMValueRef switchInstr = this.builder.buildSwitch(this.llvmOperand((Node)switchNode.value()), this.gen.getBlock(switchNode.defaultSuccessor()), values, blocks);
        LLVM.LLVMValueRef branchWeights = this.builder.branchWeights(weights);
        this.builder.setMetadata(switchInstr, "prof", branchWeights);
    }

    private void emitTypeSwitch(TypeSwitchNode switchNode) {
        int numCases = switchNode.keyCount();
        LLVM.LLVMValueRef value = this.llvmOperand((Node)switchNode.value());
        LLVM.LLVMBasicBlockRef defaultSuccessor = this.gen.getBlock(switchNode.defaultSuccessor());
        switch (numCases) {
            case 0: {
                this.builder.buildBranch(defaultSuccessor);
                break;
            }
            case 1: {
                LLVM.LLVMValueRef hub = this.gen.emitLLVMConstant(this.builder.objectType(), (JavaConstant)switchNode.keyAt(0));
                LLVM.LLVMValueRef cond = this.builder.buildCompare(Condition.EQ, value, hub, false);
                this.builder.buildIf(cond, this.gen.getBlock(switchNode.keySuccessor(0)), defaultSuccessor);
                break;
            }
            default: {
                throw GraalError.unimplemented();
            }
        }
    }

    public void emitInvoke(Invoke i) {
        boolean isVoid;
        LLVM.LLVMValueRef callee;
        LoweredCallTargetNode callTarget = (LoweredCallTargetNode)i.callTarget();
        ResolvedJavaMethod targetMethod = callTarget.targetMethod();
        NodeInputList arguments = callTarget.arguments();
        LLVM.LLVMValueRef[] args = this.getCallArguments((NodeInputList<ValueNode>)arguments, callTarget.callType(), targetMethod);
        LIRFrameState state = this.state((DeoptimizingNode)i);
        state.initDebugInfo(null, false);
        DebugInfo debugInfo = state.debugInfo();
        long patchpointId = LLVMIRBuilder.nextPatchpointId.getAndIncrement();
        if (callTarget instanceof DirectCallTargetNode) {
            callee = this.gen.getFunction(targetMethod);
            isVoid = LLVMIRBuilder.isVoidType(this.gen.getLLVMFunctionReturnType(targetMethod, false));
            this.gen.getLLVMResult().recordDirectCall(targetMethod, patchpointId, debugInfo);
        } else if (callTarget instanceof IndirectCallTargetNode) {
            LLVM.LLVMValueRef computedAddress = this.llvmOperand((Node)((IndirectCallTargetNode)callTarget).computedAddress());
            if (LLVMIRBuilder.isObject(LLVMIRBuilder.typeOf(computedAddress))) {
                computedAddress = this.builder.buildPtrToInt(computedAddress, this.builder.longType());
            }
            if (targetMethod != null) {
                callee = this.builder.buildIntToPtr(computedAddress, this.builder.pointerType(this.gen.getLLVMFunctionType(targetMethod, false), false));
                isVoid = LLVMIRBuilder.isVoidType(this.gen.getLLVMFunctionReturnType(targetMethod, false));
            } else {
                LLVM.LLVMTypeRef returnType = this.gen.getLLVMType(callTarget.returnStamp().getTrustedStamp());
                isVoid = LLVMIRBuilder.isVoidType(returnType);
                LLVM.LLVMTypeRef[] argTypes = this.getUnknownCallArgumentTypes((NodeInputList<ValueNode>)arguments, callTarget);
                assert (args.length == argTypes.length);
                callee = this.builder.buildIntToPtr(computedAddress, this.builder.pointerType(this.builder.functionType(returnType, argTypes), false));
            }
            this.gen.getLLVMResult().recordIndirectCall(targetMethod, patchpointId, debugInfo);
            if (this.gen.getDebugLevel() >= 3) {
                this.gen.emitPrintf("Indirect call to " + (targetMethod != null ? targetMethod.getName() : "[unknown]"), new JavaKind[]{JavaKind.Object}, new LLVM.LLVMValueRef[]{callee});
            }
        } else {
            throw GraalError.shouldNotReachHere();
        }
        LLVM.LLVMValueRef call = this.emitCall(i, callTarget, callee, patchpointId, args);
        if (!isVoid) {
            this.setResult((ValueNode)i.asNode(), call);
        }
    }

    protected LLVM.LLVMValueRef emitCall(Invoke invoke, LoweredCallTargetNode callTarget, LLVM.LLVMValueRef callee, long patchpointId, LLVM.LLVMValueRef ... args) {
        LLVM.LLVMValueRef call;
        if (invoke instanceof InvokeWithExceptionNode) {
            InvokeWithExceptionNode invokeWithExceptionNode = (InvokeWithExceptionNode)invoke;
            LLVM.LLVMBasicBlockRef successor = this.gen.getBlock(invokeWithExceptionNode.next());
            LLVM.LLVMBasicBlockRef handler = this.gen.getBlock(invokeWithExceptionNode.exceptionEdge());
            call = this.builder.buildInvoke(callee, successor, handler, patchpointId, args);
        } else {
            call = this.builder.buildCall(callee, patchpointId, args);
        }
        return call;
    }

    protected LLVM.LLVMValueRef[] getCallArguments(NodeInputList<ValueNode> arguments, CallingConvention.Type callType, ResolvedJavaMethod targetMethod) {
        return (LLVM.LLVMValueRef[])arguments.stream().map(this::llvmOperand).toArray(LLVM.LLVMValueRef[]::new);
    }

    protected LLVM.LLVMTypeRef[] getUnknownCallArgumentTypes(NodeInputList<ValueNode> arguments, LoweredCallTargetNode callTarget) {
        return (LLVM.LLVMTypeRef[])Arrays.stream(callTarget.signature()).map(argType -> this.builder.getLLVMStackType(this.gen.getTypeKind(argType.resolve(null), false))).toArray(LLVM.LLVMTypeRef[]::new);
    }

    public void emitReadExceptionObject(ValueNode node) {
        this.builder.buildLandingPad();
    }

    public void visitMerge(AbstractMergeNode i) {
    }

    public void visitEndNode(AbstractEndNode i) {
        LLVM.LLVMBasicBlockRef nextBlock = this.gen.getBlock((AbstractBeginNode)i.merge());
        this.builder.buildBranch(nextBlock);
    }

    public void visitLoopEnd(LoopEndNode i) {
        LLVM.LLVMBasicBlockRef[] basicBlocks = new LLVM.LLVMBasicBlockRef[]{this.gen.getBlockEnd((Block)this.gen.getCurrentBlock())};
        for (ValuePhiNode phiNode : i.merge().valuePhis()) {
            LLVM.LLVMValueRef phi = this.backwardsPhi.get(phiNode);
            LLVM.LLVMValueRef value = this.llvmOperand((Node)phiNode.valueAt((AbstractEndNode)i));
            LLVM.LLVMValueRef[] values = new LLVM.LLVMValueRef[]{value};
            this.builder.addIncoming(phi, values, basicBlocks);
        }
    }

    public void visitSafepointNode(SafepointNode i) {
        throw GraalError.unimplemented();
    }

    public void visitBreakpointNode(BreakpointNode i) {
        if (this.gen.getDebugLevel() >= 1) {
            this.gen.emitPrintf("breakpoint");
        }
        this.builder.buildDebugtrap();
    }

    public void visitFullInfopointNode(FullInfopointNode i) {
        throw GraalError.unimplemented();
    }

    public void setSourcePosition(NodeSourcePosition position) {
    }

    public LIRFrameState state(DeoptimizingNode deopt) {
        FrameState state;
        if (!deopt.canDeoptimize()) {
            return null;
        }
        if (this.gen.needOnlyOopMaps()) {
            return new LIRFrameState(null, null, null);
        }
        if (deopt instanceof DeoptimizingNode.DeoptBefore) {
            assert (!(deopt instanceof DeoptimizingNode.DeoptDuring) && !(deopt instanceof DeoptimizingNode.DeoptAfter));
            state = ((DeoptimizingNode.DeoptBefore)deopt).stateBefore();
        } else if (deopt instanceof DeoptimizingNode.DeoptDuring) {
            assert (!(deopt instanceof DeoptimizingNode.DeoptAfter));
            state = ((DeoptimizingNode.DeoptDuring)deopt).stateDuring();
        } else {
            assert (deopt instanceof DeoptimizingNode.DeoptAfter);
            state = ((DeoptimizingNode.DeoptAfter)deopt).stateAfter();
        }
        assert (state != null);
        return this.debugInfoBuilder.build(state, null);
    }

    public void emitOverflowCheckBranch(AbstractBeginNode overflowSuccessor, AbstractBeginNode next, Stamp compareStamp, double probability) {
        throw GraalError.unimplemented();
    }

    public Value[] visitInvokeArguments(CallingConvention cc, Collection<ValueNode> arguments) {
        throw GraalError.unimplemented();
    }

    public Value operand(Node node) {
        return (Value)this.valueMap.get(node);
    }

    protected LLVM.LLVMValueRef llvmOperand(Node node) {
        assert (this.valueMap.containsKey(node));
        return this.valueMap.get(node).get();
    }

    public boolean hasOperand(Node node) {
        return this.valueMap.containsKey(node);
    }

    protected void setResult(ValueNode node, LLVM.LLVMValueRef operand) {
        this.setResult(node, (Value)new LLVMUtils.LLVMVariable(operand));
    }

    public Value setResult(ValueNode node, Value operand) {
        LLVMUtils.LLVMValueWrapper llvmOperand;
        boolean typeOverride = false;
        if (operand instanceof LLVMUtils.LLVMValueWrapper) {
            llvmOperand = (LLVMUtils.LLVMValueWrapper)operand;
        } else if (operand instanceof ConstantValue) {
            llvmOperand = new LLVMUtils.LLVMVariable(this.builder.constantNull(((LLVMUtils.LLVMKind)operand.getPlatformKind()).get()));
        } else if (operand instanceof LLVMUtils.LLVMAddressValue) {
            LLVMUtils.LLVMAddressValue addressValue = (LLVMUtils.LLVMAddressValue)operand;
            LLVM.LLVMValueRef base = LLVMUtils.getVal(addressValue.getBase());
            Value index = addressValue.getIndex();
            LLVM.LLVMTypeRef baseType = LLVMIRBuilder.typeOf(base);
            if (LLVMIRBuilder.isIntegerType(baseType) && LLVMIRBuilder.integerTypeWidth(baseType) == JavaKind.Long.getBitCount()) {
                base = this.builder.buildIntToPtr(base, this.builder.rawPointerType());
            } else if (LLVMIRBuilder.isObject(baseType)) {
                typeOverride = true;
            } else {
                throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpValues("unsupported base for address", base));
            }
            LLVM.LLVMValueRef intermediate = index == null || index == Value.ILLEGAL ? base : this.builder.buildGEP(base, LLVMUtils.getVal(index));
            llvmOperand = new LLVMUtils.LLVMVariable(intermediate);
        } else if (operand instanceof RegisterValue) {
            RegisterValue registerValue = (RegisterValue)operand;
            llvmOperand = (LLVMUtils.LLVMVariable)this.gen.emitReadRegister(registerValue.getRegister(), registerValue.getValueKind());
        } else {
            throw GraalError.shouldNotReachHere((String)("unknown operand: " + operand.toString()));
        }
        assert (typeOverride || LLVMIRBuilder.compatibleTypes(this.getLLVMType(node), LLVMIRBuilder.typeOf(llvmOperand.get()))) : LLVMUtils.dumpValues("value type doesn't match node stamp (" + node.stamp(NodeView.DEFAULT).toString() + ")", llvmOperand.get());
        if (this.gen.getDebugLevel() >= 3 && node.getStackKind() != JavaKind.Void) {
            this.builder.setValueName(llvmOperand.get(), node.toString());
        }
        this.valueMap.put((Node)node, llvmOperand);
        return operand;
    }

    public ValueNode valueForOperand(Value value) {
        throw GraalError.unimplemented();
    }
}

