/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.llvm;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.LLVM;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.Pointer;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.llvm.LLVMIRBuilder;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.nativeimage.ImageSingletons;

public class LLVMUtils {
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final Pointer NULL = null;
    static final int UNTRACKED_POINTER_ADDRESS_SPACE = 0;
    static final int TRACKED_POINTER_ADDRESS_SPACE = 1;
    public static final long DEFAULT_PATCHPOINT_ID = 2882400000L;
    public static final String ALWAYS_INLINE = "alwaysinline";
    public static final String GC_REGISTER_FUNCTION_NAME = "__llvm_gc_register";
    public static final String GC_LEAF_FUNCTION_NAME = "gc-leaf-function";
    public static final String JNI_WRAPPER_PREFIX = "__llvm_jni_wrapper_";

    static int getLLVMIntCond(Condition cond) {
        switch (cond) {
            case EQ: {
                return 32;
            }
            case NE: {
                return 33;
            }
            case LT: {
                return 40;
            }
            case LE: {
                return 41;
            }
            case GT: {
                return 38;
            }
            case GE: {
                return 39;
            }
            case AE: {
                return 35;
            }
            case BE: {
                return 37;
            }
            case AT: {
                return 34;
            }
            case BT: {
                return 36;
            }
        }
        throw GraalError.shouldNotReachHere((String)"invalid condition");
    }

    static int getLLVMRealCond(Condition cond, boolean unordered) {
        switch (cond) {
            case EQ: {
                return unordered ? 9 : 1;
            }
            case NE: {
                return unordered ? 14 : 6;
            }
            case LT: {
                return unordered ? 12 : 4;
            }
            case LE: {
                return unordered ? 13 : 5;
            }
            case GT: {
                return unordered ? 10 : 2;
            }
            case GE: {
                return unordered ? 11 : 3;
            }
        }
        throw GraalError.shouldNotReachHere((String)"invalid condition");
    }

    public static LLVM.LLVMValueRef getVal(Value value) {
        return ((LLVMValueWrapper)value).get();
    }

    static LLVM.LLVMTypeRef getType(ValueKind<?> kind) {
        return ((LLVMTypeWrapper)kind.getPlatformKind()).get();
    }

    static String dumpValues(String prefix, LLVM.LLVMValueRef ... values) {
        StringBuilder builder = new StringBuilder(prefix);
        for (LLVM.LLVMValueRef value : values) {
            builder.append(" ");
            builder.append(LLVM.LLVMPrintValueToString((LLVM.LLVMValueRef)value).getString());
        }
        return builder.toString();
    }

    static String dumpTypes(String prefix, LLVM.LLVMTypeRef ... types) {
        StringBuilder builder = new StringBuilder(prefix);
        for (LLVM.LLVMTypeRef type : types) {
            builder.append(" ");
            builder.append(LLVM.LLVMPrintTypeToString((LLVM.LLVMTypeRef)type).getString());
        }
        return builder.toString();
    }

    public static class LLVMAddressValue
    extends Value {
        private final Value base;
        private final Value index;

        public LLVMAddressValue(ValueKind<?> kind, Value base, Value index) {
            super(kind);
            this.base = base;
            this.index = index;
        }

        public Value getBase() {
            return this.base;
        }

        public Value getIndex() {
            return this.index;
        }
    }

    static final class LLVMKind
    implements PlatformKind,
    LLVMTypeWrapper {
        private final LLVM.LLVMTypeRef type;

        private LLVMKind(LLVM.LLVMTypeRef type) {
            this.type = type;
        }

        static LIRKind toLIRKind(LLVM.LLVMTypeRef type) {
            if (LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)type) == 12 && LLVM.LLVMGetPointerAddressSpace((LLVM.LLVMTypeRef)type) == 1) {
                return LIRKind.reference((PlatformKind)new LLVMKind(type));
            }
            return LIRKind.value((PlatformKind)new LLVMKind(type));
        }

        @Override
        public LLVM.LLVMTypeRef get() {
            return this.type;
        }

        public String name() {
            return LLVM.LLVMPrintTypeToString((LLVM.LLVMTypeRef)this.type).getString();
        }

        public PlatformKind.Key getKey() {
            throw GraalError.unimplemented();
        }

        public int getSizeInBytes() {
            switch (LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)this.type)) {
                case 8: {
                    return NumUtil.roundUp((int)LLVM.LLVMGetIntTypeWidth((LLVM.LLVMTypeRef)this.type), (int)8) / 8;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 8;
                }
                case 12: {
                    return 8;
                }
            }
            throw GraalError.shouldNotReachHere((String)"invalid kind");
        }

        public int getVectorLength() {
            return 1;
        }

        public char getTypeChar() {
            throw GraalError.unimplemented();
        }
    }

    public static class LLVMKindTool
    implements LIRKindTool {
        private LLVM.LLVMContextRef context;

        public LLVMKindTool(LLVM.LLVMContextRef context) {
            this.context = context;
        }

        public LIRKind getIntegerKind(int bits) {
            return LIRKind.value((PlatformKind)new LLVMKind(LLVM.LLVMIntTypeInContext((LLVM.LLVMContextRef)this.context, (int)bits)));
        }

        public LIRKind getFloatingKind(int bits) {
            switch (bits) {
                case 32: {
                    return LIRKind.value((PlatformKind)new LLVMKind(LLVM.LLVMFloatTypeInContext((LLVM.LLVMContextRef)this.context)));
                }
                case 64: {
                    return LIRKind.value((PlatformKind)new LLVMKind(LLVM.LLVMDoubleTypeInContext((LLVM.LLVMContextRef)this.context)));
                }
            }
            throw GraalError.shouldNotReachHere((String)"invalid float type");
        }

        public LIRKind getObjectKind() {
            return LIRKind.reference((PlatformKind)new LLVMKind(LLVM.LLVMPointerType((LLVM.LLVMTypeRef)LLVM.LLVMInt8TypeInContext((LLVM.LLVMContextRef)this.context), (int)1)));
        }

        public LIRKind getWordKind() {
            return LIRKind.value((PlatformKind)new LLVMKind(LLVM.LLVMInt64TypeInContext((LLVM.LLVMContextRef)this.context)));
        }

        public LIRKind getNarrowOopKind() {
            throw GraalError.unimplemented();
        }

        public LIRKind getNarrowPointerKind() {
            throw GraalError.unimplemented();
        }
    }

    public static class LLVMStackSlot
    extends VirtualStackSlot
    implements LLVMValueWrapper {
        private static int id = 0;
        private LLVM.LLVMValueRef value;
        private final LLVMVariable address;

        LLVMStackSlot(LLVM.LLVMValueRef value) {
            super(id++, (ValueKind)LLVMKind.toLIRKind(LLVM.LLVMTypeOf((LLVM.LLVMValueRef)value)));
            this.value = value;
            this.address = new LLVMVariable(value);
        }

        @Override
        public LLVM.LLVMValueRef get() {
            return this.value;
        }

        public LLVMVariable address() {
            return this.address;
        }

        public String toString() {
            return LLVM.LLVMPrintValueToString((LLVM.LLVMValueRef)this.value).getString();
        }
    }

    static class LLVMConstant
    extends ConstantValue
    implements LLVMValueWrapper {
        private final LLVM.LLVMValueRef value;

        LLVMConstant(LLVM.LLVMValueRef value, Constant constant) {
            super((ValueKind)LLVMKind.toLIRKind(LLVMIRBuilder.typeOf(value)), constant);
            this.value = value;
        }

        @Override
        public LLVM.LLVMValueRef get() {
            return this.value;
        }

        public String toString() {
            return LLVM.LLVMPrintValueToString((LLVM.LLVMValueRef)this.value).getString();
        }
    }

    public static class LLVMVariable
    extends Variable
    implements LLVMValueWrapper {
        private static int id = 0;
        private LLVM.LLVMValueRef value;

        LLVMVariable(ValueKind<?> kind) {
            super(kind, id++);
        }

        LLVMVariable(LLVM.LLVMTypeRef type) {
            this((ValueKind<?>)LLVMKind.toLIRKind(type));
        }

        public LLVMVariable(LLVM.LLVMValueRef value) {
            this((ValueKind<?>)LLVMKind.toLIRKind(LLVM.LLVMTypeOf((LLVM.LLVMValueRef)value)));
            this.value = value;
        }

        public void set(LLVM.LLVMValueRef value) {
            assert (this.value == null);
            this.value = value;
        }

        @Override
        public LLVM.LLVMValueRef get() {
            return this.value;
        }

        public String toString() {
            return LLVM.LLVMPrintValueToString((LLVM.LLVMValueRef)this.value).getString();
        }
    }

    static interface LLVMTypeWrapper {
        public LLVM.LLVMTypeRef get();
    }

    public static interface LLVMValueWrapper {
        public LLVM.LLVMValueRef get();
    }

    public static interface TargetSpecific {
        public static TargetSpecific get() {
            return (TargetSpecific)ImageSingletons.lookup(TargetSpecific.class);
        }

        public String getRegisterInlineAsm(String var1);

        public String getJumpInlineAsm();

        public String getLLVMArchName();

        public int getCallFrameSeparation();

        public int getFramePointerOffset();

        public int getStackPointerDwarfRegNum();

        public int getFramePointerDwarfRegNum();

        default public List<String> getLLCAdditionalOptions() {
            return Collections.emptyList();
        }

        default public String getLLVMRegisterName(String register) {
            return register;
        }
    }

    public static enum LLVMIntrinsicOperation {
        LOG(1),
        LOG10(1),
        EXP(1),
        POW(2),
        SIN(1),
        COS(1),
        SQRT(1),
        ABS(1),
        ROUND(1),
        RINT(1),
        CEIL(1),
        FLOOR(1),
        MIN(2),
        MAX(2),
        COPYSIGN(2),
        FMA(3),
        CTLZ(1),
        CTTZ(1),
        CTPOP(1);

        private int argCount;

        private LLVMIntrinsicOperation(int argCount) {
            this.argCount = argCount;
        }

        public int argCount() {
            return this.argCount;
        }
    }

    public static final class DebugLevel {
        public static final int NONE = 0;
        public static final int FUNCTION = 1;
        public static final int BLOCK = 2;
        public static final int NODE = 3;
    }
}

