/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.llvm;

import java.util.List;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.llvm.LLVMGenerationResult;
import org.graalvm.compiler.core.llvm.NodeLLVMBuilder;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;

public class LLVMGenerationPhase {
    protected static void run(NodeLLVMBuilder nodeBuilder, StructuredGraph graph) {
        StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
        LLVMGenerationResult genResult = nodeBuilder.getLIRGeneratorTool().getLLVMResult();
        for (Block b : schedule.getCFG().getBlocks()) {
            assert (!genResult.isProcessed((AbstractBlockBase<?>)b)) : "Block already processed " + b;
            assert (LLVMGenerationPhase.verifyPredecessors(genResult, b));
            nodeBuilder.doBlock(b, graph, (BlockMap<List<Node>>)schedule.getBlockToNodesMap());
        }
        nodeBuilder.finish();
    }

    private static boolean verifyPredecessors(LLVMGenerationResult genResult, Block block) {
        for (Block pred : (Block[])block.getPredecessors()) {
            if (!block.isLoopHeader() || !pred.isLoopEnd()) assert (genResult.isProcessed((AbstractBlockBase<?>)pred)) : "Predecessor not yet processed " + pred;
        }
        return true;
    }
}

