/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.threading;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.trufflenode.JSExternalObject;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

public class JavaMessagePortData {
    private final long nativePointer;
    private final Deque<Object> queue;
    private int encodedRefs;

    public JavaMessagePortData(DynamicObject external) {
        assert (JSExternalObject.isJSExternalObject(external));
        this.encodedRefs = 0;
        this.queue = new ConcurrentLinkedDeque<Object>();
        this.nativePointer = JSExternalObject.getPointer(external);
    }

    public long getMessagePortDataPointer() {
        return this.nativePointer;
    }

    public void encodingBegin() {
        this.encodedRefs = 0;
    }

    public void encodingEnd() {
        this.encodedRefs = 0;
    }

    public boolean encodedJavaRefs() {
        return this.encodedRefs > 0;
    }

    public void enqueueJavaRef(Object hostObject) {
        this.queue.add(hostObject);
        ++this.encodedRefs;
    }

    public void disposeLastMessageRefs() {
        for (int i = 0; i < this.encodedRefs; ++i) {
            this.queue.removeLast();
        }
        this.encodedRefs = 0;
    }

    public Object removeJavaRef() {
        return this.queue.removeFirst();
    }
}

