/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.node.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.trufflenode.GraalJSAccess;

public class SetBreakPointNode
extends JavaScriptRootNode {
    public static final String NAME = "setBreakPoint";
    private final GraalJSAccess graalJSAccess;

    public SetBreakPointNode(GraalJSAccess graalJSAccess) {
        this.graalJSAccess = graalJSAccess;
    }

    public Object execute(VirtualFrame frame) {
        CallTarget callTarget;
        Object[] args = frame.getArguments();
        int numArgs = JSArguments.getUserArgumentCount((Object[])args);
        Object arg0 = Undefined.instance;
        if (numArgs >= 1) {
            arg0 = JSArguments.getUserArgument((Object[])args, (int)0);
        }
        if (JSFunction.isJSFunction((Object)arg0) && (callTarget = JSFunction.getFunctionData((DynamicObject)arg0).getCallTarget()) instanceof RootCallTarget) {
            return this.addBreakPoint((RootCallTarget)callTarget, args);
        }
        SetBreakPointNode.unsupported();
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    private int addBreakPoint(RootCallTarget callTarget, Object[] args) {
        Object arg2;
        Object arg1;
        int numArgs = JSArguments.getUserArgumentCount((Object[])args);
        SourceSection sourceSection = callTarget.getRootNode().getSourceSection();
        Source source = sourceSection.getSource();
        int lineNo = sourceSection.getStartLine();
        int columnNo = sourceSection.getStartColumn();
        int userLine = 0;
        if (numArgs >= 2 && (arg1 = JSArguments.getUserArgument((Object[])args, (int)1)) instanceof Number) {
            userLine = ((Number)arg1).intValue();
            lineNo += userLine;
        }
        if (userLine > 0) {
            columnNo = 1;
        } else if (SetBreakPointNode.startsWith(sourceSection, "function")) {
            columnNo += 9;
        }
        if (numArgs >= 3 && (arg2 = JSArguments.getUserArgument((Object[])args, (int)2)) instanceof Number) {
            columnNo += ((Number)arg2).intValue();
        }
        boolean oneShot = false;
        if (numArgs >= 5) {
            Object arg4 = JSArguments.getUserArgument((Object[])args, (int)4);
            oneShot = JSRuntime.toBoolean((Object)arg4);
        }
        this.addBreakPoint(source, lineNo, columnNo, oneShot);
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    private void addBreakPoint(Source source, int lineNo, int columnNo, boolean oneShot) {
        Breakpoint.Builder builder = Breakpoint.newBuilder((Source)source).lineIs(lineNo).columnIs(columnNo);
        if (oneShot) {
            builder.oneShot();
        }
        Breakpoint breakpoint = builder.build();
        Debugger debugger = this.graalJSAccess.lookupInstrument("debugger", Debugger.class);
        debugger.install(breakpoint);
    }

    @CompilerDirectives.TruffleBoundary
    private static void unsupported() {
        System.err.println("Unsupported usage of Debug.setBreakpoint!");
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean startsWith(SourceSection sourceSection, String prefix) {
        CharSequence characters = sourceSection.getCharacters();
        int n = prefix.length();
        if (n > characters.length()) {
            return false;
        }
        return characters.subSequence(0, n).toString().equals(prefix);
    }
}

