/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.node;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.info.Accessor;
import com.oracle.truffle.trufflenode.info.FunctionTemplate;
import com.oracle.truffle.trufflenode.info.ObjectTemplate;
import com.oracle.truffle.trufflenode.info.Value;
import java.util.ArrayList;

public class ObjectTemplateNode
extends JavaScriptBaseNode {
    @Node.Children
    ObjectLiteralNode.ObjectLiteralMemberNode[] members;
    private final JSContext context;

    ObjectTemplateNode(ObjectLiteralNode.ObjectLiteralMemberNode[] members, JSContext context) {
        this.members = members;
        this.context = context;
    }

    @ExplodeLoop
    public DynamicObject executeWithObject(VirtualFrame frame, DynamicObject object) {
        for (int i = 0; i < this.members.length; ++i) {
            this.members[i].executeVoid(frame, object, this.context);
        }
        return object;
    }

    public static ObjectTemplateNode fromObjectTemplate(ObjectTemplate template, JSContext context, GraalJSAccess graalJSAccess) {
        ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> members = new ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode>();
        for (Accessor accessor : template.getAccessors()) {
            Pair<JSFunctionData, JSFunctionData> pair = accessor.getFunctions(context);
            JavaScriptNode getterNode = null;
            JavaScriptNode setterNode = null;
            if (pair.getFirst() != null) {
                getterNode = ObjectLiteralNode.MakeMethodNode.createWithKey((JSContext)context, (JavaScriptNode)JSFunctionExpressionNode.create((JSFunctionData)((JSFunctionData)pair.getFirst()), null), (HiddenKey)GraalJSAccess.HOLDER_KEY);
            }
            if (pair.getSecond() != null) {
                setterNode = ObjectLiteralNode.MakeMethodNode.createWithKey((JSContext)context, (JavaScriptNode)JSFunctionExpressionNode.create((JSFunctionData)((JSFunctionData)pair.getSecond()), null), (HiddenKey)GraalJSAccess.HOLDER_KEY);
            }
            members.add(ObjectLiteralNode.newAccessorMember((Object)accessor.getName(), (boolean)false, (int)accessor.getAttributes(), (JavaScriptNode)getterNode, (JavaScriptNode)setterNode));
        }
        for (Value value : template.getValues()) {
            JSConstantNode valueNode;
            Object propertyValue = value.getValue();
            if (propertyValue instanceof FunctionTemplate) {
                FunctionTemplate functionTempl = (FunctionTemplate)propertyValue;
                valueNode = JSConstantNode.create((Object)graalJSAccess.functionTemplateGetFunction(context.getRealm(), functionTempl));
            } else {
                valueNode = JSConstantNode.create((Object)propertyValue);
            }
            Object name = value.getName();
            int attributes = value.getAttributes();
            if (propertyValue instanceof Pair) {
                Pair pair = (Pair)propertyValue;
                JSRealm realm = context.getRealm();
                Object getterTemplate = pair.getFirst();
                Object setterTemplate = pair.getSecond();
                DynamicObject getter = getterTemplate == null ? Undefined.instance : graalJSAccess.functionTemplateGetFunction(realm, getterTemplate);
                DynamicObject setter = setterTemplate == null ? Undefined.instance : graalJSAccess.functionTemplateGetFunction(realm, setterTemplate);
                JSConstantNode getterNode = JSConstantNode.create((Object)getter);
                JSConstantNode setterNode = JSConstantNode.create((Object)setter);
                members.add(ObjectLiteralNode.newAccessorMember((Object)name, (boolean)false, (int)attributes, (JavaScriptNode)getterNode, (JavaScriptNode)setterNode));
                continue;
            }
            if (name instanceof String || name instanceof Symbol) {
                members.add(ObjectLiteralNode.newDataMember((Object)name, (boolean)false, (int)attributes, (JavaScriptNode)valueNode));
                continue;
            }
            if (name instanceof HiddenKey) {
                if (template.hasPropertyHandler()) continue;
                members.add(new InternalFieldNode(false, attributes, (HiddenKey)name, propertyValue, context));
                continue;
            }
            members.add(ObjectLiteralNode.newComputedDataMember((JavaScriptNode)JSConstantNode.create((Object)name), (boolean)false, (int)attributes, (JavaScriptNode)valueNode));
        }
        return new ObjectTemplateNode(members.toArray(ObjectLiteralNode.ObjectLiteralMemberNode.EMPTY), context);
    }

    private static final class InternalFieldNode
    extends ObjectLiteralNode.ObjectLiteralMemberNode {
        @Node.Child
        PropertySetNode setNode;
        private final Object value;

        private InternalFieldNode(boolean isStatic, int attributes, HiddenKey key, Object value, JSContext context) {
            super(isStatic, attributes);
            this.setNode = PropertySetNode.createSetHidden((HiddenKey)key, (JSContext)context);
            this.value = value;
        }

        public void executeVoid(VirtualFrame frame, DynamicObject obj, JSContext context) {
            this.setNode.setValue((Object)obj, this.value);
        }

        protected ObjectLiteralNode.ObjectLiteralMemberNode copyUninitialized() {
            return new InternalFieldNode(this.isStatic, this.attributes, (HiddenKey)this.setNode.getKey(), this.value, this.setNode.getContext());
        }
    }
}

