/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.buffer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.cast.JSToIntegerNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerNodeGen;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.util.BufferUtil;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.buffer.NIOBufferAccessNode;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class NIOBufferUTF8WriteNode
extends NIOBufferAccessNode {
    @Node.Child
    protected JSToIntegerNode toInt;
    protected final BranchProfile nativePath = BranchProfile.create();
    protected final BranchProfile errorBranch = BranchProfile.create();

    public NIOBufferUTF8WriteNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
        this.toInt = JSToIntegerNodeGen.create();
    }

    private DynamicObject getNativeUtf8Write() {
        return GraalJSAccess.getRealmEmbedderData(this.getContext().getRealm()).getNativeUtf8Write();
    }

    @Specialization(guards={"accept(target)"})
    public Object write(DynamicObject target, String str, int destOffset, int bytes) {
        try {
            return this.doWrite(target, str, destOffset, bytes);
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, str, destOffset, bytes);
        }
    }

    @Specialization(guards={"accept(target)", "isUndefined(bytes)"})
    public Object writeDefaultOffset(DynamicObject target, String str, int destOffset, Object bytes) {
        try {
            return this.doWrite(target, str, destOffset, NIOBufferUTF8WriteNode.getBytes(str).length);
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, str, destOffset, bytes);
        }
    }

    @Specialization(guards={"accept(target)", "isUndefined(destOffset)", "isUndefined(bytes)"})
    public Object writeDefaultValues(DynamicObject target, String str, Object destOffset, Object bytes) {
        try {
            return this.doWrite(target, str, 0, NIOBufferUTF8WriteNode.getBytes(str).length);
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, str, destOffset, bytes);
        }
    }

    @Specialization(guards={"accept(target)"})
    public Object write(DynamicObject target, String str, double destOffset, double bytes) {
        try {
            return this.doWrite(target, str, this.toInt.executeInt((Object)destOffset), this.toInt.executeInt((Object)bytes));
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, str, destOffset, bytes);
        }
    }

    @Specialization
    public Object writeDefault(DynamicObject target, Object str, Object destOffset, Object bytes) {
        return JSFunction.call((DynamicObject)this.getNativeUtf8Write(), (Object)target, (Object[])new Object[]{str, destOffset, bytes});
    }

    @Specialization(guards={"!isJSArrayBufferView(target)"})
    public Object writeAbort(Object target, Object str, Object destOffset, Object bytes) {
        throw Errors.createTypeErrorArrayBufferViewExpected();
    }

    private Object doNativeFallback(DynamicObject target, String str, Object destOffset, Object bytes) {
        this.nativePath.enter();
        return JSFunction.call((DynamicObject)this.getNativeUtf8Write(), (Object)target, (Object[])new Object[]{str, destOffset, bytes});
    }

    private int doWrite(DynamicObject target, String str, int destOffset, int bytes) throws CharacterCodingException {
        boolean isArrayBufferView = JSArrayBufferView.isJSArrayBufferView((DynamicObject)target);
        DynamicObject arrayBuffer = NIOBufferUTF8WriteNode.getArrayBuffer(target, isArrayBufferView);
        int bufferOffset = this.getOffset(target, isArrayBufferView);
        int bufferLen = this.getLength(target);
        if (destOffset > bufferLen || bytes < 0 || destOffset < 0) {
            this.errorBranch.enter();
            this.outOfBoundsFail();
        }
        ByteBuffer rawBuffer = NIOBufferUTF8WriteNode.getDirectByteBuffer(arrayBuffer);
        ByteBuffer buffer = NIOBufferUTF8WriteNode.sliceBuffer(rawBuffer, bufferOffset);
        BufferUtil.asBaseBuffer((Buffer)buffer).position(destOffset);
        BufferUtil.asBaseBuffer((Buffer)buffer).limit(Math.min(bufferLen, destOffset + bytes));
        CoderResult res = NIOBufferUTF8WriteNode.doEncode(str, buffer);
        if (NIOBufferUTF8WriteNode.cannotEncode(res)) {
            this.errorBranch.enter();
            throw new CharacterCodingException();
        }
        return buffer.position() - destOffset;
    }

    @CompilerDirectives.TruffleBoundary
    private static CoderResult doEncode(String str, ByteBuffer buffer) {
        CharsetEncoder encoder = utf8.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPORT);
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer cb = CharBuffer.wrap(str);
        CoderResult res = encoder.encode(cb, buffer, true);
        if (res.isUnderflow()) {
            encoder.encode(cb, buffer, true);
            res = encoder.flush(buffer);
        }
        return res;
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] getBytes(String str) {
        return str.getBytes(utf8);
    }

    private static boolean cannotEncode(CoderResult res) {
        return res.isMalformed() || res.isUnmappable() || res.isError();
    }
}

