/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.buffer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.access.ArrayBufferViewGetByteLengthNode;
import com.oracle.truffle.js.nodes.access.ArrayBufferViewGetByteLengthNodeGen;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public abstract class NIOBufferAccessNode
extends JSBuiltinNode {
    protected static final Charset utf8 = Charset.forName("UTF-8");
    @Node.Child
    protected ArrayBufferViewGetByteLengthNode getLenNode;

    public NIOBufferAccessNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
        this.getLenNode = ArrayBufferViewGetByteLengthNodeGen.create((JSContext)context);
    }

    protected static DynamicObject getArrayBuffer(DynamicObject target, boolean condition) {
        assert (JSArrayBufferView.isJSArrayBufferView((DynamicObject)target)) : "Target object must be a JSArrayBufferView";
        DynamicObject arrayBuffer = JSArrayBufferView.getArrayBuffer((DynamicObject)target, (boolean)condition);
        assert (JSArrayBuffer.isJSDirectArrayBuffer((DynamicObject)arrayBuffer) || JSSharedArrayBuffer.isJSSharedArrayBuffer((DynamicObject)arrayBuffer)) : "Target buffer must be a DirectArrayBuffer";
        return arrayBuffer;
    }

    protected static ByteBuffer getDirectByteBuffer(DynamicObject arrayBuffer) {
        if (JSArrayBuffer.isJSDirectArrayBuffer((DynamicObject)arrayBuffer)) {
            return JSArrayBuffer.getDirectByteBuffer((DynamicObject)arrayBuffer);
        }
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer((DynamicObject)arrayBuffer));
        return JSSharedArrayBuffer.getDirectByteBuffer((DynamicObject)arrayBuffer);
    }

    protected int getOffset(DynamicObject target, boolean condition) {
        int byteOffset = JSArrayBufferView.getByteOffset((DynamicObject)target, (boolean)condition, (JSContext)this.getContext());
        return byteOffset;
    }

    protected int getLength(DynamicObject target) {
        return this.getLenNode.executeInt(target);
    }

    protected static ByteBuffer sliceBuffer(ByteBuffer rawBuffer, int byteOffset) {
        return ((ByteBuffer)BufferUtil.asBaseBuffer((Buffer)rawBuffer.duplicate()).position(byteOffset)).slice().order(ByteOrder.nativeOrder());
    }

    @CompilerDirectives.TruffleBoundary
    protected void outOfBoundsFail() {
        JSException exception = Errors.createRangeError((String)"out of range index");
        DynamicObject errorObject = (DynamicObject)exception.getErrorObjectEager(this.getContext());
        JSObject.set((DynamicObject)errorObject, (Object)"code", (Object)"ERR_BUFFER_OUT_OF_BOUNDS");
        throw exception;
    }

    protected static boolean accept(DynamicObject target) {
        return JSArrayBufferView.isJSArrayBufferView((DynamicObject)target);
    }
}

