/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context;

import com.oracle.graal.pointsto.meta.AnalysisMethod;

public class BytecodeLocation {
    public static final int EMPTY_BCI = -1;
    public static final int UNKNOWN_BCI = -2;
    public static final int DYNAMIC_ALLOCATION_BCI = -3;
    public static final BytecodeLocation EMPTY_BYTECODE_LOCATION = BytecodeLocation.create(-1, null);
    private final int bci;
    private final AnalysisMethod method;

    public static int keyToBci(Object key) {
        int bci;
        if (key instanceof Integer) {
            bci = (Integer)key;
            assert (bci >= 0) : "Negative BCI.";
        } else {
            bci = -2;
        }
        return bci;
    }

    public static boolean isValidBci(Object key) {
        if (key instanceof Integer) {
            int bci = (Integer)key;
            return bci != -1 && bci != -2;
        }
        return false;
    }

    public static boolean hasValidBci(BytecodeLocation location) {
        return location.bci != -1 && location.bci != -2;
    }

    public static BytecodeLocation create(Object key, AnalysisMethod method) {
        return BytecodeLocation.create(BytecodeLocation.keyToBci(key), method);
    }

    public static BytecodeLocation create(AnalysisMethod method, Object key) {
        return BytecodeLocation.create(BytecodeLocation.keyToBci(key), method);
    }

    public static BytecodeLocation create(int bci, AnalysisMethod method) {
        return new BytecodeLocation(bci, method);
    }

    public static BytecodeLocation create(AnalysisMethod method, int bci) {
        return new BytecodeLocation(bci, method);
    }

    protected BytecodeLocation(int bci, AnalysisMethod method) {
        this.bci = bci;
        this.method = method;
    }

    public int getBci() {
        return this.bci;
    }

    public AnalysisMethod getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("");
        String methodName = "_";
        String sourceLocation = "_";
        if (this.method != null) {
            methodName = this.method.format("%h.%n(%p)");
            StackTraceElement traceElement = this.method.asStackTraceElement(this.bci);
            sourceLocation = traceElement.getFileName() + ":" + traceElement.getLineNumber();
        }
        str.append("@(").append(methodName).append(":").append(this.bci).append(")");
        str.append(" = (").append(sourceLocation).append(")");
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BytecodeLocation) {
            BytecodeLocation that = (BytecodeLocation)obj;
            return this.bci == that.bci && this.method != null ? this.method.equals(that.method) : that.method == null;
        }
        return false;
    }

    public int hashCode() {
        return 0x2A ^ (this.method != null ? this.method.hashCode() : 1) ^ this.bci;
    }

    public static String formatLocation(BytecodeLocation bcl) {
        return BytecodeLocation.formatLocation(bcl.getMethod(), bcl.getBci());
    }

    public static String formatLocation(AnalysisMethod method, int bci) {
        return method.format("%h.%n(%p)") + ":" + bci;
    }
}

