/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.details;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.details.DetailsTable;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing.HeaderPanel;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing.ScrollBar;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineSupport;

public final class DetailsPanel
extends JPanel {
    private JPanel noDataContainer;
    private JComponent dataContainer;
    private JScrollBar scrollBar;
    private DetailsTable table;
    private final TimelineSupport support;
    private boolean selectionAdjusting;
    private KeyStroke tableKeyStroke;

    public DetailsPanel(TimelineSupport support) {
        this.support = support;
        this.initComponents();
        this.initListeners();
    }

    public void setTableModel(TableModel model) {
        if (model == null) {
            this.table.clearSelection();
            this.table.setModel(new DefaultTableModel());
            this.removeAll();
            this.add((Component)this.noDataContainer, "Center");
        } else {
            int selectedRow = this.getSelectedRow();
            this.table.setModel(model);
            if (selectedRow != -1) {
                this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            }
            this.removeAll();
            this.add((Component)this.dataContainer, "Center");
        }
        this.validate();
        this.repaint();
    }

    private void initListeners() {
        TableListener tableListener = new TableListener();
        this.table.getSelectionModel().addListSelectionListener(tableListener);
        this.table.addKeyListener(tableListener);
        this.table.addMouseListener(tableListener);
    }

    private int getSelectedRow() {
        int selectedRow = this.table.getSelectedRow();
        return selectedRow == -1 ? -1 : this.table.convertRowIndexToModel(selectedRow);
    }

    private boolean isTrackingEnd() {
        if (this.scrollBar == null) {
            return false;
        }
        return this.scrollBar.getValue() + this.scrollBar.getVisibleAmount() >= this.scrollBar.getMaximum();
    }

    private boolean isSelectionChanging() {
        if (this.selectionAdjusting) {
            return true;
        }
        if (this.tableKeyStroke == null) {
            return false;
        }
        return this.table.getActionForKeyStroke(this.tableKeyStroke) != null;
    }

    private void initComponents() {
        this.table = new DetailsTable();
        this.table.getSelectionModel().setSelectionMode(0);
        Viewport viewport = new Viewport(this.table);
        final JScrollPane tableScroll = new JScrollPane(22, 30);
        tableScroll.setViewport(viewport);
        tableScroll.setBorder(BorderFactory.createEmptyBorder());
        tableScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        tableScroll.setCorner("UPPER_RIGHT_CORNER", new HeaderPanel());
        this.scrollBar = new ScrollBar(1){

            @Override
            public int getUnitIncrement(int direction) {
                JViewport vp = tableScroll.getViewport();
                Scrollable view = (Scrollable)((Object)vp.getView());
                Rectangle vr = vp.getViewRect();
                return view.getScrollableUnitIncrement(vr, this.getOrientation(), direction);
            }

            @Override
            public int getBlockIncrement(int direction) {
                JViewport vp = tableScroll.getViewport();
                Scrollable view = (Scrollable)((Object)vp.getView());
                Rectangle vr = vp.getViewRect();
                return view.getScrollableBlockIncrement(vr, this.getOrientation(), direction);
            }

            @Override
            public void setValues(int newValue, int newExtent, int newMin, int newMax) {
                this.setEnabled(newExtent < newMax);
                if (this.isEnabled() && !DetailsPanel.this.isSelectionChanging() && DetailsPanel.this.isTrackingEnd()) {
                    newValue = newMax - newExtent;
                }
                super.setValues(newValue, newExtent, newMin, newMax);
            }
        };
        tableScroll.setVerticalScrollBar(this.scrollBar);
        this.dataContainer = tableScroll;
        JLabel noDataLabel = new JLabel("<No probe selected>", 0);
        noDataLabel.setEnabled(false);
        this.noDataContainer = new JPanel(new BorderLayout());
        this.noDataContainer.setOpaque(false);
        this.noDataContainer.add((Component)noDataLabel, "Center");
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.noDataContainer, "Center");
    }

    private static class Viewport
    extends JViewport {
        private final DetailsTable view;
        private final Color background;

        Viewport(DetailsTable view) {
            this.setView(view);
            this.view = view;
            this.setOpaque(true);
            this.background = view.getBackground();
            this.setBackground(this.background);
            view.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                    Viewport.this.repaint();
                }

                @Override
                public void columnMoved(TableColumnModelEvent e) {
                    Viewport.this.repaint();
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                    Viewport.this.repaint();
                }

                @Override
                public void columnMarginChanged(ChangeEvent e) {
                    Viewport.this.repaint();
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintVerticalLines(g);
        }

        private void paintVerticalLines(Graphics g) {
            int height = this.getHeight();
            int viewHeight = this.view.getHeight();
            if (viewHeight >= height) {
                return;
            }
            g.setColor(this.background);
            g.fillRect(0, viewHeight, this.getWidth(), this.getHeight() - viewHeight);
            int cellX = 0;
            TableColumnModel model = this.view.getColumnModel();
            int columnCount = model.getColumnCount();
            g.setColor(DetailsTable.DEFAULT_GRID_COLOR);
            for (int i = 0; i < columnCount; ++i) {
                int cellWidth = model.getColumn(i).getWidth();
                g.drawLine((cellX += cellWidth) - 1, viewHeight, cellX - 1, height);
            }
        }
    }

    private class TableListener
    extends MouseAdapter
    implements ListSelectionListener,
    KeyListener {
        private TableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            DetailsPanel.this.selectionAdjusting = e.getValueIsAdjusting();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            DetailsPanel.this.tableKeyStroke = KeyStroke.getKeyStrokeForEvent(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            DetailsPanel.this.tableKeyStroke = null;
            if (e.getKeyCode() == 32) {
                DetailsPanel.this.support.scrollChartToIndex(DetailsPanel.this.getSelectedRow());
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                DetailsPanel.this.support.scrollChartToIndex(DetailsPanel.this.getSelectedRow());
            }
        }
    }
}

