/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.GeneratedPlugin;
import org.graalvm.compiler.replacements.processor.InjectedDependencies;

public class GeneratedFoldPlugin
extends GeneratedPlugin {
    public GeneratedFoldPlugin(ExecutableElement intrinsicMethod) {
        super(intrinsicMethod);
    }

    @Override
    protected TypeElement getAnnotationClass(AbstractProcessor processor) {
        return processor.getTypeElement("org.graalvm.compiler.api.replacements.Fold");
    }

    @Override
    public void extraImports(Set<String> imports) {
        imports.add("jdk.vm.ci.meta.JavaConstant");
        imports.add("jdk.vm.ci.meta.JavaKind");
        imports.add("org.graalvm.compiler.nodes.ConstantNode");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected InjectedDependencies createExecute(AbstractProcessor processor, PrintWriter out) {
        Object receiver;
        InjectedDependencies deps = new InjectedDependencies();
        List<? extends VariableElement> params = this.intrinsicMethod.getParameters();
        int argCount = 0;
        if (this.intrinsicMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            receiver = this.intrinsicMethod.getEnclosingElement();
        } else {
            receiver = "arg0";
            TypeElement type = (TypeElement)this.intrinsicMethod.getEnclosingElement();
            GeneratedFoldPlugin.constantArgument(processor, out, deps, argCount, type.asType(), argCount);
            ++argCount;
        }
        int firstArg = argCount;
        for (VariableElement variableElement : params) {
            if (processor.getAnnotation((Element)variableElement, processor.getType("org.graalvm.compiler.api.replacements.Fold.InjectedParameter")) == null) {
                GeneratedFoldPlugin.constantArgument(processor, out, deps, argCount, variableElement.asType(), argCount);
            } else {
                out.printf("        if (!checkInjectedArgument(b, args[%d], targetMethod)) {\n", argCount);
                out.printf("            return false;\n", new Object[0]);
                out.printf("        }\n", argCount);
                out.printf("        %s arg%d = %s;\n", variableElement.asType(), argCount, deps.use(processor, (DeclaredType)variableElement.asType()));
            }
            ++argCount;
        }
        TreeSet<String> suppressWarnings = new TreeSet<String>();
        if (this.intrinsicMethod.getAnnotation(Deprecated.class) != null) {
            suppressWarnings.add("deprecation");
        }
        if (GeneratedFoldPlugin.hasRawtypeWarning(this.intrinsicMethod.getReturnType())) {
            suppressWarnings.add("rawtypes");
        }
        for (VariableElement variableElement : params) {
            if (!GeneratedFoldPlugin.hasUncheckedWarning(variableElement.asType())) continue;
            suppressWarnings.add("unchecked");
        }
        if (suppressWarnings.size() > 0) {
            out.printf("        @SuppressWarnings({", new Object[0]);
            String string = "";
            for (String suppressWarning : suppressWarnings) {
                void var9_13;
                out.printf("%s\"%s\"", var9_13, suppressWarning);
                String string2 = ", ";
            }
            out.printf("})\n", new Object[0]);
        }
        out.printf("        %s result = %s.%s(", GeneratedFoldPlugin.getErasedType(this.intrinsicMethod.getReturnType()), receiver, this.intrinsicMethod.getSimpleName());
        if (argCount > firstArg) {
            void var9_17;
            out.printf("arg%d", firstArg);
            int n = firstArg + 1;
            while (var9_17 < argCount) {
                out.printf(", arg%d", (int)var9_17);
                ++var9_17;
            }
        }
        out.printf(");\n", new Object[0]);
        TypeMirror typeMirror = this.intrinsicMethod.getReturnType();
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                out.printf("        JavaConstant constant = JavaConstant.forInt(result ? 1 : 0);\n", new Object[0]);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: {
                out.printf("        JavaConstant constant = JavaConstant.forInt(result);\n", new Object[0]);
                break;
            }
            case LONG: {
                out.printf("        JavaConstant constant = JavaConstant.forLong(result);\n", new Object[0]);
                break;
            }
            case FLOAT: {
                out.printf("        JavaConstant constant = JavaConstant.forFloat(result);\n", new Object[0]);
                break;
            }
            case DOUBLE: {
                out.printf("        JavaConstant constant = JavaConstant.forDouble(result);\n", new Object[0]);
                break;
            }
            case ARRAY: 
            case TYPEVAR: 
            case DECLARED: {
                if (typeMirror.equals(processor.getType("java.lang.String"))) {
                    out.printf("        JavaConstant constant = %s.forString(result);\n", deps.use(InjectedDependencies.WellKnownDependency.CONSTANT_REFLECTION));
                    break;
                }
                out.printf("        JavaConstant constant = %s.forObject(result);\n", deps.use(InjectedDependencies.WellKnownDependency.SNIPPET_REFLECTION));
                break;
            }
            default: {
                throw new IllegalArgumentException(typeMirror.toString());
            }
        }
        out.printf("        ConstantNode node = ConstantNode.forConstant(constant, %s, %s);\n", deps.use(InjectedDependencies.WellKnownDependency.META_ACCESS), deps.use(InjectedDependencies.WellKnownDependency.STRUCTURED_GRAPH));
        out.printf("        b.push(JavaKind.%s, node);\n", GeneratedFoldPlugin.getReturnKind(this.intrinsicMethod));
        out.printf("        b.notifyReplacedCall(targetMethod, node);\n", new Object[0]);
        out.printf("        return true;\n", new Object[0]);
        return deps;
    }
}

