/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.text.resources.cldr.tr;

import java.util.ListResourceBundle;

public class FormatData_tr extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "MonthNames",
                new String[] {
                    "Ocak",
                    "\u015eubat",
                    "Mart",
                    "Nisan",
                    "May\u0131s",
                    "Haziran",
                    "Temmuz",
                    "A\u011fustos",
                    "Eyl\u00fcl",
                    "Ekim",
                    "Kas\u0131m",
                    "Aral\u0131k",
                    "",
                }
            },
            { "standalone.MonthNames",
                new String[] {
                    "Ocak",
                    "\u015eubat",
                    "Mart",
                    "Nisan",
                    "May\u0131s",
                    "Haziran",
                    "Temmuz",
                    "A\u011fustos",
                    "Eyl\u00fcl",
                    "Ekim",
                    "Kas\u0131m",
                    "Aral\u0131k",
                    "",
                }
            },
            { "MonthAbbreviations",
                new String[] {
                    "Oca",
                    "\u015eub",
                    "Mar",
                    "Nis",
                    "May",
                    "Haz",
                    "Tem",
                    "A\u011fu",
                    "Eyl",
                    "Eki",
                    "Kas",
                    "Ara",
                    "",
                }
            },
            { "standalone.MonthAbbreviations",
                new String[] {
                    "Oca",
                    "\u015eub",
                    "Mar",
                    "Nis",
                    "May",
                    "Haz",
                    "Tem",
                    "A\u011fu",
                    "Eyl",
                    "Eki",
                    "Kas",
                    "Ara",
                    "",
                }
            },
            { "MonthNarrows",
                new String[] {
                    "O",
                    "\u015e",
                    "M",
                    "N",
                    "M",
                    "H",
                    "T",
                    "A",
                    "E",
                    "E",
                    "K",
                    "A",
                    "",
                }
            },
            { "standalone.MonthNarrows",
                new String[] {
                    "O",
                    "\u015e",
                    "M",
                    "N",
                    "M",
                    "H",
                    "T",
                    "A",
                    "E",
                    "E",
                    "K",
                    "A",
                    "",
                }
            },
            { "DayNames",
                new String[] {
                    "Pazar",
                    "Pazartesi",
                    "Sal\u0131",
                    "\u00c7ar\u015famba",
                    "Per\u015fembe",
                    "Cuma",
                    "Cumartesi",
                }
            },
            { "standalone.DayNames",
                new String[] {
                    "Pazar",
                    "Pazartesi",
                    "Sal\u0131",
                    "\u00c7ar\u015famba",
                    "Per\u015fembe",
                    "Cuma",
                    "Cumartesi",
                }
            },
            { "DayAbbreviations",
                new String[] {
                    "Paz",
                    "Pzt",
                    "Sal",
                    "\u00c7ar",
                    "Per",
                    "Cum",
                    "Cmt",
                }
            },
            { "standalone.DayAbbreviations",
                new String[] {
                    "Paz",
                    "Pzt",
                    "Sal",
                    "\u00c7ar",
                    "Per",
                    "Cum",
                    "Cmt",
                }
            },
            { "DayNarrows",
                new String[] {
                    "P",
                    "P",
                    "S",
                    "\u00c7",
                    "P",
                    "C",
                    "C",
                }
            },
            { "standalone.DayNarrows",
                new String[] {
                    "P",
                    "P",
                    "S",
                    "\u00c7",
                    "P",
                    "C",
                    "C",
                }
            },
            { "QuarterNames",
                new String[] {
                    "1. \u00e7eyrek",
                    "2. \u00e7eyrek",
                    "3. \u00e7eyrek",
                    "4. \u00e7eyrek",
                }
            },
            { "standalone.QuarterNames",
                new String[] {
                    "1. \u00e7eyrek",
                    "2. \u00e7eyrek",
                    "3. \u00e7eyrek",
                    "4. \u00e7eyrek",
                }
            },
            { "QuarterAbbreviations",
                new String[] {
                    "\u00c71",
                    "\u00c72",
                    "\u00c73",
                    "\u00c74",
                }
            },
            { "standalone.QuarterAbbreviations",
                new String[] {
                    "\u00c71",
                    "\u00c72",
                    "\u00c73",
                    "\u00c74",
                }
            },
            { "QuarterNarrows",
                new String[] {
                    "1",
                    "2",
                    "3",
                    "4",
                }
            },
            { "long.Eras",
                new String[] {
                    "Milattan \u00d6nce",
                    "Milattan Sonra",
                }
            },
            { "Eras",
                new String[] {
                    "M\u00d6",
                    "MS",
                }
            },
            { "field.era", "Miladi D\u00f6nem" },
            { "field.year", "Y\u0131l" },
            { "field.month", "Ay" },
            { "field.week", "Hafta" },
            { "field.weekday", "Haftan\u0131n G\u00fcn\u00fc" },
            { "field.dayperiod", "AM/PM" },
            { "field.hour", "Saat" },
            { "field.minute", "Dakika" },
            { "field.second", "Saniye" },
            { "field.zone", "Saat Dilimi" },
            { "TimePatterns",
                new String[] {
                    "HH:mm:ss zzzz",
                    "HH:mm:ss z",
                    "HH:mm:ss",
                    "HH:mm",
                }
            },
            { "DatePatterns",
                new String[] {
                    "d MMMM y EEEE",
                    "d MMMM y",
                    "d MMM y",
                    "dd.MM.yyyy",
                }
            },
            { "java.time.buddhist.DatePatterns",
                new String[] {
                    "dd MMMM y G EEEE",
                    "dd MMMM y G",
                    "dd MMM y G",
                    "dd.MM.yyyy G",
                }
            },
            { "buddhist.DatePatterns",
                new String[] {
                    "dd MMMM y GGGG EEEE",
                    "dd MMMM y GGGG",
                    "dd MMM y GGGG",
                    "dd.MM.yyyy GGGG",
                }
            },
            { "java.time.japanese.DatePatterns",
                new String[] {
                    "dd MMMM y G EEEE",
                    "dd MMMM y G",
                    "dd MMM y G",
                    "dd.MM.yyyy G",
                }
            },
            { "japanese.DatePatterns",
                new String[] {
                    "dd MMMM y GGGG EEEE",
                    "dd MMMM y GGGG",
                    "dd MMM y GGGG",
                    "dd.MM.yyyy GGGG",
                }
            },
            { "java.time.roc.DatePatterns",
                new String[] {
                    "dd MMMM y G EEEE",
                    "dd MMMM y G",
                    "dd MMM y G",
                    "dd.MM.yyyy G",
                }
            },
            { "roc.DatePatterns",
                new String[] {
                    "dd MMMM y GGGG EEEE",
                    "dd MMMM y GGGG",
                    "dd MMM y GGGG",
                    "dd.MM.yyyy GGGG",
                }
            },
            { "islamic.MonthNames",
                new String[] {
                    "Muharrem",
                    "Safer",
                    "Rebi\u00fclevvel",
                    "Rebi\u00fclahir",
                    "Cemaziyelevvel",
                    "Cemaziyelahir",
                    "Recep",
                    "\u015eaban",
                    "Ramazan",
                    "\u015eevval",
                    "Zilkade",
                    "Zilhicce",
                    "",
                }
            },
            { "java.time.islamic.DatePatterns",
                new String[] {
                    "dd MMMM y G EEEE",
                    "dd MMMM y G",
                    "dd MMM y G",
                    "dd.MM.yyyy G",
                }
            },
            { "islamic.DatePatterns",
                new String[] {
                    "dd MMMM y GGGG EEEE",
                    "dd MMMM y GGGG",
                    "dd MMM y GGGG",
                    "dd.MM.yyyy GGGG",
                }
            },
            { "calendarname.islamic-civil", "Arap Takvimi" },
            { "calendarname.islamicc", "Arap Takvimi" },
            { "calendarname.roc", "\u00c7in Cumhuriyeti Takvimi" },
            { "calendarname.japanese", "Japon Takvimi" },
            { "calendarname.islamic", "Hicri Takvim" },
            { "calendarname.buddhist", "Budist Takvimi" },
            { "calendarname.gregorian", "Miladi Takvim" },
            { "calendarname.gregory", "Miladi Takvim" },
            { "DefaultNumberingSystem", "latn" },
            { "latn.NumberElements",
                new String[] {
                    ",",
                    ".",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                }
            },
            { "NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "#,##0.00\u00a0\u00a4",
                    "%#,##0",
                }
            },
        };
        return data;
    }
}
