#pragma once

// stateMachine = -1
// indexTest = 0

// def parse(str):
//     s = ""
//     for i in range(len(str)//2):
//         s = s + "0x" + str[2* i: 2 * i+2:] + ", "
//     print(s[:-2])
//     return s


// def structure(n):
//     for i in range(n + 1):
//         print("{ \n .publicKey = pub_" + str(i) + ", \n .privateKey = pri_" + str(i) + ", \n  .sharedKey = x_" + str(i) + ", \n .flag = result__" + str(i) + " \n}, ")

// if __name__ == '__main__':
//     structure(215)


//     # f = open("", 'r')
//     #
//     # for line in f:
//     #     if line.find("tcId") != -1:
//     #         stateMachine = 0
//     #         continue
//     #
//     #     if stateMachine == 0:
//     #         print("//" + "Test vector "  + str(indexTest) + ": "+ line)
//     #         stateMachine += 1
//     #         continue
//     #
//     #     if stateMachine == 1:
//     #         id = "public";
//     #         idLen = 11;
//     #         indexStart = line.find(id)
//     #         indexEnd = line.find(',')
//     #         print("static uint8_t pub_" + str(indexTest) + "  [65] = {")
//     #         parse(line[indexStart + idLen:indexEnd:])
//     #         print("};")
//     #         stateMachine +=1
//     #         continue
//     #
//     #     if stateMachine == 2:
//     #         id = "private";
//     #         idLen = 12;
//     #         indexStart = line.find(id)
//     #         indexEnd = line.find(',')
//     #         print("static uint8_t pri_" + str(indexTest) + "  [32] = {")
//     #         parse(line[indexStart + idLen:indexEnd:])
//     #         print("};")
//     #         stateMachine +=1
//     #         continue
//     #
//     #
//     #     if stateMachine == 3:
//     #         id = "shared";
//     #         idLen = 11;
//     #         indexStart = line.find(id)
//     #         indexEnd = line.find(',')
//     #         print("static uint8_t x_" + str(indexTest) + "  [32] = {")
//     #         parse(line[indexStart + idLen:indexEnd:])
//     #         print("};")
//     #         stateMachine +=1
//     #         continue
//     #
//     #     if stateMachine == 4:
//     #         id = "result";
//     #         idLen = 11;
//     #         indexStart = line.find(id)
//     #         indexEnd = line.find(',')
//     #         result = line[indexStart + idLen:indexEnd - 1]
//     #         if (result == "valid"):
//     #             print("static const uint64_t result__" + str(indexTest) + " = 0;\n")
//     #         elif (result == "invalid"):
//     #             print(" static const uint64_t result__" + str(indexTest) + " = 18446744073709551615;\n")
//     #         elif (result == "acceptable"):
//     #             print("static const uint64_t result__" + str(indexTest) + " = 1;\n")
//     #
//     #         # if (result == "valid"):
//     #         #     print("ok = ok && (success == 0); \n ok = ok && compare_and_print(32, result, x_0);")
//     #         # elif (result == "invalid"):
//     #         #     print("ok = ok && (success == 18446744073709551615);")
//     #         # elif (result == "acceptable"):
//     #         #     print("if (success == 0) \n ok = ok && compare_and_print(32, result, x_0); ");
//     #         # else:
//     #         #     print("SDDSS")
//     #         stateMachine +=1
//     #         indexTest += 1
//     #         stateMachine = -1
//     #         continue






//           "public" : "0462d5bd3372af75fe85a040715d0f502428e07046868b0bfdfa61d731afe44f26ac333a93a9e70a81cd5a95b5bf8d13990eb741c8c38872b4a07d275a014e30cf",
//           "private" : "0612465c89a023ab17855b0a6bcebfd3febb53aef84138647b5352e02c10c346",
//           "shared" : "53020d908b0219328b658b525f26780e3ae12bcd952bb25a93bc0895e1714285",
//           "result" : "valid",


typedef struct 
{
	uint8_t* publicKey;
	uint8_t* privateKey;
	uint8_t* sharedKey;
	uint64_t flag;	
} 
	ecdhp256_w_i;

//Test vector 0:           "comment" : "normal case",

static uint8_t pub_0  [65] = {
0x04, 0x62, 0xd5, 0xbd, 0x33, 0x72, 0xaf, 0x75, 0xfe, 0x85, 0xa0, 0x40, 0x71, 0x5d, 0x0f, 0x50, 0x24, 0x28, 0xe0, 0x70, 0x46, 0x86, 0x8b, 0x0b, 0xfd, 0xfa, 0x61, 0xd7, 0x31, 0xaf, 0xe4, 0x4f, 0x26, 0xac, 0x33, 0x3a, 0x93, 0xa9, 0xe7, 0x0a, 0x81, 0xcd, 0x5a, 0x95, 0xb5, 0xbf, 0x8d, 0x13, 0x99, 0x0e, 0xb7, 0x41, 0xc8, 0xc3, 0x88, 0x72, 0xb4, 0xa0, 0x7d, 0x27, 0x5a, 0x01, 0x4e, 0x30, 0xcf
};
static uint8_t pri_0  [32] = {
0x06, 0x12, 0x46, 0x5c, 0x89, 0xa0, 0x23, 0xab, 0x17, 0x85, 0x5b, 0x0a, 0x6b, 0xce, 0xbf, 0xd3, 0xfe, 0xbb, 0x53, 0xae, 0xf8, 0x41, 0x38, 0x64, 0x7b, 0x53, 0x52, 0xe0, 0x2c, 0x10, 0xc3, 0x46
};
static uint8_t x_0  [32] = {
0x53, 0x02, 0x0d, 0x90, 0x8b, 0x02, 0x19, 0x32, 0x8b, 0x65, 0x8b, 0x52, 0x5f, 0x26, 0x78, 0x0e, 0x3a, 0xe1, 0x2b, 0xcd, 0x95, 0x2b, 0xb2, 0x5a, 0x93, 0xbc, 0x08, 0x95, 0xe1, 0x71, 0x42, 0x85
};

#define result__0 0

//Test vector 2:           "comment" : "edge case for shared secret",

static uint8_t pub_2  [65] = {
0x04, 0x58, 0xfd, 0x41, 0x68, 0xa8, 0x77, 0x95, 0x60, 0x3e, 0x2b, 0x04, 0x39, 0x02, 0x85, 0xbd, 0xca, 0x6e, 0x57, 0xde, 0x60, 0x27, 0xfe, 0x21, 0x1d, 0xd9, 0xd2, 0x5e, 0x22, 0x12, 0xd2, 0x9e, 0x62, 0x08, 0x0d, 0x36, 0xbd, 0x22, 0x4d, 0x74, 0x05, 0x50, 0x92, 0x95, 0xee, 0xd0, 0x2a, 0x17, 0x15, 0x0e, 0x03, 0xb3, 0x14, 0xf9, 0x6d, 0xa3, 0x74, 0x45, 0xb0, 0xd1, 0xd2, 0x93, 0x77, 0xd1, 0x2c
};
static uint8_t pri_2  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_2  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#define result__2 0

//Test vector 3:           "comment" : "edge case for shared secret",

static uint8_t pub_3  [65] = {
0x04, 0x0f, 0x6d, 0x20, 0xc0, 0x42, 0x61, 0xec, 0xc3, 0xe9, 0x28, 0x46, 0xac, 0xad, 0x48, 0xdc, 0x8e, 0xc5, 0xee, 0x35, 0xae, 0x08, 0x83, 0xf0, 0xd2, 0xea, 0x71, 0x21, 0x69, 0x06, 0xee, 0x1c, 0x47, 0xc0, 0x42, 0x68, 0x9a, 0x99, 0x6d, 0xd1, 0x28, 0x30, 0xae, 0x45, 0x93, 0x82, 0xe9, 0x4a, 0xac, 0x56, 0xb7, 0x17, 0xaf, 0x2e, 0x20, 0x80, 0x21, 0x5f, 0x9e, 0x41, 0x94, 0x9b, 0x1f, 0x52, 0xbe
};
static uint8_t pri_3  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_3  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#define result__3 0

//Test vector 4:           "comment" : "edge case for shared secret",

static uint8_t pub_4  [65] = {
0x04, 0x00, 0xc7, 0xde, 0xfe, 0xb1, 0xa1, 0x62, 0x36, 0x73, 0x8e, 0x9a, 0x11, 0x23, 0xba, 0x62, 0x1b, 0xc8, 0xe9, 0xa3, 0xf2, 0x48, 0x5b, 0x3f, 0x8f, 0xfd, 0xe7, 0xf9, 0xce, 0x98, 0xf5, 0xa8, 0xa1, 0xcb, 0x33, 0x8c, 0x39, 0x12, 0xb1, 0x79, 0x2f, 0x60, 0xc2, 0xb0, 0x6e, 0xc5, 0x23, 0x1e, 0x2d, 0x84, 0xb0, 0xe5, 0x96, 0xe9, 0xb7, 0x6d, 0x41, 0x9c, 0xe1, 0x05, 0xec, 0xe3, 0x79, 0x1d, 0xbc
};
static uint8_t pri_4  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_4  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
#define result__4 0

//Test vector 5:           "comment" : "edge case for shared secret",

static uint8_t pub_5  [65] = {
0x04, 0xe9, 0xb9, 0x8f, 0xb2, 0xc0, 0xac, 0x04, 0x5f, 0x8c, 0x76, 0x12, 0x5f, 0xfd, 0x99, 0xeb, 0x8a, 0x51, 0x57, 0xbe, 0x1d, 0x7d, 0xb3, 0xe8, 0x5d, 0x65, 0x5e, 0xc1, 0xd8, 0x21, 0x02, 0x88, 0xcf, 0x21, 0x8d, 0xf2, 0x4f, 0xd2, 0xc2, 0x74, 0x6b, 0xe5, 0x9d, 0xf4, 0x12, 0x62, 0xef, 0x3a, 0x97, 0xd9, 0x86, 0x74, 0x4b, 0x28, 0x36, 0x74, 0x8a, 0x74, 0x86, 0x23, 0x0a, 0x31, 0x9f, 0xfe, 0xc0
};
static uint8_t pri_5  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_5  [32] = {
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00
};
#define result__5 0

//Test vector 6:           "comment" : "edge case for shared secret",

static uint8_t pub_6  [65] = {
0x04, 0xe9, 0x48, 0x4e, 0x58, 0xf3, 0x33, 0x1b, 0x66, 0xff, 0xed, 0x6d, 0x90, 0xcb, 0x1c, 0x78, 0x06, 0x5f, 0xa2, 0x8c, 0xfb, 0xa5, 0xc7, 0xdd, 0x43, 0x52, 0x01, 0x3d, 0x32, 0x52, 0xee, 0x42, 0x77, 0xbd, 0x75, 0x03, 0xb0, 0x45, 0xa3, 0x8b, 0x4b, 0x24, 0x7b, 0x32, 0xc5, 0x95, 0x93, 0x58, 0x0f, 0x39, 0xe6, 0xab, 0xfa, 0x37, 0x6c, 0x3d, 0xca, 0x20, 0xcf, 0x7f, 0x9c, 0xfb, 0x65, 0x9e, 0x13
};
static uint8_t pri_6  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_6  [32] = {
0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff
};

#define result__6 0

//Test vector 7:           "comment" : "edge case for shared secret",

static uint8_t pub_7  [65] = {
0x04, 0x76, 0x7d, 0x7f, 0xbb, 0x84, 0xaa, 0x6a, 0x4d, 0xb1, 0x07, 0x93, 0x72, 0x64, 0x4e, 0x42, 0xec, 0xb2, 0xfe, 0xc2, 0x00, 0xc1, 0x78, 0x82, 0x23, 0x92, 0xcb, 0x8b, 0x95, 0x0f, 0xfd, 0xd0, 0xc9, 0x1c, 0x86, 0x85, 0x3c, 0xaf, 0xd0, 0x9b, 0x52, 0xba, 0x2f, 0x28, 0x7f, 0x0e, 0xba, 0xa2, 0x64, 0x15, 0xa3, 0xcf, 0xab, 0xaf, 0x92, 0xc6, 0xa6, 0x17, 0xa1, 0x99, 0x88, 0x56, 0x3d, 0x9d, 0xea
};
static uint8_t pri_7  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_7  [32] = {
0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x01, 0x00, 0x01
};
#define result__7 0

//Test vector 8:           "comment" : "edge case for shared secret",

static uint8_t pub_8  [65] = {
0x04, 0xc7, 0x4d, 0x54, 0x6f, 0x2f, 0xcc, 0x6d, 0xd3, 0x92, 0xf8, 0x5e, 0x5b, 0xe1, 0x67, 0xe3, 0x58, 0xde, 0x90, 0x87, 0x56, 0xb0, 0xc0, 0xbb, 0x01, 0xcb, 0x69, 0xd8, 0x64, 0xca, 0x08, 0x3e, 0x1c, 0x93, 0xf9, 0x59, 0xee, 0xce, 0x6e, 0x10, 0xee, 0x11, 0xbd, 0x39, 0x34, 0x20, 0x7d, 0x65, 0xae, 0x28, 0xaf, 0x68, 0xb0, 0x92, 0x58, 0x5a, 0x15, 0x09, 0x26, 0x0e, 0xce, 0xb3, 0x9b, 0x92, 0xef
};
static uint8_t pri_8  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_8  [32] = {
0x08, 0x5e, 0xc5, 0xa4, 0xaf, 0x40, 0x17, 0x6b, 0x63, 0x18, 0x90, 0x69, 0xae, 0xff, 0xcb, 0x22, 0x9c, 0x96, 0xd3, 0xe0, 0x46, 0xe0, 0x28, 0x3e, 0xd2, 0xf9, 0xda, 0xc2, 0x1b, 0x15, 0xad, 0x3c
};
#define result__8 0

//Test vector 9:           "comment" : "edge case for shared secret",

static uint8_t pub_9  [65] = {
0x04, 0x34, 0xfc, 0x9f, 0x1e, 0x7a, 0x09, 0x4c, 0xd2, 0x95, 0x98, 0xd1, 0x84, 0x1f, 0xa9, 0x61, 0x3d, 0xbe, 0x82, 0x31, 0x3d, 0x63, 0x3a, 0x51, 0xd6, 0x3f, 0xb6, 0xef, 0xf0, 0x74, 0xcc, 0x9b, 0x9a, 0x4e, 0xcf, 0xd9, 0xf2, 0x58, 0xc5, 0xc4, 0xd4, 0x21, 0x0b, 0x49, 0x75, 0x12, 0x13, 0xa2, 0x4c, 0x59, 0x69, 0x82, 0xbd, 0x1d, 0x54, 0xe0, 0x44, 0x54, 0x43, 0xf2, 0x1e, 0xf1, 0x54, 0x92, 0xa5
};
static uint8_t pri_9  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_9  [32] = {
0x19, 0x0c, 0x25, 0xf8, 0x8a, 0xd9, 0xae, 0x3a, 0x09, 0x8e, 0x6c, 0xff, 0xe6, 0xfd, 0x0b, 0x1b, 0xea, 0x42, 0x11, 0x4e, 0xb0, 0xce, 0xdd, 0x58, 0x68, 0xa4, 0x5c, 0x5f, 0xe2, 0x77, 0xdf, 0xf3
};
#define result__9 0

//Test vector 10:           "comment" : "edge case for shared secret",

static uint8_t pub_10  [65] = {
0x04, 0xd5, 0xc9, 0x6e, 0xfd, 0x19, 0x07, 0xfd, 0x48, 0xde, 0x2a, 0xd7, 0x15, 0xac, 0xf8, 0x2e, 0xae, 0x5c, 0x66, 0x90, 0xfe, 0x3e, 0xfe, 0x16, 0xa7, 0x8d, 0x61, 0xc6, 0x8d, 0x3b, 0xfd, 0x10, 0xdf, 0x03, 0xea, 0xc8, 0x16, 0xb9, 0xe7, 0xb7, 0x76, 0x19, 0x2a, 0x3f, 0x50, 0x75, 0x88, 0x7c, 0x0e, 0x22, 0x56, 0x17, 0x50, 0x58, 0x33, 0xca, 0x99, 0x7c, 0xda, 0x32, 0xfd, 0x0f, 0x67, 0x3c, 0x5e
};
static uint8_t pri_10  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_10  [32] = {
0x50, 0x74, 0x42, 0x00, 0x73, 0x22, 0xaa, 0x89, 0x53, 0x40, 0xcb, 0xa4, 0xab, 0xc2, 0xd7, 0x30, 0xbf, 0xd0, 0xb1, 0x6c, 0x2c, 0x79, 0xa4, 0x68, 0x15, 0xf8, 0x78, 0x0d, 0x2c, 0x55, 0xa2, 0xdd
};
#define result__10 0

//Test vector 11:           "comment" : "edge case for shared secret",

static uint8_t pub_11  [65] = {
0x04, 0xf4, 0x75, 0xf5, 0x03, 0xa7, 0x70, 0xdf, 0x72, 0xc4, 0x5a, 0xed, 0xfe, 0x42, 0xc0, 0x08, 0xf5, 0x9a, 0xa5, 0x7e, 0x72, 0xb2, 0x32, 0xf2, 0x66, 0x00, 0xbd, 0xd0, 0x35, 0x39, 0x57, 0xcb, 0x20, 0xbd, 0xb8, 0xf6, 0x40, 0x5b, 0x49, 0x18, 0x05, 0x0a, 0x35, 0x49, 0xf4, 0x4c, 0x07, 0xa8, 0xeb, 0xa8, 0x20, 0xcd, 0xce, 0x4e, 0xce, 0x69, 0x98, 0x88, 0xc6, 0x38, 0xdf, 0x66, 0xf5, 0x4f, 0x7c
};
static uint8_t pri_11  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_11  [32] = {
0x5f, 0x17, 0x7b, 0xfe, 0x19, 0xba, 0xaa, 0xee, 0x59, 0x7e, 0x68, 0xb6, 0xa8, 0x7a, 0x51, 0x9e, 0x80, 0x5e, 0x9d, 0x28, 0xa7, 0x0c, 0xb7, 0x2f, 0xd4, 0x0f, 0x0f, 0xe5, 0xa7, 0x54, 0xba, 0x45
};
#define result__11 0

//Test vector 12:           "comment" : "edge case for shared secret",

static uint8_t pub_12  [65] = {
0x04, 0xf3, 0xcb, 0x67, 0x54, 0xb7, 0xe2, 0xa8, 0x6d, 0x06, 0x4d, 0xfb, 0x9f, 0x90, 0x31, 0x85, 0xaa, 0xa4, 0xc9, 0x2b, 0x48, 0x1c, 0x2c, 0x1a, 0x1f, 0xf2, 0x76, 0x30, 0x3b, 0xbc, 0x41, 0x83, 0xe4, 0x9c, 0x31, 0x85, 0x99, 0xb0, 0x98, 0x4c, 0x35, 0x63, 0xdf, 0x33, 0x93, 0x11, 0xfe, 0x14, 0x3a, 0x7d, 0x92, 0x1e, 0xe7, 0x5b, 0x75, 0x5a, 0x52, 0xc6, 0xf8, 0x04, 0xf8, 0x97, 0xb8, 0x09, 0xf7
};
static uint8_t pri_12  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_12  [32] = {
0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff
};
#define result__12 0

//Test vector 13:           "comment" : "edge case for shared secret",

static uint8_t pub_13  [65] = {
0x04, 0xcc, 0xe1, 0x3f, 0xbd, 0xc9, 0x6a, 0x94, 0x6d, 0xfb, 0x8c, 0x6d, 0x9e, 0xd7, 0x62, 0xdb, 0xd1, 0x73, 0x16, 0x30, 0x45, 0x56, 0x89, 0xf5, 0x7a, 0x43, 0x7f, 0xee, 0x12, 0x4d, 0xd5, 0x4c, 0xec, 0xae, 0xf7, 0x80, 0x26, 0xc6, 0x53, 0x03, 0x0c, 0xf2, 0xf3, 0x14, 0xa6, 0x70, 0x64, 0x23, 0x6b, 0x0a, 0x35, 0x4d, 0xef, 0xeb, 0xc5, 0xe9, 0x0c, 0x94, 0x12, 0x4e, 0x9b, 0xf5, 0xc4, 0xfc, 0x24
};
static uint8_t pri_13  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_13  [32] = {
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04
};
#define result__13 0

//Test vector 14:           "comment" : "edge case for shared secret",

static uint8_t pub_14  [65] = {
0x04, 0x76, 0x33, 0xdf, 0xd0, 0xad, 0x06, 0x76, 0x50, 0x97, 0xbc, 0x11, 0xbd, 0x50, 0x22, 0xb2, 0x00, 0xdf, 0x31, 0xf2, 0x8c, 0x4f, 0xf0, 0x62, 0x54, 0x21, 0x22, 0x1a, 0xc7, 0xee, 0xb6, 0xe6, 0xf4, 0xcb, 0x9c, 0x67, 0x69, 0x36, 0x09, 0xdd, 0xd6, 0xf9, 0x23, 0x43, 0xa5, 0xa1, 0xc6, 0x35, 0x40, 0x82, 0x40, 0xf4, 0xf8, 0xe2, 0x71, 0x20, 0xc1, 0x25, 0x54, 0xc7, 0xff, 0x8c, 0x76, 0xe2, 0xfe
};
static uint8_t pri_14  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_14  [32] = {
0x80, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00
};
#define result__14 0

//Test vector 15:           "comment" : "edge case for shared secret",

static uint8_t pub_15  [65] = {
0x04, 0xa3, 0x86, 0xac, 0xe5, 0x73, 0xf8, 0x75, 0x58, 0xa6, 0x8e, 0xad, 0x2a, 0x20, 0x08, 0x8e, 0x3f, 0xe9, 0x28, 0xbd, 0xae, 0x9e, 0x10, 0x94, 0x46, 0xf9, 0x3a, 0x07, 0x8c, 0x15, 0x74, 0x1f, 0x04, 0x21, 0x26, 0x1e, 0x6d, 0xb2, 0xbf, 0x12, 0x10, 0x6e, 0x4c, 0x6b, 0xf8, 0x5b, 0x95, 0x81, 0xb4, 0xc0, 0x30, 0x2a, 0x52, 0x62, 0x22, 0xf9, 0x0a, 0xbc, 0x5a, 0x54, 0x92, 0x06, 0xb1, 0x10, 0x11
};
static uint8_t pri_15  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_15  [32] = {
0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff
};
#define result__15 0

//Test vector 16:           "comment" : "edge case for shared secret",

static uint8_t pub_16  [65] = {
0x04, 0x8e, 0x7b, 0x50, 0xf7, 0xd8, 0xc4, 0x4d, 0x5d, 0x34, 0x96, 0xc4, 0x31, 0x41, 0xa5, 0x02, 0xf4, 0xa4, 0x3f, 0x15, 0x3d, 0x03, 0xad, 0x43, 0xed, 0xa8, 0xe3, 0x95, 0x97, 0xf1, 0xd4, 0x77, 0xb8, 0x64, 0x7f, 0x3d, 0xa6, 0x79, 0x69, 0xb7, 0xf9, 0x89, 0xff, 0x4a, 0xdd, 0xc3, 0x93, 0x51, 0x5a, 0xf4, 0x0c, 0x82, 0x08, 0x5c, 0xe1, 0xf2, 0xee, 0x19, 0x54, 0x12, 0xc6, 0xf5, 0x83, 0x77, 0x4f
};
static uint8_t pri_16  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_16  [32] = {
0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff
};
#define result__16 0

//Test vector 17:           "comment" : "edge case for shared secret",

static uint8_t pub_17  [65] = {
0x04, 0xc8, 0x27, 0xfb, 0x93, 0x0f, 0xd5, 0x1d, 0x92, 0x60, 0x86, 0x19, 0x1b, 0x50, 0x2a, 0xf8, 0x3a, 0xbb, 0x5f, 0x71, 0x7d, 0xeb, 0xc8, 0xde, 0x29, 0x89, 0x7a, 0x39, 0x34, 0xb2, 0x57, 0x1c, 0xa0, 0x59, 0x90, 0xc0, 0x59, 0x7b, 0x0b, 0x7a, 0x2e, 0x42, 0xfe, 0xbd, 0x56, 0xb1, 0x32, 0x35, 0xd1, 0xd4, 0x08, 0xd7, 0x6e, 0xd2, 0xc9, 0x3b, 0x3f, 0xac, 0xf5, 0x14, 0xd9, 0x02, 0xf6, 0x91, 0x0a
};
static uint8_t pri_17  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_17  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
#define result__17 0

//Test vector 18:           "comment" : "y-coordinate of the public key is small",

static uint8_t pub_18  [65] = {
0x04, 0x3c, 0xbc, 0x1b, 0x31, 0xb4, 0x3f, 0x17, 0xdc, 0x20, 0x0d, 0xd7, 0x0c, 0x29, 0x44, 0xc0, 0x4c, 0x6c, 0xb1, 0xb0, 0x82, 0x82, 0x0c, 0x23, 0x4a, 0x30, 0x0b, 0x05, 0xb7, 0x76, 0x38, 0x44, 0xc7, 0x4f, 0xde, 0x0a, 0x4e, 0xf9, 0x38, 0x87, 0x46, 0x97, 0x93, 0x27, 0x0e, 0xb2, 0xff, 0x14, 0x82, 0x87, 0xda, 0x92, 0x65, 0xb0, 0x33, 0x4f, 0x9e, 0x26, 0x09, 0xaa, 0xc1, 0x6e, 0x8a, 0xd5, 0x03
};
static uint8_t pri_18  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_18  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0xcf, 0x22, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
#define result__18 0

//Test vector 19:           "comment" : "y-coordinate of the public key is small",

static uint8_t pub_19  [65] = {
0x04, 0x28, 0x30, 0xd9, 0x64, 0x89, 0xae, 0x24, 0xb7, 0x9c, 0xad, 0x42, 0x50, 0x56, 0xe8, 0x27, 0x46, 0xf9, 0xe3, 0xf4, 0x19, 0xab, 0x9a, 0xa2, 0x1c, 0xa1, 0xfb, 0xb1, 0x1c, 0x73, 0x25, 0xe7, 0xd3, 0x18, 0xab, 0xe6, 0x6f, 0x57, 0x5e, 0xe8, 0xa2, 0xf1, 0xc4, 0xa8, 0x0e, 0x35, 0x26, 0x0a, 0xe8, 0x2a, 0xd7, 0xd6, 0xf6, 0x61, 0xd1, 0x5f, 0x06, 0x96, 0x79, 0x30, 0xa5, 0x85, 0x09, 0x7e, 0xf7
};
static uint8_t pri_19  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_19  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x24, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#define result__19 0

//Test vector 20:           "comment" : "y-coordinate of the public key is small",

static uint8_t pub_20  [65] = {
0x04, 0x45, 0x0b, 0x6b, 0x6e, 0x20, 0x97, 0x17, 0x8e, 0x9d, 0x28, 0x50, 0x10, 0x95, 0x18, 0xd2, 0x8e, 0xb3, 0xb6, 0xde, 0xd2, 0x92, 0x2a, 0x54, 0x52, 0x00, 0x3b, 0xc2, 0xe4, 0xa4, 0xec, 0x77, 0x5c, 0x89, 0x4e, 0x90, 0xf0, 0xdf, 0x1b, 0x0e, 0x6c, 0xad, 0xb0, 0x3b, 0x9d, 0xe2, 0x4f, 0x6a, 0x22, 0xd1, 0xbd, 0x0a, 0x4a, 0x58, 0xcd, 0x64, 0x5c, 0x27, 0x3c, 0xae, 0x1c, 0x61, 0x9b, 0xfd, 0x61
};
static uint8_t pri_20  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_20  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xea, 0x77, 0xd4, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
#define result__20 0

//Test vector 21:           "comment" : "y-coordinate of the public key is large",

static uint8_t pub_21  [65] = {
0x04, 0x3c, 0xbc, 0x1b, 0x31, 0xb4, 0x3f, 0x17, 0xdc, 0x20, 0x0d, 0xd7, 0x0c, 0x29, 0x44, 0xc0, 0x4c, 0x6c, 0xb1, 0xb0, 0x82, 0x82, 0x0c, 0x23, 0x4a, 0x30, 0x0b, 0x05, 0xb7, 0x76, 0x38, 0x44, 0xc7, 0xb0, 0x21, 0xf5, 0xb0, 0x06, 0xc7, 0x78, 0xba, 0x68, 0x6c, 0xd8, 0xf1, 0x4d, 0x00, 0xeb, 0x7d, 0x78, 0x25, 0x6d, 0x9b, 0x4f, 0xcc, 0xb0, 0x61, 0xd9, 0xf6, 0x55, 0x3e, 0x91, 0x75, 0x2a, 0xfc
};
static uint8_t pri_21  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_21  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0xcf, 0x22, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
#define result__21 0

//Test vector 22:           "comment" : "y-coordinate of the public key is large",

static uint8_t pub_22  [65] = {
0x04, 0x28, 0x30, 0xd9, 0x64, 0x89, 0xae, 0x24, 0xb7, 0x9c, 0xad, 0x42, 0x50, 0x56, 0xe8, 0x27, 0x46, 0xf9, 0xe3, 0xf4, 0x19, 0xab, 0x9a, 0xa2, 0x1c, 0xa1, 0xfb, 0xb1, 0x1c, 0x73, 0x25, 0xe7, 0xd3, 0xe7, 0x54, 0x19, 0x8f, 0xa8, 0xa1, 0x17, 0x5e, 0x0e, 0x3b, 0x57, 0xf1, 0xca, 0xd9, 0xf5, 0x17, 0xd5, 0x28, 0x29, 0x0a, 0x9e, 0x2e, 0xa0, 0xf9, 0x69, 0x86, 0xcf, 0x5a, 0x7a, 0xf6, 0x81, 0x08
};
static uint8_t pri_22  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_22  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x24, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#define result__22 0

//Test vector 23:           "comment" : "y-coordinate of the public key is large",

static uint8_t pub_23  [65] = {
0x04, 0x45, 0x0b, 0x6b, 0x6e, 0x20, 0x97, 0x17, 0x8e, 0x9d, 0x28, 0x50, 0x10, 0x95, 0x18, 0xd2, 0x8e, 0xb3, 0xb6, 0xde, 0xd2, 0x92, 0x2a, 0x54, 0x52, 0x00, 0x3b, 0xc2, 0xe4, 0xa4, 0xec, 0x77, 0x5c, 0x76, 0xb1, 0x6f, 0x0e, 0x20, 0xe4, 0xf1, 0x94, 0x52, 0x4f, 0xc4, 0x62, 0x1d, 0xb0, 0x95, 0xdd, 0x2e, 0x42, 0xf5, 0xb6, 0xa7, 0x32, 0x9b, 0xa3, 0xd8, 0xc3, 0x51, 0xe3, 0x9e, 0x64, 0x02, 0x9e
};
static uint8_t pri_23  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_23  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xea, 0x77, 0xd4, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
#define result__23 0

//Test vector 24:           "comment" : "y-coordinate of the public key has many trailing 1's",

static uint8_t pub_24  [65] = {
0x04, 0x9a, 0x0f, 0x0e, 0x3d, 0xd3, 0x14, 0x17, 0xbb, 0xd9, 0xe2, 0x98, 0xbc, 0x06, 0x8a, 0xb6, 0xd5, 0xc3, 0x67, 0x33, 0xaf, 0x26, 0xed, 0x67, 0x67, 0x6f, 0x41, 0x0c, 0x80, 0x4b, 0x8b, 0x2c, 0xa1, 0xb0, 0x2c, 0x82, 0xf3, 0xa6, 0x1a, 0x37, 0x6d, 0xb7, 0x95, 0x62, 0x6e, 0x94, 0x00, 0x55, 0x71, 0x12, 0x27, 0x3a, 0x36, 0xcd, 0xdb, 0x08, 0xca, 0xaa, 0x43, 0x95, 0x39, 0x65, 0x45, 0x47, 0x30
};
static uint8_t pri_24  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_24  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x08, 0x90, 0x11, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
#define result__24 0

//Test vector 25:           "comment" : "y-coordinate of the public key has many trailing 1's",

static uint8_t pub_25  [65] = {
0x04, 0x8e, 0x5d, 0x22, 0xd5, 0xe5, 0x3e, 0xc7, 0x97, 0xc5, 0x5e, 0xcd, 0x68, 0xa0, 0x8a, 0x7c, 0x33, 0x61, 0xcd, 0x99, 0xca, 0x7f, 0xad, 0x1a, 0x68, 0xea, 0x80, 0x2a, 0x6a, 0x4c, 0xb5, 0x8a, 0x91, 0x8e, 0xa7, 0xa0, 0x70, 0x23, 0xef, 0x67, 0x67, 0x70, 0x24, 0xbd, 0x38, 0x41, 0xe1, 0x87, 0xc6, 0x4b, 0x30, 0xa3, 0x0a, 0x37, 0x50, 0xeb, 0x2e, 0xe8, 0x73, 0xfb, 0xe5, 0x8f, 0xa1, 0x35, 0x7b
};
static uint8_t pri_25  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_25  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x6b, 0xd1, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#define result__25 0

//Test vector 26:           "comment" : "y-coordinate of the public key has many trailing 1's",

static uint8_t pub_26  [65] = {
0x04, 0x29, 0x3a, 0xa3, 0x49, 0xb9, 0x34, 0xab, 0x2c, 0x83, 0x9c, 0xf5, 0x4b, 0x8a, 0x73, 0x7d, 0xf2, 0x30, 0x4e, 0xf9, 0xb2, 0x0f, 0xa4, 0x94, 0xe3, 0x1a, 0xd6, 0x2b, 0x31, 0x5d, 0xd6, 0xa5, 0x3c, 0x11, 0x81, 0x82, 0xb8, 0x5e, 0xf4, 0x66, 0xeb, 0x9a, 0x8e, 0x87, 0xf9, 0x66, 0x1f, 0x7d, 0x01, 0x79, 0x84, 0xc1, 0x5e, 0xa8, 0x20, 0x43, 0xf5, 0x36, 0xd1, 0xee, 0x6a, 0x6d, 0x95, 0xb5, 0x09
};
static uint8_t pri_26  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_26  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x09, 0x9f, 0x55, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
#define result__26 0

//Test vector 27:           "comment" : "y-coordinate of the public key has many trailing 0's",

static uint8_t pub_27  [65] = {
0x04, 0x9a, 0x0f, 0x0e, 0x3d, 0xd3, 0x14, 0x17, 0xbb, 0xd9, 0xe2, 0x98, 0xbc, 0x06, 0x8a, 0xb6, 0xd5, 0xc3, 0x67, 0x33, 0xaf, 0x26, 0xed, 0x67, 0x67, 0x6f, 0x41, 0x0c, 0x80, 0x4b, 0x8b, 0x2c, 0xa1, 0x4f, 0xd3, 0x7d, 0x0b, 0x59, 0xe5, 0xc8, 0x93, 0x48, 0x6a, 0x9d, 0x91, 0x6b, 0xff, 0xaa, 0x8e, 0xed, 0xd8, 0xc5, 0xca, 0x32, 0x24, 0xf7, 0x35, 0x55, 0xbc, 0x6a, 0xc6, 0x9a, 0xba, 0xb8, 0xcf
};
static uint8_t pri_27  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_27  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x08, 0x90, 0x11, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
#define result__27 0

//Test vector 28:           "comment" : "y-coordinate of the public key has many trailing 0's",

static uint8_t pub_28  [65] = {
0x04, 0x8e, 0x5d, 0x22, 0xd5, 0xe5, 0x3e, 0xc7, 0x97, 0xc5, 0x5e, 0xcd, 0x68, 0xa0, 0x8a, 0x7c, 0x33, 0x61, 0xcd, 0x99, 0xca, 0x7f, 0xad, 0x1a, 0x68, 0xea, 0x80, 0x2a, 0x6a, 0x4c, 0xb5, 0x8a, 0x91, 0x71, 0x58, 0x5f, 0x8e, 0xdc, 0x10, 0x98, 0x99, 0x8f, 0xdb, 0x42, 0xc7, 0xbe, 0x1e, 0x78, 0x39, 0xb4, 0xcf, 0x5c, 0xf6, 0xc8, 0xaf, 0x14, 0xd1, 0x17, 0x8c, 0x04, 0x1a, 0x70, 0x5e, 0xca, 0x84
};
static uint8_t pri_28  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_28  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x6b, 0xd1, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#define result__28 0

//Test vector 29:           "comment" : "y-coordinate of the public key has many trailing 0's",

static uint8_t pub_29  [65] = {
0x04, 0x29, 0x3a, 0xa3, 0x49, 0xb9, 0x34, 0xab, 0x2c, 0x83, 0x9c, 0xf5, 0x4b, 0x8a, 0x73, 0x7d, 0xf2, 0x30, 0x4e, 0xf9, 0xb2, 0x0f, 0xa4, 0x94, 0xe3, 0x1a, 0xd6, 0x2b, 0x31, 0x5d, 0xd6, 0xa5, 0x3c, 0xee, 0x7e, 0x7d, 0x46, 0xa1, 0x0b, 0x99, 0x15, 0x65, 0x71, 0x78, 0x06, 0x99, 0xe0, 0x82, 0xfe, 0x86, 0x7b, 0x3e, 0xa2, 0x57, 0xdf, 0xbc, 0x0a, 0xc9, 0x2e, 0x11, 0x95, 0x92, 0x6a, 0x4a, 0xf6
};
static uint8_t pri_29  [32] = {
0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce, 0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1, 0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a
};
static uint8_t x_29  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x09, 0x9f, 0x55, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
#define result__29 0

//Test vector 30:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_30  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x48, 0x5c, 0x78, 0x0e, 0x2f, 0x83, 0xd7, 0x24, 0x33, 0xbd, 0x5d, 0x84, 0xa0, 0x6b, 0xb6, 0x54, 0x1c, 0x2a, 0xf3, 0x1d, 0xae, 0x87, 0x17, 0x28, 0xbf, 0x85, 0x6a, 0x17, 0x4f, 0x93, 0xf4
};
static uint8_t pri_30  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_30  [32] = {
0xcf, 0xe4, 0x07, 0x7c, 0x87, 0x30, 0xb1, 0xc9, 0x38, 0x45, 0x81, 0xd3, 0x6b, 0xff, 0x55, 0x42, 0xbc, 0x41, 0x7c, 0x9e, 0xff, 0x5c, 0x2a, 0xfc, 0xb9, 0x8c, 0xc8, 0x82, 0x9b, 0x2c, 0xe8, 0x48
};
#define result__30 0

//Test vector 31:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_31  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4f, 0x2b, 0x92, 0xb4, 0xc5, 0x96, 0xa5, 0xa4, 0x7f, 0x8b, 0x04, 0x1d, 0x2d, 0xea, 0x60, 0x43, 0x02, 0x1a, 0xc7, 0x7b, 0x9a, 0x80, 0xb1, 0x34, 0x3a, 0xc9, 0xd7, 0x78, 0xf4, 0xf8, 0xf7, 0x33
};
static uint8_t pri_31  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_31  [32] = {
0x49, 0xae, 0x50, 0xfe, 0x09, 0x6a, 0x6c, 0xd2, 0x66, 0x98, 0xb7, 0x83, 0x56, 0xb2, 0xc8, 0xad, 0xf1, 0xf6, 0xa3, 0x49, 0x0f, 0x14, 0xe3, 0x64, 0x62, 0x9f, 0x7a, 0x06, 0x39, 0x44, 0x25, 0x09
};
#define result__31 0

//Test vector 32:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_32  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x38, 0x12, 0x0b, 0xe6, 0xab, 0x31, 0xed, 0xfa, 0x34, 0x76, 0x8c, 0x43, 0x87, 0xd2, 0xf8, 0x4f, 0xb4, 0xb0, 0xbe, 0x8a, 0x9a, 0x98, 0x58, 0x64, 0xa1, 0x57, 0x5f, 0x44, 0x36, 0xbb, 0x37, 0xb0
};
static uint8_t pri_32  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_32  [32] = {
0x5a, 0x13, 0x34, 0x57, 0x2b, 0x2a, 0x71, 0x1e, 0xad, 0x8b, 0x46, 0x53, 0xeb, 0x31, 0x0c, 0xd8, 0xd9, 0xfd, 0x11, 0x43, 0x99, 0x37, 0x9a, 0x8f, 0x6b, 0x87, 0x2e, 0x3b, 0x8f, 0xdd, 0xa2, 0xd9
};
#define result__32 0

//Test vector 33:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_33  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x46, 0x2c, 0x04, 0x66, 0xe4, 0x18, 0x02, 0x23, 0x8d, 0x6c, 0x92, 0x5e, 0xcb, 0xef, 0xc7, 0x47, 0xcf, 0xe5, 0x05, 0xea, 0x19, 0x6a, 0xf9, 0xa2, 0xd1, 0x1b, 0x62, 0x85, 0x0f, 0xce, 0x94, 0x6e
};
static uint8_t pri_33  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_33  [32] = {
0xc7, 0x37, 0x55, 0x13, 0x3b, 0x6b, 0x9b, 0x4b, 0x2a, 0x00, 0x63, 0x1c, 0xbc, 0x79, 0x40, 0xec, 0xbe, 0x6e, 0xc0, 0x8f, 0x20, 0x44, 0x80, 0x71, 0x42, 0x2e, 0x33, 0x62, 0xf2, 0x55, 0x68, 0x88
};
#define result__33 0

//Test vector 34:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_34  [65] = {
0x04, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x15, 0x82, 0xfa, 0x32, 0xe2, 0xd4, 0xa8, 0x9d, 0xfc, 0xfb, 0x3d, 0x0b, 0x14, 0x9f, 0x66, 0x7d, 0xba, 0x33, 0x29, 0x49, 0x0f, 0x4d, 0x64, 0xee, 0x2a, 0xd5, 0x86, 0xc0, 0xc9, 0xe8, 0xc5, 0x08
};
static uint8_t pri_34  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_34  [32] = {
0x06, 0xfa, 0x10, 0x59, 0x93, 0x5e, 0x47, 0xa9, 0xfd, 0x66, 0x7e, 0x13, 0xf4, 0x69, 0x61, 0x4e, 0xb2, 0x57, 0xcc, 0x9a, 0x7e, 0x3f, 0xc5, 0x99, 0xbf, 0xb9, 0x27, 0x80, 0xd5, 0x9b, 0x14, 0x6d
};
#define result__34 0

//Test vector 35:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_35  [65] = {
0x04, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x01, 0x00, 0x01, 0x68, 0x4c, 0x8a, 0x95, 0x86, 0xed, 0x6f, 0x9c, 0xbe, 0x44, 0x70, 0x58, 0xa7, 0xda, 0x21, 0x08, 0xba, 0xb1, 0xe5, 0xe0, 0xa6, 0x0d, 0x1f, 0x73, 0xe4, 0xe2, 0xe7, 0x13, 0xf0, 0xa3, 0xdf, 0xe0
};
static uint8_t pri_35  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_35  [32] = {
0xf2, 0x37, 0xdf, 0x4c, 0x10, 0xbd, 0x3e, 0x35, 0x79, 0x71, 0xbb, 0x2b, 0x16, 0xb2, 0x93, 0x56, 0x6b, 0x7e, 0x35, 0x5b, 0xdc, 0x81, 0x41, 0xd6, 0xc9, 0x2c, 0xab, 0xc6, 0x82, 0x98, 0x3c, 0x45
};
#define result__35 0

//Test vector 36:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_36  [65] = {
0x04, 0x08, 0x5e, 0xc5, 0xa4, 0xaf, 0x40, 0x17, 0x6b, 0x63, 0x18, 0x90, 0x69, 0xae, 0xff, 0xcb, 0x22, 0x9c, 0x96, 0xd3, 0xe0, 0x46, 0xe0, 0x28, 0x3e, 0xd2, 0xf9, 0xda, 0xc2, 0x1b, 0x15, 0xad, 0x3c, 0x78, 0x59, 0xf9, 0x7c, 0xb6, 0xe2, 0x03, 0xf4, 0x6b, 0xf3, 0x43, 0x8f, 0x61, 0x28, 0x23, 0x25, 0xe9, 0x4e, 0x68, 0x1b, 0x60, 0xb5, 0x66, 0x97, 0x88, 0xae, 0xb0, 0x65, 0x5b, 0xf1, 0x9d, 0x38
};
static uint8_t pri_36  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_36  [32] = {
0xd8, 0x74, 0xb5, 0x56, 0x78, 0xd0, 0xa0, 0x4d, 0x21, 0x6c, 0x31, 0xb0, 0x2f, 0x3a, 0xd1, 0xf3, 0x0c, 0x92, 0xca, 0xaf, 0x16, 0x8f, 0x34, 0xe3, 0xa7, 0x43, 0x35, 0x6d, 0x92, 0x76, 0xe9, 0x93
};
#define result__36 0

//Test vector 37:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_37  [65] = {
0x04, 0x19, 0x0c, 0x25, 0xf8, 0x8a, 0xd9, 0xae, 0x3a, 0x09, 0x8e, 0x6c, 0xff, 0xe6, 0xfd, 0x0b, 0x1b, 0xea, 0x42, 0x11, 0x4e, 0xb0, 0xce, 0xdd, 0x58, 0x68, 0xa4, 0x5c, 0x5f, 0xe2, 0x77, 0xdf, 0xf3, 0x21, 0xb8, 0x34, 0x2e, 0xf0, 0x77, 0xbc, 0x67, 0x24, 0x11, 0x24, 0x03, 0xea, 0xee, 0x5a, 0x15, 0xb4, 0xc3, 0x1a, 0x71, 0x58, 0x9f, 0x02, 0xde, 0xd0, 0x9c, 0xd9, 0x9c, 0xc5, 0xdb, 0x9c, 0x83
};
static uint8_t pri_37  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_37  [32] = {
0x11, 0xa8, 0x58, 0x20, 0x57, 0x46, 0x3f, 0xc7, 0x6f, 0xda, 0x3a, 0xb8, 0x08, 0x7e, 0xb0, 0xa4, 0x20, 0xb0, 0xd6, 0x01, 0xbb, 0x31, 0x34, 0x16, 0x5a, 0x36, 0x96, 0x46, 0x93, 0x1e, 0x52, 0xa6
};
#define result__37 0

//Test vector 38:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_38  [65] = {
0x04, 0x50, 0x74, 0x42, 0x00, 0x73, 0x22, 0xaa, 0x89, 0x53, 0x40, 0xcb, 0xa4, 0xab, 0xc2, 0xd7, 0x30, 0xbf, 0xd0, 0xb1, 0x6c, 0x2c, 0x79, 0xa4, 0x68, 0x15, 0xf8, 0x78, 0x0d, 0x2c, 0x55, 0xa2, 0xdd, 0x46, 0x19, 0xd6, 0x9f, 0x99, 0x40, 0xf5, 0x16, 0x63, 0xaa, 0x12, 0x38, 0x1b, 0xc7, 0xcf, 0x67, 0x8b, 0xd1, 0xa7, 0x2a, 0x49, 0xfb, 0xc1, 0x1b, 0x0b, 0x69, 0xcb, 0x22, 0xd1, 0xaf, 0x9f, 0x2d
};
static uint8_t pri_38  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_38  [32] = {
0x4e, 0x17, 0x3a, 0x80, 0x90, 0x7f, 0x36, 0x1f, 0xe5, 0xa5, 0xd3, 0x35, 0xba, 0x76, 0x85, 0xd5, 0xeb, 0xa9, 0x3e, 0x9d, 0xfc, 0x8d, 0x8f, 0xcd, 0xb1, 0xdc, 0xd2, 0xd2, 0xbd, 0xe2, 0x75, 0x07
};
#define result__38 0

//Test vector 39:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_39  [65] = {
0x04, 0x5f, 0x17, 0x7b, 0xfe, 0x19, 0xba, 0xaa, 0xee, 0x59, 0x7e, 0x68, 0xb6, 0xa8, 0x7a, 0x51, 0x9e, 0x80, 0x5e, 0x9d, 0x28, 0xa7, 0x0c, 0xb7, 0x2f, 0xd4, 0x0f, 0x0f, 0xe5, 0xa7, 0x54, 0xba, 0x45, 0x62, 0xca, 0x11, 0x03, 0xf7, 0x0a, 0x20, 0x06, 0xcd, 0x1f, 0x67, 0xf5, 0xf6, 0xa3, 0x58, 0x0b, 0x29, 0xdc, 0x44, 0x6a, 0xbc, 0x90, 0xe0, 0xe9, 0x10, 0xc1, 0xe0, 0x5a, 0x9a, 0xa7, 0x88, 0xcd
};
static uint8_t pri_39  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_39  [32] = {
0x73, 0x22, 0x04, 0x71, 0xec, 0x8b, 0xad, 0x99, 0xa2, 0x97, 0xdb, 0x48, 0x8a, 0x34, 0xa2, 0x59, 0xf9, 0xbc, 0x89, 0x1f, 0xfa, 0xf0, 0x99, 0x22, 0xe6, 0xb5, 0x00, 0x1f, 0x5d, 0xf6, 0x70, 0x18
};
#define result__39 0

//Test vector 40:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_40  [65] = {
0x04, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x2e, 0x22, 0x13, 0xca, 0xf0, 0x30, 0x33, 0xe0, 0xfd, 0x0f, 0x79, 0x51, 0x15, 0x4f, 0x6e, 0x6c, 0x3a, 0x92, 0x44, 0xa7, 0x2f, 0xac, 0xa6, 0x5e, 0x9c, 0xe9, 0xee, 0xb5, 0xc8, 0xe1, 0xce, 0xa9
};
static uint8_t pri_40  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_40  [32] = {
0x55, 0xd0, 0xa2, 0x03, 0xe2, 0x2f, 0xfb, 0x52, 0x3c, 0x8d, 0x27, 0x05, 0x06, 0x0c, 0xee, 0x9d, 0x28, 0x30, 0x8b, 0x51, 0xf1, 0x84, 0xbe, 0xef, 0xc5, 0x18, 0xcf, 0xf6, 0x90, 0xba, 0xd3, 0x46
};
#define result__40 0

//Test vector 41:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_41  [65] = {
0x04, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x2b, 0xe8, 0x78, 0x9d, 0xb8, 0x1b, 0xb4, 0x87, 0x0a, 0x9e, 0x60, 0xc5, 0xc1, 0x8c, 0x80, 0xc8, 0x3d, 0xe4, 0x64, 0x27, 0x72, 0x81, 0xf1, 0xaf, 0x1e, 0x64, 0x08, 0x43, 0xa1, 0xa3, 0x14, 0x8e
};
static uint8_t pri_41  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_41  [32] = {
0x25, 0x18, 0xd8, 0x46, 0xe5, 0x77, 0xd9, 0x5e, 0x9e, 0x7b, 0xc7, 0x66, 0xcd, 0xe7, 0x99, 0x7c, 0xb8, 0x87, 0xfb, 0x26, 0x6d, 0x3a, 0x6c, 0xb5, 0x98, 0xa8, 0x39, 0xfd, 0x54, 0xaa, 0x2f, 0x4f
};
#define result__41 0

//Test vector 42:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_42  [65] = {
0x04, 0x80, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x72, 0x25, 0x40, 0xf8, 0xa4, 0x71, 0xc3, 0x79, 0x08, 0x3c, 0x60, 0x0b, 0x58, 0xfd, 0xe4, 0xd9, 0x5c, 0x7d, 0xca, 0xd5, 0x09, 0x5f, 0x42, 0x19, 0xfc, 0x5e, 0x9b, 0xdd, 0xe3, 0xc5, 0xcd, 0x39
};
static uint8_t pri_42  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_42  [32] = {
0xbd, 0xb4, 0x9f, 0x4b, 0xdf, 0x42, 0xac, 0x64, 0x50, 0x4e, 0x9c, 0xe6, 0x77, 0xb3, 0xec, 0x5c, 0x0a, 0x03, 0x82, 0x8c, 0x5b, 0x3e, 0xfa, 0xd7, 0x26, 0x00, 0x56, 0x92, 0xd3, 0x5c, 0x0f, 0x26
};
#define result__42 0

//Test vector 43:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_43  [65] = {
0x04, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0x5d, 0xf8, 0x0f, 0xc6, 0xca, 0xe2, 0x6b, 0x6c, 0x19, 0x52, 0xfb, 0xd0, 0x0e, 0xd1, 0x74, 0xee, 0x12, 0x09, 0xd0, 0x69, 0x33, 0x5f, 0x5b, 0x48, 0x58, 0x8e, 0x29, 0xe8, 0x0b, 0x91, 0x91, 0xad
};
static uint8_t pri_43  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_43  [32] = {
0xf5, 0x03, 0xac, 0x65, 0x63, 0x7e, 0x0f, 0x17, 0xcb, 0x44, 0x08, 0x96, 0x1c, 0xb8, 0x82, 0xc8, 0x75, 0xe4, 0xc6, 0xef, 0x7a, 0x54, 0x8d, 0x2d, 0x52, 0xd8, 0xc2, 0xf6, 0x81, 0x83, 0x8c, 0x55
};
#define result__43 0

//Test vector 44:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_44  [65] = {
0x04, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x2c, 0x63, 0x65, 0x0e, 0x6a, 0x5d, 0x33, 0x2e, 0x29, 0x87, 0xdd, 0x09, 0xa7, 0x90, 0x08, 0xe8, 0xfa, 0xab, 0xbd, 0x37, 0xe4, 0x9c, 0xb0, 0x16, 0xbf, 0xb9, 0x2c, 0x8c, 0xd0, 0xf5, 0xda, 0x77
};
static uint8_t pri_44  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_44  [32] = {
0xe3, 0xc1, 0x8e, 0x7d, 0x73, 0x77, 0xdc, 0x54, 0x0b, 0xc4, 0x5c, 0x08, 0xd3, 0x89, 0xbd, 0xbe, 0x25, 0x5f, 0xa8, 0x0c, 0xa8, 0xfa, 0xf1, 0xef, 0x6b, 0x94, 0xd5, 0x20, 0x49, 0x98, 0x7d, 0x21
};
#define result__44 0

//Test vector 45:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_45  [65] = {
0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x11, 0x6c, 0x96, 0x4a, 0x4c, 0xd6, 0x06, 0x68, 0xbf, 0x89, 0xcf, 0xfe, 0x15, 0x77, 0x14, 0xa3, 0xce, 0x21, 0xb9, 0x3b, 0x3c, 0xa6, 0x07, 0xc8, 0xa5, 0xb9, 0x3a, 0xc5, 0x4f, 0xfc, 0x0a
};
static uint8_t pri_45  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_45  [32] = {
0x51, 0x6d, 0x6d, 0x32, 0x9b, 0x09, 0x5a, 0x7c, 0x7e, 0x93, 0xb4, 0x02, 0x3d, 0x4d, 0x05, 0x02, 0x0c, 0x14, 0x45, 0xef, 0x1d, 0xdc, 0xb3, 0x34, 0x7b, 0x3a, 0x27, 0xd7, 0xd7, 0xf5, 0x72, 0x65
};
#define result__45 0

//Test vector 46:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_46  [65] = {
0x04, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0xcf, 0x22, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0xc7, 0xc3, 0x06, 0x43, 0xab, 0xed, 0x0a, 0xf0, 0xa4, 0x9f, 0xe3, 0x52, 0xcb, 0x48, 0x3f, 0xf9, 0xb9, 0x7d, 0xcc, 0xdf, 0x42, 0x7c, 0x65, 0x8e, 0x87, 0x93, 0x24, 0x0d
};
static uint8_t pri_46  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_46  [32] = {
0x6f, 0xd2, 0x66, 0x61, 0x85, 0x1a, 0x8d, 0xe3, 0xc6, 0xd0, 0x6f, 0x83, 0x4e, 0xf3, 0xac, 0xb8, 0xf2, 0xa5, 0xf9, 0xc1, 0x36, 0xa9, 0x85, 0xff, 0xe1, 0x0d, 0x5e, 0xeb, 0x51, 0xed, 0xcf, 0xa3
};
#define result__46 0

//Test vector 47:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_47  [65] = {
0x04, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0xcf, 0x22, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x38, 0x3c, 0xf9, 0xbd, 0x54, 0x12, 0xf5, 0x0f, 0x5b, 0x60, 0x1c, 0xad, 0x34, 0xb7, 0xc0, 0x07, 0x46, 0x82, 0x33, 0x20, 0xbd, 0x83, 0x9a, 0x71, 0x78, 0x6c, 0xdb, 0xf2
};
static uint8_t pri_47  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_47  [32] = {
0x6f, 0xd2, 0x66, 0x61, 0x85, 0x1a, 0x8d, 0xe3, 0xc6, 0xd0, 0x6f, 0x83, 0x4e, 0xf3, 0xac, 0xb8, 0xf2, 0xa5, 0xf9, 0xc1, 0x36, 0xa9, 0x85, 0xff, 0xe1, 0x0d, 0x5e, 0xeb, 0x51, 0xed, 0xcf, 0xa3
};
#define result__47 0

//Test vector 48:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_48  [65] = {
0x04, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x08, 0x90, 0x11, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x26, 0x7b, 0xfd, 0xf8, 0xa6, 0x11, 0x48, 0xde, 0xcd, 0x80, 0x28, 0x37, 0x32, 0xdd, 0x4c, 0x10, 0x95, 0xe4, 0xbb, 0x40, 0xb9, 0x65, 0x84, 0x08, 0x20, 0x8d, 0xc1, 0x14, 0x7f, 0xff, 0xff, 0xff
};
static uint8_t pri_48  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_48  [32] = {
0x44, 0x23, 0x6c, 0x8b, 0x95, 0x05, 0xa1, 0x9d, 0x48, 0x77, 0x4a, 0x39, 0x03, 0xc0, 0x29, 0x27, 0x59, 0xb0, 0xf8, 0x26, 0xe6, 0xac, 0x09, 0x2f, 0xf8, 0x98, 0xd8, 0x7e, 0x53, 0xd3, 0x53, 0xfc
};
#define result__48 0

//Test vector 49:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_49  [65] = {
0x04, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x08, 0x90, 0x11, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x84, 0x02, 0x06, 0x59, 0xee, 0xb7, 0x22, 0x32, 0x7f, 0xd7, 0xc8, 0xcd, 0x22, 0xb3, 0xef, 0x6a, 0x1b, 0x44, 0xc0, 0x46, 0x9a, 0x7b, 0xf7, 0xdf, 0x72, 0x3e, 0xeb, 0x80, 0x00, 0x00, 0x00
};
static uint8_t pri_49  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_49  [32] = {
0x44, 0x23, 0x6c, 0x8b, 0x95, 0x05, 0xa1, 0x9d, 0x48, 0x77, 0x4a, 0x39, 0x03, 0xc0, 0x29, 0x27, 0x59, 0xb0, 0xf8, 0x26, 0xe6, 0xac, 0x09, 0x2f, 0xf8, 0x98, 0xd8, 0x7e, 0x53, 0xd3, 0x53, 0xfc
};
#define result__49 0

//Test vector 50:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_50  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x24, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x12, 0xd3, 0x81, 0xb0, 0x76, 0x0b, 0x1c, 0x50, 0xbe, 0x8a, 0xcf, 0x85, 0x93, 0x85, 0x05, 0x2c, 0x7f, 0x53, 0xcd, 0xe6, 0x7c, 0xe1, 0x37, 0x59, 0xde, 0x31, 0x23, 0xa0
};
static uint8_t pri_50  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_50  [32] = {
0xf1, 0xf0, 0xe4, 0x3b, 0x37, 0x4f, 0xeb, 0x7e, 0x7f, 0x96, 0xd4, 0xff, 0xe7, 0x51, 0x9f, 0xa8, 0xbb, 0x6c, 0x3c, 0xfd, 0x25, 0xf6, 0xf8, 0x7d, 0xab, 0x26, 0x23, 0xd2, 0xa2, 0xd3, 0x38, 0x51
};
#define result__50 0

//Test vector 51:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_51  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x24, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf1, 0xed, 0x2c, 0x7e, 0x50, 0x89, 0xf4, 0xe3, 0xaf, 0x41, 0x75, 0x30, 0x7a, 0x6c, 0x7a, 0xfa, 0xd4, 0x80, 0xac, 0x32, 0x19, 0x83, 0x1e, 0xc8, 0xa6, 0x21, 0xce, 0xdc, 0x5f
};
static uint8_t pri_51  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_51  [32] = {
0xf1, 0xf0, 0xe4, 0x3b, 0x37, 0x4f, 0xeb, 0x7e, 0x7f, 0x96, 0xd4, 0xff, 0xe7, 0x51, 0x9f, 0xa8, 0xbb, 0x6c, 0x3c, 0xfd, 0x25, 0xf6, 0xf8, 0x7d, 0xab, 0x26, 0x23, 0xd2, 0xa2, 0xd3, 0x38, 0x51
};
#define result__51 0

//Test vector 52:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_52  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x6b, 0xd1, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x96, 0xed, 0xd6, 0x87, 0x1c, 0x32, 0x0c, 0xb8, 0xa9, 0xf4, 0x53, 0x17, 0x51, 0x10, 0x5c, 0x97, 0xb4, 0xc2, 0x57, 0x81, 0x1b, 0xbc, 0x32, 0x96, 0x3e, 0xaf, 0x39, 0xff, 0xff, 0xff, 0xff
};
static uint8_t pri_52  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_52  [32] = {
0x3e, 0xbb, 0xac, 0xe1, 0x09, 0x8a, 0x81, 0x94, 0x9d, 0x56, 0x05, 0xdd, 0x94, 0xa7, 0xaa, 0x88, 0xdc, 0x39, 0x6c, 0x2c, 0x23, 0xe0, 0x1a, 0x9c, 0x8c, 0xca, 0x5b, 0xb0, 0x7b, 0xfb, 0xb6, 0xa1
};
#define result__52 0

//Test vector 53:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_53  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x6b, 0xd1, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x69, 0x12, 0x28, 0x78, 0xe3, 0xcd, 0xf4, 0x47, 0x56, 0x0b, 0xac, 0xe8, 0xae, 0xef, 0xa3, 0x68, 0x4b, 0x3d, 0xa9, 0x7e, 0xe4, 0x43, 0xcd, 0x69, 0xc1, 0x50, 0xc6, 0x00, 0x00, 0x00, 0x00
};
static uint8_t pri_53  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_53  [32] = {
0x3e, 0xbb, 0xac, 0xe1, 0x09, 0x8a, 0x81, 0x94, 0x9d, 0x56, 0x05, 0xdd, 0x94, 0xa7, 0xaa, 0x88, 0xdc, 0x39, 0x6c, 0x2c, 0x23, 0xe0, 0x1a, 0x9c, 0x8c, 0xca, 0x5b, 0xb0, 0x7b, 0xfb, 0xb6, 0xa1
};
#define result__53 0

//Test vector 54:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_54  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xea, 0x77, 0xd4, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xfb, 0xc0, 0xb3, 0x25, 0xe8, 0x20, 0x64, 0x6d, 0xec, 0x62, 0x2f, 0xb5, 0x58, 0xa5, 0x1c, 0x34, 0x2a, 0xa2, 0x57, 0xf4, 0xb6, 0xa8, 0xec, 0x5d, 0xdf, 0x14, 0x4f
};
static uint8_t pri_54  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_54  [32] = {
0x1b, 0x08, 0x52, 0x13, 0xa9, 0xc8, 0x9d, 0x35, 0x3e, 0x11, 0x11, 0xaf, 0x07, 0x8c, 0x38, 0xc5, 0x02, 0xb7, 0xb4, 0x77, 0x1e, 0xfb, 0xa5, 0x1f, 0x58, 0x9b, 0x5b, 0xe2, 0x43, 0x41, 0x7b, 0xdc
};
#define result__54 0

//Test vector 55:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_55  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xea, 0x77, 0xd4, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x85, 0x04, 0x3f, 0x4d, 0xda, 0x17, 0xdf, 0x9b, 0x92, 0x13, 0x9d, 0xd0, 0x4a, 0xa7, 0x5a, 0xe4, 0xcb, 0xd5, 0x5d, 0xa8, 0x0b, 0x49, 0x57, 0x13, 0xa2, 0x20, 0xeb, 0xb0
};
static uint8_t pri_55  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_55  [32] = {
0x1b, 0x08, 0x52, 0x13, 0xa9, 0xc8, 0x9d, 0x35, 0x3e, 0x11, 0x11, 0xaf, 0x07, 0x8c, 0x38, 0xc5, 0x02, 0xb7, 0xb4, 0x77, 0x1e, 0xfb, 0xa5, 0x1f, 0x58, 0x9b, 0x5b, 0xe2, 0x43, 0x41, 0x7b, 0xdc
};
#define result__55 0

//Test vector 56:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_56  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x09, 0x9f, 0x55, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x15, 0x2c, 0x1a, 0x22, 0xd8, 0x23, 0xa2, 0x78, 0x55, 0xed, 0x03, 0xf8, 0xe2, 0xab, 0x50, 0x38, 0xbb, 0x1d, 0xf4, 0xd8, 0x7e, 0x43, 0x86, 0x5f, 0x2d, 0xaf, 0x69, 0x48, 0xff, 0xff, 0xff, 0xff
};
static uint8_t pri_56  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_56  [32] = {
0x67, 0xcb, 0x63, 0x56, 0x6c, 0x7c, 0xeb, 0x12, 0xfd, 0xd8, 0x5c, 0xe9, 0xd2, 0xf7, 0x7c, 0x35, 0x92, 0x42, 0xbb, 0xaa, 0x0e, 0xa1, 0xbf, 0x3c, 0xf5, 0x10, 0xa4, 0xa2, 0x65, 0x91, 0xd1, 0xf1
};
#define result__56 0

//Test vector 57:           "comment" : "edge cases for ephemeral key",

static uint8_t pub_57  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x09, 0x9f, 0x55, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0xd3, 0xe5, 0xdc, 0x27, 0xdc, 0x5d, 0x88, 0xaa, 0x12, 0xfc, 0x07, 0x1d, 0x54, 0xaf, 0xc7, 0x44, 0xe2, 0x0b, 0x28, 0x81, 0xbc, 0x79, 0xa0, 0xd2, 0x50, 0x96, 0xb7, 0x00, 0x00, 0x00, 0x00
};
static uint8_t pri_57  [32] = {
0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72, 0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20, 0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48
};
static uint8_t x_57  [32] = {
0x67, 0xcb, 0x63, 0x56, 0x6c, 0x7c, 0xeb, 0x12, 0xfd, 0xd8, 0x5c, 0xe9, 0xd2, 0xf7, 0x7c, 0x35, 0x92, 0x42, 0xbb, 0xaa, 0x0e, 0xa1, 0xbf, 0x3c, 0xf5, 0x10, 0xa4, 0xa2, 0x65, 0x91, 0xd1, 0xf1
};
#define result__57 0

//Test vector 58:           "comment" : "point with coordinate x = 0",

static uint8_t pub_58  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x48, 0x5c, 0x78, 0x0e, 0x2f, 0x83, 0xd7, 0x24, 0x33, 0xbd, 0x5d, 0x84, 0xa0, 0x6b, 0xb6, 0x54, 0x1c, 0x2a, 0xf3, 0x1d, 0xae, 0x87, 0x17, 0x28, 0xbf, 0x85, 0x6a, 0x17, 0x4f, 0x93, 0xf4
};
static uint8_t pri_58  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_58  [32] = {
0xd1, 0x1c, 0x64, 0x0b, 0x43, 0x82, 0xe6, 0x0e, 0xc8, 0xd2, 0x54, 0xee, 0x76, 0xf0, 0x9b, 0x8f, 0xac, 0x57, 0x65, 0x1a, 0xb7, 0x3b, 0x6d, 0xd3, 0xfd, 0xc9, 0x35, 0xa6, 0x15, 0x64, 0xa3, 0xe9
};
#define result__58 0

//Test vector 59:           "comment" : "point with coordinate x = 0",

static uint8_t pub_59  [65] = {
0x04, 0x10, 0x01, 0x21, 0xf1, 0xa0, 0x94, 0x43, 0x85, 0x1c, 0x9a, 0xa2, 0xab, 0x6e, 0xe6, 0x44, 0x0e, 0x2a, 0xc5, 0xe1, 0xbe, 0x64, 0x82, 0x74, 0xbd, 0x5d, 0x26, 0xc1, 0x2f, 0xb3, 0xba, 0x3f, 0x7f, 0x03, 0x2a, 0x1c, 0x21, 0x9f, 0xa1, 0x45, 0x7c, 0xb2, 0x05, 0x88, 0x29, 0x7e, 0x05, 0x13, 0xcf, 0xd4, 0x90, 0x1f, 0x9a, 0x95, 0x41, 0x4f, 0x7e, 0x91, 0x4f, 0x91, 0x79, 0xf3, 0x85, 0x67, 0xa6
};
static uint8_t pri_59  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_59  [32] = {
0x90, 0xe7, 0x12, 0xe2, 0xaf, 0xd1, 0x41, 0x71, 0xc1, 0x94, 0x67, 0xa2, 0xbf, 0xe7, 0xab, 0xf1, 0xc4, 0x77, 0xd1, 0xf4, 0x0f, 0x66, 0x75, 0xf0, 0x0e, 0x62, 0x2f, 0xd5, 0x60, 0x4f, 0xa1, 0x6a
};
#define result__59 0

//Test vector 60:           "comment" : "point with coordinate x = 0",

static uint8_t pub_60  [65] = {
0x04, 0xca, 0xd0, 0x2a, 0xb5, 0x37, 0xc8, 0x08, 0x31, 0xcc, 0xdd, 0x39, 0x51, 0x29, 0xfc, 0x4b, 0xfe, 0x4a, 0x89, 0xae, 0x0c, 0x86, 0x6f, 0x66, 0x19, 0xa3, 0xe1, 0x41, 0x46, 0xd3, 0x69, 0x16, 0x94, 0x68, 0x9d, 0x47, 0x70, 0x65, 0xb4, 0x0f, 0x14, 0x0e, 0xd8, 0x7b, 0x37, 0xad, 0x04, 0x1e, 0x28, 0x22, 0x9b, 0x0f, 0x79, 0xa6, 0xb3, 0xc9, 0x92, 0x68, 0x99, 0x54, 0xc9, 0x7f, 0x73, 0x36, 0xd0
};
static uint8_t pri_60  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_60  [32] = {
0x15, 0x95, 0x83, 0x10, 0x3d, 0x83, 0xf6, 0x35, 0x38, 0xbd, 0x4e, 0x20, 0x36, 0x07, 0xd7, 0x34, 0x89, 0x90, 0xbb, 0x7f, 0x84, 0x7f, 0xfb, 0xc9, 0xe5, 0xe5, 0x09, 0xc7, 0xe3, 0x4d, 0x39, 0x2c
};
#define result__60 0

//Test vector 61:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_61  [65] = {
0x04, 0xab, 0xd1, 0x2e, 0xed, 0x4d, 0x65, 0x4b, 0xaa, 0x7d, 0x96, 0x86, 0x33, 0x77, 0x0f, 0x4a, 0x58, 0x2f, 0x17, 0x3d, 0x66, 0x33, 0x90, 0x60, 0x00, 0xed, 0x8a, 0xcf, 0x62, 0x33, 0xc6, 0x36, 0x5f, 0x09, 0x12, 0xf3, 0x0b, 0xb9, 0x8e, 0x7c, 0xb5, 0x25, 0x89, 0x0d, 0x5e, 0xa1, 0xe2, 0x17, 0x14, 0x9d, 0x52, 0xa6, 0xc5, 0x9f, 0x78, 0x02, 0xa9, 0xf3, 0x07, 0xe8, 0x0d, 0x2a, 0x9f, 0xee, 0x3a
};
static uint8_t pri_61  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_61  [32] = {
0x54, 0x6a, 0x2d, 0xfa, 0xdb, 0x1d, 0x60, 0x14, 0x0b, 0xec, 0xac, 0x2d, 0xc2, 0xe6, 0x2d, 0x20, 0xc7, 0x89, 0x03, 0x77, 0x55, 0xad, 0x5a, 0x49, 0xe3, 0x7e, 0x48, 0xf2, 0xca, 0x1b, 0x76, 0x80
};
#define result__61 0

//Test vector 62:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_62  [65] = {
0x04, 0xa5, 0x62, 0xc1, 0xad, 0x9a, 0x72, 0x21, 0x7d, 0xf0, 0x01, 0x47, 0xc7, 0xd2, 0xce, 0xaf, 0xc6, 0x5a, 0x16, 0x20, 0xa1, 0x46, 0x9c, 0x94, 0x7e, 0x14, 0xfe, 0x43, 0x00, 0x3a, 0xc5, 0x37, 0x1b, 0x7a, 0xd1, 0xd3, 0x3c, 0x01, 0xf0, 0xeb, 0x92, 0xb7, 0x79, 0xed, 0x6e, 0x46, 0x0d, 0x03, 0x34, 0x44, 0x70, 0x75, 0xa3, 0xcf, 0x66, 0xb2, 0xff, 0xbd, 0xae, 0x31, 0xb4, 0x38, 0xdf, 0x6d, 0x7b
};
static uint8_t pri_62  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_62  [32] = {
0xe5, 0x85, 0x9c, 0x78, 0x11, 0xc5, 0xc3, 0xac, 0xa6, 0xc2, 0x36, 0xab, 0x49, 0x9c, 0xca, 0xd1, 0x03, 0x01, 0xc7, 0xc5, 0xee, 0x91, 0x3c, 0xe9, 0x1b, 0xb6, 0x64, 0x28, 0xcd, 0xe1, 0x1e, 0x4d
};
#define result__62 0

//Test vector 63:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_63  [65] = {
0x04, 0x8c, 0xdb, 0xeb, 0xe9, 0xd0, 0x7d, 0x2e, 0xbc, 0x4e, 0x41, 0xb1, 0xd7, 0x2a, 0x9b, 0xac, 0x29, 0x74, 0xcf, 0xc4, 0xcf, 0x73, 0x8d, 0x8b, 0x6d, 0xe7, 0x1a, 0x40, 0xed, 0xe9, 0x92, 0x0d, 0x88, 0xdc, 0x24, 0x39, 0xee, 0x00, 0x03, 0xfb, 0xde, 0x7b, 0x0a, 0x3a, 0xe4, 0x17, 0x10, 0xc6, 0x4b, 0x17, 0xb0, 0x8a, 0x88, 0x41, 0xe9, 0x7a, 0x39, 0x0e, 0x48, 0x2c, 0x97, 0x68, 0xfe, 0x01, 0xea
};
static uint8_t pri_63  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_63  [32] = {
0x65, 0x75, 0x4a, 0xb4, 0x59, 0xa1, 0x04, 0x71, 0xaf, 0x00, 0x94, 0x3f, 0x41, 0x4f, 0x28, 0xde, 0x1b, 0xc3, 0x79, 0x68, 0xb0, 0x97, 0xad, 0x28, 0x45, 0xfe, 0x11, 0x14, 0x20, 0x85, 0x50, 0x08
};
#define result__63 0

//Test vector 64:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_64  [65] = {
0x04, 0xf0, 0xcd, 0x7c, 0xd8, 0x33, 0x46, 0x78, 0x30, 0x8c, 0xfe, 0xb7, 0x85, 0xa6, 0x8a, 0x15, 0x04, 0xa9, 0x14, 0x18, 0xd4, 0x44, 0x1c, 0x4d, 0x4c, 0x74, 0x0c, 0x57, 0x48, 0x8b, 0x9a, 0xaf, 0xb0, 0x79, 0xd8, 0xa8, 0xd2, 0x99, 0x73, 0xeb, 0x50, 0x22, 0x67, 0xec, 0xcf, 0x6e, 0xda, 0x32, 0x66, 0x26, 0xfc, 0x6e, 0x02, 0x5d, 0x53, 0x2b, 0x85, 0xe9, 0xf7, 0x11, 0xf8, 0xce, 0x69, 0x71, 0xbb
};
static uint8_t pri_64  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_64  [32] = {
0x86, 0x31, 0xfe, 0xde, 0xe6, 0xce, 0xb3, 0x38, 0x6a, 0xc4, 0x2e, 0xdf, 0x32, 0x2c, 0x18, 0x88, 0x24, 0x89, 0x3d, 0x26, 0x7d, 0x61, 0x08, 0xf0, 0xcf, 0x5d, 0xe6, 0x96, 0x4b, 0x88, 0x33, 0x1b
};
#define result__64 0

//Test vector 65:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_65  [65] = {
0x04, 0x8a, 0xd0, 0xaf, 0x23, 0xb9, 0x0e, 0x03, 0x41, 0xb4, 0xe2, 0xa5, 0xa9, 0x63, 0xc8, 0x52, 0x2f, 0xe0, 0x11, 0xac, 0xe1, 0x9b, 0x1b, 0x86, 0x10, 0xcb, 0xe7, 0x92, 0x7a, 0x17, 0xa7, 0x24, 0x97, 0x36, 0xb8, 0x7a, 0xb9, 0x90, 0x72, 0x89, 0xa2, 0x3a, 0x0f, 0xb2, 0x0c, 0xa4, 0xbe, 0x42, 0xd4, 0x21, 0xfe, 0x38, 0xd3, 0x5a, 0xf0, 0x9d, 0x79, 0xcb, 0xe6, 0xe6, 0xa4, 0xe9, 0x5a, 0x1a, 0x8b
};
static uint8_t pri_65  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_65  [32] = {
0x68, 0xc5, 0x85, 0x99, 0xc1, 0x23, 0xbe, 0x6d, 0x37, 0xd3, 0x43, 0xbd, 0x41, 0xb1, 0x1c, 0xec, 0xc5, 0xf8, 0x4b, 0x26, 0x35, 0x66, 0x11, 0x63, 0x65, 0x6f, 0x76, 0xd7, 0xfb, 0x04, 0xb4, 0x26
};
#define result__65 0

//Test vector 66:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_66  [65] = {
0x04, 0x59, 0xc9, 0xcc, 0x2d, 0x72, 0x97, 0xdd, 0xb0, 0xbe, 0x63, 0x04, 0xc9, 0x4c, 0xeb, 0xf4, 0x2d, 0x81, 0x3e, 0x97, 0x0c, 0x50, 0xf4, 0x52, 0x87, 0x75, 0x3b, 0x8e, 0x9c, 0xb0, 0xc6, 0xdb, 0x45, 0xf5, 0x71, 0xd9, 0x86, 0x99, 0x08, 0x97, 0x85, 0x1f, 0xc8, 0xe1, 0xdb, 0x67, 0xc9, 0x97, 0x59, 0xe8, 0x97, 0x9c, 0x3d, 0x9d, 0xdf, 0xd0, 0x2f, 0x63, 0x3c, 0xf1, 0xea, 0x5b, 0x6c, 0x48, 0xab
};
static uint8_t pri_66  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_66  [32] = {
0xb5, 0x8d, 0x00, 0x52, 0x5c, 0x4c, 0x4b, 0x4f, 0x46, 0x56, 0x28, 0x52, 0xc1, 0x5c, 0xe2, 0xe4, 0x8d, 0xbe, 0x23, 0xa3, 0xbe, 0x37, 0x54, 0x1e, 0x04, 0x84, 0x46, 0xef, 0xf5, 0x15, 0x2e, 0xc6
};
#define result__66 0

//Test vector 67:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_67  [65] = {
0x04, 0xe9, 0x70, 0x80, 0xda, 0x72, 0x63, 0xa2, 0x9c, 0x30, 0x72, 0xa6, 0x51, 0x78, 0xb7, 0xb3, 0x15, 0x87, 0xa5, 0xdf, 0xfc, 0x19, 0x75, 0x4c, 0x56, 0x1e, 0x32, 0xfc, 0x53, 0x19, 0x92, 0x34, 0xf0, 0x4e, 0x0b, 0x9b, 0x70, 0xc9, 0x7b, 0x60, 0xe9, 0x40, 0xd5, 0x62, 0x9f, 0x22, 0x66, 0xd1, 0xa8, 0xe2, 0x42, 0xde, 0xb7, 0x1e, 0xb7, 0xf0, 0xb2, 0xb2, 0xda, 0x2e, 0x30, 0x44, 0x73, 0x8a, 0xb0
};
static uint8_t pri_67  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_67  [32] = {
0x4b, 0xaa, 0x01, 0xc2, 0x11, 0xaf, 0x8f, 0x94, 0xac, 0xa8, 0x95, 0x48, 0x90, 0x2a, 0x71, 0xf7, 0xb5, 0x3f, 0x78, 0x14, 0xbb, 0xce, 0xb3, 0xd4, 0xbe, 0xf3, 0x1b, 0x37, 0x6e, 0x34, 0xb4, 0x76
};
#define result__67 0

//Test vector 68:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_68  [65] = {
0x04, 0x44, 0xf6, 0x00, 0xda, 0x71, 0x60, 0xb9, 0x75, 0xa0, 0x23, 0x2c, 0xb6, 0xa4, 0xa9, 0xe7, 0x28, 0x03, 0xfd, 0x77, 0xca, 0xac, 0x84, 0x35, 0x20, 0x39, 0xce, 0x9f, 0x4a, 0x67, 0xa1, 0xda, 0x77, 0x62, 0x60, 0x45, 0x59, 0x93, 0x81, 0xe5, 0x99, 0xeb, 0x9c, 0xd0, 0x3f, 0x28, 0x2e, 0x26, 0x7b, 0x8c, 0xfd, 0x3b, 0xa9, 0x8d, 0xab, 0xbb, 0x0f, 0x29, 0xab, 0x1c, 0x09, 0x44, 0x27, 0x0f, 0x3f
};
static uint8_t pri_68  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_68  [32] = {
0xe1, 0x9f, 0xe9, 0xd1, 0x29, 0x4c, 0xca, 0x94, 0xa6, 0x38, 0x88, 0x25, 0x24, 0x9e, 0x6b, 0x37, 0x93, 0x1a, 0x23, 0x1e, 0xb9, 0x17, 0xcf, 0xec, 0xb2, 0x92, 0x79, 0x2d, 0x0c, 0x18, 0xf1, 0xb8
};
#define result__68 0

//Test vector 69:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_69  [65] = {
0x04, 0x71, 0xe3, 0xe9, 0xbe, 0x0e, 0x0e, 0xe4, 0x44, 0x9a, 0x19, 0xd2, 0xef, 0x79, 0x19, 0x26, 0x68, 0x14, 0xa0, 0xfa, 0xfd, 0x04, 0xfb, 0x67, 0x7e, 0xdc, 0x32, 0x65, 0x6e, 0x6a, 0x46, 0xe4, 0xd2, 0xbc, 0x5f, 0x40, 0x4c, 0x5b, 0x54, 0xf0, 0x3e, 0x29, 0x4b, 0xe2, 0x2e, 0x88, 0x20, 0xa7, 0x1b, 0x4d, 0x4a, 0xc0, 0x4a, 0x70, 0x8e, 0x13, 0xcd, 0x71, 0xfd, 0xb0, 0x04, 0x1e, 0x7e, 0x96, 0x98
};
static uint8_t pri_69  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_69  [32] = {
0xdd, 0xc1, 0xf4, 0x66, 0x3b, 0x92, 0x8a, 0xdd, 0x06, 0xb1, 0xe5, 0x7c, 0x48, 0xdb, 0x98, 0xea, 0x08, 0xc4, 0xd3, 0x3c, 0x3c, 0x21, 0x06, 0x37, 0x14, 0x07, 0xf3, 0x84, 0x8a, 0x9d, 0x53, 0xf7
};
#define result__69 0

//Test vector 70:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_70  [65] = {
0x04, 0x27, 0xb6, 0x93, 0x61, 0x01, 0x54, 0xd5, 0xb7, 0xf0, 0x80, 0x94, 0xe4, 0x6f, 0xf2, 0xa2, 0xac, 0x1c, 0x01, 0xd3, 0xcd, 0x82, 0x6e, 0x32, 0x08, 0xe5, 0x25, 0x44, 0x36, 0xed, 0x27, 0x99, 0x60, 0xf2, 0x36, 0x4e, 0x3a, 0x60, 0x4f, 0x3b, 0x59, 0x2e, 0x19, 0x26, 0x2a, 0x1b, 0x22, 0xb1, 0xa1, 0x48, 0xe3, 0x8c, 0xd8, 0x2c, 0x9e, 0x54, 0xf1, 0x08, 0xef, 0x8f, 0x83, 0x36, 0x83, 0xf8, 0xb4
};
static uint8_t pri_70  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_70  [32] = {
0x91, 0xdf, 0xa9, 0x5e, 0xd1, 0xea, 0xcb, 0xea, 0x41, 0x91, 0x56, 0x47, 0x1a, 0x8d, 0xdb, 0xb6, 0xcb, 0x93, 0xdd, 0x45, 0x64, 0x33, 0xe1, 0x86, 0x33, 0xd2, 0x68, 0x17, 0x61, 0x1b, 0x9c, 0x64
};
#define result__70 0

//Test vector 71:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_71  [65] = {
0x04, 0xc3, 0x2a, 0x52, 0xaf, 0x6d, 0xac, 0x36, 0x9b, 0x6a, 0x49, 0x9a, 0x49, 0xd3, 0xe3, 0x8e, 0x7c, 0x95, 0x34, 0xbb, 0x91, 0x39, 0xf5, 0x7d, 0x49, 0x84, 0xb1, 0xd3, 0xc0, 0x4a, 0xb8, 0x22, 0x06, 0x53, 0xcd, 0xc2, 0xda, 0xef, 0xac, 0x83, 0xcf, 0x43, 0xc0, 0xd6, 0x46, 0x04, 0xe5, 0xf9, 0xd8, 0x5b, 0x55, 0xdd, 0xe6, 0x2b, 0x69, 0x2c, 0xd3, 0x6a, 0xf9, 0x9e, 0xbf, 0xf4, 0x14, 0x0c, 0x39
};
static uint8_t pri_71  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_71  [32] = {
0x9f, 0x91, 0xa9, 0x63, 0x3d, 0xaa, 0x4c, 0x56, 0x46, 0x5e, 0x9f, 0xbe, 0xf4, 0x43, 0x1e, 0x13, 0x04, 0x1f, 0x68, 0x91, 0x0f, 0xb5, 0xba, 0x89, 0xf8, 0xda, 0x93, 0x81, 0xd6, 0x8a, 0x0d, 0xfe
};
#define result__71 0

//Test vector 72:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_72  [65] = {
0x04, 0x6f, 0x4e, 0x2f, 0x72, 0xf3, 0x2a, 0xe6, 0x6f, 0x1f, 0x46, 0x10, 0x96, 0x60, 0x04, 0xc4, 0x36, 0xaa, 0x0d, 0x90, 0xb7, 0xdf, 0x07, 0xce, 0x9c, 0x4a, 0xca, 0x52, 0xb0, 0x2d, 0x46, 0xb4, 0xd0, 0xc6, 0xa3, 0xec, 0x76, 0xbf, 0x32, 0x1b, 0x7f, 0xe5, 0x20, 0x3c, 0xf3, 0xd6, 0x6e, 0x2d, 0x52, 0xe3, 0xee, 0x04, 0x95, 0xec, 0x76, 0x6d, 0x57, 0x9a, 0x45, 0x11, 0x17, 0x5e, 0x01, 0xbc, 0x4d
};
static uint8_t pri_72  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_72  [32] = {
0x01, 0x4a, 0xe8, 0x14, 0x42, 0xf8, 0xcb, 0x6d, 0xf5, 0x8f, 0xf4, 0x1e, 0x6d, 0xb2, 0x03, 0xdb, 0x40, 0xea, 0x95, 0x1b, 0x91, 0xbe, 0xbf, 0x86, 0xd4, 0x2c, 0xda, 0x7b, 0xe3, 0x3f, 0xea, 0x64
};
#define result__72 0

//Test vector 73:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_73  [65] = {
0x04, 0x2e, 0x06, 0x59, 0x75, 0xdf, 0x64, 0x2f, 0xcf, 0xda, 0xfe, 0x2f, 0xa5, 0xaf, 0xfc, 0x18, 0xb2, 0xc6, 0x83, 0x71, 0x79, 0x6f, 0x9d, 0x96, 0x3d, 0x89, 0xc4, 0xf5, 0xac, 0x5c, 0xce, 0xa2, 0x8b, 0x99, 0x0f, 0x31, 0x52, 0x2f, 0xbb, 0x26, 0x5c, 0x3f, 0x4d, 0x5c, 0x4b, 0xb8, 0x2e, 0xbf, 0x5d, 0xdf, 0xf5, 0xa8, 0xea, 0x58, 0x8d, 0xb4, 0xd2, 0x82, 0xac, 0xdc, 0xa7, 0xa6, 0xcc, 0xf4, 0x28
};
static uint8_t pri_73  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_73  [32] = {
0x78, 0xe8, 0x1e, 0x85, 0x73, 0xc3, 0xae, 0x60, 0x89, 0xdf, 0x7d, 0xb1, 0xfb, 0x29, 0xd7, 0xbe, 0x12, 0xdc, 0x11, 0xf1, 0x5b, 0xb2, 0x5b, 0xff, 0x2a, 0xf8, 0x02, 0xe1, 0x5d, 0xdc, 0x13, 0x6e
};
#define result__73 0

//Test vector 74:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_74  [65] = {
0x04, 0xe1, 0x33, 0x1e, 0xee, 0x03, 0xc5, 0x0c, 0xc2, 0xb9, 0x09, 0x44, 0xdd, 0xfc, 0x0d, 0x3a, 0x7d, 0xd8, 0x18, 0x5e, 0x6c, 0x21, 0xc7, 0x5f, 0xa9, 0x2a, 0x0c, 0x14, 0xb0, 0xf1, 0x94, 0x9a, 0xc9, 0x15, 0x4d, 0x78, 0x3f, 0x45, 0x47, 0xdc, 0xf5, 0x50, 0x8b, 0xbd, 0x86, 0xc3, 0xdd, 0x8c, 0x3b, 0x17, 0xb6, 0x19, 0x89, 0xf9, 0x3d, 0xb5, 0x49, 0x0e, 0xc0, 0x2a, 0x46, 0xa1, 0x00, 0x5c, 0x2c
};
static uint8_t pri_74  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_74  [32] = {
0xed, 0x67, 0x19, 0x5a, 0x27, 0x2c, 0x63, 0xc5, 0x02, 0x05, 0xab, 0xf2, 0x74, 0x39, 0x29, 0x11, 0x34, 0xff, 0xa1, 0xe8, 0xec, 0x59, 0x7f, 0x3b, 0x30, 0x27, 0x16, 0xd9, 0x36, 0x32, 0xe9, 0x8d
};
#define result__74 0

//Test vector 75:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_75  [65] = {
0x04, 0xe0, 0xc5, 0x6d, 0x48, 0x6e, 0x9c, 0x01, 0x16, 0x3e, 0xd6, 0xc3, 0xff, 0x25, 0xde, 0x3c, 0xdf, 0x57, 0x44, 0xdb, 0xf9, 0xe0, 0xe0, 0x0b, 0xdc, 0xf1, 0x99, 0x65, 0xdf, 0x4b, 0xa1, 0xf3, 0x11, 0xbd, 0x5e, 0x44, 0x43, 0x06, 0x65, 0x82, 0x3d, 0x8c, 0x0b, 0x34, 0xeb, 0xec, 0x0a, 0x6a, 0xab, 0x5e, 0xa9, 0x6c, 0xf2, 0x39, 0xde, 0x21, 0x4f, 0xd0, 0x11, 0xe6, 0xf9, 0xec, 0x50, 0x1d, 0xd4
};
static uint8_t pri_75  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_75  [32] = {
0x50, 0x77, 0x43, 0x47, 0x84, 0x88, 0x28, 0xee, 0xb6, 0x23, 0x0f, 0x49, 0x7c, 0xd1, 0x81, 0xf8, 0xc5, 0x7f, 0xbd, 0x18, 0xff, 0xbf, 0x83, 0x28, 0xcd, 0x00, 0x83, 0x21, 0xa1, 0xc3, 0x7c, 0x43
};
#define result__75 0

//Test vector 76:           "comment" : "point with coordinate x = 0 in left to right addition chain",

static uint8_t pub_76  [65] = {
0x04, 0x88, 0x5e, 0xad, 0x6c, 0x07, 0x4f, 0x8d, 0x75, 0x1a, 0x76, 0x7e, 0x91, 0x8c, 0x4e, 0x89, 0x21, 0x0a, 0x58, 0x7c, 0x4b, 0x19, 0xd4, 0x22, 0x44, 0xae, 0x07, 0x02, 0x7e, 0x36, 0x18, 0x31, 0x05, 0x3e, 0x80, 0x77, 0x2b, 0xe5, 0x7f, 0xbd, 0x74, 0x49, 0x55, 0xa2, 0xe8, 0x52, 0x30, 0x63, 0xcc, 0x61, 0x36, 0xf2, 0xbb, 0x37, 0xbe, 0xfb, 0xef, 0x7a, 0x68, 0x1d, 0x3b, 0xbb, 0xc5, 0x77, 0x88
};
static uint8_t pri_76  [32] = {
0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf, 0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a, 0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b
};
static uint8_t x_76  [32] = {
0x91, 0x3d, 0xa7, 0x10, 0x44, 0xb8, 0x02, 0x1a, 0x86, 0xc8, 0xfc, 0xaf, 0x4f, 0x63, 0x4d, 0x0d, 0x62, 0x5f, 0xf9, 0x1e, 0xe1, 0xc8, 0x47, 0x4d, 0x54, 0x8b, 0xd1, 0x08, 0x88, 0x96, 0x4f, 0xb1
};
#define result__76 0

//Test vector 77:           "comment" : "point with coordinate x = 0 in precomputation or right to left addition chain",

static uint8_t pub_77  [65] = {
0x04, 0x41, 0xe9, 0xd4, 0xcf, 0xa8, 0xef, 0xe8, 0x0b, 0x89, 0x5a, 0x8c, 0xbc, 0xce, 0x25, 0x68, 0xe2, 0x51, 0xdb, 0x7e, 0xcd, 0xfd, 0x20, 0xa7, 0xad, 0x71, 0x0d, 0x4a, 0x4b, 0xf2, 0xad, 0xdc, 0x6b, 0x5e, 0xc3, 0x6a, 0x83, 0x39, 0x16, 0x8a, 0x03, 0xf1, 0x5b, 0x8c, 0x80, 0xf2, 0xa2, 0xa8, 0x28, 0xf1, 0x51, 0xd3, 0x87, 0x91, 0x58, 0x48, 0x53, 0xba, 0x2f, 0xf4, 0x4a, 0x2a, 0x04, 0x60, 0xa1
};
static uint8_t pri_77  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_77  [32] = {
0xb4, 0x8e, 0x11, 0x9d, 0x29, 0xee, 0xf7, 0xdb, 0xb7, 0x6b, 0x64, 0x21, 0x8e, 0x72, 0x8d, 0xdb, 0xf6, 0xec, 0x60, 0x05, 0x05, 0xec, 0x7c, 0xed, 0x6a, 0xb6, 0xfb, 0x87, 0x63, 0x30, 0x8d, 0xa5
};
#define result__77 0

//Test vector 78:           "comment" : "point with coordinate x = 0 in precomputation or right to left addition chain",

static uint8_t pub_78  [65] = {
0x04, 0x77, 0x6a, 0xef, 0x1a, 0xcb, 0x82, 0xb6, 0x28, 0xe1, 0x32, 0xcc, 0x29, 0x44, 0x09, 0x88, 0xf0, 0xa1, 0x5d, 0x4c, 0xc2, 0xb4, 0xf3, 0x28, 0xae, 0xcb, 0x06, 0x3c, 0x9b, 0x86, 0xe5, 0x01, 0x8e, 0x6e, 0x44, 0xdf, 0xc6, 0x04, 0x44, 0xfa, 0xa9, 0xc4, 0xe3, 0x6b, 0xc2, 0x17, 0x45, 0x1f, 0x7a, 0xc2, 0x95, 0x6c, 0xb3, 0xb2, 0xe9, 0xbb, 0xd6, 0x55, 0xeb, 0xa2, 0x97, 0x16, 0x3d, 0x1f, 0x34
};
static uint8_t pri_78  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_78  [32] = {
0x28, 0xa8, 0x8b, 0x6b, 0x25, 0x8f, 0x23, 0x30, 0x20, 0xba, 0x6f, 0xa9, 0xc0, 0x0d, 0x1d, 0x72, 0x83, 0x1f, 0x45, 0x15, 0xb8, 0x69, 0x66, 0xa9, 0x78, 0x2f, 0x52, 0x13, 0x15, 0xe1, 0x8a, 0xa7
};
#define result__78 0

//Test vector 79:           "comment" : "point with coordinate x = 0 in precomputation or right to left addition chain",

static uint8_t pub_79  [65] = {
0x04, 0x9e, 0xc0, 0x6b, 0x0b, 0x08, 0x66, 0x2c, 0x0e, 0x1d, 0xd9, 0x11, 0x16, 0x96, 0xa6, 0x3a, 0x16, 0x01, 0xcc, 0x83, 0xce, 0xe2, 0x06, 0x95, 0x77, 0x8a, 0xdf, 0x84, 0xd4, 0x30, 0x64, 0xfc, 0x90, 0x15, 0x60, 0x01, 0xf0, 0x84, 0xcd, 0x3c, 0x1d, 0xf1, 0xa0, 0x87, 0xf6, 0x26, 0x53, 0x3b, 0x65, 0x72, 0x58, 0x48, 0x89, 0xbd, 0x3d, 0x5c, 0x2c, 0x99, 0xf0, 0xe3, 0x11, 0xe2, 0x2b, 0x41, 0xe6
};
static uint8_t pri_79  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_79  [32] = {
0xc4, 0xff, 0x86, 0x5f, 0xf3, 0xdc, 0x49, 0x53, 0xea, 0x78, 0xd9, 0x2a, 0x02, 0xf3, 0x34, 0x5a, 0x53, 0xbd, 0xb6, 0x05, 0x0c, 0xfd, 0x8f, 0x41, 0xba, 0xa4, 0x39, 0x5e, 0xcb, 0x6a, 0xca, 0xb8
};
#define result__79 0

//Test vector 80:           "comment" : "point with coordinate x = 0 in precomputation or right to left addition chain",

static uint8_t pub_80  [65] = {
0x04, 0xfa, 0x51, 0xd1, 0x28, 0xad, 0xc2, 0x00, 0x0f, 0x09, 0xff, 0x12, 0xc6, 0xfd, 0x8e, 0x25, 0xaa, 0x08, 0x55, 0x6d, 0x70, 0x8b, 0xf6, 0xb0, 0xff, 0xff, 0x9e, 0x8e, 0xaa, 0xd4, 0x78, 0x3f, 0x0d, 0xe2, 0x2b, 0xf5, 0x29, 0xe5, 0x16, 0xe1, 0xf6, 0x4b, 0x8e, 0x0d, 0x09, 0xf9, 0x8f, 0xad, 0x4e, 0x50, 0x16, 0x95, 0xa9, 0x30, 0xa1, 0xb2, 0x20, 0x76, 0x65, 0x9d, 0xa7, 0x07, 0xe3, 0xcc, 0xd0
};
static uint8_t pri_80  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_80  [32] = {
0xde, 0x10, 0x69, 0xf0, 0x51, 0x63, 0x7e, 0x10, 0x16, 0x65, 0x59, 0xce, 0xf4, 0x46, 0x88, 0xaf, 0xc8, 0x09, 0x34, 0x18, 0x55, 0x26, 0x12, 0x15, 0xc4, 0xf3, 0x81, 0xd9, 0xd7, 0xda, 0x76, 0xca
};
#define result__80 0

//Test vector 81:           "comment" : "point with coordinate x = 0 in precomputation or right to left addition chain",

static uint8_t pub_81  [65] = {
0x04, 0x61, 0x4d, 0xcf, 0xbe, 0xa4, 0x78, 0x9a, 0x3f, 0x3e, 0xb4, 0xa8, 0xe2, 0xf1, 0x11, 0xc8, 0x87, 0xf0, 0x24, 0x8d, 0x93, 0x16, 0xb9, 0x9d, 0x08, 0x64, 0xc9, 0x27, 0xa0, 0x45, 0xd6, 0x94, 0x17, 0x53, 0xa0, 0x73, 0xbe, 0xfe, 0x08, 0x49, 0x1a, 0x80, 0x50, 0xa4, 0xd9, 0x6d, 0x08, 0xba, 0x47, 0x90, 0xae, 0x18, 0xdb, 0x3e, 0xf7, 0xf0, 0xea, 0xcc, 0xf5, 0x9c, 0xe1, 0x09, 0x5a, 0xfc, 0x54
};
static uint8_t pri_81  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_81  [32] = {
0x42, 0x07, 0xbf, 0x41, 0x59, 0xfa, 0xa0, 0xe5, 0x0e, 0xd2, 0x38, 0xb9, 0xc0, 0xff, 0x46, 0x19, 0x4a, 0x53, 0x9a, 0x1b, 0xa0, 0x3a, 0x5a, 0x4c, 0x8d, 0x68, 0xf3, 0x69, 0xae, 0xcd, 0x31, 0xa5
};
#define result__81 0

//Test vector 82:           "comment" : "point with coordinate x = 0 in precomputation or right to left addition chain",

static uint8_t pub_82  [65] = {
0x04, 0xef, 0xe7, 0x75, 0x4e, 0xd4, 0xc0, 0xb3, 0xc1, 0xdd, 0x30, 0x1b, 0xc1, 0xed, 0x69, 0x80, 0x0a, 0xa2, 0xff, 0x5d, 0x51, 0xfb, 0x85, 0x93, 0x77, 0x15, 0xe6, 0x0d, 0x2e, 0x7b, 0xca, 0xda, 0x8e, 0xb1, 0x58, 0x1a, 0xb7, 0x5f, 0xb3, 0xc7, 0x97, 0xef, 0x94, 0xa9, 0xdb, 0xa3, 0xd8, 0x25, 0x68, 0xc8, 0x46, 0x17, 0xea, 0xf3, 0xfa, 0x04, 0xf2, 0x79, 0xfb, 0xfd, 0x89, 0x8f, 0x70, 0x46, 0x04
};
static uint8_t pri_82  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_82  [32] = {
0xb5, 0xa0, 0xec, 0x92, 0xae, 0xcc, 0x30, 0x10, 0xd2, 0x7d, 0x22, 0x63, 0xd3, 0xda, 0x66, 0xe3, 0xd2, 0xf3, 0x39, 0x5d, 0x23, 0x94, 0x70, 0x24, 0xa3, 0xf4, 0x74, 0x44, 0x54, 0x62, 0x20, 0x27
};
#define result__82 0

//Test vector 83:           "comment" : "point with coordinate x = 0 in right to left addition chain",

static uint8_t pub_83  [65] = {
0x04, 0xd8, 0xe1, 0x3f, 0xbd, 0x01, 0x7f, 0x1f, 0x9a, 0x26, 0xbe, 0x35, 0xc6, 0x11, 0xd7, 0xb2, 0x29, 0x9f, 0x5d, 0x10, 0xde, 0x3c, 0x8a, 0x26, 0x36, 0x22, 0x73, 0xff, 0xfb, 0x85, 0x23, 0x8f, 0x3e, 0xd1, 0x42, 0x6b, 0x74, 0x8c, 0x1f, 0x87, 0xe3, 0xaf, 0xa2, 0xc1, 0xe7, 0xa0, 0x22, 0x43, 0x10, 0xc9, 0x80, 0x65, 0x5e, 0x07, 0x39, 0x95, 0x90, 0xd1, 0x49, 0x4d, 0x6d, 0x6b, 0xea, 0x03, 0x96
};
static uint8_t pri_83  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_83  [32] = {
0xd2, 0xa5, 0xbc, 0x66, 0x49, 0x8c, 0x60, 0x36, 0xae, 0xcd, 0xfa, 0xad, 0x04, 0x1c, 0xef, 0x73, 0x2a, 0x89, 0x3d, 0xe1, 0x90, 0xa0, 0xa5, 0xb4, 0x2f, 0xf7, 0x1e, 0x13, 0xf0, 0x92, 0x80, 0xe7
};
#define result__83 0

//Test vector 84:           "comment" : "point with coordinate x = 0 in right to left addition chain",

static uint8_t pub_84  [65] = {
0x04, 0x5a, 0x10, 0x27, 0x66, 0x6a, 0x0e, 0x37, 0x24, 0x81, 0xfe, 0xc0, 0xb3, 0x90, 0x1e, 0x05, 0x8d, 0x60, 0x10, 0x7c, 0x07, 0xb1, 0x11, 0x55, 0x50, 0xce, 0xb0, 0x57, 0x89, 0xb5, 0x5a, 0x6d, 0x35, 0x06, 0x3d, 0x4c, 0x8e, 0xe6, 0x6e, 0xd4, 0x5f, 0xf3, 0xe1, 0xdf, 0xdc, 0xfd, 0x73, 0xed, 0x96, 0xa9, 0xe8, 0x31, 0x93, 0x88, 0x4a, 0xdb, 0xca, 0xa5, 0x74, 0xb2, 0xdd, 0x11, 0x8a, 0x69, 0x2b
};
static uint8_t pri_84  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_84  [32] = {
0x1f, 0x81, 0x23, 0x13, 0xdd, 0xcf, 0x36, 0xbc, 0x38, 0x07, 0x1d, 0x0e, 0x51, 0xa7, 0x41, 0x00, 0xd6, 0x30, 0xc8, 0xe2, 0x0c, 0xc4, 0x14, 0x32, 0x6e, 0xef, 0xa4, 0x2e, 0xcb, 0x1b, 0x5f, 0x8e
};
#define result__84 0

//Test vector 85:           "comment" : "point with coordinate x = 0 in right to left addition chain",

static uint8_t pub_85  [65] = {
0x04, 0x79, 0x37, 0xb9, 0xc4, 0x09, 0x86, 0xdd, 0x75, 0x5a, 0x06, 0x56, 0x20, 0x30, 0x89, 0x78, 0x25, 0x83, 0xda, 0x7d, 0x81, 0x13, 0xa4, 0x41, 0x90, 0x76, 0x2a, 0xb4, 0x74, 0xa2, 0x0b, 0xcf, 0x60, 0xef, 0xcb, 0xc1, 0x52, 0x5a, 0xed, 0x5b, 0x4a, 0xd8, 0xe6, 0x87, 0xcb, 0x02, 0xc2, 0xef, 0x88, 0x87, 0x09, 0x5c, 0xad, 0xca, 0x56, 0xc7, 0x65, 0xb4, 0x1b, 0x4a, 0x95, 0x44, 0xff, 0x2f, 0xe8
};
static uint8_t pri_85  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_85  [32] = {
0xf2, 0x84, 0x08, 0x9b, 0xdd, 0xd5, 0xe2, 0xe1, 0xbe, 0x3f, 0x82, 0x64, 0x0e, 0xfa, 0x06, 0x58, 0x46, 0x8f, 0xa1, 0xf1, 0x0b, 0x28, 0x19, 0x63, 0xa3, 0xca, 0x19, 0x0c, 0x39, 0x82, 0xfd, 0xa6
};
#define result__85 0

//Test vector 86:           "comment" : "point with coordinate x = 0 in right to left addition chain",

static uint8_t pub_86  [65] = {
0x04, 0x93, 0x68, 0x06, 0x6a, 0x07, 0x48, 0x86, 0x7a, 0x7b, 0x87, 0x02, 0x44, 0xf5, 0xc9, 0xf8, 0x2e, 0xa8, 0xbd, 0x51, 0x55, 0x29, 0x59, 0xdd, 0x55, 0x0b, 0xb7, 0x39, 0x44, 0x97, 0x15, 0x9a, 0x5d, 0x40, 0x76, 0x4a, 0xdd, 0x1a, 0xe2, 0x4c, 0x8e, 0x3f, 0x43, 0x2e, 0xe0, 0x11, 0xbe, 0x97, 0xd3, 0x13, 0x07, 0x18, 0xfe, 0x0a, 0x6a, 0x90, 0xed, 0x8b, 0x10, 0x11, 0xb2, 0x03, 0x4d, 0x09, 0xa0
};
static uint8_t pri_86  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_86  [32] = {
0x45, 0x29, 0xf4, 0xb6, 0x31, 0xc9, 0x98, 0x4a, 0xb2, 0x16, 0xa6, 0x80, 0x12, 0x81, 0xfc, 0x4f, 0xd8, 0x73, 0x1a, 0x58, 0xb6, 0x5c, 0xa8, 0xd0, 0x7b, 0xff, 0x07, 0x81, 0x11, 0x16, 0x37, 0x1f
};
#define result__86 0

//Test vector 87:           "comment" : "point with coordinate x = 0 in right to left addition chain",

static uint8_t pub_87  [65] = {
0x04, 0x98, 0x1d, 0x74, 0x49, 0xbd, 0xf0, 0x01, 0x3f, 0x5e, 0xed, 0xdb, 0xb7, 0xe4, 0x2c, 0x44, 0x2f, 0x7c, 0xcd, 0xd9, 0x42, 0x7b, 0xd2, 0x6d, 0x7b, 0x38, 0x87, 0x55, 0xaa, 0x5e, 0x26, 0xf4, 0x6a, 0x12, 0x92, 0xb8, 0x8f, 0xa6, 0xbf, 0x5d, 0xff, 0xca, 0x05, 0x4d, 0xd4, 0x2e, 0xd3, 0x59, 0x42, 0x77, 0xb5, 0x93, 0xdc, 0xc4, 0x02, 0xd8, 0x03, 0x40, 0xfb, 0x78, 0x16, 0xe4, 0xdc, 0xab, 0x37
};
static uint8_t pri_87  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_87  [32] = {
0x64, 0xbb, 0xc9, 0xfd, 0xd7, 0x36, 0x43, 0xeb, 0x29, 0x54, 0xf4, 0xab, 0x64, 0x03, 0x81, 0xb9, 0x38, 0xc5, 0xe6, 0x01, 0x84, 0x6a, 0x0c, 0x6b, 0x69, 0x54, 0x96, 0x6e, 0x0d, 0xc7, 0x3e, 0x6f
};
#define result__87 0

//Test vector 88:           "comment" : "point with coordinate y = 1",

static uint8_t pub_88  [65] = {
0x04, 0x09, 0xe7, 0x8d, 0x4e, 0xf6, 0x0d, 0x05, 0xf7, 0x50, 0xf6, 0x63, 0x62, 0x09, 0x09, 0x2b, 0xc4, 0x3c, 0xbd, 0xd6, 0xb4, 0x7e, 0x11, 0xa9, 0xde, 0x20, 0xa9, 0xfe, 0xb2, 0xa5, 0x0b, 0xb9, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
static uint8_t pri_88  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_88  [32] = {
0x28, 0xf6, 0x77, 0x57, 0xac, 0xc2, 0x8b, 0x16, 0x84, 0xba, 0x76, 0xff, 0xd5, 0x34, 0xae, 0xd4, 0x2d, 0x45, 0xb8, 0xb3, 0xf1, 0x0b, 0x82, 0xa5, 0x69, 0x94, 0x16, 0xef, 0xf7, 0x19, 0x9a, 0x74
};
#define result__88 0

//Test vector 89:           "comment" : "point with coordinate y = 1",

static uint8_t pub_89  [65] = {
0x04, 0x53, 0x84, 0xd6, 0xc0, 0xde, 0xf7, 0x89, 0x60, 0xdb, 0x96, 0x7b, 0x80, 0x96, 0xd3, 0x54, 0x77, 0xc5, 0xa5, 0xce, 0x30, 0xef, 0x0c, 0x6d, 0x88, 0x79, 0xa5, 0x56, 0x8c, 0xa8, 0x7e, 0x97, 0x94, 0x01, 0xee, 0x56, 0xc4, 0x58, 0x17, 0x22, 0x61, 0x0b, 0x43, 0xf3, 0xcb, 0xfc, 0xf3, 0x86, 0x2c, 0x08, 0x2a, 0x6e, 0x36, 0xba, 0xa3, 0x6f, 0xd6, 0xf7, 0x84, 0x03, 0xc0, 0xe3, 0x99, 0xfa, 0xa5
};
static uint8_t pri_89  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_89  [32] = {
0x9e, 0xe6, 0x53, 0xcd, 0xa4, 0x6d, 0xb6, 0x76, 0x12, 0x76, 0x0c, 0xe3, 0x5b, 0xac, 0x84, 0x50, 0xbb, 0xf4, 0x8d, 0xbf, 0x74, 0x45, 0x1e, 0xd9, 0x3a, 0xbb, 0x6d, 0xb4, 0x08, 0xa9, 0xfe, 0x10
};
#define result__89 0

//Test vector 90:           "comment" : "point with coordinate y = 1",

static uint8_t pub_90  [65] = {
0x04, 0x4e, 0xca, 0x76, 0x41, 0xa4, 0xaf, 0xd5, 0xea, 0xb0, 0xb2, 0x14, 0x65, 0x7f, 0xf3, 0xbd, 0xcb, 0xfc, 0x66, 0xf1, 0x55, 0x1a, 0x53, 0xbb, 0x59, 0x49, 0x3b, 0xc3, 0x8e, 0xd7, 0x8f, 0xf3, 0x96, 0x14, 0xa0, 0xca, 0xdf, 0xf1, 0x4c, 0x14, 0x73, 0x6e, 0xdb, 0xdc, 0xda, 0xb5, 0x10, 0xcb, 0xa0, 0x7a, 0x89, 0x24, 0xff, 0xd0, 0x49, 0x0e, 0xe5, 0x14, 0xae, 0xdf, 0xaa, 0xdb, 0x64, 0x8b, 0x01
};
static uint8_t pri_90  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_90  [32] = {
0x97, 0x36, 0xad, 0x6b, 0x2a, 0x2e, 0xf1, 0x7e, 0xc3, 0xf8, 0xc8, 0xdc, 0x2e, 0x35, 0x71, 0x5f, 0xb1, 0xc0, 0x6f, 0x28, 0xd8, 0x2e, 0x4e, 0x26, 0x87, 0x6f, 0x02, 0x14, 0x58, 0x81, 0x65, 0xf1
};
#define result__90 0

//Test vector 91:           "comment" : "point with coordinate y = 1",

static uint8_t pub_91  [65] = {
0x04, 0x8d, 0x01, 0x77, 0xeb, 0xab, 0x9c, 0x6e, 0x9e, 0x10, 0xdb, 0x6d, 0xd0, 0x95, 0xdb, 0xac, 0x0d, 0x63, 0x75, 0xe8, 0xa9, 0x7b, 0x70, 0xf6, 0x11, 0x87, 0x5d, 0x87, 0x7f, 0x00, 0x69, 0xd2, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
static uint8_t pri_91  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_91  [32] = {
0x74, 0x8f, 0xa4, 0xf5, 0xa3, 0x99, 0x32, 0x03, 0x82, 0xdc, 0x92, 0x00, 0x26, 0x93, 0x86, 0x94, 0xc4, 0x1a, 0x26, 0xfe, 0x2a, 0xaa, 0x31, 0x8c, 0x5e, 0x71, 0x01, 0x98, 0xdd, 0x71, 0xc7, 0x93
};
#define result__91 0

//Test vector 92:           "comment" : "point with coordinate y = 1",

static uint8_t pub_92  [65] = {
0x04, 0x5f, 0xdb, 0x7f, 0x0c, 0xff, 0xb8, 0xb5, 0xb1, 0x14, 0x2d, 0x24, 0x69, 0x8a, 0x4b, 0xda, 0x76, 0xbf, 0x98, 0x27, 0xd6, 0x3b, 0x1a, 0x6b, 0xd8, 0x5a, 0x4e, 0x2f, 0x9b, 0x59, 0xc5, 0x10, 0xcf, 0xbc, 0xb3, 0x5b, 0xa9, 0xc9, 0x87, 0x10, 0x8b, 0x6d, 0x43, 0x37, 0xad, 0x53, 0x93, 0xf9, 0xf9, 0x10, 0xec, 0x92, 0x41, 0x0c, 0x23, 0x08, 0x69, 0xd6, 0x65, 0x28, 0xed, 0x88, 0xc1, 0xb9, 0x8a
};
static uint8_t pri_92  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_92  [32] = {
0x7f, 0x97, 0xdb, 0x83, 0xb4, 0xd8, 0x6f, 0x04, 0xfe, 0x28, 0x60, 0x41, 0xee, 0x21, 0xe8, 0x0e, 0xc3, 0xd5, 0x9f, 0x3c, 0xe8, 0x2c, 0xde, 0xea, 0xf3, 0x62, 0x01, 0x6f, 0xc8, 0x7a, 0x3e, 0x02
};
#define result__92 0

//Test vector 93:           "comment" : "point with coordinate y = 1",

static uint8_t pub_93  [65] = {
0x04, 0x53, 0x0b, 0x22, 0x93, 0xe6, 0x0c, 0x6b, 0x6f, 0x14, 0xc7, 0x5c, 0x90, 0xb1, 0xef, 0x8b, 0x9f, 0x9f, 0xa6, 0xb2, 0x15, 0x1b, 0x8d, 0x98, 0x55, 0x79, 0x2e, 0xb2, 0xb3, 0xdc, 0x69, 0xf0, 0x7a, 0x0d, 0xb4, 0x24, 0x40, 0xe7, 0x3f, 0xd7, 0xd6, 0xdf, 0x04, 0xae, 0xd5, 0x02, 0x2f, 0xbe, 0x21, 0xce, 0xae, 0xc3, 0x3c, 0x5f, 0xba, 0xde, 0x1b, 0xd6, 0xad, 0x32, 0x1e, 0xf2, 0xe1, 0x0d, 0x0b
};
static uint8_t pri_93  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_93  [32] = {
0x21, 0x79, 0x4c, 0xf2, 0x4f, 0x56, 0x27, 0x3f, 0xa4, 0x46, 0x3c, 0xc7, 0xae, 0x42, 0x32, 0xfa, 0x34, 0xdb, 0xe0, 0xf1, 0x8b, 0x73, 0x61, 0x3b, 0x8a, 0xe9, 0xcb, 0xfb, 0x9c, 0x36, 0xab, 0xf0
};
#define result__93 0

//Test vector 94:           "comment" : "point with coordinate y = 1",

static uint8_t pub_94  [65] = {
0x04, 0x69, 0x16, 0xfa, 0xc4, 0x5e, 0x56, 0x8b, 0x6b, 0x9e, 0x2e, 0x2e, 0xcd, 0x61, 0x1b, 0x28, 0x2e, 0x5f, 0xcc, 0x40, 0xa3, 0x06, 0x7d, 0x60, 0x10, 0x57, 0xf8, 0x79, 0xce, 0x5a, 0x8a, 0x73, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
static uint8_t pri_94  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_94  [32] = {
0x91, 0x51, 0x06, 0xd0, 0x78, 0x16, 0xe8, 0x79, 0xe7, 0x64, 0x3f, 0x00, 0xab, 0xf6, 0xd7, 0x9f, 0xb8, 0xf1, 0xcb, 0x78, 0xbf, 0x64, 0xa6, 0xa3, 0x82, 0x7f, 0x91, 0xa7, 0xb0, 0xef, 0x0f, 0x41
};
#define result__94 0

//Test vector 95:           "comment" : "point with coordinate y = 1",

static uint8_t pub_95  [65] = {
0x04, 0xed, 0x95, 0x68, 0xc8, 0x5b, 0xc5, 0x2a, 0x6b, 0x45, 0x73, 0x36, 0x18, 0xc3, 0x60, 0x21, 0x07, 0xc1, 0xfd, 0xac, 0xf2, 0x3b, 0x1a, 0x38, 0xe4, 0x86, 0xaf, 0x95, 0x97, 0x8a, 0x21, 0x4e, 0x2e, 0xfa, 0x0d, 0x71, 0xd5, 0xe7, 0x37, 0x89, 0x1c, 0x42, 0x76, 0xe2, 0x47, 0x58, 0x1e, 0xe6, 0x13, 0x90, 0x11, 0xca, 0x14, 0x60, 0xdb, 0x9b, 0x1e, 0x20, 0xb3, 0x64, 0xd9, 0x27, 0x56, 0x83, 0xe2
};
static uint8_t pri_95  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_95  [32] = {
0x2f, 0xcc, 0xe5, 0x52, 0x31, 0x08, 0x19, 0xdd, 0x77, 0x5a, 0xb7, 0xba, 0x9f, 0xf0, 0xf9, 0x6a, 0x1f, 0xca, 0xdd, 0x25, 0xa0, 0xc7, 0x09, 0x70, 0x3c, 0xef, 0x04, 0xbb, 0x6e, 0x1a, 0x7b, 0xd7
};
#define result__95 0

//Test vector 96:           "comment" : "point with coordinate y = 1",

static uint8_t pub_96  [65] = {
0x04, 0x9f, 0xf7, 0x73, 0x1c, 0x00, 0xf2, 0xaa, 0x88, 0xb3, 0xfc, 0x17, 0x4a, 0xba, 0x90, 0x7a, 0xd1, 0x75, 0x95, 0xe6, 0x02, 0xe7, 0x68, 0xa5, 0xf1, 0xe9, 0x46, 0x2a, 0x6d, 0x4b, 0x89, 0xb2, 0xd2, 0x3f, 0x17, 0x8a, 0x70, 0xb9, 0xbb, 0x3e, 0xdc, 0xe2, 0x89, 0x11, 0x83, 0x38, 0xa3, 0x3d, 0xf3, 0x0c, 0x43, 0x2c, 0x34, 0x7f, 0x12, 0xa3, 0xde, 0x0a, 0x2b, 0x03, 0xb3, 0x53, 0x87, 0x8d, 0x96
};
static uint8_t pri_96  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_96  [32] = {
0x75, 0x7d, 0x92, 0x6a, 0x26, 0x93, 0xbc, 0x8a, 0x3d, 0x2d, 0x8c, 0x05, 0x54, 0xa1, 0x35, 0x79, 0xef, 0x9e, 0x55, 0x91, 0x86, 0x57, 0x89, 0x11, 0xf3, 0x7e, 0xdc, 0x88, 0xb2, 0xf5, 0xe6, 0x1a
};
#define result__96 0

//Test vector 97:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_97  [65] = {
0x04, 0x82, 0x70, 0xf8, 0x17, 0x9d, 0x57, 0x43, 0x6b, 0x34, 0xdf, 0xc0, 0xbd, 0xf7, 0xd4, 0x17, 0xa5, 0xc8, 0x95, 0x11, 0x6b, 0x90, 0xcb, 0x51, 0xae, 0xc7, 0x18, 0x61, 0x4f, 0x86, 0x4a, 0x63, 0x5d, 0x17, 0x48, 0x04, 0xe0, 0xc0, 0xe0, 0x6e, 0x3d, 0x68, 0xd3, 0x14, 0x9e, 0x0b, 0x95, 0x66, 0x21, 0xc6, 0xaa, 0x2b, 0xde, 0x83, 0xf4, 0xd1, 0x7d, 0x03, 0xd2, 0x8e, 0xf8, 0xaa, 0x38, 0x9f, 0xff
};
static uint8_t pri_97  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_97  [32] = {
0x3d, 0xb2, 0x9e, 0xc6, 0xf9, 0x78, 0xd2, 0x26, 0x9e, 0x92, 0xe9, 0xc7, 0xeb, 0x5c, 0x8b, 0x5a, 0x8e, 0x56, 0xc2, 0x22, 0x8a, 0x4f, 0xb9, 0xe4, 0x83, 0xfe, 0xca, 0x50, 0xaa, 0x3e, 0x45, 0x1f
};
#define result__97 0

//Test vector 98:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_98  [65] = {
0x04, 0xc6, 0x17, 0x50, 0xe9, 0x8a, 0xba, 0xf2, 0x02, 0x25, 0xa8, 0x81, 0xdb, 0xfd, 0x35, 0x10, 0x53, 0x2c, 0xfc, 0x3d, 0xf9, 0x71, 0xbb, 0xbc, 0xa4, 0xa2, 0xbd, 0x52, 0xf9, 0x1a, 0xcc, 0x9c, 0x59, 0xd0, 0xfe, 0x79, 0x34, 0x20, 0x97, 0xf8, 0x8a, 0xe7, 0x8f, 0xc7, 0x9a, 0x80, 0x32, 0x24, 0x5f, 0xdd, 0x2c, 0x30, 0xcc, 0x64, 0xac, 0xea, 0xaa, 0x9f, 0xd5, 0x7b, 0x08, 0x25, 0x69, 0x25, 0x31
};
static uint8_t pri_98  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_98  [32] = {
0x72, 0xc5, 0x7c, 0x2e, 0x10, 0xd7, 0x73, 0x18, 0xb3, 0xa7, 0x96, 0x09, 0x7b, 0xbf, 0x76, 0x8c, 0x63, 0x66, 0x14, 0x2d, 0x80, 0xf9, 0x8c, 0x90, 0xa9, 0x37, 0x80, 0xa8, 0x41, 0x07, 0x5f, 0x32
};
#define result__98 0

//Test vector 99:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_99  [65] = {
0x04, 0x9c, 0x5d, 0x3b, 0xb5, 0x46, 0x50, 0xd9, 0x55, 0x0e, 0x1e, 0xe2, 0xef, 0xa3, 0xea, 0x43, 0xc1, 0x4a, 0xb9, 0x9d, 0x18, 0xbb, 0x04, 0x9f, 0x37, 0xb4, 0x2a, 0x6d, 0xac, 0x48, 0x23, 0x2f, 0x0b, 0xd3, 0xa2, 0x76, 0x0d, 0x83, 0xd3, 0x3a, 0xfe, 0x4c, 0xe6, 0xf1, 0xd1, 0x24, 0x54, 0x89, 0xc5, 0x09, 0xbd, 0x26, 0xb0, 0x25, 0x1f, 0x30, 0x8f, 0x8c, 0x99, 0x6e, 0x80, 0xf7, 0xa3, 0xf8, 0xeb
};
static uint8_t pri_99  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_99  [32] = {
0xa9, 0x6b, 0x07, 0x94, 0x4e, 0x9e, 0xb2, 0xb2, 0x2a, 0x9a, 0x36, 0x57, 0x5e, 0xff, 0x1f, 0x4f, 0x63, 0x63, 0xb4, 0xaa, 0x3a, 0x53, 0xb1, 0x00, 0xb8, 0x51, 0x8a, 0x67, 0xba, 0x54, 0x05, 0xdd
};
#define result__99 0

//Test vector 100:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_100  [65] = {
0x04, 0xf1, 0x72, 0x4e, 0xfd, 0x48, 0x1a, 0xd4, 0x5a, 0x55, 0x79, 0x5f, 0x06, 0x12, 0x6b, 0x1f, 0x5e, 0xd2, 0x8e, 0x7d, 0x9b, 0xb4, 0xfe, 0xe9, 0x10, 0xaf, 0x2a, 0xd8, 0xc1, 0x37, 0x3b, 0x18, 0xff, 0x77, 0xed, 0xbc, 0x34, 0xda, 0x6c, 0x78, 0x7e, 0xc7, 0x34, 0x30, 0x34, 0x7f, 0x4d, 0xa8, 0x68, 0x10, 0x03, 0x2d, 0x88, 0xf7, 0x47, 0x5f, 0x6c, 0x42, 0xf1, 0x59, 0x14, 0x07, 0x9d, 0x17, 0x9e
};
static uint8_t pri_100  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_100  [32] = {
0x85, 0x58, 0x83, 0x31, 0x6b, 0x6d, 0x09, 0x7a, 0xe5, 0xea, 0xb6, 0xc6, 0x7e, 0x84, 0x11, 0xa1, 0x39, 0x73, 0x49, 0xa0, 0x9b, 0x9d, 0x7d, 0x8f, 0x09, 0x6b, 0x2b, 0xa1, 0xbd, 0x03, 0xea, 0x31
};
#define result__100 0

//Test vector 101:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_101  [65] = {
0x04, 0xfc, 0x36, 0x80, 0xaf, 0x52, 0xfa, 0x89, 0xff, 0xcd, 0x19, 0x3e, 0xcc, 0x0b, 0x07, 0x14, 0x46, 0x6f, 0xe5, 0xdb, 0x27, 0x7e, 0xe5, 0x87, 0x28, 0x46, 0xc5, 0x20, 0xbf, 0x4e, 0x37, 0x21, 0xd9, 0x27, 0x26, 0x0a, 0x0e, 0x22, 0x5a, 0x3d, 0x37, 0x7e, 0x67, 0x23, 0xec, 0xb6, 0xbe, 0xf8, 0xd4, 0x49, 0x3c, 0x2d, 0xa7, 0x8a, 0x22, 0xa3, 0x07, 0xfc, 0xca, 0x8f, 0x88, 0xf4, 0x52, 0x72, 0x08
};
static uint8_t pri_101  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_101  [32] = {
0x5a, 0x75, 0xbb, 0x7a, 0x0c, 0x96, 0xb8, 0x34, 0x0d, 0x08, 0x42, 0xbc, 0xcc, 0xf1, 0x19, 0x74, 0xe1, 0xa5, 0xa2, 0xc8, 0xf4, 0xbc, 0x22, 0xb3, 0x33, 0x43, 0x3c, 0xce, 0x64, 0x6b, 0x6a, 0x8a
};
#define result__101 0

//Test vector 102:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_102  [65] = {
0x04, 0x10, 0x6b, 0x6f, 0x81, 0xe3, 0x48, 0x2d, 0xb1, 0x8d, 0x74, 0x02, 0x92, 0x91, 0x82, 0x1a, 0xe4, 0x48, 0xc3, 0x88, 0x44, 0xef, 0x78, 0x3b, 0xf1, 0xd6, 0x99, 0x9a, 0x40, 0x44, 0x01, 0xf6, 0x3f, 0x6a, 0x57, 0x53, 0xf0, 0xed, 0xc6, 0x8a, 0x62, 0xcf, 0xd6, 0xa0, 0xb1, 0x81, 0xbb, 0x25, 0x99, 0xe1, 0xf3, 0xba, 0xc5, 0xfa, 0x88, 0x24, 0xaf, 0x16, 0x0d, 0xe7, 0x9e, 0xd8, 0x67, 0xc3, 0x50
};
static uint8_t pri_102  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_102  [32] = {
0xd9, 0x64, 0x12, 0xe3, 0x1c, 0xf4, 0xd2, 0x61, 0x95, 0x92, 0x0c, 0xac, 0x95, 0x2f, 0xb7, 0x9e, 0xa2, 0x5f, 0x6c, 0x50, 0xab, 0xc7, 0x9b, 0x5e, 0xd0, 0xef, 0x80, 0x26, 0xa6, 0xe8, 0x33, 0x19
};
#define result__102 0

//Test vector 103:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_103  [65] = {
0x04, 0x09, 0x3c, 0xb5, 0x19, 0x3a, 0x4f, 0x94, 0xcd, 0x18, 0xed, 0xaa, 0x20, 0xa9, 0x73, 0xb8, 0x7f, 0xf7, 0x9b, 0x0c, 0x03, 0x68, 0x4c, 0x79, 0x48, 0x7e, 0xcf, 0xee, 0x34, 0x7e, 0x53, 0x54, 0xeb, 0x04, 0xfc, 0xb5, 0x75, 0x25, 0x39, 0x17, 0x07, 0x77, 0x93, 0x2b, 0xe1, 0x5c, 0xd8, 0x4c, 0x97, 0xf0, 0x38, 0x15, 0xff, 0xee, 0x8b, 0x60, 0xb6, 0x47, 0xc1, 0x78, 0xee, 0xbb, 0x8e, 0x14, 0xd4
};
static uint8_t pri_103  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_103  [32] = {
0x2b, 0x0e, 0xed, 0x9b, 0xad, 0xc9, 0x2a, 0x10, 0x68, 0x19, 0x6d, 0xfe, 0xc1, 0x24, 0xfe, 0x8f, 0x9d, 0x3f, 0x45, 0x1e, 0x29, 0x4d, 0x32, 0x2e, 0xb8, 0x81, 0xcc, 0xe0, 0x2f, 0x28, 0x60, 0x26
};
#define result__103 0

//Test vector 104:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_104  [65] = {
0x04, 0xd6, 0xc3, 0x8f, 0x44, 0x8b, 0x96, 0x4e, 0x27, 0xb5, 0xb4, 0x50, 0xcc, 0x38, 0xd3, 0xcf, 0x41, 0xef, 0x9d, 0xf8, 0x3d, 0x8a, 0x95, 0x97, 0x71, 0xeb, 0x9c, 0x21, 0x85, 0x5c, 0xb3, 0x64, 0x45, 0xdf, 0x63, 0x8a, 0xef, 0x46, 0xa2, 0xae, 0xb1, 0x31, 0x99, 0x28, 0x1e, 0x1a, 0x26, 0xd1, 0x2f, 0xe6, 0x1b, 0x02, 0x9e, 0xc7, 0xf6, 0x8b, 0x90, 0xfa, 0xa8, 0x9f, 0x88, 0xc7, 0xa9, 0x59, 0x42
};
static uint8_t pri_104  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_104  [32] = {
0xed, 0x0b, 0x1d, 0x8d, 0xfd, 0x27, 0xa6, 0x1f, 0xce, 0x91, 0xdc, 0x64, 0x05, 0xbf, 0xc5, 0x3b, 0x6d, 0x48, 0xa8, 0xc1, 0x3b, 0xa5, 0x41, 0xc9, 0x6e, 0xf3, 0xdc, 0xf3, 0x1d, 0x7c, 0xdb, 0x88
};
#define result__104 0

//Test vector 105:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_105  [65] = {
0x04, 0x8a, 0x74, 0x8d, 0x61, 0xf5, 0x9c, 0x3b, 0x6a, 0x29, 0xb7, 0x33, 0xb0, 0xd5, 0x54, 0xb2, 0x49, 0x2e, 0x7f, 0x76, 0xfa, 0xd7, 0xca, 0xe1, 0xc1, 0x7f, 0x2a, 0xc3, 0xde, 0x9e, 0x4a, 0x65, 0xd2, 0xee, 0xdb, 0xe6, 0xc2, 0x6b, 0x6f, 0xd2, 0x2b, 0xfc, 0x03, 0xc1, 0x68, 0x75, 0x55, 0xd2, 0xf0, 0xa3, 0x8e, 0x02, 0xad, 0xee, 0x55, 0x70, 0x68, 0x61, 0x71, 0xab, 0xfe, 0xc6, 0x68, 0x19, 0x17
};
static uint8_t pri_105  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_105  [32] = {
0xa7, 0x96, 0xdd, 0x14, 0x4f, 0x21, 0xba, 0x33, 0x18, 0xf9, 0xe1, 0x08, 0x28, 0xec, 0xef, 0xc9, 0xc0, 0xf6, 0xef, 0x2c, 0x42, 0x7a, 0xe3, 0x13, 0x51, 0xc1, 0x6c, 0x2f, 0xbf, 0xa3, 0xcf, 0xa6
};
#define result__105 0

//Test vector 106:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_106  [65] = {
0x04, 0xf1, 0x05, 0x26, 0x99, 0xd8, 0x7e, 0x56, 0x77, 0xc7, 0x5e, 0x26, 0xb2, 0xab, 0xe7, 0x19, 0x31, 0x06, 0x48, 0xd8, 0x20, 0xa9, 0x6e, 0x5b, 0x38, 0x1f, 0xff, 0x58, 0xb3, 0x92, 0x40, 0x15, 0x81, 0xb1, 0xbb, 0x16, 0xae, 0x8b, 0x68, 0xcb, 0xb7, 0x6a, 0x32, 0x56, 0x87, 0x0b, 0xad, 0x1e, 0xe5, 0xa3, 0x0f, 0xf9, 0xfd, 0x66, 0x2f, 0xd4, 0xf8, 0xd1, 0xfe, 0x5b, 0x5f, 0x1f, 0x98, 0xff, 0x46
};
static uint8_t pri_106  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_106  [32] = {
0x1f, 0x3a, 0x96, 0x15, 0xb0, 0x74, 0x50, 0x46, 0xa9, 0x72, 0xba, 0xd5, 0xd5, 0x97, 0x94, 0xa0, 0xb6, 0x0b, 0x03, 0x2b, 0x4a, 0xc9, 0x4f, 0xe8, 0x5f, 0x77, 0xdf, 0xb3, 0x80, 0xd1, 0xf3, 0x2b
};
#define result__106 0

//Test vector 107:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_107  [65] = {
0x04, 0x12, 0x19, 0xaf, 0x52, 0x30, 0x06, 0x4e, 0xe9, 0x77, 0x86, 0x67, 0x22, 0x5f, 0x0e, 0x00, 0x9c, 0xdb, 0x96, 0x13, 0x30, 0xe3, 0x86, 0xed, 0xb3, 0x4e, 0x4f, 0xa9, 0xfd, 0xdd, 0x0e, 0x5b, 0xe7, 0xe2, 0xa1, 0x25, 0x54, 0x22, 0x7f, 0x61, 0x3a, 0xaa, 0xa7, 0x89, 0x38, 0xdd, 0xbb, 0xc9, 0x9b, 0x92, 0x3f, 0x9d, 0x18, 0x1b, 0x81, 0x92, 0xdc, 0x4b, 0x81, 0x65, 0x77, 0xe8, 0xf3, 0xb7, 0xe9
};
static uint8_t pri_107  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_107  [32] = {
0xca, 0xf9, 0x14, 0x1d, 0x1f, 0xca, 0x4d, 0x0f, 0x10, 0x68, 0x3b, 0x5e, 0x86, 0xd2, 0xb4, 0x1a, 0xf5, 0x60, 0x2f, 0x01, 0x79, 0x91, 0xfe, 0x73, 0x48, 0xd4, 0x4e, 0x8d, 0x70, 0x14, 0x11, 0x5c
};
#define result__107 0

//Test vector 108:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_108  [65] = {
0x04, 0x60, 0xde, 0xf1, 0x30, 0xf1, 0x90, 0xe6, 0xdc, 0x44, 0xf5, 0xeb, 0x8a, 0x59, 0xe1, 0x2e, 0x7e, 0xfb, 0x27, 0xdb, 0x96, 0x8c, 0x7f, 0xa6, 0xcc, 0x6d, 0x31, 0x78, 0x5f, 0x06, 0x6b, 0x41, 0xb1, 0xf1, 0xbb, 0x55, 0x6a, 0xc4, 0xcd, 0x77, 0x03, 0x3e, 0x7a, 0xa6, 0xc5, 0xba, 0x16, 0xf4, 0x7e, 0xba, 0xfb, 0x14, 0x97, 0x5a, 0x7f, 0xd7, 0x2d, 0xd9, 0xb7, 0xfe, 0x23, 0x11, 0x6b, 0xca, 0x55
};
static uint8_t pri_108  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_108  [32] = {
0x65, 0x39, 0xec, 0x1c, 0x98, 0xfa, 0x75, 0x19, 0x7b, 0xa0, 0x7c, 0x67, 0x8b, 0x26, 0x30, 0x0b, 0x3d, 0xa1, 0xfe, 0x40, 0x7d, 0xd4, 0xc6, 0x8b, 0x89, 0x45, 0x7e, 0xd6, 0x69, 0x08, 0x2e, 0x06
};
#define result__108 0

//Test vector 109:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_109  [65] = {
0x04, 0xf2, 0x3f, 0x09, 0xbd, 0xb7, 0xd1, 0x72, 0x89, 0xeb, 0x00, 0x59, 0x75, 0xa7, 0x57, 0xa3, 0x93, 0x25, 0xb4, 0xdf, 0x9b, 0x29, 0xe5, 0x5b, 0xa2, 0xca, 0x67, 0x9b, 0x5e, 0xc0, 0x97, 0x3a, 0xe9, 0x18, 0xc8, 0x81, 0xf3, 0xc7, 0xb6, 0xc1, 0x2b, 0xed, 0x1e, 0xc5, 0x4b, 0x83, 0x7d, 0x08, 0xc5, 0x90, 0x8e, 0x89, 0xbd, 0xce, 0xdd, 0x84, 0xb9, 0x17, 0x77, 0x20, 0x37, 0x8f, 0x78, 0x96, 0x00
};
static uint8_t pri_109  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_109  [32] = {
0x0b, 0x66, 0x19, 0x82, 0x7c, 0xfa, 0x94, 0x8d, 0x63, 0xf0, 0x21, 0xe9, 0xed, 0xdb, 0x92, 0xf8, 0x84, 0xfb, 0x5c, 0xe8, 0xa4, 0x04, 0xbf, 0xe0, 0x59, 0xe9, 0x93, 0xfc, 0x23, 0x44, 0x7a, 0x69
};
#define result__109 0

//Test vector 110:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_110  [65] = {
0x04, 0x5d, 0xbe, 0xc0, 0x98, 0xc1, 0xb7, 0xde, 0x3e, 0x3e, 0x2e, 0x73, 0xd0, 0xb6, 0x2c, 0xd4, 0x9c, 0x87, 0x7e, 0x1a, 0x01, 0x30, 0xa1, 0xb3, 0x9e, 0xb2, 0xfd, 0x4d, 0xbd, 0x44, 0x26, 0xaa, 0x4c, 0xcb, 0xee, 0xe2, 0x17, 0x59, 0x1a, 0x8d, 0x76, 0xcc, 0x8d, 0xea, 0xf1, 0x4d, 0xde, 0x52, 0xe3, 0xf4, 0x01, 0xe5, 0x3b, 0x30, 0xcb, 0xb9, 0xc1, 0x80, 0x79, 0x10, 0xd8, 0x27, 0xd0, 0x04, 0x1d
};
static uint8_t pri_110  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_110  [32] = {
0x2a, 0x53, 0xa5, 0x61, 0xac, 0xf5, 0xca, 0xec, 0x6e, 0xb0, 0xd8, 0xaa, 0x40, 0x72, 0x79, 0x42, 0x88, 0x1a, 0x75, 0xd1, 0x36, 0x89, 0x9d, 0xfb, 0xff, 0x91, 0x52, 0x82, 0x36, 0x92, 0x6c, 0x39
};
#define result__110 0

//Test vector 111:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_111  [65] = {
0x04, 0x1e, 0x70, 0x73, 0x0d, 0xc4, 0xf3, 0x9c, 0x89, 0x70, 0x18, 0x2e, 0x1a, 0x29, 0xcc, 0x83, 0x6b, 0x9e, 0x9d, 0x6c, 0xbd, 0x6f, 0xca, 0xa8, 0xc0, 0xdc, 0x10, 0x62, 0xfe, 0xd9, 0xa8, 0x49, 0x69, 0x3e, 0x7b, 0x91, 0x51, 0xf9, 0xc8, 0xa3, 0x34, 0x53, 0x66, 0xf8, 0x22, 0x1c, 0x8f, 0xb7, 0x00, 0xe8, 0xc3, 0xa9, 0xaa, 0x7f, 0x0c, 0xc4, 0x6a, 0x48, 0x86, 0x4e, 0x16, 0x05, 0x59, 0x20, 0x94
};
static uint8_t pri_111  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_111  [32] = {
0x9b, 0x37, 0x77, 0x16, 0xff, 0x1d, 0x05, 0x6d, 0xac, 0x8e, 0x39, 0x22, 0x49, 0xea, 0xec, 0x74, 0x0d, 0x2f, 0x5a, 0xa6, 0x23, 0x03, 0xf4, 0xba, 0xf6, 0xbb, 0x1b, 0x03, 0xb2, 0xa2, 0x76, 0xc5
};
#define result__111 0

//Test vector 112:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_112  [65] = {
0x04, 0xf4, 0x28, 0xc9, 0xae, 0x3e, 0x23, 0xea, 0xf9, 0xc2, 0xa5, 0xb9, 0xa7, 0xe4, 0x1e, 0xfd, 0x1c, 0xff, 0xbf, 0x35, 0xf8, 0x81, 0xbf, 0xc3, 0x56, 0x94, 0xd9, 0xc0, 0x5d, 0x1e, 0x31, 0x2b, 0x10, 0xef, 0x6d, 0xa9, 0x02, 0x3c, 0xfd, 0x2d, 0xd0, 0xcb, 0x7b, 0x9e, 0x2a, 0x77, 0xd6, 0x44, 0xaf, 0xfe, 0x62, 0xa6, 0x3f, 0xb0, 0xf2, 0x9d, 0x45, 0x29, 0x1c, 0x68, 0x61, 0xaa, 0x06, 0x3c, 0x5c
};
static uint8_t pri_112  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_112  [32] = {
0x0c, 0x0c, 0x68, 0x67, 0x66, 0x97, 0x43, 0x08, 0x25, 0x47, 0xaa, 0x94, 0x45, 0x1f, 0xeb, 0x36, 0x2f, 0xa2, 0x9f, 0xba, 0xf2, 0x28, 0xdf, 0xb3, 0xea, 0xf3, 0x75, 0xf1, 0xa5, 0xec, 0x2f, 0xb3
};
#define result__112 0

//Test vector 113:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_113  [65] = {
0x04, 0xb9, 0xa1, 0x6d, 0x9a, 0x5b, 0x85, 0xa7, 0x14, 0xe2, 0xbb, 0x2a, 0xa2, 0x2b, 0x08, 0x6a, 0x17, 0x40, 0x4c, 0x7a, 0x3f, 0xf6, 0x24, 0x52, 0x73, 0x23, 0x47, 0x41, 0x9c, 0x99, 0xe9, 0x0b, 0xda, 0xd5, 0x78, 0xb4, 0x62, 0xf5, 0x23, 0x99, 0x43, 0x04, 0xb6, 0xaf, 0xcf, 0x69, 0x44, 0xa9, 0xcc, 0x5d, 0x0a, 0xd1, 0xaf, 0xad, 0x95, 0x64, 0x75, 0xc8, 0xf2, 0x95, 0x3c, 0x06, 0xb0, 0x6b, 0x97
};
static uint8_t pri_113  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_113  [32] = {
0xd1, 0x1f, 0x9e, 0x32, 0x58, 0x7f, 0xd3, 0xb6, 0xf4, 0xa2, 0x35, 0x48, 0x12, 0x61, 0x8b, 0x4b, 0x3b, 0x4a, 0x75, 0x39, 0xb8, 0xa2, 0x23, 0xb3, 0x88, 0xbb, 0x74, 0x37, 0xf8, 0xd1, 0x38, 0xa5
};
#define result__113 0

//Test vector 114:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_114  [65] = {
0x04, 0x8f, 0x65, 0x9a, 0x16, 0x3a, 0x58, 0xe9, 0xf9, 0x00, 0xc1, 0xe9, 0xb3, 0x4f, 0xb1, 0xcd, 0x61, 0xff, 0xc9, 0x89, 0x02, 0x67, 0xbe, 0x34, 0x17, 0xc8, 0xaf, 0xe7, 0x9d, 0x57, 0x21, 0x4d, 0xa0, 0x5c, 0xd5, 0xcb, 0x68, 0xa2, 0xb9, 0x3d, 0xa0, 0xdb, 0xe5, 0x6c, 0x1c, 0xfc, 0x0d, 0xce, 0x8b, 0x6c, 0x32, 0x60, 0xe0, 0xc4, 0x83, 0x79, 0xc6, 0xd2, 0x09, 0x1f, 0x16, 0xb3, 0x92, 0x21, 0xc0
};
static uint8_t pri_114  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_114  [32] = {
0x4b, 0xab, 0xf6, 0x36, 0x8e, 0x03, 0x59, 0xb7, 0x86, 0x14, 0x06, 0x02, 0x41, 0xec, 0xe4, 0x6f, 0xac, 0xca, 0x3f, 0x52, 0xf5, 0xbb, 0xc4, 0x7a, 0xc0, 0xb4, 0x6a, 0x07, 0x5b, 0x5d, 0xd3, 0xa0
};
#define result__114 0

//Test vector 115:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_115  [65] = {
0x04, 0xd2, 0x57, 0xf1, 0x33, 0xf0, 0x0a, 0x07, 0x9f, 0x4e, 0x67, 0x78, 0xea, 0x4a, 0x9b, 0xf4, 0x2b, 0x9f, 0x23, 0x12, 0x90, 0x43, 0x1b, 0x5b, 0x93, 0xd7, 0xe8, 0xb0, 0xe3, 0x5b, 0x48, 0x01, 0x06, 0x50, 0xd6, 0xc6, 0xb4, 0x65, 0x74, 0xd1, 0xef, 0xce, 0x03, 0x51, 0x0b, 0x8d, 0xb4, 0xa0, 0x98, 0x1c, 0xe1, 0x38, 0xc5, 0xbd, 0x8f, 0xe0, 0xe5, 0x4c, 0x98, 0x8c, 0x40, 0xc5, 0xfc, 0x92, 0x00
};
static uint8_t pri_115  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_115  [32] = {
0x96, 0x27, 0xcc, 0x5c, 0x8d, 0x8b, 0x72, 0x27, 0x8b, 0xe8, 0x9c, 0x32, 0xb5, 0x22, 0x10, 0x17, 0x3e, 0x6f, 0x4b, 0x8e, 0x2f, 0x48, 0xe4, 0x60, 0xc6, 0x42, 0x9f, 0x46, 0xf9, 0xf4, 0x69, 0xae
};
#define result__115 0

//Test vector 116:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_116  [65] = {
0x04, 0x5e, 0xf2, 0xac, 0x57, 0xc4, 0xe9, 0x3c, 0xf7, 0x8d, 0x8f, 0x86, 0xc3, 0x5d, 0x41, 0x3b, 0x98, 0xdc, 0x19, 0x02, 0xdd, 0x24, 0x5a, 0xff, 0xde, 0x5c, 0x16, 0x03, 0x4a, 0xfc, 0x7e, 0xa4, 0x55, 0x47, 0xb3, 0xe9, 0xf7, 0x7f, 0xbc, 0x50, 0x75, 0xba, 0xd0, 0x3c, 0x41, 0x80, 0x94, 0xf1, 0xae, 0xc1, 0xd0, 0x3e, 0xde, 0xaf, 0xa1, 0x67, 0xfa, 0x6a, 0xf8, 0x35, 0x26, 0x55, 0x2f, 0x70, 0x34
};
static uint8_t pri_116  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_116  [32] = {
0xd2, 0xb1, 0x78, 0xbc, 0x9b, 0xb1, 0x6b, 0x5a, 0x91, 0xa1, 0x00, 0xbb, 0x72, 0xe1, 0x5a, 0x96, 0x39, 0xe0, 0x50, 0xc0, 0x34, 0x34, 0x60, 0x61, 0x41, 0x3e, 0xc2, 0x0c, 0x4f, 0xcc, 0x9b, 0xbc
};
#define result__116 0

//Test vector 117:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_117  [65] = {
0x04, 0xa7, 0xb5, 0x13, 0xf9, 0x62, 0x66, 0x41, 0x4f, 0xa6, 0xff, 0x43, 0x9a, 0x35, 0xd8, 0xf0, 0x9a, 0xb6, 0x15, 0xdb, 0x0b, 0xb6, 0xa3, 0xb1, 0xa1, 0x20, 0xc2, 0x17, 0x68, 0x3f, 0x72, 0x4b, 0x23, 0x42, 0x00, 0x7a, 0x2c, 0x9f, 0xea, 0xbc, 0xd6, 0x24, 0x9a, 0x0d, 0x17, 0xac, 0xec, 0xd9, 0x95, 0xe2, 0xa2, 0x17, 0xfb, 0x5f, 0x07, 0xbe, 0xc9, 0x69, 0x38, 0x01, 0x6e, 0x29, 0x7e, 0xfa, 0x52
};
static uint8_t pri_117  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_117  [32] = {
0x6c, 0xdc, 0xa0, 0xa7, 0x31, 0xaf, 0xf1, 0xcc, 0xfb, 0x19, 0x04, 0xa7, 0x69, 0xce, 0xf7, 0x9e, 0xba, 0x96, 0x5f, 0xba, 0xb1, 0xcc, 0x64, 0xd2, 0x04, 0x9d, 0x0d, 0xf4, 0x5d, 0xcc, 0xd2, 0x76
};
#define result__117 0

//Test vector 118:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_118  [65] = {
0x04, 0x77, 0x43, 0xab, 0x72, 0x48, 0xda, 0xe5, 0xf1, 0xa5, 0x9a, 0xc6, 0xb0, 0xa1, 0x36, 0xe9, 0xf1, 0xe5, 0x1a, 0xff, 0x8b, 0xd4, 0x57, 0x95, 0xac, 0xe5, 0xf8, 0x18, 0x7a, 0x13, 0xed, 0xf9, 0xad, 0xbd, 0x96, 0x42, 0x07, 0x83, 0x78, 0xba, 0xb5, 0xc6, 0xd4, 0x84, 0xf9, 0xe1, 0xce, 0x39, 0x67, 0x5b, 0x72, 0x17, 0x0b, 0xf3, 0x9a, 0xbc, 0x9b, 0xe7, 0x94, 0x2f, 0xc0, 0x1f, 0xc4, 0x35, 0xd7
};
static uint8_t pri_118  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_118  [32] = {
0xbd, 0x15, 0xe9, 0x7a, 0x7f, 0x49, 0xaa, 0x33, 0xe5, 0x7b, 0x54, 0x14, 0x0a, 0x75, 0xff, 0xfc, 0xe7, 0x1b, 0x78, 0x8c, 0xe0, 0xfa, 0xa3, 0x34, 0xcf, 0x8b, 0x45, 0x62, 0x3d, 0xcc, 0x81, 0x8a
};
#define result__118 0

//Test vector 119:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_119  [65] = {
0x04, 0x0e, 0x3a, 0xa9, 0x71, 0xba, 0xcd, 0xac, 0xe3, 0x50, 0xdc, 0x09, 0x57, 0xfa, 0x5b, 0xde, 0x09, 0x46, 0x32, 0x4e, 0xb1, 0x39, 0x93, 0x9d, 0x7f, 0xc1, 0x99, 0x7c, 0x70, 0x1e, 0xff, 0xd0, 0x4a, 0x4e, 0x6c, 0x36, 0x25, 0xd9, 0x56, 0x41, 0x68, 0xd3, 0xa7, 0x52, 0x96, 0x12, 0x21, 0xa1, 0xde, 0x8c, 0xf5, 0xf3, 0xd6, 0x03, 0x75, 0x2a, 0x8c, 0x2e, 0x62, 0x77, 0xac, 0x3a, 0x91, 0x8c, 0x25
};
static uint8_t pri_119  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_119  [32] = {
0xc8, 0xb5, 0xe8, 0xe7, 0x48, 0x88, 0x57, 0xa2, 0xdd, 0xe6, 0x2c, 0x5f, 0xc2, 0x1e, 0x45, 0x25, 0xeb, 0xab, 0xa0, 0xe0, 0x6b, 0x5b, 0xe8, 0x3e, 0xc6, 0xe7, 0xdd, 0x77, 0x1e, 0x15, 0xa0, 0x1a
};
#define result__119 0

//Test vector 120:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_120  [65] = {
0x04, 0x0f, 0x56, 0x3e, 0x21, 0xbf, 0x9b, 0x24, 0x01, 0x5a, 0x7c, 0xdb, 0xb6, 0xf0, 0x00, 0xa6, 0x92, 0x78, 0x4a, 0xc2, 0xe4, 0xbc, 0x27, 0x15, 0xc7, 0x6f, 0x68, 0x42, 0x64, 0xa8, 0x99, 0xc8, 0x24, 0x0c, 0xab, 0x0d, 0x76, 0xe6, 0xb0, 0x1c, 0xab, 0xe4, 0xf3, 0x27, 0x42, 0x9d, 0x11, 0xbe, 0x11, 0x5e, 0xd6, 0xdc, 0x0c, 0xa7, 0x4f, 0x02, 0xc1, 0xb9, 0x87, 0xa0, 0x82, 0xf5, 0xaf, 0x43, 0xa8
};
static uint8_t pri_120  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_120  [32] = {
0x1c, 0x63, 0xa4, 0x57, 0x50, 0x9b, 0x14, 0x82, 0x72, 0x68, 0x7e, 0x6e, 0x44, 0x2b, 0xde, 0x51, 0x98, 0x2d, 0x41, 0xb0, 0x08, 0x0d, 0x8c, 0x0c, 0x5e, 0xb7, 0x14, 0x25, 0x7a, 0xf9, 0x71, 0xe7
};
#define result__120 0

//Test vector 121:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_121  [65] = {
0x04, 0x5d, 0xa4, 0x9f, 0x10, 0x24, 0x9e, 0x4d, 0xf3, 0xdb, 0xb4, 0xe3, 0x1e, 0xce, 0x0b, 0x0e, 0xe9, 0xaa, 0x07, 0x3f, 0x25, 0x88, 0x19, 0x5a, 0xaa, 0xe6, 0x3e, 0x74, 0xf6, 0x56, 0x7a, 0x77, 0x48, 0x10, 0xb5, 0xdd, 0x61, 0xb6, 0xbf, 0x21, 0x9e, 0x9e, 0xab, 0x30, 0xef, 0x09, 0xc1, 0x3f, 0xc1, 0x84, 0xb3, 0xd0, 0x9f, 0xf7, 0xa4, 0xe1, 0x92, 0xbc, 0xa8, 0xf5, 0x11, 0x1c, 0x41, 0x63, 0xc7
};
static uint8_t pri_121  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_121  [32] = {
0x73, 0xa1, 0xac, 0x9e, 0xce, 0x35, 0x4a, 0x93, 0x0d, 0xfd, 0x9c, 0x77, 0x57, 0x7b, 0x4f, 0x50, 0xac, 0xc0, 0xa7, 0x89, 0x64, 0xea, 0x0d, 0x77, 0x75, 0x63, 0x1d, 0x64, 0xc7, 0x09, 0xc4, 0xa2
};
#define result__121 0

//Test vector 122:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_122  [65] = {
0x04, 0x6f, 0x72, 0xe6, 0xe5, 0xc6, 0x30, 0x06, 0x79, 0xd3, 0xf1, 0x4f, 0x0f, 0x6e, 0x59, 0x06, 0x65, 0x64, 0x35, 0x76, 0xae, 0x8b, 0xbc, 0xb7, 0xc0, 0x5b, 0x2f, 0x4a, 0x83, 0xe7, 0x5e, 0x6a, 0xc3, 0xe7, 0x12, 0xcb, 0x05, 0x6f, 0xf0, 0x34, 0xda, 0x34, 0x05, 0x43, 0xc5, 0xda, 0x69, 0x97, 0xe6, 0x5a, 0x3a, 0xb4, 0xcd, 0x39, 0xe9, 0x97, 0x89, 0x2b, 0xb9, 0x2e, 0xe2, 0xc2, 0x2b, 0x81, 0x67
};
static uint8_t pri_122  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_122  [32] = {
0xfc, 0xaa, 0x40, 0x63, 0x29, 0xbb, 0x74, 0xf9, 0x95, 0x86, 0x2c, 0xea, 0x7c, 0xec, 0xc7, 0x42, 0x5c, 0x6b, 0xd4, 0x14, 0x8e, 0xf1, 0xa9, 0xf4, 0x6b, 0x5d, 0x42, 0xda, 0x59, 0x94, 0x55, 0x6a
};
#define result__122 0

//Test vector 123:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_123  [65] = {
0x04, 0x6b, 0x54, 0x4d, 0xf9, 0x16, 0x8e, 0x77, 0x87, 0xdb, 0x28, 0x2e, 0x2a, 0xe0, 0x1d, 0xd7, 0x23, 0x06, 0xd9, 0xc9, 0xbc, 0x80, 0xf5, 0xab, 0x38, 0xce, 0x59, 0x47, 0x66, 0xc3, 0xd9, 0x29, 0xe9, 0x67, 0x49, 0x3f, 0xf6, 0x01, 0xca, 0x60, 0x86, 0x2b, 0x47, 0xd3, 0xa0, 0x78, 0x5c, 0x91, 0x7e, 0x44, 0x58, 0x40, 0x44, 0xe3, 0x60, 0x23, 0xa5, 0x44, 0x24, 0x01, 0x5e, 0x58, 0xbe, 0x50, 0x40
};
static uint8_t pri_123  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_123  [32] = {
0xe4, 0x9f, 0xf1, 0x1d, 0x46, 0xb6, 0xc4, 0xb5, 0xdd, 0xe5, 0x28, 0xb0, 0x41, 0x32, 0xd1, 0x5c, 0x04, 0x0e, 0x79, 0xf9, 0xb7, 0x15, 0x1f, 0xbc, 0x65, 0x00, 0x30, 0x98, 0x80, 0x28, 0xcb, 0x87
};
#define result__123 0

//Test vector 124:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_124  [65] = {
0x04, 0x1c, 0x31, 0x38, 0x5b, 0x9d, 0xb9, 0xb3, 0x74, 0xe9, 0x24, 0x99, 0x93, 0x9a, 0xb0, 0xfd, 0x7e, 0x7e, 0xda, 0x46, 0x45, 0x61, 0xeb, 0xa8, 0x9f, 0xcd, 0x7b, 0x47, 0x69, 0x81, 0x4a, 0x86, 0x38, 0xa4, 0x76, 0x4c, 0xf8, 0xce, 0x97, 0xb5, 0xd1, 0x43, 0xbb, 0x8e, 0xeb, 0x9e, 0x1b, 0x27, 0x28, 0x7f, 0x2b, 0x73, 0x94, 0x2e, 0xcd, 0xbc, 0x63, 0x59, 0xaa, 0xfb, 0x1e, 0xe7, 0xa1, 0x52, 0xc2
};
static uint8_t pri_124  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_124  [32] = {
0xfc, 0x8f, 0x64, 0xea, 0xc1, 0xc7, 0xe6, 0x88, 0xc5, 0x2c, 0x46, 0x71, 0x85, 0xde, 0x21, 0x91, 0x4e, 0x8b, 0x25, 0x30, 0x56, 0xd9, 0xe4, 0xbe, 0x01, 0x0e, 0xd0, 0x12, 0x8f, 0x92, 0xa8, 0x89
};
#define result__124 0

//Test vector 125:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_125  [65] = {
0x04, 0xaa, 0xbc, 0xf8, 0xb1, 0x44, 0x3d, 0x6c, 0xbb, 0x1d, 0xe1, 0x29, 0xa0, 0xff, 0xe0, 0x9f, 0x60, 0xb2, 0x3f, 0xd9, 0xd0, 0xa4, 0x4b, 0x6b, 0xdf, 0x25, 0xbe, 0xd7, 0x37, 0x3f, 0xdb, 0xfd, 0x1d, 0xb7, 0x16, 0xbd, 0xe7, 0xfe, 0x9f, 0x2f, 0x46, 0xde, 0x0b, 0x68, 0x8e, 0x30, 0x25, 0xe0, 0x29, 0xcf, 0xf1, 0x52, 0x44, 0x42, 0x9a, 0xd4, 0xf8, 0x34, 0x84, 0xf5, 0xde, 0xa4, 0xaf, 0x85, 0x83
};
static uint8_t pri_125  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_125  [32] = {
0x6b, 0x56, 0xd8, 0xa0, 0x1a, 0x88, 0x43, 0x19, 0xab, 0x5f, 0xb9, 0xd8, 0x90, 0xca, 0xcf, 0xc7, 0xaa, 0xbd, 0x81, 0xad, 0x93, 0x8c, 0xb5, 0xea, 0xae, 0x20, 0x7c, 0x8c, 0x1a, 0xa0, 0x6e, 0xfb
};
#define result__125 0

//Test vector 126:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_126  [65] = {
0x04, 0xe7, 0xcd, 0x58, 0x0b, 0xd9, 0x57, 0x91, 0x5d, 0x52, 0x70, 0x56, 0x83, 0x2e, 0x37, 0x79, 0x3a, 0xb3, 0xb0, 0x82, 0xdd, 0xfa, 0xd9, 0x37, 0x24, 0x12, 0xe1, 0x90, 0x8e, 0x5c, 0x16, 0xbb, 0xb6, 0x20, 0x86, 0x01, 0xa9, 0x70, 0xd5, 0x84, 0x4b, 0x78, 0x0d, 0x92, 0x46, 0xe9, 0x58, 0x3e, 0xb3, 0x59, 0x18, 0xc4, 0x2e, 0xd6, 0x95, 0xc0, 0x7d, 0x52, 0x24, 0x40, 0x37, 0xf0, 0xe3, 0x1d, 0xb5
};
static uint8_t pri_126  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_126  [32] = {
0x2f, 0x64, 0xb5, 0xc8, 0x04, 0x6d, 0x41, 0xa4, 0xe1, 0xd6, 0x31, 0xff, 0x23, 0x84, 0x6b, 0xff, 0x95, 0x6a, 0x49, 0x25, 0xa4, 0x7f, 0x85, 0x34, 0x49, 0x0a, 0x20, 0xb4, 0xb1, 0x91, 0x8b, 0x9c
};
#define result__126 0

//Test vector 127:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_127  [65] = {
0x04, 0x2a, 0x52, 0xdb, 0x1f, 0xe2, 0x46, 0xb7, 0x1c, 0x79, 0xc0, 0xd0, 0xac, 0x49, 0xa7, 0xd3, 0x8d, 0xe6, 0x7b, 0x20, 0x29, 0x95, 0xef, 0xbb, 0xd2, 0xa9, 0xcc, 0x52, 0x5f, 0x6f, 0x36, 0x01, 0x03, 0x68, 0xf4, 0x94, 0xbe, 0x27, 0xe0, 0x59, 0x3e, 0x2d, 0x61, 0x2f, 0x1f, 0xa1, 0x0a, 0x92, 0x11, 0x43, 0x7e, 0x6a, 0xa1, 0x6e, 0x65, 0xd9, 0x77, 0x35, 0x01, 0x40, 0x72, 0xf0, 0xdc, 0xec, 0x94
};
static uint8_t pri_127  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_127  [32] = {
0x63, 0xac, 0x31, 0xe7, 0x18, 0xb9, 0xa7, 0x80, 0xa8, 0x5f, 0x06, 0x70, 0xe1, 0xd3, 0x68, 0x5b, 0xbe, 0x30, 0x6e, 0x5f, 0x06, 0xfe, 0xe2, 0x82, 0xa8, 0x78, 0x47, 0x00, 0xb5, 0x03, 0xc1, 0x24
};
#define result__127 0

//Test vector 128:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_128  [65] = {
0x04, 0x1c, 0x50, 0xdc, 0x49, 0xfe, 0xf7, 0x08, 0xc4, 0xcd, 0xd6, 0x2e, 0x76, 0x6f, 0x9b, 0x60, 0xf7, 0x84, 0xd5, 0x1a, 0xfe, 0xe1, 0x7a, 0x8f, 0xe9, 0xf3, 0x70, 0x1b, 0x2f, 0xae, 0x55, 0xb7, 0xa5, 0xd1, 0x0f, 0x0d, 0x96, 0x39, 0xd8, 0x3d, 0xce, 0x8f, 0x26, 0xa8, 0x69, 0x70, 0x5a, 0x6d, 0x6d, 0x38, 0xe6, 0xd3, 0x28, 0xf5, 0x68, 0x55, 0x81, 0x14, 0x2a, 0xec, 0x0d, 0xcd, 0x1f, 0x90, 0xe7
};
static uint8_t pri_128  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_128  [32] = {
0x55, 0x5c, 0x19, 0x17, 0xb7, 0x70, 0xce, 0xbe, 0x6a, 0x98, 0x33, 0x7a, 0x00, 0x8a, 0xe3, 0xd8, 0xd0, 0x4f, 0x57, 0x15, 0x65, 0x32, 0x7c, 0x93, 0xde, 0xbf, 0x61, 0xef, 0x90, 0xdd, 0xdd, 0xd8
};
#define result__128 0

//Test vector 129:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_129  [65] = {
0x04, 0x6d, 0x0a, 0xa1, 0xbc, 0x1c, 0xee, 0x6d, 0x07, 0xd0, 0x45, 0x00, 0x2c, 0x13, 0x29, 0x0d, 0x0c, 0xa2, 0x5c, 0xa3, 0xc8, 0x78, 0x33, 0x43, 0xa5, 0x25, 0xfa, 0xc7, 0x04, 0x72, 0xb9, 0x2c, 0x62, 0xd6, 0xfb, 0xa7, 0x11, 0x74, 0x44, 0x8b, 0x47, 0x2c, 0xf1, 0x72, 0xb0, 0xca, 0x9e, 0x37, 0x7f, 0x1a, 0x26, 0x03, 0xba, 0x7a, 0xe1, 0x27, 0x6d, 0x15, 0x3b, 0x20, 0xc6, 0x3e, 0x7d, 0x24, 0xbf
};
static uint8_t pri_129  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_129  [32] = {
0x3a, 0x65, 0xa9, 0x20, 0x0f, 0x8f, 0x96, 0x63, 0x59, 0x12, 0xfa, 0xa5, 0xe7, 0x85, 0x9f, 0xa3, 0x03, 0xa7, 0x6a, 0x1c, 0x2a, 0x41, 0xea, 0x97, 0xef, 0x61, 0xaa, 0x39, 0x28, 0x77, 0x00, 0xa9
};
#define result__129 0

//Test vector 130:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_130  [65] = {
0x04, 0xf0, 0x7e, 0x3d, 0x8b, 0xe2, 0xba, 0x54, 0xc6, 0x08, 0x41, 0x41, 0xe1, 0xfd, 0x2b, 0x29, 0xcf, 0xd0, 0x0d, 0x4e, 0x6d, 0xd6, 0xff, 0xb1, 0x15, 0xed, 0x83, 0x9b, 0x10, 0xbd, 0x8a, 0x42, 0x2f, 0x42, 0x99, 0x2c, 0xb9, 0xa5, 0x24, 0x38, 0x97, 0xd5, 0x54, 0x08, 0xe9, 0xbb, 0x55, 0x60, 0x43, 0x31, 0x8d, 0x87, 0x34, 0x9a, 0xf3, 0x5d, 0xcc, 0x09, 0x75, 0xed, 0x80, 0x5c, 0x8f, 0xa2, 0xc9
};
static uint8_t pri_130  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_130  [32] = {
0xbb, 0x7b, 0xb5, 0x2d, 0xa5, 0x70, 0xba, 0x58, 0xe0, 0x5f, 0xd3, 0x22, 0xf8, 0x2d, 0x55, 0x6c, 0x2d, 0x65, 0xb3, 0x65, 0xdb, 0x30, 0x81, 0x58, 0x79, 0xf6, 0x7f, 0x23, 0x3b, 0x08, 0x9b, 0x51
};
#define result__130 0

//Test vector 131:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_131  [65] = {
0x04, 0x43, 0xa9, 0xb9, 0x02, 0x74, 0xdb, 0xd5, 0xf3, 0x6d, 0xd2, 0x90, 0x46, 0xfc, 0x83, 0x90, 0x00, 0x8d, 0xde, 0x74, 0x51, 0x3c, 0xe4, 0xc3, 0xe8, 0x89, 0x2b, 0x23, 0x6e, 0xff, 0xf8, 0x0c, 0x9d, 0xc7, 0x15, 0x47, 0x15, 0x2a, 0x58, 0x97, 0xdb, 0xe1, 0x69, 0x57, 0xbd, 0x15, 0xd1, 0xa8, 0x7d, 0x77, 0x04, 0x96, 0xf8, 0x14, 0xfe, 0x29, 0x21, 0xc8, 0xf3, 0x3d, 0xf0, 0x43, 0x93, 0xc7, 0xf8
};
static uint8_t pri_131  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_131  [32] = {
0xe8, 0xca, 0xe9, 0x94, 0x42, 0x33, 0xb8, 0x67, 0xee, 0xdf, 0x59, 0x02, 0xfc, 0x49, 0xec, 0xd0, 0x7e, 0x4c, 0x81, 0xc4, 0x62, 0x79, 0x53, 0x1e, 0x89, 0x52, 0x0b, 0x74, 0xba, 0x53, 0x70, 0xb5
};
#define result__131 0

//Test vector 132:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_132  [65] = {
0x04, 0xe9, 0xaf, 0x8e, 0x8c, 0x19, 0xda, 0x9d, 0x5c, 0x2f, 0x3b, 0x3c, 0x03, 0xb8, 0xe9, 0x27, 0xc3, 0xcb, 0xe2, 0xd7, 0x17, 0xf9, 0x8f, 0x50, 0x09, 0x72, 0xe5, 0x6d, 0x82, 0xeb, 0x07, 0xc2, 0xb1, 0x4e, 0x83, 0xfc, 0xaa, 0xca, 0xdc, 0x26, 0xf8, 0xbb, 0x5e, 0x7b, 0x94, 0x74, 0x1f, 0xe5, 0x4f, 0x31, 0x27, 0x5e, 0xbd, 0x6e, 0x1c, 0x96, 0x9d, 0x7e, 0xc2, 0xfe, 0xce, 0xad, 0x8a, 0x0d, 0xae
};
static uint8_t pri_132  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_132  [32] = {
0xe7, 0x2a, 0xd0, 0xcd, 0xb2, 0x5f, 0x43, 0x07, 0xd1, 0xd8, 0x34, 0xa5, 0xf7, 0x92, 0xe9, 0xaf, 0x64, 0xfd, 0x1b, 0x69, 0xa4, 0x70, 0x41, 0xec, 0x8f, 0xa4, 0x6d, 0x52, 0x6f, 0x41, 0x9e, 0x4d
};
#define result__132 0

//Test vector 133:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_133  [65] = {
0x04, 0x33, 0xd9, 0x58, 0x2b, 0x56, 0x7a, 0xad, 0xbe, 0x59, 0x60, 0x6f, 0xa6, 0xff, 0xc1, 0x18, 0x48, 0xe4, 0x94, 0x7b, 0x51, 0x79, 0x59, 0x73, 0x17, 0x77, 0x63, 0x17, 0xb2, 0xb4, 0xff, 0x65, 0xd0, 0xb4, 0xd8, 0x56, 0x8d, 0xc8, 0x43, 0x31, 0x9c, 0xc0, 0x4f, 0x4b, 0xf1, 0x10, 0x49, 0x6d, 0xee, 0x7c, 0x92, 0x29, 0xfc, 0x68, 0xcb, 0x09, 0x58, 0xf3, 0xcb, 0xd3, 0x7e, 0xcc, 0xa6, 0x99, 0x0f
};
static uint8_t pri_133  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_133  [32] = {
0x00, 0x01, 0x97, 0xfb, 0xc2, 0x60, 0xa8, 0x4d, 0xbc, 0xbf, 0x88, 0x13, 0x6a, 0xea, 0xa7, 0x9b, 0x03, 0xbb, 0x89, 0x49, 0xae, 0xfd, 0x24, 0x16, 0xbe, 0xf6, 0x39, 0x29, 0xef, 0x78, 0x9b, 0xf3
};
#define result__133 0

//Test vector 134:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_134  [65] = {
0x04, 0xe2, 0x1c, 0x02, 0x82, 0xad, 0xb1, 0xb2, 0x05, 0x5f, 0xda, 0x74, 0x46, 0x44, 0xc6, 0x86, 0x12, 0xcf, 0xb0, 0xc6, 0x8a, 0x70, 0xb9, 0x81, 0x2d, 0x00, 0x7f, 0x21, 0xa7, 0x8f, 0x1a, 0xdc, 0x48, 0x49, 0xf3, 0xe7, 0x64, 0x4b, 0xc6, 0x63, 0x3e, 0x27, 0x73, 0xa2, 0xf3, 0xcc, 0x52, 0x14, 0xfa, 0x72, 0x08, 0xe3, 0x0a, 0xfb, 0x3d, 0xe9, 0x92, 0xf0, 0x77, 0xee, 0x32, 0x15, 0x69, 0xdc, 0x48
};
static uint8_t pri_134  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_134  [32] = {
0xcd, 0xb1, 0x8b, 0xf6, 0x26, 0x70, 0xa8, 0x53, 0x48, 0x8c, 0xa5, 0x10, 0xd8, 0xf5, 0x5b, 0xab, 0x29, 0x18, 0x99, 0x14, 0x24, 0x92, 0x5b, 0xd9, 0xb7, 0x4a, 0x82, 0x1d, 0x2c, 0x6e, 0x7e, 0x3c
};
#define result__134 0

//Test vector 135:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_135  [65] = {
0x04, 0xaf, 0x27, 0xde, 0x0d, 0xa6, 0x55, 0x6e, 0x4e, 0x64, 0x58, 0x8c, 0x96, 0x94, 0xaf, 0xee, 0x9a, 0x84, 0xe1, 0xcb, 0xd0, 0xc3, 0x88, 0x97, 0x2d, 0xf3, 0xa9, 0x97, 0xf7, 0x60, 0xbb, 0xcd, 0x90, 0x3c, 0x5a, 0x02, 0xe1, 0x61, 0x55, 0x1f, 0x33, 0x3d, 0x77, 0x05, 0x59, 0xab, 0x1a, 0xf4, 0x9b, 0xf8, 0xb6, 0x82, 0x74, 0x89, 0x65, 0x90, 0x93, 0x9c, 0xe9, 0x56, 0xd9, 0x91, 0x3b, 0x67, 0x6f
};
static uint8_t pri_135  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_135  [32] = {
0x16, 0x73, 0x03, 0x50, 0x5d, 0x22, 0xcf, 0x9e, 0xf7, 0x8c, 0x5b, 0x96, 0x87, 0xa5, 0x41, 0x8f, 0xa9, 0xfb, 0x28, 0x4f, 0x2b, 0x0f, 0xf6, 0x83, 0x16, 0x28, 0x8e, 0xcd, 0x7f, 0x2e, 0x2e, 0x09
};
#define result__135 0

//Test vector 136:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_136  [65] = {
0x04, 0x0d, 0xa4, 0x1b, 0x82, 0x55, 0x0b, 0x35, 0x8f, 0xf4, 0x74, 0x91, 0x5d, 0x83, 0x10, 0x4d, 0x41, 0xa8, 0x3a, 0x12, 0xef, 0x70, 0x58, 0x9b, 0x9d, 0x39, 0x2f, 0x0f, 0x30, 0xdc, 0x32, 0x42, 0x9e, 0xdc, 0x76, 0x16, 0x3c, 0x8f, 0xe0, 0x7a, 0x3f, 0x70, 0x9c, 0xbd, 0x92, 0xda, 0x0b, 0xbf, 0xc5, 0x04, 0x5f, 0x3d, 0xb8, 0x2a, 0xa5, 0x34, 0x4c, 0xf1, 0xfd, 0x5b, 0x27, 0xfc, 0xd2, 0xf7, 0xa6
};
static uint8_t pri_136  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_136  [32] = {
0x85, 0x60, 0x0f, 0xf2, 0x3c, 0x3c, 0xde, 0x26, 0x00, 0x9f, 0xea, 0x9b, 0x65, 0x39, 0x66, 0x4b, 0xf0, 0x45, 0x05, 0x68, 0x83, 0x72, 0x8a, 0xb0, 0xd4, 0x49, 0x8e, 0xa0, 0xa8, 0xf4, 0xa4, 0x53
};
#define result__136 0

//Test vector 137:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_137  [65] = {
0x04, 0x19, 0xc8, 0x44, 0xb8, 0xc7, 0x20, 0x90, 0x26, 0xa0, 0x99, 0x6a, 0x78, 0x29, 0x83, 0xe1, 0xbd, 0x0f, 0x0d, 0xe9, 0x25, 0x5b, 0x86, 0x73, 0x9b, 0xe9, 0xbe, 0xf0, 0x8e, 0xa5, 0x47, 0x5c, 0xc6, 0x69, 0xa7, 0x79, 0xdd, 0xf5, 0x77, 0x47, 0xcf, 0x7d, 0x9a, 0x22, 0xf0, 0x0e, 0xd8, 0xef, 0xc6, 0xe8, 0x18, 0xaf, 0x58, 0x27, 0xb7, 0x50, 0xd6, 0x65, 0xfe, 0xe6, 0xd6, 0xd5, 0x8a, 0x22, 0xe8
};
static uint8_t pri_137  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_137  [32] = {
0xa3, 0x25, 0x0a, 0x2b, 0xfb, 0x14, 0x5c, 0xe8, 0x6e, 0x70, 0x6a, 0xc3, 0xab, 0x2b, 0xf5, 0x03, 0xa6, 0x64, 0x86, 0xac, 0x0b, 0x2f, 0x75, 0x22, 0x60, 0x1c, 0x12, 0x4b, 0x0e, 0x0f, 0x9c, 0x5b
};
#define result__137 0

//Test vector 138:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_138  [65] = {
0x04, 0xbd, 0x07, 0xbd, 0x43, 0x26, 0xcd, 0xca, 0xbf, 0x42, 0x90, 0x5e, 0xfa, 0x45, 0x59, 0xa3, 0x0e, 0x68, 0xcb, 0x21, 0x5d, 0x40, 0xc9, 0xaf, 0xb6, 0x0c, 0xe0, 0x2d, 0x4f, 0xda, 0x61, 0x75, 0x79, 0xb9, 0x27, 0xb5, 0xcb, 0xa0, 0x2d, 0x24, 0xfb, 0x9a, 0xaf, 0xe1, 0xd4, 0x29, 0x35, 0x1e, 0x48, 0xba, 0xe9, 0xdd, 0x92, 0xd7, 0xbc, 0x7b, 0xe1, 0x5e, 0x5b, 0x8a, 0x30, 0xa8, 0x6b, 0xe1, 0x3d
};
static uint8_t pri_138  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_138  [32] = {
0x2d, 0x70, 0xcc, 0x8c, 0x8a, 0xf0, 0x13, 0x66, 0x05, 0x1c, 0xc8, 0x35, 0x9c, 0x2f, 0xc8, 0xf2, 0x58, 0x75, 0x7e, 0x26, 0x01, 0xfd, 0x8f, 0x3e, 0x08, 0x42, 0x2a, 0x7b, 0x23, 0xbf, 0xef, 0xf5
};
#define result__138 0

//Test vector 139:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_139  [65] = {
0x04, 0x00, 0x89, 0xde, 0xe2, 0x7a, 0x60, 0xd0, 0x71, 0xda, 0xbb, 0xaf, 0x58, 0xf3, 0xe5, 0x66, 0x14, 0xda, 0xd3, 0xb7, 0xf9, 0xa8, 0x03, 0x07, 0x69, 0xfd, 0x04, 0x63, 0xb3, 0xe6, 0xe0, 0xf0, 0x3a, 0x14, 0x7b, 0x4d, 0x6e, 0x7e, 0x7f, 0xd9, 0x39, 0xb9, 0xb5, 0x4d, 0xab, 0x45, 0x8f, 0xd5, 0x56, 0xad, 0x8f, 0xda, 0xf4, 0xda, 0x6c, 0x39, 0x09, 0x58, 0x8c, 0x4e, 0x05, 0x0c, 0xa7, 0x4a, 0x67
};
static uint8_t pri_139  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_139  [32] = {
0xcb, 0xe0, 0xc5, 0x71, 0xd1, 0x08, 0x0e, 0xa3, 0x4e, 0xe2, 0x0a, 0xd1, 0xbf, 0xd2, 0x1e, 0xa5, 0xec, 0xc4, 0x42, 0xea, 0xd7, 0x33, 0xfb, 0x4e, 0xee, 0x3c, 0x0d, 0x7b, 0x0c, 0xce, 0x99, 0x35
};
#define result__139 0

//Test vector 140:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_140  [65] = {
0x04, 0x42, 0xed, 0xe1, 0x06, 0xcf, 0x85, 0xae, 0xf4, 0x6d, 0xf7, 0xe5, 0xdb, 0xa8, 0xa8, 0xb0, 0x04, 0x59, 0x31, 0x7d, 0x9e, 0x76, 0x6a, 0x7b, 0x77, 0xc2, 0x99, 0xaa, 0x0e, 0x17, 0xde, 0xa1, 0x42, 0xb6, 0xe9, 0xa8, 0x6f, 0x4f, 0xc3, 0xe9, 0x45, 0xd4, 0x32, 0x3b, 0xa8, 0xe4, 0x59, 0xf6, 0xb7, 0xb1, 0x4c, 0x56, 0x3a, 0x69, 0x8c, 0x75, 0x7a, 0x2d, 0x5f, 0x7b, 0x0b, 0xc3, 0x01, 0xed, 0xe2
};
static uint8_t pri_140  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_140  [32] = {
0x33, 0x32, 0x0f, 0xc7, 0x91, 0x7f, 0xe4, 0xe1, 0x92, 0x80, 0xbf, 0xbf, 0xe1, 0x6f, 0x22, 0x3c, 0x03, 0x7f, 0x7c, 0x2d, 0xc3, 0x0c, 0x0f, 0xda, 0x98, 0x31, 0x07, 0x40, 0xf5, 0x7f, 0xe2, 0x89
};
#define result__140 0

//Test vector 141:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_141  [65] = {
0x04, 0x97, 0x4b, 0x43, 0x16, 0xc5, 0xe7, 0xd1, 0x34, 0x8b, 0x28, 0xdb, 0xc4, 0xfd, 0x61, 0xd8, 0xd3, 0x47, 0x0d, 0xe7, 0x44, 0xc3, 0x0f, 0x5b, 0xe2, 0x37, 0xf8, 0x5f, 0x29, 0x96, 0x9d, 0xea, 0x77, 0xb5, 0xf0, 0x0b, 0x58, 0xb8, 0x3c, 0xfc, 0x7b, 0xc5, 0x16, 0x55, 0x46, 0x5b, 0x4a, 0x28, 0xab, 0xe1, 0xed, 0x3d, 0xbe, 0xc2, 0x0c, 0x6b, 0x46, 0x43, 0xae, 0xc8, 0x5b, 0x95, 0xa5, 0xbe, 0xc6
};
static uint8_t pri_141  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_141  [32] = {
0x35, 0xc7, 0x26, 0xea, 0xd6, 0x6c, 0x39, 0x41, 0x4f, 0xe0, 0xc2, 0x46, 0x04, 0xdf, 0x78, 0x38, 0xe5, 0x72, 0x5d, 0x2f, 0xc1, 0xbd, 0x08, 0x53, 0x26, 0x1e, 0x1d, 0xe3, 0x33, 0x8e, 0xcb, 0x4f
};
#define result__141 0

//Test vector 142:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_142  [65] = {
0x04, 0x59, 0x87, 0x3d, 0x75, 0x23, 0x93, 0x6a, 0x12, 0x1b, 0x62, 0x9e, 0x98, 0x70, 0xf9, 0x30, 0x41, 0x9f, 0x25, 0x3a, 0x57, 0x67, 0xb9, 0xd0, 0xdc, 0x49, 0x71, 0x6f, 0x2c, 0x50, 0xe1, 0x7b, 0xd0, 0x16, 0x3b, 0x71, 0xf2, 0xbf, 0x43, 0x18, 0xfb, 0xde, 0x1c, 0xea, 0xa5, 0x85, 0x45, 0x00, 0x80, 0xee, 0xc2, 0x84, 0x74, 0xcd, 0x18, 0xbf, 0x7c, 0x21, 0xd2, 0xd1, 0xbf, 0xde, 0x4f, 0xf6, 0x77
};
static uint8_t pri_142  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_142  [32] = {
0x66, 0xea, 0x42, 0xfe, 0x6f, 0xd8, 0x74, 0x1b, 0x37, 0x59, 0x9b, 0xbd, 0xad, 0xa3, 0xec, 0x0e, 0x6b, 0x08, 0xc0, 0xb5, 0x2e, 0xa6, 0x7c, 0x29, 0xa3, 0x31, 0x72, 0xf7, 0x27, 0x42, 0x58, 0x3c
};
#define result__142 0

//Test vector 143:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_143  [65] = {
0x04, 0xbd, 0x85, 0xa7, 0x9f, 0x81, 0xc4, 0xf9, 0x61, 0x3e, 0x64, 0xfa, 0x34, 0x78, 0x86, 0x43, 0x78, 0x56, 0xc7, 0x35, 0x8d, 0x1b, 0x69, 0xcf, 0x1e, 0x92, 0x3d, 0x77, 0x42, 0xd8, 0x2f, 0x9b, 0x67, 0x67, 0xd2, 0x69, 0x18, 0xea, 0xa8, 0xac, 0xb1, 0x13, 0xa1, 0xda, 0xad, 0xae, 0xdc, 0x70, 0x97, 0x42, 0x45, 0x73, 0x03, 0xeb, 0xc2, 0x3c, 0xdd, 0xa5, 0x57, 0x26, 0x13, 0xdc, 0x82, 0x77, 0x03
};
static uint8_t pri_143  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_143  [32] = {
0x2f, 0x8a, 0x50, 0x2e, 0x4f, 0x44, 0x01, 0x33, 0xe8, 0x4f, 0xb6, 0x25, 0x29, 0x2c, 0xbe, 0xab, 0xe2, 0xcb, 0x79, 0xda, 0x73, 0x98, 0x7c, 0x76, 0xd4, 0xfe, 0xd8, 0x64, 0xd1, 0xb1, 0xb7, 0x62
};
#define result__143 0

//Test vector 144:           "comment" : "point with coordinate y = 1 in left to right addition chain",

static uint8_t pub_144  [65] = {
0x04, 0x3e, 0x6a, 0x4e, 0xff, 0xc4, 0x7c, 0x2f, 0x59, 0x26, 0xbb, 0x6b, 0x4a, 0xcf, 0x2e, 0xac, 0x48, 0xb9, 0x52, 0x4c, 0x47, 0xd5, 0x11, 0xf8, 0x16, 0x97, 0x67, 0x96, 0x77, 0x86, 0x00, 0xd6, 0xc5, 0xbf, 0xce, 0x59, 0x32, 0x42, 0xa5, 0x98, 0x5a, 0x97, 0x75, 0x90, 0xf8, 0xd7, 0x48, 0x5d, 0xf3, 0xf9, 0x53, 0x35, 0x29, 0x57, 0xf3, 0xc1, 0x7c, 0x13, 0xe9, 0x45, 0x83, 0xd9, 0xc0, 0xe7, 0xb9
};
static uint8_t pri_144  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_144  [32] = {
0x06, 0x43, 0x68, 0x17, 0xd8, 0x92, 0x8b, 0x77, 0xb7, 0x3d, 0x16, 0xc5, 0xc3, 0xb3, 0x5e, 0x24, 0x3a, 0xd3, 0xef, 0x2a, 0xb5, 0x9a, 0xd0, 0x47, 0x14, 0x2c, 0x67, 0xa6, 0xd0, 0x92, 0x3c, 0x84
};
#define result__144 0

//Test vector 145:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_145  [65] = {
0x04, 0x9a, 0x44, 0x87, 0xfc, 0xfc, 0xe8, 0x39, 0x66, 0x88, 0xe7, 0x44, 0x9e, 0x09, 0x5f, 0xe8, 0x03, 0xca, 0xa2, 0x53, 0xd4, 0xbd, 0x7c, 0x66, 0xdb, 0xc6, 0x26, 0x1c, 0xc9, 0xd9, 0xf8, 0x83, 0xa5, 0x0e, 0x52, 0x51, 0xba, 0xe2, 0x9c, 0x5a, 0x5c, 0xdf, 0xa3, 0x1b, 0xc6, 0x11, 0x05, 0x67, 0x1a, 0x88, 0xa0, 0x18, 0x46, 0x73, 0x98, 0x15, 0x8d, 0x35, 0xb8, 0x88, 0x29, 0x23, 0x7c, 0x0b, 0xff
};
static uint8_t pri_145  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_145  [32] = {
0x7e, 0x83, 0xfd, 0x2c, 0x3d, 0x71, 0x3b, 0xc8, 0x5d, 0x6d, 0x85, 0xd9, 0x07, 0x8b, 0x3a, 0x08, 0x42, 0x82, 0x4d, 0x41, 0x0e, 0x8a, 0xbd, 0xe0, 0x4d, 0xa0, 0xfd, 0x71, 0xc7, 0xd9, 0x47, 0x05
};
#define result__145 0

//Test vector 146:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_146  [65] = {
0x04, 0xfe, 0xd6, 0xce, 0x12, 0x72, 0x90, 0xc1, 0x29, 0x1c, 0xa5, 0xce, 0x64, 0xac, 0xb4, 0xe0, 0xf2, 0xf8, 0x90, 0x56, 0x54, 0xd1, 0xd2, 0x5b, 0xa5, 0x7c, 0x1f, 0x74, 0xab, 0x52, 0xf2, 0x1f, 0x42, 0x96, 0x3d, 0x31, 0x67, 0x1c, 0x06, 0xb8, 0x02, 0x16, 0x99, 0x29, 0x52, 0x5c, 0x4a, 0x1f, 0xde, 0xff, 0x5b, 0x1e, 0xaf, 0xab, 0x91, 0x9d, 0xc2, 0xdf, 0x6c, 0x52, 0xbe, 0x84, 0xdf, 0xae, 0xf3
};
static uint8_t pri_146  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_146  [32] = {
0x0e, 0x3d, 0xfd, 0xab, 0x60, 0x6e, 0xbd, 0xc6, 0x42, 0x82, 0x82, 0xac, 0xd4, 0x43, 0xf1, 0x89, 0xc9, 0x9b, 0x3b, 0x48, 0x3a, 0xa1, 0x01, 0xfd, 0x8d, 0x6b, 0xed, 0x38, 0xae, 0xc5, 0x9e, 0x02
};
#define result__146 0

//Test vector 147:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_147  [65] = {
0x04, 0xf7, 0xce, 0xe5, 0xb5, 0x5f, 0x18, 0x69, 0xf1, 0x37, 0xdd, 0x70, 0x7c, 0x8f, 0x8f, 0xb8, 0x96, 0x5a, 0x2b, 0xe5, 0x84, 0x0c, 0x31, 0x49, 0xfb, 0x75, 0x96, 0x95, 0xa4, 0x66, 0x1b, 0x9c, 0x0d, 0x23, 0xc7, 0x8c, 0x4e, 0x96, 0x47, 0xb0, 0xd6, 0xcb, 0x2f, 0x26, 0x02, 0xbe, 0x73, 0xff, 0x25, 0xcf, 0x3d, 0x09, 0xc9, 0x6d, 0x89, 0x2b, 0x57, 0x45, 0xfe, 0x5e, 0xca, 0x81, 0x4a, 0xec, 0x91
};
static uint8_t pri_147  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_147  [32] = {
0xf4, 0x89, 0xf2, 0xbd, 0x93, 0xf7, 0x6b, 0x8e, 0x41, 0xfc, 0x6b, 0x9f, 0x21, 0x1b, 0xc5, 0x99, 0xd4, 0x9d, 0xb1, 0xf1, 0x7a, 0x38, 0xe9, 0x5b, 0xab, 0x1d, 0x31, 0xb2, 0xa2, 0xb5, 0x58, 0x29
};
#define result__147 0

//Test vector 148:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_148  [65] = {
0x04, 0x2b, 0xaa, 0xae, 0xc3, 0xb3, 0xe8, 0xd5, 0x4a, 0x4e, 0x18, 0xf0, 0x96, 0x0b, 0x94, 0x7d, 0xa2, 0x53, 0x5e, 0x3c, 0xfc, 0xca, 0x2c, 0xfa, 0x8b, 0x71, 0x13, 0xaa, 0xd8, 0xe3, 0xb6, 0x62, 0x6f, 0x72, 0xf7, 0x1e, 0x7c, 0x9e, 0x96, 0x04, 0x2c, 0x1d, 0x39, 0xcc, 0x8f, 0x11, 0x39, 0xd5, 0x14, 0x7c, 0x6f, 0x4f, 0xe6, 0x2e, 0x23, 0xcf, 0x6d, 0xf3, 0x64, 0xb5, 0xf4, 0xd8, 0x99, 0xf8, 0x42
};
static uint8_t pri_148  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_148  [32] = {
0xcc, 0x57, 0x38, 0xb4, 0x9d, 0x30, 0xd5, 0xd0, 0x2c, 0xf7, 0xe0, 0xc5, 0x4a, 0x3d, 0xe0, 0x9b, 0x5b, 0x6f, 0x3c, 0x4d, 0xea, 0x91, 0xdd, 0x06, 0x79, 0x07, 0x2a, 0x35, 0x62, 0x44, 0x4c, 0x37
};
#define result__148 0

//Test vector 149:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_149  [65] = {
0x04, 0xa5, 0x1a, 0xb1, 0x23, 0x8b, 0xc1, 0xbe, 0xd2, 0x52, 0x47, 0xe7, 0xd1, 0x79, 0xc8, 0x3a, 0x61, 0xae, 0x2d, 0x4a, 0x9f, 0xe2, 0x28, 0x8c, 0x36, 0x3a, 0xe0, 0xeb, 0x7a, 0x77, 0xde, 0x43, 0x2a, 0x3c, 0x6d, 0x35, 0xd8, 0x2b, 0xa8, 0x01, 0x7e, 0x6c, 0xa9, 0x04, 0x1c, 0xc7, 0x85, 0xa3, 0x07, 0x03, 0xf7, 0xbc, 0x44, 0x27, 0x50, 0x6e, 0x62, 0x4a, 0xc5, 0x97, 0x9d, 0x71, 0x54, 0x21, 0xdd
};
static uint8_t pri_149  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_149  [32] = {
0x89, 0xa1, 0x11, 0x77, 0xd6, 0x90, 0x7a, 0x81, 0xd4, 0x74, 0x67, 0x09, 0x3b, 0xf6, 0xa3, 0xcc, 0x8b, 0xa5, 0x5d, 0xee, 0x05, 0x23, 0x9b, 0x16, 0x0a, 0x31, 0xa3, 0x00, 0x0f, 0x5d, 0x80, 0x7b
};
#define result__149 0

//Test vector 150:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_150  [65] = {
0x04, 0x8b, 0x5a, 0xe8, 0xa0, 0xe5, 0x5f, 0x30, 0xf5, 0x09, 0x06, 0x13, 0x15, 0xab, 0xae, 0x79, 0xac, 0x48, 0x0f, 0x88, 0xb4, 0x46, 0x55, 0xf7, 0x26, 0x9a, 0x38, 0x5c, 0x81, 0x52, 0x68, 0x84, 0xbe, 0x26, 0x29, 0x74, 0xa3, 0x1a, 0x0e, 0x23, 0x22, 0x12, 0x6c, 0x2d, 0x77, 0xb2, 0x6b, 0x10, 0x8a, 0xbd, 0x81, 0xf8, 0xb9, 0x52, 0xc4, 0x58, 0xcc, 0xc9, 0x5d, 0x46, 0xfb, 0x49, 0x24, 0xc7, 0xc0
};
static uint8_t pri_150  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_150  [32] = {
0x2c, 0xb0, 0x3c, 0x30, 0xb2, 0x00, 0x37, 0xa5, 0xcf, 0x4d, 0x5b, 0x33, 0x57, 0x4f, 0x3a, 0xba, 0xc8, 0x95, 0xbf, 0xab, 0x37, 0x86, 0x7e, 0xb2, 0xeb, 0xed, 0x26, 0x0e, 0x09, 0x29, 0x05, 0x8d
};
#define result__150 0

//Test vector 151:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_151  [65] = {
0x04, 0x5f, 0x60, 0xc7, 0x7e, 0x47, 0x4d, 0xd6, 0x6c, 0x81, 0x35, 0xee, 0x3d, 0xaf, 0xc7, 0x5b, 0xa6, 0x44, 0x64, 0x98, 0x24, 0xc7, 0x27, 0x37, 0x54, 0x20, 0x91, 0xad, 0x46, 0x9a, 0xdb, 0xb6, 0x85, 0x31, 0x2c, 0x09, 0xc6, 0x9b, 0x62, 0x9d, 0x04, 0x36, 0xbf, 0x3b, 0xd6, 0xc6, 0x08, 0x3f, 0xf2, 0xa8, 0x7b, 0xe4, 0x84, 0xa7, 0x3e, 0xf3, 0xa5, 0xd2, 0xc3, 0xe0, 0x6b, 0x5d, 0x9b, 0x21, 0xb3
};
static uint8_t pri_151  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_151  [32] = {
0xe5, 0x4d, 0x48, 0x7d, 0x0c, 0x4b, 0x12, 0xfe, 0x52, 0x2a, 0xf3, 0xe6, 0x63, 0xce, 0x31, 0x6e, 0x63, 0x2b, 0xa9, 0xd6, 0x3a, 0x1f, 0x02, 0xa3, 0x6f, 0xc5, 0xa8, 0x2b, 0xf8, 0x27, 0x31, 0xa4
};
#define result__151 0

//Test vector 152:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_152  [65] = {
0x04, 0xe0, 0x6e, 0xaa, 0x73, 0xf6, 0xfe, 0xae, 0x45, 0x41, 0x7d, 0x85, 0x9b, 0xba, 0xd4, 0xbc, 0x40, 0x4b, 0x28, 0x85, 0xbc, 0xd2, 0x13, 0xeb, 0xac, 0xe5, 0x94, 0xe1, 0x6f, 0x49, 0x70, 0xe0, 0xc4, 0x11, 0xed, 0x33, 0x23, 0xa3, 0xd7, 0xaf, 0xc7, 0x07, 0x62, 0x39, 0x88, 0x43, 0x07, 0xf9, 0x18, 0x49, 0xed, 0x5f, 0x5e, 0x36, 0xb6, 0x17, 0x1d, 0x30, 0x9c, 0x81, 0x34, 0x4c, 0x53, 0xe0, 0x6d
};
static uint8_t pri_152  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_152  [32] = {
0xcc, 0xea, 0x96, 0x9d, 0x40, 0xfa, 0x42, 0x93, 0x3f, 0x4f, 0xbd, 0xc4, 0xca, 0xbe, 0x21, 0x85, 0xf8, 0xa4, 0x52, 0x99, 0x62, 0x54, 0xc1, 0xf4, 0xe0, 0xdd, 0xe5, 0xe1, 0x4f, 0xee, 0xea, 0x8d
};
#define result__152 0

//Test vector 153:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_153  [65] = {
0x04, 0x0f, 0x1c, 0x1b, 0x89, 0xe9, 0xfc, 0x6f, 0xc0, 0xfa, 0xef, 0xc9, 0x10, 0x9f, 0xc4, 0xa1, 0x24, 0x7d, 0x9f, 0x54, 0xc7, 0x49, 0x7b, 0x6c, 0xc9, 0x75, 0xe6, 0xa5, 0x45, 0x5b, 0xef, 0x41, 0x08, 0x36, 0xcb, 0x38, 0x18, 0x54, 0x8a, 0xc9, 0xb4, 0x1e, 0x2b, 0x83, 0x36, 0xc3, 0xeb, 0x8d, 0x97, 0x07, 0x5a, 0xe4, 0x7e, 0x18, 0x27, 0xfa, 0x1f, 0xf9, 0x3d, 0x43, 0x41, 0xd4, 0x3c, 0x0c, 0x1d
};
static uint8_t pri_153  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_153  [32] = {
0xea, 0xae, 0x0e, 0x18, 0x8c, 0x94, 0x27, 0xbf, 0x3c, 0x8b, 0x3d, 0xed, 0x77, 0x21, 0x22, 0x20, 0x4c, 0x32, 0x8d, 0x59, 0x41, 0xe3, 0x89, 0xd8, 0x08, 0xe2, 0x72, 0x46, 0x38, 0xf9, 0xaf, 0xf8
};
#define result__153 0

//Test vector 154:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_154  [65] = {
0x04, 0x57, 0x70, 0x69, 0xe8, 0x28, 0x4a, 0x95, 0xf5, 0x1d, 0xca, 0xb9, 0x19, 0xb0, 0x53, 0x66, 0x57, 0x05, 0x89, 0x71, 0xda, 0xb7, 0x62, 0x17, 0xf8, 0xd3, 0xae, 0x72, 0x2a, 0x64, 0x09, 0x2e, 0x26, 0xe5, 0x1f, 0x68, 0xa7, 0x22, 0xcc, 0x03, 0x97, 0xf4, 0x80, 0x14, 0x01, 0x77, 0x1e, 0x9a, 0x3d, 0x19, 0x88, 0xd4, 0xaf, 0x76, 0xf1, 0x4f, 0x9e, 0x2f, 0x9c, 0x36, 0xe0, 0x77, 0x3e, 0x29, 0xc2
};
static uint8_t pri_154  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_154  [32] = {
0xfe, 0xa0, 0xcc, 0xe1, 0x35, 0x8f, 0x1f, 0xf4, 0x0f, 0xfe, 0xaa, 0xff, 0xbf, 0x91, 0xb2, 0xe8, 0xd4, 0x26, 0xd4, 0xe3, 0x1e, 0x96, 0x27, 0x73, 0x1a, 0xce, 0x3a, 0x12, 0x2e, 0xab, 0x6b, 0x0d
};
#define result__154 0

//Test vector 155:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_155  [65] = {
0x04, 0x24, 0x06, 0xa2, 0x75, 0x90, 0x50, 0xb9, 0x25, 0xdd, 0x4f, 0x81, 0x4c, 0x50, 0x33, 0xe3, 0x55, 0x54, 0x8f, 0x42, 0xbb, 0xf1, 0xaf, 0xb7, 0x91, 0xc1, 0x10, 0xf0, 0x03, 0x1f, 0x29, 0xf6, 0x80, 0x99, 0xd5, 0xf4, 0xb0, 0x05, 0xde, 0x39, 0x27, 0xf1, 0x65, 0xab, 0xef, 0xf1, 0x96, 0xa2, 0x8c, 0x72, 0x17, 0xfa, 0xb1, 0xbe, 0x2b, 0x52, 0x09, 0xc3, 0x24, 0xe7, 0xd6, 0x2d, 0x2d, 0xd6, 0x87
};
static uint8_t pri_155  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_155  [32] = {
0x83, 0x76, 0x21, 0xea, 0x48, 0x27, 0xbb, 0xa0, 0x37, 0x6a, 0xaa, 0x8a, 0xa6, 0x6c, 0xfe, 0x14, 0x4a, 0x2f, 0xf1, 0xe3, 0x59, 0xdc, 0x61, 0x9a, 0x06, 0x44, 0x1d, 0x3e, 0x05, 0x5f, 0x97, 0x71
};
#define result__155 0

//Test vector 156:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_156  [65] = {
0x04, 0xcc, 0xaa, 0xc6, 0x1f, 0x35, 0xa2, 0x78, 0x61, 0x18, 0x36, 0x21, 0x64, 0x2b, 0xc5, 0x73, 0xaf, 0x91, 0x33, 0x56, 0xfb, 0x47, 0xcf, 0x58, 0x2f, 0x0b, 0x52, 0x99, 0x09, 0x9d, 0x6f, 0x6c, 0x69, 0x91, 0xf7, 0x27, 0x2b, 0x83, 0xb7, 0x38, 0xa7, 0xa5, 0xd3, 0x04, 0x47, 0xc8, 0x7f, 0x12, 0x6a, 0x7d, 0x98, 0xec, 0x72, 0xfa, 0x26, 0x09, 0xd0, 0x93, 0x9d, 0x18, 0xdb, 0x7e, 0xa7, 0xeb, 0x3a
};
static uint8_t pri_156  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_156  [32] = {
0x63, 0x97, 0x4c, 0xe6, 0x15, 0x37, 0x62, 0xe5, 0xb3, 0x64, 0x52, 0x3c, 0xea, 0xd9, 0x3e, 0x8c, 0xe8, 0xbc, 0xc7, 0x7d, 0xda, 0x56, 0x36, 0x5d, 0x67, 0x61, 0x36, 0x16, 0x9f, 0xc4, 0xe3, 0x9b
};
#define result__156 0

//Test vector 157:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_157  [65] = {
0x04, 0x01, 0x41, 0x59, 0x17, 0x27, 0x2f, 0x19, 0x84, 0xe7, 0x21, 0x7a, 0x36, 0xfb, 0x31, 0x1f, 0xd2, 0x90, 0x4d, 0x41, 0xa6, 0xb1, 0x39, 0x73, 0xf9, 0x2a, 0xae, 0x3b, 0x90, 0xe8, 0x5e, 0x4d, 0x56, 0xd9, 0x7c, 0x82, 0x2e, 0xb7, 0xb2, 0x1a, 0x84, 0xd0, 0xd1, 0xbe, 0x48, 0x67, 0x40, 0x4a, 0x80, 0xc3, 0x48, 0x67, 0xf4, 0x31, 0x39, 0xda, 0xdc, 0xc3, 0x61, 0x9e, 0x10, 0xb2, 0x22, 0x56, 0x2b
};
static uint8_t pri_157  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_157  [32] = {
0x0a, 0x04, 0x88, 0x14, 0x4b, 0xc3, 0x6d, 0x69, 0x0b, 0x62, 0x14, 0x8a, 0xc3, 0x07, 0x60, 0x47, 0xd4, 0x6d, 0x48, 0xf7, 0xad, 0xbb, 0x0f, 0x34, 0xfe, 0xe9, 0xa6, 0x36, 0x29, 0x5f, 0xe7, 0x37
};
#define result__157 0

//Test vector 158:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_158  [65] = {
0x04, 0xb2, 0x57, 0x5d, 0x10, 0x0c, 0x6f, 0xa0, 0x56, 0xbc, 0xd1, 0x37, 0xab, 0x11, 0x1b, 0x53, 0x15, 0xa8, 0x90, 0x8c, 0x29, 0x24, 0x3b, 0x84, 0xf3, 0xdc, 0x99, 0x6d, 0x0e, 0x45, 0x76, 0x4b, 0x91, 0x66, 0xca, 0xbe, 0xb4, 0x18, 0x85, 0x58, 0x8e, 0xc0, 0x8b, 0x47, 0x25, 0x7d, 0xf5, 0x8b, 0xd5, 0x8f, 0x7d, 0xcd, 0x9e, 0x01, 0x2e, 0x26, 0x69, 0xfa, 0x2f, 0x52, 0xe2, 0x57, 0x67, 0xfc, 0x4c
};
static uint8_t pri_158  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_158  [32] = {
0x12, 0x32, 0x16, 0x55, 0x38, 0xa4, 0x42, 0x68, 0xaa, 0x7c, 0x19, 0x9c, 0x54, 0xd6, 0xd2, 0x07, 0xc4, 0xef, 0x3f, 0x5a, 0xa7, 0x90, 0xc1, 0x0c, 0x92, 0x6a, 0x20, 0x75, 0x2c, 0xa6, 0x45, 0xce
};
#define result__158 0

//Test vector 159:           "comment" : "point with coordinate y = 1 in precomputation or right to left addition chain",

static uint8_t pub_159  [65] = {
0x04, 0xc1, 0x73, 0x55, 0xed, 0x30, 0xcc, 0xd6, 0x42, 0x7f, 0x96, 0x85, 0x70, 0x90, 0x21, 0xb2, 0x5c, 0x11, 0xed, 0x17, 0x6e, 0x96, 0x10, 0xc4, 0x79, 0xbc, 0xc4, 0xcc, 0x75, 0x52, 0xa7, 0x38, 0xe6, 0x1f, 0x75, 0x11, 0x47, 0x61, 0xdb, 0xa0, 0xec, 0x60, 0xcd, 0x26, 0x4b, 0xba, 0xb7, 0x63, 0xc5, 0xd5, 0xab, 0xcc, 0x75, 0xcd, 0x8f, 0xb5, 0x65, 0x1d, 0x06, 0x45, 0x17, 0x99, 0x88, 0xcc, 0x6d
};
static uint8_t pri_159  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_159  [32] = {
0xdc, 0xab, 0x5e, 0x87, 0x4e, 0x4f, 0xb7, 0x6b, 0xc4, 0x31, 0x25, 0x28, 0xe9, 0xd7, 0x6d, 0xfa, 0xe5, 0x61, 0x45, 0x92, 0x25, 0x33, 0x08, 0x97, 0x34, 0x11, 0x0b, 0xf5, 0x65, 0x3f, 0x4d, 0x77
};
#define result__159 0

//Test vector 160:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_160  [65] = {
0x04, 0x34, 0x15, 0x92, 0x39, 0x0c, 0xcc, 0xe4, 0x85, 0xde, 0x88, 0x80, 0xf3, 0xd7, 0x27, 0xf6, 0x64, 0xc3, 0x81, 0x91, 0x4a, 0x1b, 0xec, 0xec, 0x38, 0x3b, 0x35, 0x58, 0x67, 0x51, 0xfc, 0x81, 0xc2, 0xad, 0xd7, 0x18, 0x52, 0xb8, 0x70, 0x16, 0xe1, 0x01, 0x9c, 0xae, 0x7a, 0x90, 0x80, 0xe7, 0x5c, 0xe0, 0xb0, 0xb8, 0xaa, 0xc1, 0x75, 0xd6, 0x92, 0xd5, 0xe7, 0xb4, 0xda, 0xd0, 0x88, 0xf5, 0xcc
};
static uint8_t pri_160  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_160  [32] = {
0x4c, 0xe2, 0x70, 0x1b, 0x2b, 0xe6, 0x3a, 0x00, 0x83, 0xa4, 0xc5, 0x3f, 0x7a, 0x0b, 0xf0, 0x4c, 0xf8, 0x71, 0x65, 0x4f, 0x5e, 0xdb, 0x6f, 0x62, 0x5e, 0x3e, 0xa5, 0xe7, 0xd0, 0xbd, 0xcc, 0x90
};
#define result__160 0

//Test vector 161:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_161  [65] = {
0x04, 0xfa, 0x76, 0x4b, 0x6b, 0x76, 0xa8, 0x6c, 0x3b, 0x76, 0x21, 0x20, 0x82, 0x5d, 0x35, 0x3a, 0x24, 0x76, 0x62, 0x08, 0xc1, 0xf5, 0xcc, 0x0f, 0xe3, 0xfe, 0x79, 0x98, 0x02, 0x6a, 0x2e, 0xc5, 0xc4, 0x3b, 0xb2, 0xf9, 0x48, 0xfd, 0x94, 0xcd, 0xaa, 0x58, 0x69, 0xb1, 0xe0, 0xe7, 0x3a, 0x4d, 0x97, 0x03, 0x5c, 0xc4, 0x93, 0x57, 0xfb, 0x7b, 0x74, 0xd7, 0xed, 0x0a, 0x2c, 0x5b, 0x8d, 0x54, 0xeb
};
static uint8_t pri_161  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_161  [32] = {
0x7a, 0xbe, 0xf9, 0x76, 0x5c, 0xca, 0x72, 0x13, 0x20, 0xfb, 0xf8, 0xed, 0xcb, 0xef, 0x6d, 0x2b, 0xa2, 0x5d, 0x17, 0xb7, 0x0f, 0xfa, 0x17, 0x76, 0x02, 0x9b, 0xc3, 0x8f, 0xe6, 0x77, 0xa1, 0x2c
};
#define result__161 0

//Test vector 162:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_162  [65] = {
0x04, 0xa7, 0x1f, 0xbb, 0x61, 0x71, 0x99, 0xbd, 0x58, 0x5b, 0x4b, 0x66, 0x21, 0x2c, 0xa3, 0x3c, 0xa9, 0xe0, 0x93, 0x70, 0xe6, 0xbf, 0x15, 0xc8, 0xea, 0x0a, 0xce, 0xfd, 0x9c, 0x8e, 0x94, 0x5d, 0x06, 0x84, 0x0f, 0x05, 0x88, 0x63, 0x07, 0x8e, 0x74, 0x3e, 0x22, 0x0f, 0xf9, 0x9f, 0x23, 0xbb, 0xc1, 0xda, 0xa3, 0x68, 0x35, 0xd4, 0xb1, 0x26, 0x9f, 0x0a, 0x75, 0x36, 0xe6, 0x3f, 0x06, 0xd8, 0x53
};
static uint8_t pri_162  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_162  [32] = {
0x5f, 0x61, 0x40, 0x4d, 0xbb, 0xbc, 0x28, 0x67, 0xdf, 0xf9, 0x5c, 0x1f, 0x37, 0xed, 0x44, 0xf4, 0xcb, 0x8f, 0xab, 0xcd, 0x22, 0x3b, 0x03, 0x73, 0x9d, 0x88, 0x83, 0x08, 0xd1, 0x3b, 0xc4, 0x12
};
#define result__162 0

//Test vector 163:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_163  [65] = {
0x04, 0x13, 0xc8, 0x29, 0x2d, 0x85, 0x4d, 0x39, 0x45, 0x1c, 0x0c, 0x63, 0xa8, 0x02, 0xb8, 0xc0, 0x3e, 0x4f, 0xcb, 0x87, 0x5e, 0xf0, 0x12, 0x39, 0x89, 0x62, 0x95, 0xba, 0x1c, 0x0f, 0x38, 0x69, 0x75, 0xf8, 0x2d, 0xf1, 0x97, 0x08, 0x6f, 0xd8, 0x60, 0x32, 0xcb, 0x36, 0xb6, 0x9a, 0x27, 0x87, 0x6d, 0xd7, 0x5a, 0x8e, 0x96, 0x79, 0xf3, 0x6f, 0xfc, 0x22, 0x10, 0xed, 0xb1, 0x28, 0xd4, 0xbe, 0x13
};
static uint8_t pri_163  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_163  [32] = {
0x8d, 0x67, 0x3a, 0x57, 0x7e, 0x35, 0xbf, 0x9d, 0x5d, 0x00, 0x67, 0x6c, 0x08, 0xb2, 0xc7, 0x39, 0x61, 0x7c, 0x46, 0xa0, 0x52, 0x18, 0x84, 0x03, 0xaa, 0x06, 0xdc, 0x71, 0x4a, 0xf6, 0xac, 0xc1
};
#define result__163 0

//Test vector 164:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_164  [65] = {
0x04, 0x0c, 0xd9, 0xdf, 0x41, 0x5a, 0xcc, 0x0c, 0x32, 0xfd, 0x4e, 0x3d, 0x69, 0x24, 0xce, 0x53, 0x07, 0x5b, 0x04, 0x52, 0xbf, 0x91, 0x9a, 0x2a, 0xb2, 0xeb, 0xe2, 0x65, 0x97, 0x57, 0x0f, 0x1e, 0xcd, 0x59, 0x85, 0xd8, 0xd2, 0xc5, 0xdf, 0x78, 0xfc, 0x10, 0x0f, 0x87, 0xef, 0xb6, 0xdf, 0xa9, 0x54, 0x37, 0x57, 0xbd, 0xff, 0xec, 0xf0, 0x83, 0xdf, 0xcd, 0x1e, 0xcb, 0x38, 0xde, 0x6c, 0x23, 0xf8
};
static uint8_t pri_164  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_164  [32] = {
0xa7, 0x83, 0x5f, 0xfe, 0xe0, 0xf2, 0xa6, 0x9d, 0xfc, 0xf7, 0x0d, 0x4e, 0x79, 0x8d, 0xbe, 0x3e, 0xd3, 0x2b, 0xa0, 0x3c, 0xfd, 0xda, 0xe5, 0xdd, 0xd1, 0x1d, 0x8c, 0x0a, 0xc3, 0xd7, 0x4f, 0x9b
};
#define result__164 0

//Test vector 165:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_165  [65] = {
0x04, 0xd2, 0xdb, 0xea, 0x40, 0x46, 0xb2, 0x3f, 0xd2, 0xb2, 0x33, 0xd1, 0xce, 0x31, 0xdc, 0xed, 0xdb, 0x89, 0xb2, 0x5f, 0x26, 0xc0, 0x62, 0x7a, 0x9d, 0x2d, 0xb3, 0xc5, 0x60, 0x5c, 0x9c, 0xc9, 0x95, 0x35, 0xbd, 0xc8, 0xde, 0x74, 0x51, 0xc1, 0xe2, 0x7e, 0x97, 0xaa, 0x91, 0x40, 0x2c, 0xce, 0x38, 0x82, 0xc7, 0x12, 0x69, 0xd9, 0xcb, 0xdc, 0xb5, 0xd7, 0xac, 0x0c, 0xeb, 0x91, 0x1b, 0x9b, 0x6d
};
static uint8_t pri_165  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_165  [32] = {
0xe9, 0x8e, 0xa2, 0x22, 0x09, 0xcd, 0x39, 0x7e, 0xdb, 0x6c, 0x31, 0x96, 0x48, 0xc1, 0xeb, 0x24, 0xbc, 0x4d, 0x39, 0x59, 0x8a, 0xb1, 0x19, 0x95, 0x57, 0x19, 0x26, 0x68, 0x4c, 0xe2, 0xce, 0xca
};
#define result__165 0

//Test vector 166:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_166  [65] = {
0x04, 0x88, 0x8f, 0xb0, 0x44, 0xfb, 0x2b, 0x6c, 0xaa, 0x60, 0x36, 0x6b, 0xfa, 0x66, 0x2a, 0xdb, 0xa4, 0x79, 0xb8, 0x36, 0x5a, 0x65, 0x55, 0xa2, 0x98, 0x87, 0xd5, 0x80, 0xf5, 0x87, 0x08, 0x6b, 0xa8, 0x48, 0x2f, 0x4e, 0xc2, 0x40, 0x82, 0xa4, 0x8d, 0x64, 0x02, 0xaf, 0xa1, 0x62, 0x21, 0x43, 0xf2, 0x6e, 0x61, 0xd9, 0x1b, 0x7e, 0x30, 0xd6, 0xa4, 0xb2, 0x23, 0x63, 0x0e, 0xe1, 0x0f, 0x70, 0xfb
};
static uint8_t pri_166  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_166  [32] = {
0x91, 0xb6, 0x57, 0x33, 0x86, 0x0b, 0x1b, 0xdb, 0x95, 0x41, 0xd9, 0xf5, 0x58, 0x95, 0xa3, 0xdb, 0xb3, 0xf1, 0x3c, 0x19, 0x92, 0x51, 0xd3, 0x30, 0x06, 0xb6, 0xdc, 0xf9, 0x0a, 0xc3, 0x49, 0xed
};
#define result__166 0

//Test vector 167:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_167  [65] = {
0x04, 0x2e, 0x2b, 0xec, 0x13, 0x42, 0x49, 0x37, 0x9d, 0x57, 0x70, 0x03, 0x01, 0xf3, 0xa5, 0x8e, 0x4b, 0x39, 0x5a, 0x4d, 0x28, 0x37, 0x0d, 0x2a, 0x06, 0xe6, 0x5e, 0x7a, 0xc8, 0x9e, 0xd7, 0x6a, 0xc6, 0x97, 0xdc, 0x96, 0x0b, 0xd7, 0x95, 0xcd, 0xf4, 0xfb, 0xcf, 0xdd, 0x75, 0x14, 0x90, 0x57, 0xb8, 0xe0, 0x22, 0x33, 0x1c, 0x7b, 0x54, 0x61, 0xf3, 0x83, 0xac, 0x58, 0x9d, 0x76, 0x4d, 0xf3, 0x33
};
static uint8_t pri_167  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_167  [32] = {
0x1f, 0xdf, 0x7c, 0x5c, 0x48, 0x04, 0x7a, 0x11, 0x3e, 0x5e, 0x5d, 0x1b, 0x7e, 0xd5, 0x93, 0x33, 0x7e, 0x76, 0x92, 0x31, 0xcc, 0xa5, 0xc7, 0x11, 0x01, 0x60, 0xe0, 0xc1, 0xb9, 0x7f, 0x42, 0x56
};
#define result__167 0

//Test vector 168:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_168  [65] = {
0x04, 0xc7, 0x8c, 0xda, 0x7e, 0x3b, 0x9e, 0x17, 0x72, 0xeb, 0xed, 0x30, 0xb2, 0xb5, 0x1d, 0xcf, 0x15, 0x5a, 0x69, 0xa0, 0xfc, 0x50, 0x45, 0x57, 0x83, 0x6e, 0x25, 0x14, 0x7c, 0xfb, 0x81, 0x27, 0xd2, 0xf8, 0x28, 0x9c, 0xf3, 0x8b, 0x03, 0x3d, 0x37, 0x63, 0xc8, 0xf9, 0xf6, 0xc0, 0x91, 0x78, 0x7a, 0x31, 0x42, 0xfb, 0x83, 0xdf, 0xf5, 0x71, 0x95, 0x90, 0x28, 0x2c, 0x6f, 0x85, 0x2e, 0x01, 0x05
};
static uint8_t pri_168  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_168  [32] = {
0xba, 0x0a, 0xbc, 0x3e, 0x71, 0x72, 0x6c, 0xb5, 0x13, 0x30, 0x48, 0x91, 0x76, 0x35, 0x7b, 0x81, 0xb8, 0x07, 0x4d, 0x76, 0x90, 0xe4, 0xe8, 0x2e, 0x9a, 0x3c, 0x00, 0x15, 0x1e, 0x1f, 0xa3, 0x18
};
#define result__168 0

//Test vector 169:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_169  [65] = {
0x04, 0x1e, 0x3d, 0xf4, 0xdd, 0x7f, 0xb7, 0x71, 0x8c, 0xb0, 0xaa, 0x0d, 0xd7, 0x2f, 0x8a, 0x25, 0xc8, 0x3c, 0x4e, 0x80, 0x4e, 0x7c, 0xbd, 0x48, 0xc5, 0xe9, 0x65, 0x65, 0x1f, 0x9e, 0x23, 0xbf, 0x4e, 0xf0, 0xff, 0x40, 0xdd, 0x97, 0x96, 0xe4, 0xa9, 0xa5, 0xed, 0xdd, 0x2c, 0x4c, 0xa4, 0xeb, 0xd1, 0x09, 0x90, 0xd8, 0xfb, 0x89, 0x18, 0xd1, 0x2d, 0x53, 0xc7, 0x60, 0x01, 0xaf, 0xa9, 0xde, 0x7f
};
static uint8_t pri_169  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_169  [32] = {
0x16, 0xe6, 0x32, 0xf9, 0x75, 0x2d, 0x36, 0x60, 0x2c, 0x95, 0xec, 0x27, 0x4b, 0x32, 0xad, 0x59, 0x4f, 0x39, 0xf6, 0xac, 0x3b, 0xd4, 0xb0, 0xb2, 0x0f, 0x86, 0x37, 0x39, 0x21, 0x42, 0xce, 0xf4
};
#define result__169 0

//Test vector 170:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_170  [65] = {
0x04, 0xe5, 0xc5, 0xdc, 0x3f, 0xd8, 0x8d, 0x85, 0x66, 0x8b, 0x3b, 0x70, 0x9f, 0xd6, 0xb4, 0x23, 0x2f, 0x1f, 0x80, 0x94, 0x9c, 0xbc, 0xcb, 0x55, 0x88, 0x36, 0x3e, 0x6c, 0x21, 0x7a, 0x2b, 0x3e, 0xd8, 0x8d, 0xbd, 0x0d, 0x6e, 0x3c, 0xc9, 0x7f, 0x30, 0x81, 0xd1, 0x66, 0x02, 0xaa, 0x3d, 0x1b, 0x65, 0x5e, 0xe0, 0x79, 0x1c, 0x87, 0xfc, 0xb5, 0xab, 0xe6, 0x21, 0x7d, 0x8c, 0x85, 0x13, 0x80, 0x7e
};
static uint8_t pri_170  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_170  [32] = {
0x9e, 0xed, 0x4b, 0x96, 0x56, 0x9f, 0x60, 0x4a, 0x4d, 0x3f, 0x5a, 0xf9, 0x74, 0x99, 0x80, 0x71, 0x11, 0xfc, 0x98, 0x88, 0xc4, 0x58, 0xec, 0xe2, 0xe3, 0x00, 0x0e, 0x24, 0x5c, 0x2c, 0x02, 0xb0
};
#define result__170 0

//Test vector 171:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_171  [65] = {
0x04, 0x02, 0x1c, 0x41, 0xec, 0xee, 0xc2, 0x4e, 0x0f, 0xba, 0x89, 0x4a, 0xd7, 0x41, 0x5a, 0x95, 0x98, 0xcb, 0xcd, 0x14, 0xfa, 0x6c, 0xa4, 0x6e, 0x25, 0x57, 0x52, 0x68, 0xa1, 0xd8, 0xe5, 0xbb, 0xc6, 0x3f, 0x84, 0x6c, 0x6a, 0x18, 0x5f, 0xa3, 0xf2, 0x3b, 0xb9, 0x2c, 0x14, 0xe7, 0xe2, 0xcb, 0xa8, 0xc7, 0x40, 0x47, 0xc0, 0x9a, 0xf7, 0x66, 0xf5, 0x5e, 0xf0, 0xc9, 0x07, 0xc8, 0x0d, 0x94, 0x51
};
static uint8_t pri_171  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_171  [32] = {
0x21, 0xac, 0x32, 0x01, 0x38, 0x38, 0x81, 0x26, 0x21, 0xdb, 0xb5, 0x84, 0x96, 0x5b, 0xde, 0xd6, 0xfc, 0x85, 0x1d, 0x3a, 0x02, 0x98, 0x10, 0x67, 0x9b, 0xc5, 0x7b, 0x23, 0x81, 0xbb, 0x7a, 0x7d
};
#define result__171 0

//Test vector 172:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_172  [65] = {
0x04, 0x8e, 0x24, 0x19, 0x2c, 0xd3, 0x33, 0x35, 0xa1, 0x14, 0xf5, 0x07, 0x02, 0x66, 0xc0, 0x14, 0xcb, 0x0d, 0x8c, 0x70, 0x4d, 0x16, 0xd6, 0x04, 0x2e, 0x89, 0xc1, 0x75, 0x97, 0xbc, 0xd4, 0xe7, 0x7e, 0xbd, 0xb4, 0xc5, 0x17, 0x17, 0x04, 0xc2, 0xc0, 0x92, 0x75, 0xc2, 0x2a, 0x31, 0x0e, 0x0c, 0x4f, 0xe0, 0x92, 0xe4, 0x08, 0x48, 0x56, 0xda, 0x99, 0xb9, 0x4a, 0xbb, 0xfa, 0x9f, 0x46, 0x9f, 0x48
};
static uint8_t pri_172  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_172  [32] = {
0xfc, 0x59, 0x78, 0xda, 0x01, 0xca, 0x83, 0xe1, 0x27, 0xdd, 0xdf, 0x98, 0x9a, 0x03, 0x58, 0x87, 0x1b, 0x3c, 0x4c, 0xe0, 0x75, 0x5b, 0xfb, 0x02, 0x06, 0x33, 0xdb, 0x46, 0x7e, 0x21, 0xa5, 0x3c
};
#define result__172 0

//Test vector 173:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_173  [65] = {
0x04, 0x31, 0xc9, 0x0a, 0xe4, 0x7a, 0x93, 0xd0, 0x9a, 0x23, 0x52, 0xb6, 0xf3, 0x67, 0x7e, 0x79, 0x75, 0xea, 0x62, 0xaa, 0xde, 0xdb, 0x56, 0xc1, 0x18, 0xeb, 0x8b, 0x9f, 0x77, 0x1e, 0x2d, 0xd9, 0xf5, 0xf2, 0x60, 0x1f, 0xb9, 0xcc, 0xa2, 0x30, 0x4e, 0x59, 0x44, 0x23, 0xcf, 0x48, 0x06, 0x4d, 0xbe, 0xd1, 0x7a, 0xe4, 0x04, 0x52, 0xf1, 0x8b, 0xe6, 0xae, 0x01, 0x83, 0x21, 0x91, 0x1e, 0x8c, 0xb3
};
static uint8_t pri_173  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_173  [32] = {
0x9f, 0x41, 0x73, 0x41, 0x26, 0x1a, 0xa4, 0x5d, 0x39, 0x6b, 0x0c, 0xcf, 0x2a, 0x3d, 0xee, 0x7a, 0x46, 0x6c, 0xa4, 0x7e, 0x3c, 0xe8, 0x6e, 0xcd, 0x20, 0x71, 0xd9, 0xc4, 0xdb, 0x08, 0x82, 0x0e
};
#define result__173 0

//Test vector 174:           "comment" : "point with coordinate y = 1 in right to left addition chain",

static uint8_t pub_174  [65] = {
0x04, 0xd2, 0xf2, 0x11, 0xcf, 0xab, 0x84, 0xe0, 0x1c, 0x8e, 0x55, 0x44, 0x03, 0x62, 0x34, 0xde, 0xbe, 0x35, 0xae, 0x10, 0x3b, 0xb8, 0x78, 0xd7, 0xab, 0xce, 0xa6, 0x82, 0x5f, 0x75, 0x3e, 0x03, 0xa3, 0x85, 0xf7, 0xf1, 0x87, 0x0e, 0x64, 0xf1, 0x26, 0x2a, 0xf6, 0x7a, 0x25, 0xef, 0x98, 0x80, 0x41, 0x9f, 0x45, 0x60, 0x8e, 0x7f, 0x9d, 0xa6, 0xde, 0xe8, 0x3f, 0x5f, 0x46, 0xce, 0xb5, 0x3d, 0xcb
};
static uint8_t pri_174  [32] = {
0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e, 0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee, 0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff
};
static uint8_t x_174  [32] = {
0xf4, 0x19, 0xfe, 0xbb, 0x32, 0xc2, 0x54, 0x61, 0x1a, 0xdf, 0x56, 0x9c, 0x2d, 0x58, 0x3b, 0x17, 0x54, 0x2b, 0x15, 0x38, 0xca, 0xa0, 0x00, 0x19, 0x67, 0xf0, 0xa4, 0xbc, 0x34, 0xb8, 0xb7, 0x89
};
#define result__174 0

//Test vector 175:           "comment" : "edge case private key",



//Test 175
// prime = 2** 256 - 2**224 + 2**192 + 2**96 -1
// p = Zmod(prime)

// a = -3
// b = 41058363725152142129326129780047268409114441015993725554835256314039467401291

// bx = 0x31028f3377fc8f2b1967edaab90213acad0da9f50897f08f57537f78f1167447
// by = 0x43a1930189363bbde2ac4cbd1649cdc6f451add71dd2f16a8a867f2b17caa16b

// c = EllipticCurve(p, [a, b])
// p = c(bx, by) * (3 * 2**(31 * 8))
// print(hex(p.xy()[0]))



// Anna: Important. The test vector is NOT in the form that was provided by test vector initially:
// Private key was changed from 0x3 to the correct buffer. 
// We consider that it´s the internal task to provide the correct size buffers. 


static uint8_t pub_175  [65] = {
	0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_175  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3
};
static uint8_t x_175  [32] = {
0x85, 0xa0, 0xb5, 0x85, 0x19, 0xb2, 0x8e, 0x70, 0xa6, 0x94, 0xec, 0x51, 0x98, 0xf7, 0x2c, 0x4b, 0xfd, 0xab, 0xaa, 0x30, 0xa7, 0x0f, 0x71, 0x43, 0xb5, 0xb1, 0xcd, 0x75, 0x36, 0xf7, 0x16, 0xca
};
#define result__175 0

//Test vector 176:           "comment" : "edge case private key",

// Anna: Important. The test vector is NOT in the form that was provided by test vector initially:
// Private key was changed from 0x3 to the correct buffer. 
// We consider that it´s the internal task to provide the correct size buffers. 


static uint8_t pub_176  [65] = {
	0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_176  [32] = {
	0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff
};
static uint8_t x_176  [32] = {
0xa3, 0x29, 0xa7, 0xd8, 0x04, 0x24, 0xea, 0x2d, 0x6c, 0x90, 0x43, 0x93, 0x80, 0x8e, 0x51, 0x0d, 0xfb, 0xb2, 0x81, 0x55, 0x09, 0x2f, 0x1b, 0xac, 0x28, 0x4d, 0xce, 0xda, 0x1f, 0x13, 0xaf, 0xe5
};
#define result__176 0

//Test vector 177:           "comment" : "edge case private key",

static uint8_t pub_177  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_177  [32] = {
0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t x_177  [32] = {
0xbd, 0x26, 0xd0, 0x29, 0x3e, 0x88, 0x51, 0xc5, 0x1e, 0xbe, 0x0d, 0x42, 0x63, 0x45, 0x68, 0x3a, 0xe9, 0x40, 0x26, 0xac, 0xa5, 0x45, 0x28, 0x2a, 0x47, 0x59, 0xfa, 0xa8, 0x5f, 0xde, 0x66, 0x87
};
#define result__177 0

//Test vector 178:           "comment" : "edge case private key",

static uint8_t pub_178  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_178  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
static uint8_t x_178  [32] = {
0xea, 0x93, 0x50, 0xb2, 0x49, 0x0a, 0x20, 0x10, 0xc7, 0xab, 0xf4, 0x3f, 0xb1, 0xa3, 0x8b, 0xe7, 0x29, 0xa2, 0xde, 0x37, 0x5e, 0xa7, 0xa6, 0xac, 0x34, 0xff, 0x58, 0xcc, 0x87, 0xe5, 0x1b, 0x6c
};
#define result__178 0

//Test vector 179:           "comment" : "edge case private key",

static uint8_t pub_179  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_179  [32] = {
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t x_179  [32] = {
0x34, 0xee, 0xd3, 0xf6, 0x67, 0x3d, 0x34, 0x0b, 0x6f, 0x71, 0x69, 0x13, 0xf6, 0xdf, 0xa3, 0x6b, 0x5a, 0xc8, 0x5f, 0xa6, 0x67, 0x79, 0x1e, 0x2d, 0x6a, 0x21, 0x7b, 0x0c, 0x0b, 0x7b, 0xa8, 0x07
};
#define result__179 0

//Test vector 180:           "comment" : "edge case private key",

static uint8_t pub_180  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_180  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x83, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
};
static uint8_t x_180  [32] = {
0x13, 0x54, 0xce, 0x66, 0x92, 0xc9, 0xdf, 0x7b, 0x6f, 0xc3, 0x11, 0x9d, 0x47, 0xc5, 0x63, 0x38, 0xaf, 0xbe, 0xdc, 0xcb, 0x62, 0xfa, 0xa5, 0x46, 0xc0, 0xfe, 0x6e, 0xd4, 0x95, 0x9e, 0x41, 0xc3
};
#define result__180 0

//Test vector 181:           "comment" : "edge case private key",

static uint8_t pub_181  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_181  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xa9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
};
static uint8_t x_181  [32] = {
0xfe, 0x74, 0x96, 0xc3, 0x0d, 0x53, 0x49, 0x95, 0xf0, 0xbf, 0x42, 0x8b, 0x54, 0x71, 0xc2, 0x15, 0x85, 0xaa, 0xaf, 0xc8, 0x17, 0x33, 0x91, 0x6f, 0x01, 0x65, 0x59, 0x7a, 0x55, 0xd1, 0x2c, 0xb4
};
#define result__181 0

//Test vector 182:           "comment" : "edge case private key",

static uint8_t pub_182  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_182  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb1, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
};
static uint8_t x_182  [32] = {
0x34, 0x8b, 0xf8, 0x04, 0x2e, 0x4e, 0xdf, 0x1d, 0x03, 0xc8, 0xb3, 0x6a, 0xb8, 0x15, 0x15, 0x6e, 0x77, 0xc2, 0x01, 0xb7, 0x64, 0xed, 0x45, 0x62, 0xcf, 0xe2, 0xee, 0x90, 0x63, 0x8f, 0xfe, 0xf5
};
#define result__182 0

//Test vector 183:           "comment" : "edge case private key",

static uint8_t pub_183  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_183  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc1, 0xfc, 0x63, 0x25, 0x51
};
static uint8_t x_183  [32] = {
0x6e, 0x4e, 0xc5, 0x47, 0x9a, 0x7c, 0x20, 0xa5, 0x37, 0x50, 0x17, 0x00, 0x48, 0x4f, 0x6f, 0x43, 0x3a, 0x8a, 0x8f, 0xe5, 0x3c, 0x28, 0x8f, 0x7a, 0x25, 0xc8, 0xe8, 0xc9, 0x2d, 0x39, 0xe8, 0xdc
};
#define result__183 0

//Test vector 184:           "comment" : "edge case private key",

static uint8_t pub_184  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_184  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x24, 0xf3
};
static uint8_t x_184  [32] = {
0xf7, 0x40, 0x7d, 0x61, 0xfd, 0xf5, 0x81, 0xbe, 0x4f, 0x56, 0x46, 0x21, 0xd5, 0x90, 0xca, 0x9b, 0x7b, 0xa3, 0x7f, 0x31, 0x39, 0x61, 0x50, 0xf9, 0x92, 0x2f, 0x15, 0x01, 0xda, 0x8c, 0x83, 0xef
};
#define result__184 0

//Test vector 185:           "comment" : "edge case private key",

static uint8_t pub_185  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_185  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x33
};
static uint8_t x_185  [32] = {
0x82, 0x23, 0x6f, 0xd2, 0x72, 0x20, 0x86, 0x93, 0xe0, 0x57, 0x45, 0x55, 0xca, 0x46, 0x5c, 0x6c, 0xc5, 0x12, 0x16, 0x34, 0x86, 0x08, 0x4f, 0xa5, 0x7f, 0x5e, 0x1b, 0xd2, 0xe2, 0xcc, 0xc0, 0xb3
};
#define result__185 0

//Test vector 186:           "comment" : "edge case private key",

static uint8_t pub_186  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_186  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x43
};
static uint8_t x_186  [32] = {
0x06, 0x53, 0x71, 0x49, 0x66, 0x4d, 0xba, 0x1a, 0x99, 0x24, 0x65, 0x4c, 0xb7, 0xf7, 0x87, 0xed, 0x22, 0x48, 0x51, 0xb0, 0xdf, 0x25, 0xef, 0x53, 0xfc, 0xf5, 0x4f, 0x8f, 0x26, 0xcd, 0x5f, 0x3f
};
#define result__186 0

//Test vector 187:           "comment" : "edge case private key",

static uint8_t pub_187  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_187  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4b
};
static uint8_t x_187  [32] = {
0xf2, 0xb3, 0x85, 0x39, 0xbc, 0xe9, 0x95, 0xd4, 0x43, 0xc7, 0xbf, 0xee, 0xef, 0xad, 0xc9, 0xe4, 0x2c, 0xc2, 0xc8, 0x9c, 0x60, 0xbf, 0x4e, 0x86, 0xea, 0xc9, 0x5d, 0x51, 0x98, 0x7b, 0xd1, 0x12
};
#define result__187 0

//Test vector 188:           "comment" : "edge case private key",

static uint8_t pub_188  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_188  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4e
};
static uint8_t x_188  [32] = {
0x85, 0xa0, 0xb5, 0x85, 0x19, 0xb2, 0x8e, 0x70, 0xa6, 0x94, 0xec, 0x51, 0x98, 0xf7, 0x2c, 0x4b, 0xfd, 0xab, 0xaa, 0x30, 0xa7, 0x0f, 0x71, 0x43, 0xb5, 0xb1, 0xcd, 0x75, 0x36, 0xf7, 0x16, 0xca
};
#define result__188 0

//Test vector 189:           "comment" : "edge case private key",

static uint8_t pub_189  [65] = {
0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19, 0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08, 0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43, 0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16, 0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a, 0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b
};
static uint8_t pri_189  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4f
};
static uint8_t x_189  [32] = {
0x02, 0x7b, 0x01, 0x3a, 0x6f, 0x16, 0x6d, 0xb6, 0x55, 0xd6, 0x9d, 0x64, 0x3c, 0x12, 0x7e, 0xf8, 0xac, 0xe1, 0x75, 0x31, 0x1e, 0x66, 0x7d, 0xff, 0x25, 0x20, 0xf5, 0xb5, 0xc7, 0x5b, 0x76, 0x59
};
#define result__189 0

//Test vector 190:           "comment" : "CVE-2017-8932",

static uint8_t pub_190  [65] = {
0x04, 0x02, 0x38, 0x19, 0x81, 0x3a, 0xc9, 0x69, 0x84, 0x70, 0x59, 0x02, 0x8e, 0xa8, 0x8a, 0x1f, 0x30, 0xdf, 0xbc, 0xde, 0x03, 0xfc, 0x79, 0x1d, 0x3a, 0x25, 0x2c, 0x6b, 0x41, 0x21, 0x18, 0x82, 0xea, 0xf9, 0x3e, 0x4a, 0xe4, 0x33, 0xcc, 0x12, 0xcf, 0x2a, 0x43, 0xfc, 0x0e, 0xf2, 0x64, 0x00, 0xc0, 0xe1, 0x25, 0x50, 0x82, 0x24, 0xcd, 0xb6, 0x49, 0x38, 0x0f, 0x25, 0x47, 0x91, 0x48, 0xa4, 0xad
};
static uint8_t pri_190  [32] = {
0x2a, 0x26, 0x5f, 0x8b, 0xcb, 0xdc, 0xaf, 0x94, 0xd5, 0x85, 0x19, 0x14, 0x1e, 0x57, 0x81, 0x24, 0xcb, 0x40, 0xd6, 0x4a, 0x50, 0x1f, 0xba, 0x9c, 0x11, 0x84, 0x7b, 0x28, 0x96, 0x5b, 0xc7, 0x37
};
static uint8_t x_190  [32] = {
0x4d, 0x4d, 0xe8, 0x0f, 0x15, 0x34, 0x85, 0x0d, 0x26, 0x10, 0x75, 0x99, 0x7e, 0x30, 0x49, 0x32, 0x1a, 0x08, 0x64, 0x08, 0x2d, 0x24, 0xa9, 0x17, 0x86, 0x33, 0x66, 0xc0, 0x72, 0x4f, 0x5a, 0xe3
};
#define result__190 0

//Test vector 191:           "comment" : "CVE-2017-8932",

static uint8_t pub_191  [65] = {
0x04, 0xcc, 0x11, 0x88, 0x7b, 0x2d, 0x66, 0xcb, 0xae, 0x8f, 0x4d, 0x30, 0x66, 0x27, 0x19, 0x25, 0x22, 0x93, 0x21, 0x46, 0xb4, 0x2f, 0x01, 0xd3, 0xc6, 0xf9, 0x2b, 0xd5, 0xc8, 0xba, 0x73, 0x9b, 0x06, 0xa2, 0xf0, 0x8a, 0x02, 0x9c, 0xd0, 0x6b, 0x46, 0x18, 0x30, 0x85, 0xba, 0xe9, 0x24, 0x8b, 0x0e, 0xd1, 0x5b, 0x70, 0x28, 0x0c, 0x7e, 0xf1, 0x3a, 0x45, 0x7f, 0x5a, 0xf3, 0x82, 0x42, 0x60, 0x31
};
static uint8_t pri_191  [32] = {
0x31, 0x3f, 0x72, 0xff, 0x9f, 0xe8, 0x11, 0xbf, 0x57, 0x31, 0x76, 0x23, 0x1b, 0x28, 0x6a, 0x3b, 0xdb, 0x6f, 0x1b, 0x14, 0xe0, 0x5c, 0x40, 0x14, 0x65, 0x90, 0x72, 0x7a, 0x71, 0xc3, 0xbc, 0xcd
};
static uint8_t x_191  [32] = {
0x83, 0x1c, 0x3f, 0x6b, 0x5f, 0x76, 0x2d, 0x2f, 0x46, 0x19, 0x01, 0x57, 0x7a, 0xf4, 0x13, 0x54, 0xac, 0x5f, 0x22, 0x8c, 0x25, 0x91, 0xf8, 0x4f, 0x8a, 0x6e, 0x51, 0xe2, 0xe3, 0xf1, 0x79, 0x91
};
#define result__191 0

//Test vector 192:           "comment" : "point is not on curve",

static uint8_t pub_192  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t pri_192  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_192  [32] = {

};
#define result__192 18446744073709551615U

//Test vector 193:           "comment" : "point is not on curve",

static uint8_t pub_193  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
static uint8_t pri_193  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_193  [32] = {

};
 #define result__193 18446744073709551615U

//Test vector 194:           "comment" : "point is not on curve",

static uint8_t pub_194  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe
};
static uint8_t pri_194  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_194  [32] = {

};
 #define result__194 18446744073709551615U

//Test vector 195:           "comment" : "point is not on curve",

static uint8_t pub_195  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
static uint8_t pri_195  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_195  [32] = {

};
 #define result__195 18446744073709551615U

//Test vector 196:           "comment" : "point is not on curve",

static uint8_t pub_196  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t pri_196  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_196  [32] = {

};
 #define result__196 18446744073709551615U

//Test vector 197:           "comment" : "point is not on curve",

static uint8_t pub_197  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
static uint8_t pri_197  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_197  [32] = {

};
 #define result__197 18446744073709551615U

//Test vector 198:           "comment" : "point is not on curve",

static uint8_t pub_198  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe
};
static uint8_t pri_198  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_198  [32] = {

};
 #define result__198 18446744073709551615U

//Test vector 199:           "comment" : "point is not on curve",

static uint8_t pub_199  [65] = {
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
static uint8_t pri_199  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_199  [32] = {

};
 #define result__199 18446744073709551615U

//Test vector 200:           "comment" : "point is not on curve",

static uint8_t pub_200  [65] = {
0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t pri_200  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_200  [32] = {

};
 #define result__200 18446744073709551615U

//Test vector 201:           "comment" : "point is not on curve",

static uint8_t pub_201  [65] = {
0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
static uint8_t pri_201  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_201  [32] = {

};
 #define result__201 18446744073709551615U

//Test vector 202:           "comment" : "point is not on curve",

static uint8_t pub_202  [65] = {
0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe
};
static uint8_t pri_202  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_202  [32] = {

};
 #define result__202 18446744073709551615U

//Test vector 203:           "comment" : "point is not on curve",

static uint8_t pub_203  [65] = {
0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
static uint8_t pri_203  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_203  [32] = {

};
 #define result__203 18446744073709551615U

//Test vector 204:           "comment" : "point is not on curve",

static uint8_t pub_204  [65] = {
0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t pri_204  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_204  [32] = {

};
 #define result__204 18446744073709551615U

//Test vector 205:           "comment" : "point is not on curve",

static uint8_t pub_205  [65] = {
0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
static uint8_t pri_205  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_205  [32] = {

};
 #define result__205 18446744073709551615U

//Test vector 206:           "comment" : "point is not on curve",

static uint8_t pub_206  [65] = {
0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe
};
static uint8_t pri_206  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_206  [32] = {

};
 #define result__206 18446744073709551615U

//Test vector 207:           "comment" : "point is not on curve",

static uint8_t pub_207  [65] = {
0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
static uint8_t pri_207  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_207  [32] = {

};
 #define result__207 18446744073709551615U

//Test vector 208:           "comment" : "",

static uint8_t pub_208  [65] = {

};
static uint8_t pri_208  [32] = {
0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26, 0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41, 0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d
};
static uint8_t x_208  [32] = {

};
 #define result__208 18446744073709551615U

//Test vector 209:           "comment" : "invalid public key",

static uint8_t pub_209  [65] = {
0x02, 0xfd, 0x4b, 0xf6, 0x17, 0x63, 0xb4, 0x65, 0x81, 0xfd, 0x91, 0x74, 0xd6, 0x23, 0x51, 0x6c, 0xf3, 0xc8, 0x1e, 0xdd, 0x40, 0xe2, 0x9f, 0xfa, 0x27, 0x77, 0xfb, 0x6c, 0xb0, 0xae, 0x3c, 0xe5, 0x35
};
static uint8_t pri_209  [32] = {
0x6f, 0x95, 0x3f, 0xaf, 0xf3, 0x59, 0x9e, 0x6c, 0x76, 0x2d, 0x7f, 0x4c, 0xab, 0xfe, 0xed, 0x09, 0x2d, 0xe2, 0xad, 0xd1, 0xdf, 0x1b, 0xc5, 0x74, 0x8c, 0x6c, 0xbb, 0x72, 0x5c, 0xf3, 0x54, 0x58
};
static uint8_t x_209  [32] = {

};
 #define result__209 18446744073709551615U

//Test vector 210:           "comment" : "public key is a low order point on twist",

static uint8_t pub_210  [65] = {
0x03, 0xef, 0xdd, 0xe3, 0xb3, 0x28, 0x72, 0xa9, 0xef, 0xfc, 0xf3, 0xb9, 0x4c, 0xbf, 0x73, 0xaa, 0x7b, 0x39, 0xf9, 0x68, 0x3e, 0xce, 0x91, 0x21, 0xb9, 0x85, 0x21, 0x67, 0xf4, 0xe3, 0xda, 0x60, 0x9b
};
static uint8_t pri_210  [32] = {
0xd2, 0x7e, 0xdf, 0x0f, 0xf5, 0xb6, 0xb6, 0xb4, 0x65, 0x75, 0x3e, 0x71, 0x58, 0x37, 0x03, 0x32, 0xc1, 0x53, 0xb4, 0x68, 0xa1, 0xbe, 0x08, 0x7a, 0xd0, 0xf4, 0x90, 0xbd, 0xb9, 0x9e, 0x5f, 0x02
};
static uint8_t x_210  [32] = {

};
 #define result__210 18446744073709551615U

//Test vector 211:           "comment" : "public key is a low order point on twist",

static uint8_t pub_211  [65] = {
0x02, 0xef, 0xdd, 0xe3, 0xb3, 0x28, 0x72, 0xa9, 0xef, 0xfc, 0xf3, 0xb9, 0x4c, 0xbf, 0x73, 0xaa, 0x7b, 0x39, 0xf9, 0x68, 0x3e, 0xce, 0x91, 0x21, 0xb9, 0x85, 0x21, 0x67, 0xf4, 0xe3, 0xda, 0x60, 0x9b
};
static uint8_t pri_211  [32] = {
0xd2, 0x7e, 0xdf, 0x0f, 0xf5, 0xb6, 0xb6, 0xb4, 0x65, 0x75, 0x3e, 0x71, 0x58, 0x37, 0x03, 0x32, 0xc1, 0x53, 0xb4, 0x68, 0xa1, 0xbe, 0x08, 0x7a, 0xd0, 0xf4, 0x90, 0xbd, 0xb9, 0x9e, 0x5f, 0x03
};
static uint8_t x_211  [32] = {

};
 #define result__211 18446744073709551615U

//Test vector 212:           "comment" : "public key is a low order point on twist",

static uint8_t pub_212  [65] = {
0x02, 0xc4, 0x95, 0x24, 0xb2, 0xad, 0xfd, 0x8f, 0x5f, 0x97, 0x2e, 0xf5, 0x54, 0x65, 0x28, 0x36, 0xe2, 0xef, 0xb2, 0xd3, 0x06, 0xc6, 0xd3, 0xb0, 0x68, 0x92, 0x34, 0xce, 0xc9, 0x3a, 0xe7, 0x3d, 0xb5
};
static uint8_t pri_212  [32] = {
0x95, 0xea, 0xd8, 0x45, 0x40, 0xc2, 0xd0, 0x27, 0xaa, 0x31, 0x30, 0xff, 0x1b, 0x47, 0x88, 0x8c, 0xc1, 0xed, 0x67, 0xe8, 0xdd, 0xa4, 0x61, 0x56, 0xe7, 0x1c, 0xe0, 0x99, 0x17, 0x91, 0xe8, 0x35
};
static uint8_t x_212  [32] = {

};
 #define result__212 18446744073709551615U

//Test vector 213:           "comment" : "public key is a low order point on twist",

static uint8_t pub_213  [65] = {
0x03, 0x18, 0xf9, 0xba, 0xe7, 0x74, 0x7c, 0xd8, 0x44, 0xe9, 0x85, 0x25, 0xb7, 0xcc, 0xd0, 0xda, 0xf6, 0xe1, 0xd2, 0x0a, 0x81, 0x8b, 0x21, 0x75, 0xa9, 0xa9, 0x1e, 0x4e, 0xae, 0x53, 0x43, 0xbc, 0x98
};
static uint8_t pri_213  [32] = {
0xa8, 0x68, 0x1e, 0xf6, 0x7f, 0xb1, 0xf1, 0x89, 0x64, 0x7d, 0x95, 0xe8, 0xdb, 0x00, 0xc5, 0x2c, 0xee, 0xf6, 0xd4, 0x1a, 0x85, 0xba, 0x0a, 0x5b, 0xd7, 0x4c, 0x44, 0xe8, 0xe6, 0x2c, 0x8a, 0xa4
};
static uint8_t x_213  [32] = {

};
 #define result__213 18446744073709551615U

//Test vector 214:           "comment" : "public key is a low order point on twist",

static uint8_t pub_214  [65] = {
0x02, 0x18, 0xf9, 0xba, 0xe7, 0x74, 0x7c, 0xd8, 0x44, 0xe9, 0x85, 0x25, 0xb7, 0xcc, 0xd0, 0xda, 0xf6, 0xe1, 0xd2, 0x0a, 0x81, 0x8b, 0x21, 0x75, 0xa9, 0xa9, 0x1e, 0x4e, 0xae, 0x53, 0x43, 0xbc, 0x98
};
static uint8_t pri_214  [32] = {
0xa8, 0x68, 0x1e, 0xf6, 0x7f, 0xb1, 0xf1, 0x89, 0x64, 0x7d, 0x95, 0xe8, 0xdb, 0x00, 0xc5, 0x2c, 0xee, 0xf6, 0xd4, 0x1a, 0x85, 0xba, 0x0a, 0x5b, 0xd7, 0x4c, 0x44, 0xe8, 0xe6, 0x2c, 0x8a, 0xa5
};
static uint8_t x_214  [32] = {

};
 #define result__214 18446744073709551615U

//Test vector 215:           "comment" : "public key is a low order point on twist",

static uint8_t pub_215  [65] = {
0x03, 0xc4, 0x95, 0x24, 0xb2, 0xad, 0xfd, 0x8f, 0x5f, 0x97, 0x2e, 0xf5, 0x54, 0x65, 0x28, 0x36, 0xe2, 0xef, 0xb2, 0xd3, 0x06, 0xc6, 0xd3, 0xb0, 0x68, 0x92, 0x34, 0xce, 0xc9, 0x3a, 0xe7, 0x3d, 0xb5
};
static uint8_t pri_215  [32] = {
0x95, 0xea, 0xd8, 0x45, 0x40, 0xc2, 0xd0, 0x27, 0xaa, 0x31, 0x30, 0xff, 0x1b, 0x47, 0x88, 0x8c, 0xc1, 0xed, 0x67, 0xe8, 0xdd, 0xa4, 0x61, 0x56, 0xe7, 0x1c, 0xe0, 0x99, 0x17, 0x91, 0xe8, 0x34
};
static uint8_t x_215  [32] = {

};

#define result__215 18446744073709551615U


static ecdhp256_w_i w_vectors[] = {
{ 
 .publicKey = pub_0, 
 .privateKey = pri_0, 
  .sharedKey = x_0, 
 .flag = result__0
}, 
{ 
 .publicKey = pub_2, 
 .privateKey = pri_2, 
  .sharedKey = x_2, 
 .flag = result__2 
}, 
{ 
 .publicKey = pub_3, 
 .privateKey = pri_3, 
  .sharedKey = x_3, 
 .flag = result__3 
}, 
{ 
 .publicKey = pub_4, 
 .privateKey = pri_4, 
  .sharedKey = x_4, 
 .flag = result__4 
}, 
{ 
 .publicKey = pub_5, 
 .privateKey = pri_5, 
  .sharedKey = x_5, 
 .flag = result__5 
}, 
{ 
 .publicKey = pub_6, 
 .privateKey = pri_6, 
  .sharedKey = x_6, 
 .flag = result__6 
}, 
{ 
 .publicKey = pub_7, 
 .privateKey = pri_7, 
  .sharedKey = x_7, 
 .flag = result__7 
}, 
{ 
 .publicKey = pub_8, 
 .privateKey = pri_8, 
  .sharedKey = x_8, 
 .flag = result__8 
}, 
{ 
 .publicKey = pub_9, 
 .privateKey = pri_9, 
  .sharedKey = x_9, 
 .flag = result__9 
}, 
{ 
 .publicKey = pub_10, 
 .privateKey = pri_10, 
  .sharedKey = x_10, 
 .flag = result__10 
}, 
{ 
 .publicKey = pub_11, 
 .privateKey = pri_11, 
  .sharedKey = x_11, 
 .flag = result__11 
}, 
{ 
 .publicKey = pub_12, 
 .privateKey = pri_12, 
  .sharedKey = x_12, 
 .flag = result__12 
}, 
{ 
 .publicKey = pub_13, 
 .privateKey = pri_13, 
  .sharedKey = x_13, 
 .flag = result__13 
}, 
{ 
 .publicKey = pub_14, 
 .privateKey = pri_14, 
  .sharedKey = x_14, 
 .flag = result__14 
}, 
{ 
 .publicKey = pub_15, 
 .privateKey = pri_15, 
  .sharedKey = x_15, 
 .flag = result__15 
}, 
{ 
 .publicKey = pub_16, 
 .privateKey = pri_16, 
  .sharedKey = x_16, 
 .flag = result__16 
}, 
{ 
 .publicKey = pub_17, 
 .privateKey = pri_17, 
  .sharedKey = x_17, 
 .flag = result__17 
}, 
{ 
 .publicKey = pub_18, 
 .privateKey = pri_18, 
  .sharedKey = x_18, 
 .flag = result__18 
}, 
{ 
 .publicKey = pub_19, 
 .privateKey = pri_19, 
  .sharedKey = x_19, 
 .flag = result__19 
}, 
{ 
 .publicKey = pub_20, 
 .privateKey = pri_20, 
  .sharedKey = x_20, 
 .flag = result__20 
}, 
{ 
 .publicKey = pub_21, 
 .privateKey = pri_21, 
  .sharedKey = x_21, 
 .flag = result__21 
}, 
{ 
 .publicKey = pub_22, 
 .privateKey = pri_22, 
  .sharedKey = x_22, 
 .flag = result__22 
}, 
{ 
 .publicKey = pub_23, 
 .privateKey = pri_23, 
  .sharedKey = x_23, 
 .flag = result__23 
}, 
{ 
 .publicKey = pub_24, 
 .privateKey = pri_24, 
  .sharedKey = x_24, 
 .flag = result__24 
}, 
{ 
 .publicKey = pub_25, 
 .privateKey = pri_25, 
  .sharedKey = x_25, 
 .flag = result__25 
}, 
{ 
 .publicKey = pub_26, 
 .privateKey = pri_26, 
  .sharedKey = x_26, 
 .flag = result__26 
}, 
{ 
 .publicKey = pub_27, 
 .privateKey = pri_27, 
  .sharedKey = x_27, 
 .flag = result__27 
}, 
{ 
 .publicKey = pub_28, 
 .privateKey = pri_28, 
  .sharedKey = x_28, 
 .flag = result__28 
}, 
{ 
 .publicKey = pub_29, 
 .privateKey = pri_29, 
  .sharedKey = x_29, 
 .flag = result__29 
}, 
{ 
 .publicKey = pub_30, 
 .privateKey = pri_30, 
  .sharedKey = x_30, 
 .flag = result__30 
}, 
{ 
 .publicKey = pub_31, 
 .privateKey = pri_31, 
  .sharedKey = x_31, 
 .flag = result__31 
}, 
{ 
 .publicKey = pub_32, 
 .privateKey = pri_32, 
  .sharedKey = x_32, 
 .flag = result__32 
}, 
{ 
 .publicKey = pub_33, 
 .privateKey = pri_33, 
  .sharedKey = x_33, 
 .flag = result__33 
}, 
{ 
 .publicKey = pub_34, 
 .privateKey = pri_34, 
  .sharedKey = x_34, 
 .flag = result__34 
}, 
{ 
 .publicKey = pub_35, 
 .privateKey = pri_35, 
  .sharedKey = x_35, 
 .flag = result__35 
}, 
{ 
 .publicKey = pub_36, 
 .privateKey = pri_36, 
  .sharedKey = x_36, 
 .flag = result__36 
}, 
{ 
 .publicKey = pub_37, 
 .privateKey = pri_37, 
  .sharedKey = x_37, 
 .flag = result__37 
}, 
{ 
 .publicKey = pub_38, 
 .privateKey = pri_38, 
  .sharedKey = x_38, 
 .flag = result__38 
}, 
{ 
 .publicKey = pub_39, 
 .privateKey = pri_39, 
  .sharedKey = x_39, 
 .flag = result__39 
}, 
{ 
 .publicKey = pub_40, 
 .privateKey = pri_40, 
  .sharedKey = x_40, 
 .flag = result__40 
}, 
{ 
 .publicKey = pub_41, 
 .privateKey = pri_41, 
  .sharedKey = x_41, 
 .flag = result__41 
}, 
{ 
 .publicKey = pub_42, 
 .privateKey = pri_42, 
  .sharedKey = x_42, 
 .flag = result__42 
}, 
{ 
 .publicKey = pub_43, 
 .privateKey = pri_43, 
  .sharedKey = x_43, 
 .flag = result__43 
}, 
{ 
 .publicKey = pub_44, 
 .privateKey = pri_44, 
  .sharedKey = x_44, 
 .flag = result__44 
}, 
{ 
 .publicKey = pub_45, 
 .privateKey = pri_45, 
  .sharedKey = x_45, 
 .flag = result__45 
}, 
{ 
 .publicKey = pub_46, 
 .privateKey = pri_46, 
  .sharedKey = x_46, 
 .flag = result__46 
}, 
{ 
 .publicKey = pub_47, 
 .privateKey = pri_47, 
  .sharedKey = x_47, 
 .flag = result__47 
}, 
{ 
 .publicKey = pub_48, 
 .privateKey = pri_48, 
  .sharedKey = x_48, 
 .flag = result__48 
}, 
{ 
 .publicKey = pub_49, 
 .privateKey = pri_49, 
  .sharedKey = x_49, 
 .flag = result__49 
}, 
{ 
 .publicKey = pub_50, 
 .privateKey = pri_50, 
  .sharedKey = x_50, 
 .flag = result__50 
}, 
{ 
 .publicKey = pub_51, 
 .privateKey = pri_51, 
  .sharedKey = x_51, 
 .flag = result__51 
}, 
{ 
 .publicKey = pub_52, 
 .privateKey = pri_52, 
  .sharedKey = x_52, 
 .flag = result__52 
}, 
{ 
 .publicKey = pub_53, 
 .privateKey = pri_53, 
  .sharedKey = x_53, 
 .flag = result__53 
}, 
{ 
 .publicKey = pub_54, 
 .privateKey = pri_54, 
  .sharedKey = x_54, 
 .flag = result__54 
}, 
{ 
 .publicKey = pub_55, 
 .privateKey = pri_55, 
  .sharedKey = x_55, 
 .flag = result__55 
}, 
{ 
 .publicKey = pub_56, 
 .privateKey = pri_56, 
  .sharedKey = x_56, 
 .flag = result__56 
}, 
{ 
 .publicKey = pub_57, 
 .privateKey = pri_57, 
  .sharedKey = x_57, 
 .flag = result__57 
}, 
{ 
 .publicKey = pub_58, 
 .privateKey = pri_58, 
  .sharedKey = x_58, 
 .flag = result__58 
}, 
{ 
 .publicKey = pub_59, 
 .privateKey = pri_59, 
  .sharedKey = x_59, 
 .flag = result__59 
}, 
{ 
 .publicKey = pub_60, 
 .privateKey = pri_60, 
  .sharedKey = x_60, 
 .flag = result__60 
}, 
{ 
 .publicKey = pub_61, 
 .privateKey = pri_61, 
  .sharedKey = x_61, 
 .flag = result__61 
}, 
{ 
 .publicKey = pub_62, 
 .privateKey = pri_62, 
  .sharedKey = x_62, 
 .flag = result__62 
}, 
{ 
 .publicKey = pub_63, 
 .privateKey = pri_63, 
  .sharedKey = x_63, 
 .flag = result__63 
}, 
{ 
 .publicKey = pub_64, 
 .privateKey = pri_64, 
  .sharedKey = x_64, 
 .flag = result__64 
}, 
{ 
 .publicKey = pub_65, 
 .privateKey = pri_65, 
  .sharedKey = x_65, 
 .flag = result__65 
}, 
{ 
 .publicKey = pub_66, 
 .privateKey = pri_66, 
  .sharedKey = x_66, 
 .flag = result__66 
}, 
{ 
 .publicKey = pub_67, 
 .privateKey = pri_67, 
  .sharedKey = x_67, 
 .flag = result__67 
}, 
{ 
 .publicKey = pub_68, 
 .privateKey = pri_68, 
  .sharedKey = x_68, 
 .flag = result__68 
}, 
{ 
 .publicKey = pub_69, 
 .privateKey = pri_69, 
  .sharedKey = x_69, 
 .flag = result__69 
}, 
{ 
 .publicKey = pub_70, 
 .privateKey = pri_70, 
  .sharedKey = x_70, 
 .flag = result__70 
}, 
{ 
 .publicKey = pub_71, 
 .privateKey = pri_71, 
  .sharedKey = x_71, 
 .flag = result__71 
}, 
{ 
 .publicKey = pub_72, 
 .privateKey = pri_72, 
  .sharedKey = x_72, 
 .flag = result__72 
}, 
{ 
 .publicKey = pub_73, 
 .privateKey = pri_73, 
  .sharedKey = x_73, 
 .flag = result__73 
}, 
{ 
 .publicKey = pub_74, 
 .privateKey = pri_74, 
  .sharedKey = x_74, 
 .flag = result__74 
}, 
{ 
 .publicKey = pub_75, 
 .privateKey = pri_75, 
  .sharedKey = x_75, 
 .flag = result__75 
}, 
{ 
 .publicKey = pub_76, 
 .privateKey = pri_76, 
  .sharedKey = x_76, 
 .flag = result__76 
}, 
{ 
 .publicKey = pub_77, 
 .privateKey = pri_77, 
  .sharedKey = x_77, 
 .flag = result__77 
}, 
{ 
 .publicKey = pub_78, 
 .privateKey = pri_78, 
  .sharedKey = x_78, 
 .flag = result__78 
}, 
{ 
 .publicKey = pub_79, 
 .privateKey = pri_79, 
  .sharedKey = x_79, 
 .flag = result__79 
}, 
{ 
 .publicKey = pub_80, 
 .privateKey = pri_80, 
  .sharedKey = x_80, 
 .flag = result__80 
}, 
{ 
 .publicKey = pub_81, 
 .privateKey = pri_81, 
  .sharedKey = x_81, 
 .flag = result__81 
}, 
{ 
 .publicKey = pub_82, 
 .privateKey = pri_82, 
  .sharedKey = x_82, 
 .flag = result__82 
}, 
{ 
 .publicKey = pub_83, 
 .privateKey = pri_83, 
  .sharedKey = x_83, 
 .flag = result__83 
}, 
{ 
 .publicKey = pub_84, 
 .privateKey = pri_84, 
  .sharedKey = x_84, 
 .flag = result__84 
}, 
{ 
 .publicKey = pub_85, 
 .privateKey = pri_85, 
  .sharedKey = x_85, 
 .flag = result__85 
}, 
{ 
 .publicKey = pub_86, 
 .privateKey = pri_86, 
  .sharedKey = x_86, 
 .flag = result__86 
}, 
{ 
 .publicKey = pub_87, 
 .privateKey = pri_87, 
  .sharedKey = x_87, 
 .flag = result__87 
}, 
{ 
 .publicKey = pub_88, 
 .privateKey = pri_88, 
  .sharedKey = x_88, 
 .flag = result__88 
}, 
{ 
 .publicKey = pub_89, 
 .privateKey = pri_89, 
  .sharedKey = x_89, 
 .flag = result__89 
}, 
{ 
 .publicKey = pub_90, 
 .privateKey = pri_90, 
  .sharedKey = x_90, 
 .flag = result__90 
}, 
{ 
 .publicKey = pub_91, 
 .privateKey = pri_91, 
  .sharedKey = x_91, 
 .flag = result__91 
}, 
{ 
 .publicKey = pub_92, 
 .privateKey = pri_92, 
  .sharedKey = x_92, 
 .flag = result__92 
}, 
{ 
 .publicKey = pub_93, 
 .privateKey = pri_93, 
  .sharedKey = x_93, 
 .flag = result__93 
}, 
{ 
 .publicKey = pub_94, 
 .privateKey = pri_94, 
  .sharedKey = x_94, 
 .flag = result__94 
}, 
{ 
 .publicKey = pub_95, 
 .privateKey = pri_95, 
  .sharedKey = x_95, 
 .flag = result__95 
}, 
{ 
 .publicKey = pub_96, 
 .privateKey = pri_96, 
  .sharedKey = x_96, 
 .flag = result__96 
}, 
{ 
 .publicKey = pub_97, 
 .privateKey = pri_97, 
  .sharedKey = x_97, 
 .flag = result__97 
}, 
{ 
 .publicKey = pub_98, 
 .privateKey = pri_98, 
  .sharedKey = x_98, 
 .flag = result__98 
}, 
{ 
 .publicKey = pub_99, 
 .privateKey = pri_99, 
  .sharedKey = x_99, 
 .flag = result__99 
}, 
{ 
 .publicKey = pub_100, 
 .privateKey = pri_100, 
  .sharedKey = x_100, 
 .flag = result__100 
}, 
{ 
 .publicKey = pub_101, 
 .privateKey = pri_101, 
  .sharedKey = x_101, 
 .flag = result__101 
}, 
{ 
 .publicKey = pub_102, 
 .privateKey = pri_102, 
  .sharedKey = x_102, 
 .flag = result__102 
}, 
{ 
 .publicKey = pub_103, 
 .privateKey = pri_103, 
  .sharedKey = x_103, 
 .flag = result__103 
}, 
{ 
 .publicKey = pub_104, 
 .privateKey = pri_104, 
  .sharedKey = x_104, 
 .flag = result__104 
}, 
{ 
 .publicKey = pub_105, 
 .privateKey = pri_105, 
  .sharedKey = x_105, 
 .flag = result__105 
}, 
{ 
 .publicKey = pub_106, 
 .privateKey = pri_106, 
  .sharedKey = x_106, 
 .flag = result__106 
}, 
{ 
 .publicKey = pub_107, 
 .privateKey = pri_107, 
  .sharedKey = x_107, 
 .flag = result__107 
}, 
{ 
 .publicKey = pub_108, 
 .privateKey = pri_108, 
  .sharedKey = x_108, 
 .flag = result__108 
}, 
{ 
 .publicKey = pub_109, 
 .privateKey = pri_109, 
  .sharedKey = x_109, 
 .flag = result__109 
}, 
{ 
 .publicKey = pub_110, 
 .privateKey = pri_110, 
  .sharedKey = x_110, 
 .flag = result__110 
}, 
{ 
 .publicKey = pub_111, 
 .privateKey = pri_111, 
  .sharedKey = x_111, 
 .flag = result__111 
}, 
{ 
 .publicKey = pub_112, 
 .privateKey = pri_112, 
  .sharedKey = x_112, 
 .flag = result__112 
}, 
{ 
 .publicKey = pub_113, 
 .privateKey = pri_113, 
  .sharedKey = x_113, 
 .flag = result__113 
}, 
{ 
 .publicKey = pub_114, 
 .privateKey = pri_114, 
  .sharedKey = x_114, 
 .flag = result__114 
}, 
{ 
 .publicKey = pub_115, 
 .privateKey = pri_115, 
  .sharedKey = x_115, 
 .flag = result__115 
}, 
{ 
 .publicKey = pub_116, 
 .privateKey = pri_116, 
  .sharedKey = x_116, 
 .flag = result__116 
}, 
{ 
 .publicKey = pub_117, 
 .privateKey = pri_117, 
  .sharedKey = x_117, 
 .flag = result__117 
}, 
{ 
 .publicKey = pub_118, 
 .privateKey = pri_118, 
  .sharedKey = x_118, 
 .flag = result__118 
}, 
{ 
 .publicKey = pub_119, 
 .privateKey = pri_119, 
  .sharedKey = x_119, 
 .flag = result__119 
}, 
{ 
 .publicKey = pub_120, 
 .privateKey = pri_120, 
  .sharedKey = x_120, 
 .flag = result__120 
}, 
{ 
 .publicKey = pub_121, 
 .privateKey = pri_121, 
  .sharedKey = x_121, 
 .flag = result__121 
}, 
{ 
 .publicKey = pub_122, 
 .privateKey = pri_122, 
  .sharedKey = x_122, 
 .flag = result__122 
}, 
{ 
 .publicKey = pub_123, 
 .privateKey = pri_123, 
  .sharedKey = x_123, 
 .flag = result__123 
}, 
{ 
 .publicKey = pub_124, 
 .privateKey = pri_124, 
  .sharedKey = x_124, 
 .flag = result__124 
}, 
{ 
 .publicKey = pub_125, 
 .privateKey = pri_125, 
  .sharedKey = x_125, 
 .flag = result__125 
}, 
{ 
 .publicKey = pub_126, 
 .privateKey = pri_126, 
  .sharedKey = x_126, 
 .flag = result__126 
}, 
{ 
 .publicKey = pub_127, 
 .privateKey = pri_127, 
  .sharedKey = x_127, 
 .flag = result__127 
}, 
{ 
 .publicKey = pub_128, 
 .privateKey = pri_128, 
  .sharedKey = x_128, 
 .flag = result__128 
}, 
{ 
 .publicKey = pub_129, 
 .privateKey = pri_129, 
  .sharedKey = x_129, 
 .flag = result__129 
}, 
{ 
 .publicKey = pub_130, 
 .privateKey = pri_130, 
  .sharedKey = x_130, 
 .flag = result__130 
}, 
{ 
 .publicKey = pub_131, 
 .privateKey = pri_131, 
  .sharedKey = x_131, 
 .flag = result__131 
}, 
{ 
 .publicKey = pub_132, 
 .privateKey = pri_132, 
  .sharedKey = x_132, 
 .flag = result__132 
}, 
{ 
 .publicKey = pub_133, 
 .privateKey = pri_133, 
  .sharedKey = x_133, 
 .flag = result__133 
}, 
{ 
 .publicKey = pub_134, 
 .privateKey = pri_134, 
  .sharedKey = x_134, 
 .flag = result__134 
}, 
{ 
 .publicKey = pub_135, 
 .privateKey = pri_135, 
  .sharedKey = x_135, 
 .flag = result__135 
}, 
{ 
 .publicKey = pub_136, 
 .privateKey = pri_136, 
  .sharedKey = x_136, 
 .flag = result__136 
}, 
{ 
 .publicKey = pub_137, 
 .privateKey = pri_137, 
  .sharedKey = x_137, 
 .flag = result__137 
}, 
{ 
 .publicKey = pub_138, 
 .privateKey = pri_138, 
  .sharedKey = x_138, 
 .flag = result__138 
}, 
{ 
 .publicKey = pub_139, 
 .privateKey = pri_139, 
  .sharedKey = x_139, 
 .flag = result__139 
}, 
{ 
 .publicKey = pub_140, 
 .privateKey = pri_140, 
  .sharedKey = x_140, 
 .flag = result__140 
}, 
{ 
 .publicKey = pub_141, 
 .privateKey = pri_141, 
  .sharedKey = x_141, 
 .flag = result__141 
}, 
{ 
 .publicKey = pub_142, 
 .privateKey = pri_142, 
  .sharedKey = x_142, 
 .flag = result__142 
}, 
{ 
 .publicKey = pub_143, 
 .privateKey = pri_143, 
  .sharedKey = x_143, 
 .flag = result__143 
}, 
{ 
 .publicKey = pub_144, 
 .privateKey = pri_144, 
  .sharedKey = x_144, 
 .flag = result__144 
}, 
{ 
 .publicKey = pub_145, 
 .privateKey = pri_145, 
  .sharedKey = x_145, 
 .flag = result__145 
}, 
{ 
 .publicKey = pub_146, 
 .privateKey = pri_146, 
  .sharedKey = x_146, 
 .flag = result__146 
}, 
{ 
 .publicKey = pub_147, 
 .privateKey = pri_147, 
  .sharedKey = x_147, 
 .flag = result__147 
}, 
{ 
 .publicKey = pub_148, 
 .privateKey = pri_148, 
  .sharedKey = x_148, 
 .flag = result__148 
}, 
{ 
 .publicKey = pub_149, 
 .privateKey = pri_149, 
  .sharedKey = x_149, 
 .flag = result__149 
}, 
{ 
 .publicKey = pub_150, 
 .privateKey = pri_150, 
  .sharedKey = x_150, 
 .flag = result__150 
}, 
{ 
 .publicKey = pub_151, 
 .privateKey = pri_151, 
  .sharedKey = x_151, 
 .flag = result__151 
}, 
{ 
 .publicKey = pub_152, 
 .privateKey = pri_152, 
  .sharedKey = x_152, 
 .flag = result__152 
}, 
{ 
 .publicKey = pub_153, 
 .privateKey = pri_153, 
  .sharedKey = x_153, 
 .flag = result__153 
}, 
{ 
 .publicKey = pub_154, 
 .privateKey = pri_154, 
  .sharedKey = x_154, 
 .flag = result__154 
}, 
{ 
 .publicKey = pub_155, 
 .privateKey = pri_155, 
  .sharedKey = x_155, 
 .flag = result__155 
}, 
{ 
 .publicKey = pub_156, 
 .privateKey = pri_156, 
  .sharedKey = x_156, 
 .flag = result__156 
}, 
{ 
 .publicKey = pub_157, 
 .privateKey = pri_157, 
  .sharedKey = x_157, 
 .flag = result__157 
}, 
{ 
 .publicKey = pub_158, 
 .privateKey = pri_158, 
  .sharedKey = x_158, 
 .flag = result__158 
}, 
{ 
 .publicKey = pub_159, 
 .privateKey = pri_159, 
  .sharedKey = x_159, 
 .flag = result__159 
}, 
{ 
 .publicKey = pub_160, 
 .privateKey = pri_160, 
  .sharedKey = x_160, 
 .flag = result__160 
}, 
{ 
 .publicKey = pub_161, 
 .privateKey = pri_161, 
  .sharedKey = x_161, 
 .flag = result__161 
}, 
{ 
 .publicKey = pub_162, 
 .privateKey = pri_162, 
  .sharedKey = x_162, 
 .flag = result__162 
}, 
{ 
 .publicKey = pub_163, 
 .privateKey = pri_163, 
  .sharedKey = x_163, 
 .flag = result__163 
}, 
{ 
 .publicKey = pub_164, 
 .privateKey = pri_164, 
  .sharedKey = x_164, 
 .flag = result__164 
}, 
{ 
 .publicKey = pub_165, 
 .privateKey = pri_165, 
  .sharedKey = x_165, 
 .flag = result__165 
}, 
{ 
 .publicKey = pub_166, 
 .privateKey = pri_166, 
  .sharedKey = x_166, 
 .flag = result__166 
}, 
{ 
 .publicKey = pub_167, 
 .privateKey = pri_167, 
  .sharedKey = x_167, 
 .flag = result__167 
}, 
{ 
 .publicKey = pub_168, 
 .privateKey = pri_168, 
  .sharedKey = x_168, 
 .flag = result__168 
}, 
{ 
 .publicKey = pub_169, 
 .privateKey = pri_169, 
  .sharedKey = x_169, 
 .flag = result__169 
}, 
{ 
 .publicKey = pub_170, 
 .privateKey = pri_170, 
  .sharedKey = x_170, 
 .flag = result__170 
}, 
{ 
 .publicKey = pub_171, 
 .privateKey = pri_171, 
  .sharedKey = x_171, 
 .flag = result__171 
}, 
{ 
 .publicKey = pub_172, 
 .privateKey = pri_172, 
  .sharedKey = x_172, 
 .flag = result__172 
}, 
{ 
 .publicKey = pub_173, 
 .privateKey = pri_173, 
  .sharedKey = x_173, 
 .flag = result__173 
}, 
{ 
 .publicKey = pub_174, 
 .privateKey = pri_174, 
  .sharedKey = x_174, 
 .flag = result__174 
}, 
{ 
 .publicKey = pub_175, 
 .privateKey = pri_175, 
  .sharedKey = x_175, 
 .flag = result__175 
},

{ 
 .publicKey = pub_176, 
 .privateKey = pri_176, 
  .sharedKey = x_176, 
 .flag = result__176 
}, 

{ 
 .publicKey = pub_177, 
 .privateKey = pri_177, 
  .sharedKey = x_177, 
 .flag = result__177 
}, 
{ 
 .publicKey = pub_178, 
 .privateKey = pri_178, 
  .sharedKey = x_178, 
 .flag = result__178 
}, 
{ 
 .publicKey = pub_179, 
 .privateKey = pri_179, 
  .sharedKey = x_179, 
 .flag = result__179 
}, 
{ 
 .publicKey = pub_180, 
 .privateKey = pri_180, 
  .sharedKey = x_180, 
 .flag = result__180 
}, 
{ 
 .publicKey = pub_181, 
 .privateKey = pri_181, 
  .sharedKey = x_181, 
 .flag = result__181 
}, 
{ 
 .publicKey = pub_182, 
 .privateKey = pri_182, 
  .sharedKey = x_182, 
 .flag = result__182 
}, 
{ 
 .publicKey = pub_183, 
 .privateKey = pri_183, 
  .sharedKey = x_183, 
 .flag = result__183 
}, 
{ 
 .publicKey = pub_184, 
 .privateKey = pri_184, 
  .sharedKey = x_184, 
 .flag = result__184 
}, 
{ 
 .publicKey = pub_185, 
 .privateKey = pri_185, 
  .sharedKey = x_185, 
 .flag = result__185 
}, 
{ 
 .publicKey = pub_186, 
 .privateKey = pri_186, 
  .sharedKey = x_186, 
 .flag = result__186 
}, 
{ 
 .publicKey = pub_187, 
 .privateKey = pri_187, 
  .sharedKey = x_187, 
 .flag = result__187 
}, 
{ 
 .publicKey = pub_188, 
 .privateKey = pri_188, 
  .sharedKey = x_188, 
 .flag = result__188 
}, 
{ 
 .publicKey = pub_189, 
 .privateKey = pri_189, 
  .sharedKey = x_189, 
 .flag = result__189 
}, 
{ 
 .publicKey = pub_190, 
 .privateKey = pri_190, 
  .sharedKey = x_190, 
 .flag = result__190 
}, 
{ 
 .publicKey = pub_191, 
 .privateKey = pri_191, 
  .sharedKey = x_191, 
 .flag = result__191 
}, 
{ 
 .publicKey = pub_192, 
 .privateKey = pri_192, 
  .sharedKey = x_192, 
 .flag = result__192 
}, 
{ 
 .publicKey = pub_193, 
 .privateKey = pri_193, 
  .sharedKey = x_193, 
 .flag = result__193 
}, 
{ 
 .publicKey = pub_194, 
 .privateKey = pri_194, 
  .sharedKey = x_194, 
 .flag = result__194 
}, 
{ 
 .publicKey = pub_195, 
 .privateKey = pri_195, 
  .sharedKey = x_195, 
 .flag = result__195 
}, 
{ 
 .publicKey = pub_196, 
 .privateKey = pri_196, 
  .sharedKey = x_196, 
 .flag = result__196 
}, 
{ 
 .publicKey = pub_197, 
 .privateKey = pri_197, 
  .sharedKey = x_197, 
 .flag = result__197 
}, 
{ 
 .publicKey = pub_198, 
 .privateKey = pri_198, 
  .sharedKey = x_198, 
 .flag = result__198 
}, 
{ 
 .publicKey = pub_199, 
 .privateKey = pri_199, 
  .sharedKey = x_199, 
 .flag = result__199 
}, 
{ 
 .publicKey = pub_200, 
 .privateKey = pri_200, 
  .sharedKey = x_200, 
 .flag = result__200 
}, 
{ 
 .publicKey = pub_201, 
 .privateKey = pri_201, 
  .sharedKey = x_201, 
 .flag = result__201 
}, 
{ 
 .publicKey = pub_202, 
 .privateKey = pri_202, 
  .sharedKey = x_202, 
 .flag = result__202 
}, 
{ 
 .publicKey = pub_203, 
 .privateKey = pri_203, 
  .sharedKey = x_203, 
 .flag = result__203 
}, 
{ 
 .publicKey = pub_204, 
 .privateKey = pri_204, 
  .sharedKey = x_204, 
 .flag = result__204 
}, 
{ 
 .publicKey = pub_205, 
 .privateKey = pri_205, 
  .sharedKey = x_205, 
 .flag = result__205 
}, 
{ 
 .publicKey = pub_206, 
 .privateKey = pri_206, 
  .sharedKey = x_206, 
 .flag = result__206 
}, 
{ 
 .publicKey = pub_207, 
 .privateKey = pri_207, 
  .sharedKey = x_207, 
 .flag = result__207 
}, 
{ 
 .publicKey = pub_208, 
 .privateKey = pri_208, 
  .sharedKey = x_208, 
 .flag = result__208 
}, 
{ 
 .publicKey = pub_209, 
 .privateKey = pri_209, 
  .sharedKey = x_209, 
 .flag = result__209 
}, 
{ 
 .publicKey = pub_210, 
 .privateKey = pri_210, 
  .sharedKey = x_210, 
 .flag = result__210 
}, 
{ 
 .publicKey = pub_211, 
 .privateKey = pri_211, 
  .sharedKey = x_211, 
 .flag = result__211 
}, 
{ 
 .publicKey = pub_212, 
 .privateKey = pri_212, 
  .sharedKey = x_212, 
 .flag = result__212 
}, 
{ 
 .publicKey = pub_213, 
 .privateKey = pri_213, 
  .sharedKey = x_213, 
 .flag = result__213 
}, 
{ 
 .publicKey = pub_214, 
 .privateKey = pri_214, 
  .sharedKey = x_214, 
 .flag = result__214 
}, 
{ 
 .publicKey = pub_215, 
 .privateKey = pri_215, 
  .sharedKey = x_215, 
 .flag = result__215,
}, 

};