// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

'use strict';
const common = require('../common');
const assert = require('assert');
const net = require('net');

const client = net.connect({
  host: 'this.hostname.is.invalid',
  port: common.PORT
});

client.once('error', common.mustCall((err) => {
  assert(err);
  assert.strictEqual(err.code, err.errno);
  // If Name Service Switch is available on the operating system then it
  // might be configured differently (/etc/nsswitch.conf).
  // If the system is configured with no dns the error code will be EAI_AGAIN,
  // but if there are more services after the dns entry, for example some
  // linux distributions ship a myhostname service by default which would
  // still produce the ENOTFOUND error.
  assert.ok(err.code === 'ENOTFOUND' || err.code === 'EAI_AGAIN');
  assert.strictEqual(err.host, err.hostname);
  assert.strictEqual(err.host, 'this.hostname.is.invalid');
  assert.strictEqual(err.syscall, 'getaddrinfo');
}));

client.end();
