#!/usr/bin/python3

"""
ISP Protocol

- ISP commands and Error codes
Sync'd with common/include/isp_protocol.h used by seram and serom

__author__ onyettr
"""
# pylint: disable=unused-argument, invalid-name

# ISP protocol definition
ISP_COMMAND_START_ISP = 0x00
ISP_COMMAND_STOP_ISP = 0x01
ISP_COMMAND_ABORT = 0x02
ISP_COMMAND_DOWNLOAD_START = 0x03  # SERAM DEPRECTAED
ISP_COMMAND_DOWNLOAD_DATA = 0x04
ISP_COMMAND_DOWNLOAD_DONE = 0x05
ISP_COMMAND_EXECUTE = 0x06  # SERAM DEPRECATED
ISP_COMMAND_AUTHENTICATE = 0x07  # SERAM DEPRECATED
ISP_COMMAND_BURN_MRAM = 0x08  # SERAM
ISP_COMMAND_RESET_DEVICE = 0x09

ISP_COMMAND_PRINT_DATA = 0x0C
ISP_COMMAND_MRAM_WRITE = 0x0D  # SEROM
ISP_COMMAND_SECURE_DEBUG = 0x0E
ISP_COMMAND_ENQUIRY = 0x0F
ISP_COMMAND_GET_BAUD_RATE = 0x10
ISP_COMMAND_SET_BAUD_RATE = 0x11
ISP_COMMAND_VERIFY_IMAGE = 0x12
ISP_COMMAND_GET_TOC_INFO = 0x13  # SERAM DEPRECATED
ISP_COMMAND_GET = 0x14
ISP_COMMAND_ERASE_MRAM = 0x15
ISP_COMMAND_SET_MAINTENANCE_FLAG = 0x16
ISP_COMMAND_OTP_READ = 0x17
ISP_COMMAND_OTP_WRITE = 0x18
ISP_COMMAND_MRAM_READ = 0x19
ISP_COMMAND_SET = 0x1A
ISP_COMMAND_DMPU = 0x1B
ISP_COMMAND_SRAM_WRITE = 0x1C  # SEROM
ISP_COMMAND_VERIFY_AND_EXECUTE = 0x1D  # SEROM

ISP_COMMAND_ACK = 0xFE
ISP_COMMAND_NAK = 0xFF
ISP_COMMAND_DATA_RESPONSE = 0xFD

ISP_MAXIMUM_PACKET_SIZE = 256
ISP_PACKET_HEADER_LENGTH = 2
ISP_PACKET_LENGTH_FIELD = 0
ISP_PACKET_COMMAND_FIELD = 1
ISP_PACKET_DATA_FIELD = 2
ISP_PACKET_DATA = 3
ISP_PACKET_DOWNLOAD_FIELD = 4

# ISP Sources
ISP_SOURCE_SEROM = 0x01
ISP_SOURCE_SERAM = 0x02

# ISP Error codes and returns
ISP_SUCCESS = 0x00
ISP_DATA_SUCCESS = 0x01
ISP_ERROR = 0xFF
ISP_READ_TIMEOUT = 0xFE
ISP_WRITE_TIMEOUT = 0xFD
ISP_UNKNOWN_COMMAND = 0xFC
ISP_COMMAND_STOP = 0xFB
ISP_CHECKSUM_ERROR = 0xFA
ISP_NOT_SUPPORTED = 0xF9
ISP_BAD_PACKET_SIZE = 0xF8
ISP_BAD_DESTINATION_ADDR = 0xF7
ISP_UNEXPECTED_COMMAND = 0xF6
ISP_HOST_AUTH_FAILED = 0xF5
ISP_NOT_ALLOWED = 0xF4
ISP_BAD_AUTH_TOKEN = 0xF3
ISP_IMAGE_AUTHENTICATION_FAILED = 0xF2
ISP_IMAGE_VERIFICATION_FAILED = 0xF1
ISP_SECURE_DEBUG_FAILED = 0xF0
ISP_MRAM_WRITE_FAILED = 0xEF
ISP_UNKNOWN_GET_OBJECT = 0xEE
ISP_ERROR_ILLEGAL_ADDRESS = 0xED
ISP_ERROR_MISALIGNED = 0xEC
ISP_MRAM_OFFSET_MISALIGNED = 0xEB
ISP_UNKNOWN_MRAM_ERROR = 0xEA
ISP_MRAM_LENGTH_TOO_LARGE = 0xE9
ISP_UNKNOWN_SET_OBJECT = 0xE8
ISP_CODE_VERIFY_FAILURE = 0xE7  # SEROM
ISP_INVALID_CODE_SIZE = 0xE6  # SEROM
ISP_MFG_DATA_MISCOMPARE = 0xE5  # SEROM
ISP_SERAM_JUMP_FAILED = 0xE4  # SEROM
ISP_MRAM_CONTROLLER_ERROR = 0xE3  # SEROM

# ISP Sub-command
ISP_GET_TOC_INFO = 0x01
ISP_GET_REVISION = 0x02
ISP_GET_BAUDRATE = 0x03
ISP_GET_BANNER = 0x04
ISP_GET_CPU_STATUS = 0x05
ISP_GET_MRAM_CONTENTS = 0x06
ISP_GET_SERAM_METRICS = 0x07
ISP_GET_LOG_BUFFER_INFO = 0x08
ISP_GET_LOG_DATA = 0x09
ISP_GET_SERAM_UPDT_ADDR = 0x0A
# ISP_GET_OTP_READ            = 0x0B unused
ISP_GET_TRACE_BUFFER = 0x0C
ISP_GET_SECURE_DEBUG_TOKENS = 0x0D
ISP_GET_POWER_INFO = 0x0E
ISP_GET_PEEK_ADDRESS = 0x0F
ISP_GET_CLOCK_INFO = 0x10
ISP_GET_SERAM_TRACE_BUFFER = 0x11
ISP_GET_ECC_KEY = 0x12
ISP_GET_FIREWALL_CONFIG = 0x13

ISP_SET_PRINTING_ENABLE = 0x30
ISP_SET_PRINTING_DISABLE = 0x31
ISP_SET_LOGGING_ENABLE = 0x32
ISP_SET_LOGGING_DISABLE = 0x33
ISP_SET_POKE_ADDRESS = 0x34

ISP_TOC_COMMAND_FIELD = 0x02
ISP_DATA_START_FIELD = 0x02
ISP_TOC_INFO_START_MARKER = 0xA5
ISP_TOC_INFO_END_MARKER = 0xA6
ISP_DATA_START_MARKER = 0xA7
ISP_DATA_END_MARKER = 0xA8

# Reader thread states
ISP_STATUS_READER_STOP = 0x100
ISP_STATUS_READER_START = 0x101
ISP_STATUS_READER_RUNNING = 0x102
ISP_STATUS_READER_QUIT = 0x103
