#include <string_view>
#include "LuaParser/Ast/LuaSyntaxNodeKind.h"

std::string_view detail::debug::GetSyntaxKindDebugName(LuaSyntaxNodeKind kind) {
    switch (kind) {
        case LuaSyntaxNodeKind::None:
            return "None";
        case LuaSyntaxNodeKind::File:
            return "File";
        case LuaSyntaxNodeKind::Block:
            return "Block";
        case LuaSyntaxNodeKind::EmptyStatement:
            return "EmptyStatement";
        case LuaSyntaxNodeKind::LocalStatement:
            return "LocalStatement";
        case LuaSyntaxNodeKind::LocalFunctionStatement:
            return "localFunctionStatement";
        case LuaSyntaxNodeKind::IfStatement:
            return "IfStatement";
        case LuaSyntaxNodeKind::WhileStatement:
            return "WhileStatement";
        case LuaSyntaxNodeKind::DoStatement:
            return "DoStatement";
        case LuaSyntaxNodeKind::ForStatement:
            return "FormatStatement";
        case LuaSyntaxNodeKind::RepeatStatement:
            return "RepeatStatement";
        case LuaSyntaxNodeKind::FunctionStatement:
            return "FunctionStatement";
        case LuaSyntaxNodeKind::LabelStatement:
            return "LabelStatement";
        case LuaSyntaxNodeKind::BreakStatement:
            return "BreakStatement";
        case LuaSyntaxNodeKind::ReturnStatement:
            return "ReturnStatement";
        case LuaSyntaxNodeKind::GotoStatement:
            return "GotoStatement";
        case LuaSyntaxNodeKind::ExpressionStatement:
            return "ExpressionStatement";
        case LuaSyntaxNodeKind::AssignStatement:
            return "AssignStatement";
        case LuaSyntaxNodeKind::SuffixedExpression:
            return "SuffixedExpression";
        case LuaSyntaxNodeKind::ParExpression:
            return "ParExpression";
        case LuaSyntaxNodeKind::LiteralExpression:
            return "LiteralExpression";
        case LuaSyntaxNodeKind::StringLiteralExpression:
            return "StringLiteralExpression";
        case LuaSyntaxNodeKind::ClosureExpression:
            return "ClosureExpression";
        case LuaSyntaxNodeKind::UnaryExpression:
            return "UnaryExpression";
        case LuaSyntaxNodeKind::BinaryExpression:
            return "BinaryExpression";
        case LuaSyntaxNodeKind::TableExpression:
            return "TableExpression";
        case LuaSyntaxNodeKind::CallExpression:
            return "CallExpression";
        case LuaSyntaxNodeKind::IndexExpression:
            return "IndexExpression";
        case LuaSyntaxNodeKind::NameExpression:
            return "NameExpression";
        case LuaSyntaxNodeKind::FunctionNameExpression:
            return "FunctionNameExpression";
        case LuaSyntaxNodeKind::VarList:
            return "VarList";
        case LuaSyntaxNodeKind::TableFieldList:
            return "TableFieldList";
        case LuaSyntaxNodeKind::TableField:
            return "TableField";
        case LuaSyntaxNodeKind::FunctionBody:
            return "FunctionBody";
        case LuaSyntaxNodeKind::ParamList:
            return "ParamList";
        case LuaSyntaxNodeKind::NameDefList:
            return "NameDefList";
        case LuaSyntaxNodeKind::Attribute:
            return "Attribute";
        case LuaSyntaxNodeKind::ExpressionList:
            return "ExpressionList";
        case LuaSyntaxNodeKind::ForNumber:
            return "ForNumber";
        case LuaSyntaxNodeKind::ForList:
            return "ForList";
        case LuaSyntaxNodeKind::ForBody:
            return "ForBody";
        case LuaSyntaxNodeKind::Error:
            return "Error";
        case LuaSyntaxNodeKind::Comment:
            return "Comment";
        case LuaSyntaxNodeKind::ShortComment:
            return "ShortComment";
        case LuaSyntaxNodeKind::LongComment:
            return "LongComment";
        case LuaSyntaxNodeKind::ShebangComment:
            return "ShebangComment";
        case LuaSyntaxNodeKind::DocTagFormat:
            return "DocTagFormat";
        case LuaSyntaxNodeKind::TableFieldSep:
            return "TableFieldSep";
    }
    return "Unknown";
}
