#include <stdio.h>
#include <string>
#include <vector>
#include "util.h"
#include "bundled_shaders.h"

using namespace std;
using namespace movit;

namespace movit {

// We need a fake (empty) list of shaders, since we reuse read_file().
BundledShader bundled_shaders[] = {
	{ nullptr, 0, 0 }
};
const char *shader_bundle = "";
extern string *movit_data_directory;

}  // namespace movit

int main(int argc, char **argv)
{
	std::vector<BundledShader> shaders;
	std::string bundle;

	movit_data_directory = new string(".");

	for (int i = 1; i < argc; ++i) {
		string contents = read_file(argv[i]);
		shaders.push_back(BundledShader{ argv[i], /*offset=*/bundle.size(), /*length=*/contents.size() });
		bundle += contents;
	}

	printf("// Autogenerated by make_bundled_shaders.cpp. Do not edit by hand!\n");
	printf("#include <string>\n");
	printf("#include \"bundled_shaders.h\"\n");
	printf("\n");
	printf("namespace movit {\n");
	printf("\n");
	printf("BundledShader bundled_shaders[] = {\n");
	for (const BundledShader &shader : shaders) {
		printf("\t{ \"%s\", %zu, %zu },\n", shader.filename, shader.offset, shader.length);
	}
	printf("\t{ nullptr, 0, 0 }\n");
	printf("};\n");
	printf("const char *shader_bundle = \"");
	for (unsigned char ch : bundle) {
		if (ch == '\n') {
			printf("\\n");
		} else if (ch == '\t') {
			printf("\\t");
		} else if (ch == '"') {	
			printf("\\\"");
		} else if (ch == '\\') {	
			printf("\\\\");
		} else if (!isprint(ch)) {
			printf("\\0%o", ch);
		} else {
			printf("%c", ch);
		}
	}
	printf("\";\n");
	printf("\n");
	printf("}  // namespace movit\n");
}
