/* lhtml_strdup.c: General utility functions
   Mooneer Salem <mooneer@translator.cx> */

/* includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stddef.h>
#include "lhtml.h"

/* functions */

/* ---- These functions are to ensure ANSI compliance. ---- */

/* replacement for strdup() */
char *lhtml_strdup (char *string) {
	#ifdef HAVE_STRDUP
		return strdup(string);
	#else
		char *tmp = (char*)malloc((size_t)strlen(string) + 1);
		if (tmp == NULL) {
			return NULL;
		}

		strcpy(tmp, string);

		return tmp;
	#endif
}
