/* lhtml_strcasecmp.c: General utility functions
   Mooneer Salem <mooneer@translator.cx> */

/* includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stddef.h>
#include "lhtml.h"

/* functions */

/* ---- These functions are to ensure ANSI compliance. ---- */

/* replacement for strcasecmp() */
int lhtml_strcasecmp (char *haystack, char *needle) {
	#ifdef HAVE_STRCASECMP
		return strcasecmp(haystack, needle);
	#else
		register char char1, char2;
		register int total;
		while(*needle) {
			char1 = tolower(*haystack);
			char2 = tolower(*needle);

			needle++;
			if (*haystack) haystack++;
		}

		total = (int)char1 - (int)char2;

		return total;
	#endif
}
