/* -*- mode: c++ -*- */

%module frameCPP

#define DETECTOR_AS_VECTOR 0
%{
#include "ldastoolsal/types.hh"
#include "framecpp/FrTOC.hh"
#include "framecpp/STRING.hh"

using namespace FrameCPP;

#define proc_key_container_type FrTOCProcData::key_container_type

#if SWIG_VERSION < 0x030000
#if DETECTOR_AS_VECTOR
 typedef FrameCPP::FrTOC::namedetector_container_type
   namedetector_container_type;
#endif /* DETECTOR_AS_VECTOR */
#else
 typedef FrameCPP::FrTOC::namedetector_container_type
   namedetector_container_type;
#endif
%}

#if DETECTOR_AS_VECTOR
%import "std_vector.i"

%import "STRING.i"

namespace std {
  %template(STRINGVector) vector< FrameCPP::STRING >;
}
#endif /* DETECTOR_AS_VECTOR */

%import "framecpp/FrTOC.hh"

%include "FrTOCAdc.i"
%include "FrTOCProc.i"
%include "FrTOCSim.i"

%feature("autodoc",
"""
FrTOC (Table of Contents Structure) implementation of the frame specification.

  Attributes:

    ULeapS  From the first FrameH in this file.
    nFrame  Number of frames in this file.
    GTimeS  Array of GPS seconds of frame start times.
    GTimeN  Array of GPS nanoseconds of frame start times.
""" ) FrTOC;

class FrTOC
{
public:
  //---------------------------------------------------------------------
  // typedefs
  //---------------------------------------------------------------------
  typedef FR_TOC_ULEAPS_TYPE uleaps_type;
  typedef FR_TOC_NFRAME_TYPE nFrame_type;

  //---------------------------------------------------------------------
  // namedetector_container_type
  //---------------------------------------------------------------------
#if SWIG_VERSION < 0x030000
#if DETECTOR_AS_VECTOR
  typedef STRINGVector namedetector_container_type;
#else /* DETECTOR_AS_VECTOR */
  typedef FrameCPP::FrTOCData::namedetector_container_type
  namedetector_container_type;
#else
  typedef std::vector< namedetector_type > namedetector_container_type;
#endif

#if defined(SWIGPYTHON)
  %typemap(out) const namedetector_container_type& {

    PyObject* tuple = PyTuple_New( $1->size( ) );
    int tuple_index = 0;

    for ( $1_basetype::const_iterator
	    cur = $1->begin( ),
	    last = $1->end( );
	  cur != last;
	  ++cur,
	    ++tuple_index )
    {
      PyTuple_SET_ITEM( tuple, tuple_index,
			PyString_FromString( cur->c_str( ) ) );
    }
    $result = tuple;
  }
#else
#error no "out" typemap for namedetector_container_type
#endif

#endif /* DETECTOR_AS_VECTOR */

#if SWIG_VERSION < 0x030000
  typedef FrameCPP::FrTOC::gtimes_container_type
  gtimes_container_type;
#else
  typedef std::vector< gtimes_type > gtimes_container_type;
#endif

#if defined(SWIGPYTHON)
  %typemap(out) const gtimes_container_type& {

    PyObject* tuple = PyTuple_New( $1->size( ) );
    int tuple_index = 0;

    for ( $1_basetype::const_iterator
	    cur = $1->begin( ),
	    last = $1->end( );
	  cur != last;
	  ++cur,
	    ++tuple_index )
    {
      PyTuple_SET_ITEM( tuple, tuple_index,
			PyInt_FromLong( *cur ) );
    }
    $result = tuple;
  }
#else
#error no "out" typemap for namedetector_container_type
#endif

#if SWIG_VERSION < 0x030000
  typedef FrameCPP::FrTOC::gtimen_container_type
  gtimen_container_type;
#else
  typedef std::vector< gtimen_type > gtimen_container_type;
#endif

  %apply const gtimes_container_type& { const gtimen_container_type& }

  //---------------------------------------------------------------------
  // GetNameDetector
  //---------------------------------------------------------------------
  nFrame_type GetNFrame( ) const;

  const namedetector_container_type& GetNameDetector( ) const;

  const gtimes_container_type& GetGTimeS( ) const;

  const gtimen_container_type& GetGTimeN( ) const;

  const MapADC_type& GetADC( ) const;

  const MapProc_type& GetProc( ) const;

  const MapSim_type& GetSim( ) const;

  uleaps_type GetULeapS( ) const;

  LDAS_PROPERTY_READ_ONLY("ULeapS",GetULeapS)
  LDAS_PROPERTY_READ_ONLY("nFrame",GetNFrame)
  LDAS_PROPERTY_READ_ONLY("GTimeS",GetGTimeS)
  LDAS_PROPERTY_READ_ONLY("GTimeN",GetGTimeN)
};

