#ifndef FrameCPP_VERSION_8_FrSimData_HH
#define FrameCPP_VERSION_8_FrSimData_HH

#ifndef SWIGIMPORTED
#include <vector>
#endif /* SWIGIMPORTED */

#if ! defined(SWIGIMPORTED)
#include "framecpp/Common/SearchContainer.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version7/FrSimData.hh"

#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/STRING.hh"

#include "framecpp/Version8/FrHistory.hh"
#include "framecpp/Version8/FrTable.hh"
#include "framecpp/Version8/FrVect.hh"
#endif /* ! defined(SWIGIMPORTED) */


#undef FR_SIM_DATA_NAME_TYPE
#if defined(__cplusplus)
#define FR_SIM_DATA_NAME_TYPE std::string
#endif /* defined(__cplusplus) */

#undef FR_SIM_DATA_COMMENT_TYPE
#if defined(__cplusplus)
#define FR_SIM_DATA_COMMENT_TYPE std::string
#endif /* defined(__cplusplus) */

#undef FR_SIM_DATA_SAMPLERATE_TYPE
#define FR_SIM_DATA_SAMPLERATE_TYPE	REAL_8

#undef FR_SIM_DATA_TIMEOFFSEST_TYPE
#define FR_SIM_DATA_TIMEOFFSET_TYPE	REAL_8

#undef FR_SIM_DATA_FSHIFT_TYPE
#define FR_SIM_DATA_FSHIFT_TYPE		REAL_8

#undef FR_SIM_DATA_PHASE_TYPE
#define FR_SIM_DATA_PHASE_TYPE		REAL_4

namespace FrameCPP
{
  namespace Version_8
  {
    //===================================================================
    //===================================================================

#if ! defined(SWIG)
    typedef Previous::FrSimData::FrSimDataStorage FrSimDataStorage;
#endif /* ! defined(SWIG) */

    //===================================================================
    // FrSimDataRefs
    //===================================================================

#if ! defined(SWIG)
    using Previous::FrSimDataRefsT;
#endif /* ! defined(SWIG) */

    typedef FrSimDataRefsT< FrVect, FrTable> FrSimDataRefs;

    //===================================================================
    /// \brief Simulated Data Structure Definition
    //===================================================================
    class FrSimData
#if ! defined(SWIG)
      : public ObjectWithChecksum< Common::FrameSpec::Object >,
	public FrSimDataStorage,
	public FrSimDataRefs,
	public Common::TOCInfo
#endif /* ! defined(SWIG) */
    {
    public:
      typedef FR_SIM_DATA_NAME_TYPE name_type;
      typedef FR_SIM_DATA_COMMENT_TYPE comment_type;
      typedef FR_SIM_DATA_SAMPLERATE_TYPE sampleRate_type;
      typedef FR_SIM_DATA_TIMEOFFSET_TYPE timeOffset_type;
      typedef FR_SIM_DATA_FSHIFT_TYPE fShift_type;
      typedef FR_SIM_DATA_PHASE_TYPE phase_type;

      typedef FrVect					data_value_type;

      //-----------------------------------------------------------------
      /// \brief Default constructor
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrSimData( );

      //-----------------------------------------------------------------
      /// \brief Copy Constructor
      ///
      /// \param[in] Source
      ///     The object from which to copy the information.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrSimData( const FrSimData& Source );

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Name
      ///     Name of simulated data.
      /// \param[in] Comment
      ///     Comment
      /// \param[in] SampleRate
      ///     Simulated data sample rate, samples per second.
      /// \param[in] FShift
      ///     The frequency in the original data that corresponds to
      ///     0 Hz in the heterodyned series.
      /// \param[in] Phase
      ///     Phase of heterodyning signal at start of dataset.
      /// \param[in] TimeOffset
      ///     Offset of 1st sample relative to the frame start time.
      ///
      /// \return
      ///     A new instance of the object.
      //-----------------------------------------------------------------
      FrSimData( const std::string& Name,
		 const std::string& Comment,
		 const REAL_8 SampleRate, 
		 const REAL_8 FShift,
		 const REAL_4 Phase,
		 const REAL_8 TimeOffset = DEFAULT_TIME_OFFSET );

      //-----------------------------------------------------------------
      /// \brief Promotion Constructor
      ///
      /// \param[in] Source
      ///     An FrSimData structure from a previous frame specification.
      /// \param[in] Stream
      ///     The stream from which the earliest version of the
      ///     FrSimData structure was read.
      ///
      /// \return
      ///     A new instance of the object.
      //-----------------------------------------------------------------
      FrSimData( Previous::FrSimData& Source,
		 Common::IStream* Stream );

      //-----------------------------------------------------------------
      /// \brief Establish the value of the comment field.
      ///
      /// \param[in] Comment
      ///     The desired value of the comment field.
      //-----------------------------------------------------------------
      void SetComment( const comment_type& Comment );

      //-----------------------------------------------------------------
      /// \brief Establish the value of the sampleRate field.
      ///
      /// \param[in] SampleRate
      ///     The desired value of the sampleRate field.
      //-----------------------------------------------------------------
      void SetSampleRate( sampleRate_type SampleRate );

      //-----------------------------------------------------------------
      /// \brief Establish the value of the timeOffset field.
      ///
      /// \param[in] time
      ///     The desired value of the timeOffset field.
      //-----------------------------------------------------------------
      void SetTimeOffset( timeOffset_type time );

      //-----------------------------------------------------------------
      /// \brief Promote previous version of object to this version
      ///
      /// \param[in] Source
      ///     The frame specification version of the object.
      /// \param[in] Obj
      ///     The previous version of the object.
      /// \param[in] Stream
      ///     Stream from which the origional object was created.
      ///
      /// \return
      ///     A new instance of FrameH based on Obj
      //-----------------------------------------------------------------
      static promote_ret_type
      Promote( INT_2U Source,
	       promote_arg_type Obj,
	       Common::IStream* Stream );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      static const char* StructName( );

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      static const Common::Description* StructDescription( );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

      //-----------------------------------------------------------------
      /// \brief Return the name associate with the FrSimData structure.
      ///
      /// \return
      ///     The name associated with the FrSimData structure
      //-----------------------------------------------------------------
      const std::string& GetNameSlow() const;
      
      //-----------------------------------------------------------------
      /// \brief The data acquisition rate.
      ///
      /// \return
      ///     The data acquisition rate.
      //-----------------------------------------------------------------
      sampleRate_type GetSampleRate( ) const;

      //-----------------------------------------------------------------
      /// \brief Merge with another FrSimData
      ///
      /// \param[in] RHS
      ///     The source of the information to append to this FrSimData
      ///     structure.
      ///
      /// \return
      ///     A reference to this object
      //-----------------------------------------------------------------
      FrSimData& Merge( const FrSimData& RHS );

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrSimData object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrSimData& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief equality operator for abstract data type
      ///
      /// \param[in] RHS
      ///     The object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      virtual bool operator==( const Common::FrameSpec::Object& RHS ) const;

#if WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Answer requests for information as needed by TOC
      ///
      /// \param[in] InfoClass
      ///     Class of information being requested.
      //-----------------------------------------------------------------
      virtual void TOCQuery( int InfoClass, ... ) const;
#endif /*  WORKING_VIRTUAL_TOCQUERY */

    protected:
      //-----------------------------------------------------------------
      /// \brief Demotes object to previous version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the frame specification to demote too.
      /// \param[in] Obj
      ///     The version of the object to demote.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of the previous generation.
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Promotes object to another version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the promoted frame specification.
      /// \param[in] Obj
      ///     The object to be promoted.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object promoted to the next generation.
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \param[in] Stream
      ///     The stream from which to the object is being read or
      ///     written.
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      cmn_streamsize_type pBytes( const Common::StreamBase& Stream) const;

      //-----------------------------------------------------------------
      /// \brief Virtual constructor
      ///
      /// \param[in] Stream
      ///     The input stream from where the object is being read.
      //-----------------------------------------------------------------
      virtual FrSimData* pCreate( Common::IStream& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      virtual void pWrite( Common::OStream& Stream ) const;

#if ! WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Answer requests for information as needed by TOC
      ///
      /// \param[in] InfoClass
      ///     Class of information being requested.
      /// \param[in] vl
      ///     Variable argument list of requested data.
      //-----------------------------------------------------------------
      virtual void vTOCQuery( int InfoClass, va_list vl ) const;
#endif /* ! WORKING_VIRTUAL_TOCQUERY */

    private:
      //-----------------------------------------------------------------
      /// \brief Object with checksum data.
      //-----------------------------------------------------------------
      typedef ObjectWithChecksum< Common::FrameSpec::Object > object_type;

      using Common::FrameSpec::Object::Create;

      //-----------------------------------------------------------------
      /// \brief Stream Constructor
      ///
      /// \param[in] Stream
      ///     The stream from which the object is being read.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrSimData( Common::IStream& Stream );
    };
 
    inline FrSimData::sampleRate_type FrSimData::
    GetSampleRate( ) const
    {
      return m_data.sampleRate;
    }

    inline void FrSimData::
    SetComment( const comment_type& Comment )
    {
      m_data.comment = Comment;
    }

    inline void FrSimData::
    SetSampleRate( sampleRate_type SampleRate )
    {
      m_data.sampleRate = SampleRate;
#if WORKING
      //-----------------------------------------------------------------
      /// \todo
      /// Modifications to the sample rate need also be reflected in the
      /// corrisponding FrVect structures.
      //-----------------------------------------------------------------
      for ( data_type::iterator
	      cur = RefData( ).begin( ),
	      last = RefData( ).end( );
	    cur != last;
	    ++cur )
      {
	cur->
      }
#endif /* WORKING */
    }

    inline void FrSimData::
    SetTimeOffset( timeOffset_type time )
    {
      m_data.timeOffset = time;
    }

    inline FrSimData::promote_ret_type FrSimData::
    Promote( INT_2U Source,
	     promote_arg_type Obj,
	     Common::IStream* Stream )
    {
      return Object::PromoteObject< Previous::FrSimData, FrSimData >
	( DATA_FORMAT_VERSION, Source, Obj, Stream );
    }

    inline const char* FrSimData::
    StructName( )
    {
      static const char* name = "FrSimData";
      return name;
    }

    inline bool FrSimData::
    operator==( const FrSimData& RHS ) const
    {
      return ( ( this == &RHS )
	       || ( ( m_data == RHS.m_data )
		    && ( m_refs == RHS.m_refs )
		    ) );
    }
  } // namespace - Version_8
} // namespace FrameCPP
#endif /* FrameCPP_VERSION_8_FrSimData_HH */
