#ifndef FRAME_CPP__Common__CompressionDifferential_hh
#define	FRAME_CPP__Common__CompressionDifferential_hh

#include "ldastoolsal/autoarray.hh"
#include "ldastoolsal/SharedArray.hh"

#include "framecpp/Common/Compression.hh"

namespace FrameCPP
{
  namespace Compression
  {

    namespace Differential
    {
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      void
      Decode( CHAR_U* Data, INT_4U NData, data_types_type Type );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      void
      Decode( const CHAR_U* Data, INT_4U NData, data_types_type Type,
	      LDASTools::AL::AutoArray< CHAR_U >& Out );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      void
      Decode( const CHAR_U* Data, INT_4U NData, data_types_type Type,
	      LDASTools::AL::SharedArray< CHAR_U >& Out );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      template< class T >
      void Decode( CHAR_U* Data, INT_4U NData );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      template< class T >
      void Decode( const CHAR_U* Data, INT_4U NData,
		   LDASTools::AL::AutoArray< CHAR_U >& Out );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      template< class T >
      void Decode( const CHAR_U* Data, INT_4U NData,
		   LDASTools::AL::SharedArray< CHAR_U >& Out );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      void Encode( CHAR_U* Data, INT_4U NData, INT_2U Type );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      void Encode( const CHAR_U* Data, INT_4U NData, INT_2U Type,
		   LDASTools::AL::AutoArray< CHAR_U >& Out );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      void Encode( const CHAR_U* Data, INT_4U NData, INT_2U Type,
		   LDASTools::AL::SharedArray< CHAR_U >& Out );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      template< class T >
      void Encode( CHAR_U* Data, INT_4U NData );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      template< class T >
      void Encode( const CHAR_U* Data, INT_4U NData,
		   LDASTools::AL::AutoArray< CHAR_U >& Dest );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      template< class T >
      void Encode( const CHAR_U* Data, INT_4U NData,
		   LDASTools::AL::SharedArray< CHAR_U >& Dest );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      inline void
      Decode( CHAR_U* Data, INT_4U NData, data_types_type Type )
      {
	if ( NData > 1 )
	{
	  switch( Type )
	  {
	  case FR_VECT_C:
	    Decode<CHAR>( Data, NData );
	    break;
	  case FR_VECT_1U:
	    Decode<CHAR_U>( Data, NData );
	    break;
	  case FR_VECT_2S:
	    Decode<INT_2S>( Data, NData );
	    break;
	  case FR_VECT_2U:
	    Decode<INT_2U>( Data, NData );
	    break;
	  case FR_VECT_4S:
	    Decode<INT_4S>( Data, NData );
	    break;
	  case FR_VECT_4U:
	    Decode<INT_4U>( Data, NData );
	    break;
	  case FR_VECT_8S:
	    Decode<INT_8S>( Data, NData );
	    break;
	  case FR_VECT_8U:
	    Decode<INT_8U>( Data, NData );
	    break;
	  case FR_VECT_4R:
	    Decode<INT_4S>( Data, NData );
	    break;
	  case FR_VECT_8R:
	    Decode<INT_8S>( Data, NData );
	    break;
	  case FR_VECT_8C:
	    Decode<INT_4S>( Data, INT_4U( NData * 2 ) );
	    break;
	  case FR_VECT_16C:
	    Decode<INT_8S>( Data, INT_4U( NData * 2 ) );
	    break;
	  default:
	    {
	      std::ostringstream	msg;
	  
	      msg << "unable to perform differntial decoding on data type: "
		  << Type;
	      throw std::range_error( msg.str( ) );
	    }
	    break;
	  }
	}
      }	// function - Decode

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      inline void
      Decode( const CHAR_U* Data, INT_4U NData, data_types_type Type,
	      LDASTools::AL::AutoArray< CHAR_U >& Out )
      {
	if ( NData > 1 )
	{
	  switch( Type )
	  {
	  case FR_VECT_C:
	    Decode<CHAR>( Data, NData, Out );
	    break;
	  case FR_VECT_1U:
	    Decode<CHAR_U>( Data, NData, Out );
	    break;
	  case FR_VECT_2S:
	    Decode<INT_2S>( Data, NData, Out );
	    break;
	  case FR_VECT_2U:
	    Decode<INT_2U>( Data, NData, Out );
	    break;
	  case FR_VECT_4S:
	    Decode<INT_4S>( Data, NData, Out );
	    break;
	  case FR_VECT_4U:
	    Decode<INT_4U>( Data, NData, Out );
	    break;
	  case FR_VECT_8S:
	    Decode<INT_8S>( Data, NData, Out );
	    break;
	  case FR_VECT_8U:
	    Decode<INT_8U>( Data, NData, Out );
	    break;
	  case FR_VECT_4R:
	    Decode<INT_4S>( Data, NData, Out );
	    break;
	  case FR_VECT_8R:
	    Decode<INT_8S>( Data, NData, Out );
	    break;
	  case FR_VECT_8C:
	    Decode<INT_4S>( Data, INT_4U( NData * 2 ), Out );
	    break;
	  case FR_VECT_16C:
	    Decode<INT_8S>( Data, INT_4U( NData * 2 ), Out );
	    break;
	  default:
	    {
	      std::ostringstream	msg;
	  
	      msg << "unable to perform differntial decoding on data type: "
		  << Type;
	      throw std::range_error( msg.str( ) );
	    }
	    break;
	  }
	}
      }	// function - Decode

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      inline void
      Decode( const CHAR_U* Data, INT_4U NData, data_types_type Type,
	      LDASTools::AL::SharedArray< CHAR_U >& Out )
      {
	if ( NData > 1 )
	{
	  switch( Type )
	  {
	  case FR_VECT_C:
	    Decode<CHAR>( Data, NData, Out );
	    break;
	  case FR_VECT_1U:
	    Decode<CHAR_U>( Data, NData, Out );
	    break;
	  case FR_VECT_2S:
	    Decode<INT_2S>( Data, NData, Out );
	    break;
	  case FR_VECT_2U:
	    Decode<INT_2U>( Data, NData, Out );
	    break;
	  case FR_VECT_4S:
	    Decode<INT_4S>( Data, NData, Out );
	    break;
	  case FR_VECT_4U:
	    Decode<INT_4U>( Data, NData, Out );
	    break;
	  case FR_VECT_8S:
	    Decode<INT_8S>( Data, NData, Out );
	    break;
	  case FR_VECT_8U:
	    Decode<INT_8U>( Data, NData, Out );
	    break;
	  case FR_VECT_4R:
	    Decode<INT_4S>( Data, NData, Out );
	    break;
	  case FR_VECT_8R:
	    Decode<INT_8S>( Data, NData, Out );
	    break;
	  case FR_VECT_8C:
	    Decode<INT_4S>( Data, INT_4U( NData * 2 ), Out );
	    break;
	  case FR_VECT_16C:
	    Decode<INT_8S>( Data, INT_4U( NData * 2 ), Out );
	    break;
	  default:
	    {
	      std::ostringstream	msg;
	  
	      msg << "unable to perform differntial decoding on data type: "
		  << Type;
	      throw std::range_error( msg.str( ) );
	    }
	    break;
	  }
	}
      }	// function - Decode

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      inline void
      Encode( CHAR_U* Data, INT_4U NData, INT_2U Type )
      {
	switch( Type )
	{
	case FR_VECT_1U:
	  Encode< CHAR_U >( Data, NData );
	  break;
	case FR_VECT_C:
	  Encode< CHAR >( Data, NData );
	  break;
      
	case FR_VECT_2S:
	  Encode< INT_2S >( Data, NData );
	  break;
      
	case FR_VECT_2U:
	  Encode< INT_2U >( Data, NData );
	  break;
      
	case FR_VECT_4S:
	  Encode< INT_4S >( Data, NData );
	  break;
      
	case FR_VECT_4U:
	  Encode< INT_4U >( Data, NData );
	  break;
      
	case FR_VECT_8S:
	  Encode< INT_8S >( Data, NData );
	  break;
      
	case FR_VECT_8U:
	  Encode< INT_8U >( Data, NData );
	  break;
      
	case FR_VECT_4R:
	  Encode< INT_4S >( Data, NData );
	  break;
      
	case FR_VECT_8R:
	  Encode< INT_8S >( Data, NData );
	  break;
      
	case FR_VECT_8C:
	  Encode< INT_4S >( Data, INT_4U( NData * 2 ) );
	  break;
      
	case FR_VECT_16C:
	  Encode< INT_8S >( Data, INT_4U( NData * 2 ) );
	  break;
	}
      } // function - Encode

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      inline void
      Encode( const CHAR_U* Data, INT_4U NData, INT_2U Type,
	      LDASTools::AL::AutoArray< CHAR_U >& Out )
      {
	switch( Type )
	{
	case FR_VECT_1U:
	  Encode< CHAR_U >( Data, NData, Out );
	  break;
	case FR_VECT_C:
	  Encode< CHAR >( Data, NData, Out );
	  break;
      
	case FR_VECT_2S:
	  Encode< INT_2S >( Data, NData, Out );
	  break;
      
	case FR_VECT_2U:
	  Encode< INT_2U >( Data, NData, Out );
	  break;
      
	case FR_VECT_4S:
	  Encode< INT_4S >( Data, NData, Out );
	  break;
      
	case FR_VECT_4U:
	  Encode< INT_4U >( Data, NData, Out );
	  break;
      
	case FR_VECT_8S:
	  Encode< INT_8S >( Data, NData, Out );
	  break;
      
	case FR_VECT_8U:
	  Encode< INT_8U >( Data, NData, Out );
	  break;
      
	case FR_VECT_4R:
	  Encode< INT_4S >( Data, NData, Out );
	  break;
      
	case FR_VECT_8R:
	  Encode< INT_8S >( Data, NData, Out );
	  break;
      
	case FR_VECT_8C:
	  Encode< INT_4S >( Data, INT_4U( NData * 2 ), Out );
	  break;
      
	case FR_VECT_16C:
	  Encode< INT_8S >( Data, INT_4U( NData * 2 ), Out );
	  break;
	}
      } // function - Encode

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      inline void
      Encode( const CHAR_U* Data, INT_4U NData, INT_2U Type,
	      LDASTools::AL::SharedArray< CHAR_U >& Out )
      {
	switch( Type )
	{
	case FR_VECT_1U:
	  Encode< CHAR_U >( Data, NData, Out );
	  break;
	case FR_VECT_C:
	  Encode< CHAR >( Data, NData, Out );
	  break;
      
	case FR_VECT_2S:
	  Encode< INT_2S >( Data, NData, Out );
	  break;
      
	case FR_VECT_2U:
	  Encode< INT_2U >( Data, NData, Out );
	  break;
      
	case FR_VECT_4S:
	  Encode< INT_4S >( Data, NData, Out );
	  break;
      
	case FR_VECT_4U:
	  Encode< INT_4U >( Data, NData, Out );
	  break;
      
	case FR_VECT_8S:
	  Encode< INT_8S >( Data, NData, Out );
	  break;
      
	case FR_VECT_8U:
	  Encode< INT_8U >( Data, NData, Out );
	  break;
      
	case FR_VECT_4R:
	  Encode< INT_4S >( Data, NData, Out );
	  break;
      
	case FR_VECT_8R:
	  Encode< INT_8S >( Data, NData, Out );
	  break;
      
	case FR_VECT_8C:
	  Encode< INT_4S >( Data, INT_4U( NData * 2 ), Out );
	  break;
      
	case FR_VECT_16C:
	  Encode< INT_8S >( Data, INT_4U( NData * 2 ), Out );
	  break;
	}
      } // function - Encode
    }
  } // namespace -  Compression
  
} // namespace - FrameCPP

#endif /* FRAME_CPP__Common__CompressionDifferential_hh */

