#ifndef FrameCPP_VERSION_8_FrRawData_HH
#define FrameCPP_VERSION_8_FrRawData_HH

#ifndef SWIGIMPORTED
#include <string>
#include <vector>
#endif /* SWIGIMPORTED */

#include "framecpp/Common/SearchContainer.hh"

#include "framecpp/Version7/FrRawData.hh"

#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/FrAdcData.hh"
#include "framecpp/Version8/FrMsg.hh"
#include "framecpp/Version8/FrSerData.hh"
#include "framecpp/Version8/FrTable.hh"
#include "framecpp/Version8/FrVect.hh"
#include "framecpp/Version8/STRING.hh"

namespace FrameCPP
{
  namespace Version_8
  {
    //===================================================================
    /// \brief Raw Data Structgure Definition
    //===================================================================
    class FrRawData
      : public ObjectWithChecksum< Common::FrameSpec::Object >
    {
    public:
      typedef Common::SearchContainer< FrSerData, &FrSerData::GetName >
      firstSer_type;
      typedef firstSer_type::iterator firstSer_iterator;
      typedef firstSer_type::const_iterator const_firstSer_iterator;
      typedef firstSer_type::hash_iterator firstSer_hash_iterator;
      typedef firstSer_type::const_hash_iterator const_firstSer_hash_iterator;

      typedef Common::SearchContainer< FrAdcData, &FrAdcData::GetNameSlow >
      firstAdc_type;
      typedef firstAdc_type::iterator firstAdc_iterator;
      typedef firstAdc_type::const_iterator const_firstAdc_iterator;
      typedef firstAdc_type::hash_iterator firstAdc_hash_iterator;
      typedef firstAdc_type::const_hash_iterator const_firstAdc_hash_iterator;

      typedef Common::SearchContainer< FrTable, &FrTable::GetNameSlow >
      firstTable_type;
      typedef firstTable_type::iterator firstTable_iterator;
      typedef firstTable_type::const_iterator const_firstTable_iterator;
      typedef firstTable_type::hash_iterator firstTable_hash_iterator;
      typedef firstTable_type::const_hash_iterator const_firstTable_hash_iterator;

      typedef Common::SearchContainer< FrMsg, &FrMsg::GetAlarm >
      logMsg_type;
      typedef logMsg_type::iterator logMsg_iterator;
      typedef logMsg_type::const_iterator const_logMsg_iterator;
      typedef logMsg_type::hash_iterator logMsg_hash_iterator;
      typedef logMsg_type::const_hash_iterator const_logMsg_hash_iterator;

      typedef Common::SearchContainer< FrVect, &FrVect::GetName >
      more_type;
      typedef more_type::iterator more_iterator;
      typedef more_type::const_iterator const_more_iterator;
      typedef more_type::hash_iterator more_hash_iterator;
      typedef more_type::const_hash_iterator const_more_hash_iterator;

      //-----------------------------------------------------------------
      /// \brief Default constructor
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrRawData( );
      //-----------------------------------------------------------------
      /// \brief Copy Constructor
      ///
      /// \param[in] rawData
      ///     The object from which to copy the information.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrRawData( const FrRawData& rawData );

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] name
      ///     Namne of raw data.
      ///
      /// \return
      ///     A new instance of the object.
      //-----------------------------------------------------------------
      FrRawData( const std::string& name );

      //-----------------------------------------------------------------
      /// \brief Promotion Constructor
      ///
      /// \param[in] Source
      ///     An FrRawData structure from a previous frame specification.
      /// \param[in] Stream
      ///     The stream from which the earliest version of the
      ///     FrRawData structure was read.
      ///
      /// \return
      ///     A new instance of an FrRawData object
      //-----------------------------------------------------------------
      FrRawData( Previous::FrRawData& Source, Common::IStream* Stream );

      //-----------------------------------------------------------------
      /// \brief Destructor
      //-----------------------------------------------------------------
      ~FrRawData( );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

      //-----------------------------------------------------------------
      /// \brief Return the name associate with the FrRawData structure.
      ///
      /// \return
      ///     The name associated with the FrRawData structure
      //-----------------------------------------------------------------
      const std::string& GetName() const;

      //-----------------------------------------------------------------
      /// \brief Identifier for first serial data structure.
      ///
      /// \return
      ///     A constant reference to the first serial data structure.
      //-----------------------------------------------------------------
      const firstSer_type& RefFirstSer( ) const;

      //-----------------------------------------------------------------
      /// \brief Identifier for first serial data structure.
      ///
      /// \return
      ///     A reference to the first serial data structure.
      //-----------------------------------------------------------------
      firstSer_type& RefFirstSer( );

      //-----------------------------------------------------------------
      /// \brief Identifier for first ADC data structure.
      ///
      /// \return
      ///     A constant reference to the first ADC data structure.
      //-----------------------------------------------------------------
      const firstAdc_type& RefFirstAdc( ) const;

      //-----------------------------------------------------------------
      /// \brief Identifier for first ADC data structure.
      ///
      /// \return
      ///     A reference to the first ADC data structure.
      //-----------------------------------------------------------------
      firstAdc_type&  RefFirstAdc( );

      //-----------------------------------------------------------------
      /// \brief Identifier for first table data structure.
      ///
      /// \return
      ///     A constant reference to the first table data structure.
      //-----------------------------------------------------------------
      const firstTable_type& RefFirstTable( ) const;

      //-----------------------------------------------------------------
      /// \brief Identifier for first table data structure.
      ///
      /// \return
      ///     A reference to the first table data structure.
      //-----------------------------------------------------------------
      firstTable_type& RefFirstTable( );

      //-----------------------------------------------------------------
      /// \brief Identifier for first error message data structure.
      ///
      /// \return
      ///     A constant reference to the first error message data structure.
      //-----------------------------------------------------------------
      const logMsg_type& RefLogMsg( ) const;

      //-----------------------------------------------------------------
      /// \brief Identifier for first error message data structure.
      ///
      /// \return
      ///     A reference to the first error message data structure.
      //-----------------------------------------------------------------
      logMsg_type& RefLogMsg( );

      //-----------------------------------------------------------------
      /// \brief Identifier for additional user-defined data structure.
      ///
      /// \return
      ///     A constant reference to the additional user-defined data structure.
      //-----------------------------------------------------------------
      const more_type& RefMore( ) const;

      //-----------------------------------------------------------------
      /// \brief Identifier for additional user-defined data structure.
      ///
      /// \return
      ///     A reference to the additional user-defined data structure.
      //-----------------------------------------------------------------
      more_type& RefMore( );
   
      static const Common::FrameSpec::Info::frame_object_types CLASS_ID
      = Common::FrameSpec::Info::FSI_FR_RAW_DATA;

      //-----------------------------------------------------------------
      /// \brief Promote previous version of object to this version
      ///
      /// \param[in] Source
      ///     The frame specification version of the object.
      /// \param[in] Obj
      ///     The previous version of the object.
      /// \param[in] Stream
      ///     Stream from which the origional object was created.
      ///
      /// \return
      ///     A new instance of FrameH based on Obj
      //-----------------------------------------------------------------
      static promote_ret_type
      Promote( INT_2U Source,
	       promote_arg_type Obj,
	       Common::IStream* Stream );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      static const char* StructName( );

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      static const Common::Description* StructDescription( );

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrRawData object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrRawData& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief equality operator for abstract data type
      ///
      /// \param[in] RHS
      ///     The object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      /// \brief comparison operator
      virtual bool operator==( const Common::FrameSpec::Object& RHS ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Demotes object to previous version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the frame specification to demote too.
      /// \param[in] Obj
      ///     The version of the object to demote.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of the previous generation.
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Promotes object to another version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the promoted frame specification.
      /// \param[in] Obj
      ///     The object to be promoted.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object promoted to the next generation.
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \param[in] Stream
      ///     The stream from which to the object is being read or
      ///     written.
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      virtual cmn_streamsize_type
      pBytes( const Common::StreamBase& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Virtual constructor
      ///
      /// \param[in] Stream
      ///     The input stream from where the object is being read.
      //-----------------------------------------------------------------
      virtual FrRawData* pCreate( Common::IStream& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      virtual void pWrite( Common::OStream& Stream ) const;

    private:
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      typedef ObjectWithChecksum< Common::FrameSpec::Object > object_type;

      using Common::FrameSpec::Object::Create;

      struct fr_raw_data_type {
	fr_raw_data_type( );
	bool operator==( const fr_raw_data_type& RHS ) const;

	//---------------------------------------------------------------
	/// Name of raw data.
	//---------------------------------------------------------------
	STRING		name;
	//---------------------------------------------------------------
	/// Identifier for first serial data structure in the
	/// linked list.
	//---------------------------------------------------------------
	firstSer_type	firstSer;
	//---------------------------------------------------------------
	/// Identifier for first ADC data structure in the
	/// linked list.
	//---------------------------------------------------------------
	firstAdc_type	firstAdc;
	//---------------------------------------------------------------
	/// Identifier for first table data structure in the
	/// linked list.
	//---------------------------------------------------------------
	firstTable_type	firstTable;
	//---------------------------------------------------------------
	/// Identifier for first error message data structure in the
	/// linked list.
	//---------------------------------------------------------------
	logMsg_type	logMsg;
	//---------------------------------------------------------------
	/// Identifier for the additional user-defined data structure
	/// in the linked list.
	//---------------------------------------------------------------
	more_type	more;
      };

      //-----------------------------------------------------------------
      /// \brief Stream Constructor
      ///
      /// \param[in] Stream
      ///     The stream from which the object is being read.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrRawData( Common::IStream& Stream );

      //-----------------------------------------------------------------
      /// \brief Promotion Constructor
      ///
      /// \param[in] Source
      ///     An FrRawData structure from a previous frame specification.
      ///
      /// \return
      ///     A new instance of an FrRawData object
      //-----------------------------------------------------------------
      FrRawData( const Previous::FrRawData& Source );

      fr_raw_data_type	m_data;
    };

    inline FrRawData::promote_ret_type FrRawData::
    Promote( INT_2U Source,
	     promote_arg_type Obj,
	     Common::IStream* Stream )
    {
      return Object::PromoteObject< Previous::FrRawData, FrRawData >
	( DATA_FORMAT_VERSION, Source, Obj, Stream );
    }

    inline const char* FrRawData::
    StructName( )
    {
      static const char* name = "FrRawData";
      return name;
    }

    inline const FrRawData::firstSer_type& FrRawData::
    RefFirstSer( ) const
    {
      return m_data.firstSer;
    }

    inline FrRawData::firstSer_type& FrRawData::
    RefFirstSer( )
    {
      return m_data.firstSer;
    }

    inline const FrRawData::firstAdc_type& FrRawData::
    RefFirstAdc( ) const
    {
      return m_data.firstAdc;
    }

    inline FrRawData::firstAdc_type&  FrRawData::
    RefFirstAdc( )
    {
      return m_data.firstAdc;
    }

    inline const FrRawData::firstTable_type& FrRawData::
    RefFirstTable( ) const
    {
      return m_data.firstTable;
    }

    inline FrRawData::firstTable_type& FrRawData::
    RefFirstTable( )
    {
      return m_data.firstTable;
    }

    inline const FrRawData::logMsg_type& FrRawData::
    RefLogMsg( ) const
    {
      return m_data.logMsg;
    }

    inline FrRawData::logMsg_type& FrRawData::
    RefLogMsg( )
    {
      return m_data.logMsg;
    }

    inline const FrRawData::more_type& FrRawData::
    RefMore( ) const
    {
      return m_data.more;
    }

    inline FrRawData::more_type& FrRawData::
    RefMore( )
    {
      return m_data.more;
    }
   
    inline bool FrRawData::
    operator==( const FrRawData& RHS ) const
    {
      return ( m_data == RHS.m_data );
    }

    inline bool FrRawData::fr_raw_data_type::
    operator==( const fr_raw_data_type& RHS ) const
    {
      return ( ( this == &RHS )
	       || ( ( name == RHS.name )
		    && ( firstSer == RHS.firstSer )
		    && ( firstAdc == RHS.firstAdc )
		    && ( firstTable == RHS.firstTable )
		    && ( logMsg == RHS.logMsg )
		    && ( more == RHS.more )
		    )
	       );
    }
  } // namespace - Version_8
} // namespace FrameCPP
#endif /* FrameCPP_VERSION_8_FrRawData_HH */
