#include <framecpp_config.h>

#include <memory>

#include "framecpp/Version6/FrameSpec.hh"

#include "framecpp/Version6/PTR_STRUCT.hh"
#include "framecpp/Version6/StreamRef.hh"

#include "framecpp/Version6/FrAdcData.hh"
#include "framecpp/Version6/FrameH.hh"
#include "framecpp/Version6/FrDetector.hh"
#include "framecpp/Version6/FrEndOfFile.hh"
#include "framecpp/Version6/FrEndOfFrame.hh"
#include "framecpp/Version6/FrEvent.hh"
#include "framecpp/Version6/FrHeader.hh"
#include "framecpp/Version6/FrHistory.hh"
#include "framecpp/Version6/FrMsg.hh"
#include "framecpp/Version6/FrProcData.hh"
#include "framecpp/Version6/FrRawData.hh"
#include "framecpp/Version6/FrSE.hh"
#include "framecpp/Version6/FrSerData.hh"
#include "framecpp/Version6/FrSH.hh"
#include "framecpp/Version6/FrSimData.hh"
#include "framecpp/Version6/FrSimEvent.hh"
#include "framecpp/Version6/FrStatData.hh"
#include "framecpp/Version6/FrSummary.hh"
#include "framecpp/Version6/FrTable.hh"
#include "framecpp/Version6/FrTOC.hh"
#include "framecpp/Version6/FrVect.hh"

namespace {
  const FrameCPP::Common::DetectorNames&
  dnt_init( )
  {
    static FrameCPP::Common::DetectorNames retval;

      //-----------------------------------------------------------------
      // Setup the DetectorNameTable from the appendix
      //-----------------------------------------------------------------
      typedef std::pair< int, int > dqb;

      retval( "TAMA_300", "TAMA 300",
	      "T1:", dqb( 0, 1 ) );
      retval( "Virgo_CITF", "Virgo Central Interferometer",
	      "V1:", dqb( 2, 3 ) );
      retval( "Virgo", "Virgo 3 km",
	      "V1:", dqb( 4, 5 ) );
      retval( "GEO_600", "GEO 600",
	      "G1:", dqb( 6, 7 ) );
      retval( "LHO_2k", "LIGO LHO 2 km",
	      "H2:", dqb( 8, 9 ) );
      retval( "LHO_4k", "LIGO LHO 4 km",
	      "H1:", dqb( 10, 11 ) );
      retval( "LLO_4k", "LIGO LLO 4 km",
	      "L1:", dqb( 12, 13 ) );
      retval( "CIT_40", "Caltech 40 meters",
	      "P1:", dqb( 14, 15 ) );
      retval( "ALLEGRO_<theta>", "Allegro with <theta> degrees azimuth",
	      "A1:", dqb( 16, 17 ) );
      retval( "AURIGA", "Auriga",
	      "O1:", dqb( 18, 19 ) );
      retval.Freeze( );

      return retval;
  }
}

namespace FrameCPP
{
  namespace Version_6
  {
    static const bool Initialized = init_frame_spec( );

    const Common::DetectorNames& DetectorNameTable = dnt_init( );

    bool init_frame_spec( )
    {
      using Common::FrameSpec;

      static bool initialized = false;

      if ( ! initialized )
      {
	//---------------------------------------------------------------
	// Local storage describing implementation of the frame spec
	//---------------------------------------------------------------
	std::auto_ptr< Common::FrameSpec::Info >
	  info( new Common::FrameSpec::Info( DATA_FORMAT_VERSION,
					     LIBRARY_MINOR_VERSION ) );

	info->FrameObject( new PTR_STRUCT );
	info->FrameObject( new StreamRef );

	info->FrameObject( new FrAdcData );
	info->FrameObject( new FrameH );
	info->FrameObject( new FrDetector );
	info->FrameObject( new FrEndOfFile );
	info->FrameObject( new FrEndOfFrame );
	info->FrameObject( new FrEvent );
	info->FrameObject( new FrHeader );
	info->FrameObject( new FrHistory );
	info->FrameObject( new FrMsg );
	info->FrameObject( new FrProcData );
	info->FrameObject( new FrRawData );
	info->FrameObject( new FrSE );
	info->FrameObject( new FrSerData );
	info->FrameObject( new FrSH );
	info->FrameObject( new FrSimData );
	info->FrameObject( new FrSimEvent );
	info->FrameObject( new FrStatData );
	info->FrameObject( new FrSummary );
	info->FrameObject( new FrTable );
	info->FrameObject( new FrTOC );
	info->FrameObject( new FrVect );

	//---------------------------------------------------------------
	// Register with the stream manipulator
	//---------------------------------------------------------------
	FrameSpec::SpecInfo( FrameSpec::version_type( DATA_FORMAT_VERSION ),
			     info.release( ) );
	initialized = true;
      }
      return true;
    }

#ifndef SWIGIMPORTED
    extern const Common::DetectorNames&	DetectorNameTable;
#endif /* SWIGIMPORTED */

  } // namespace - Version_6
} // namespace - FrameCPP
