#include "framecpp/Common/Description.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version4/FrameSpec.hh"
#include "framecpp/Version4/FrTOCTable.hh"
#include "framecpp/Version4/FrSE.hh"
#include "framecpp/Version4/FrSH.hh"
#include "framecpp/Version4/FrTOC.hh"

#include "framecpp/Version4/STRING.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::TOCInfo;

namespace FrameCPP
{
  namespace Version_4
  {
    //===================================================================
    //===================================================================
    void FrTOCTable::
    Description( Common::Description& Desc )
    {
      Desc( FrSE( "nTable", "INT_4U",
		  "Number of unique FrTable names in file." ) );
      Desc( FrSE( "nameTable", "*STRING", "Array of FrTable names" ) );
      Desc( FrSE( "positionTable", "*INT_8U",
		  "Array of lists of FrTable offset positions, in bytes,"
		  " from beginning of file (size of nFrame*nTable)"
		  ) );
    }

    void FrTOCTable::
    QueryTable( const Common::TOCInfo& Info,
	       INT_4U FrameOffset,
	       INT_8U Position )
    {
      STRING	name;

      Info.TOCQuery( TOCInfo::IC_NAME, TOCInfo::DT_STRING_2, &name,
		     TOCInfo::IC_EOQ );

      table_info_type& i( m_info[ name ] );
      i.resize( FrameOffset + 1 );
      i[ FrameOffset ] = Position;
    }
  } // namespace - Version_4
} // namespace - FrameCPP
