#include "framecpp/Common/Description.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version4/FrameSpec.hh"
#include "framecpp/Version4/FrTOCSimData.hh"
#include "framecpp/Version4/FrSE.hh"
#include "framecpp/Version4/FrSH.hh"
#include "framecpp/Version4/FrTOC.hh"

#include "framecpp/Version4/STRING.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::TOCInfo;

namespace FrameCPP
{
  namespace Version_4
  {
    //===================================================================
    //===================================================================
    void FrTOCSimData::
    Description( Common::Description& Desc )
    {
      Desc( FrSE( "nSim", "INT_4U",
		  "Number of unique FrSimData names in file." ) );
      Desc( FrSE( "nameSim", "*STRING", "Array of FrSimData names" ) );
      Desc( FrSE( "positionSim", "*INT_8U",
		  "Array of lists of FrSimData offset positions, in bytes,"
		  " from beginning of file (size of nFrame*nSim)"
		  ) );
    }

    void FrTOCSimData::
    QuerySim( const Common::TOCInfo& Info,
	       INT_4U FrameOffset,
	       INT_8U Position )
    {
      STRING	name;

      Info.TOCQuery( TOCInfo::IC_NAME, TOCInfo::DT_STRING_2, &name,
		     TOCInfo::IC_EOQ );

      sim_info_type& i( m_info[ name ] );
      i.resize( FrameOffset + 1 );
      i[ FrameOffset ] = Position;
    }

    //-------------------------------------------------------------------
    /// This method allows for iterting over each element of information
    /// and allows the caller to gather information about each element.
    //-------------------------------------------------------------------
    void FrTOCSimData::
    forEach( Common::FrTOC::query_info_type Info,
	     Common::FrTOC::FunctionBase& Action ) const
    {
      switch( Info )
      {
      case Common::FrTOC::TOC_CHANNEL_NAMES:
	{
	  try
	  {
	    Common::FrTOC::FunctionString&
	      action( dynamic_cast< Common::FrTOC::FunctionString& >
		      ( Action ) );

	    for ( MapSim_type::const_iterator
		    cur = m_info.begin( ),
		    last = m_info.end( );
		  cur != last;
		  ++cur )
	    {
	      action( cur->first );
	    }
	  }
	  catch( ... )
	  {
	    // Does not understand Action
	  }
	}
	break;
      default:
	//---------------------------------------------------------------
	// ignore all other requests
	//---------------------------------------------------------------
	break;
      }
    }

  } // namespace - Version_4
} // namespace - FrameCPP
