/* -*- mode: c++ -*- */
#ifndef IFRAME_FSTREAM_I
#define IFRAME_FSTREAM_I

%module frameCPP

%{
#include "IFrameStream.hh"
%}

%import "framecpp/Common/FrHeader.hh"

class IFrameFStream
{
public:
  typedef FR_HEADER__VERSION_TYPE			version_type;
  typedef FR_HEADER__FRAME_LIBRARY_TYPE			frame_library_type;
  typedef FR_HEADER__LIBRARY_REVISION_TYPE		library_revision_type;

  typedef FrameCPP::Common::IFrameStream::size_type	size_type;
  typedef LDASTools::AL::SharedPtr< FrDetector >	fr_detector_type;
  typedef LDASTools::AL::SharedPtr< FrEvent >		fr_event_type;
  typedef LDASTools::AL::SharedPtr< FrAdcData >		fr_adc_data_type;
  typedef LDASTools::AL::SharedPtr< FrProcData >	fr_proc_data_type;
  typedef LDASTools::AL::SharedPtr< FrSimData >		fr_sim_data_type;
  typedef LDASTools::AL::SharedPtr< FrameH >		frame_h_type;

  IFrameFStream( const char* Filename );

  frame_library_type FrameLibrary( ) const;

  std::string FrameLibraryName( ) const;

  size_type GetNumberOfFrames( ) const;

  const FrTOC& GetTOC( ) const;

  library_revision_type LibraryRevision( ) const;

  fr_detector_type ReadDetector( const std::string& Name );

  fr_event_type ReadFrEvent( INT_4U Frame, const std::string& Channel );

  fr_adc_data_type ReadFrAdcData( INT_4U Frame, const std::string& Channel );

  fr_proc_data_type ReadFrProcData( INT_4U Frame, const std::string& Channel );

  fr_sim_data_type ReadFrSimData( INT_4U Frame, const std::string& Channel );

  frame_h_type ReadFrameN( INT_4U Index );

  frame_h_type ReadNextFrame( );

  version_type Version( ) const;
};

#endif /* IFRAME_FSTREAM_I */
