/* -*- mode: c++ -*- */

%module LDASframe

%{
#include "framecpp/FrVect.hh"
#include "Channel.hh"

  using FrameCPP::FrVect;
  using FrameCPP::Common::FrameSpec;

%}

#if 0
%import "framecpp/frameCPPPython.i"
%import "framecpp/DataTypes.i"
%import "framecpp/GPSTime.i"
%import "framecpp/STRING.i"
%import "framecpp/Dimension.i"
#endif /* 0 */

%include "ldastoolsal/SharedPtr.i"
%import(module="frameCPP") "framecpp/FrVect.hh"

 // %import "framecpp/FrAdcData.i"
%import "framecpp/FrProcData.i"
%import "framecpp/FrSimData.i"

%import "Channel.hh"

%SharedPtr(FrVect)

%nodefaultctor Channel;

class Channel
{
 public:
  typedef CHANNEL_NAME_TYPE	name_type;
  typedef CHANNEL_UNIT_Y_TYPE	unitY_type;

#ifdef SWIGPYTHON
  typedef Container< FrVect > data_type;
#else /* SWIGPYTHON */
  using FrameCPP::FrProcData::data_type;
#endif /* SWIGPYTHON */
  

  name_type GetName( ) const;
  unitY_type GetUnitY( ) const;

  data_type& RefData( );

  LDAS_PROPERTY_READ_ONLY("name",GetName)
  LDAS_PROPERTY_READ_ONLY("unitY",GetUnitY)
  LDAS_PROPERTY_READ_ONLY("data",RefData)
};

#if ! SWIGIMPORTED
%{
  Channel::data_type&
  Channel_RefData( Channel* Self )
  {
    return Self->RefData( );
  }
%}
#endif /* ! SWIGIMPORTED */
