#ifndef FRAME_API__SAM_FS_LOADER_HH
#define FRAME_API__SAM_FS_LOADER_HH

#include "ldastoolsal/SOLoader.hh"

namespace FrameAPI
{
  class SAMFSLoader
    : public LDASTools::AL::SOLoader
  {
  public:
    //: Constructor
    SAMFSLoader( );

    int Stage( const std::string& Path, const std::string& Ops ) const;

  private:
    typedef int (*stage_func_type)( const char*, const char* );

    stage_func_type	m_func_stage;
  };

  inline int SAMFSLoader::
  Stage( const std::string& Path, const std::string& Ops ) const
  {
    if ( m_func_stage )
    {
      return (*m_func_stage)( Path.c_str( ), Ops.c_str( ) );
    }
    return 0;
  }
}
#endif /* FRAME_API__SAM_FS_LOADER_HH */
