dnl======================================================================
dnl LDAS_CHECK_OS_LIBRARY_PATH_SUPPORT
dnl   Check for the operating system supports overwriting of library
dnl   search path via environment variable.
dnl======================================================================

AC_DEFUN([AX_LDAS_CHECK_OS_LIBRARY_PATH_SUPPORT],[ dnl
  ldas_os_library_path_support="yes"
  AS_CASE([$build_os],
	  [darwin*],[ v=[`]echo ${build_os} \| sed -e 's,darwin,,'[`]
	             AS_VERSION_COMPARE([$v],dnl version-1
		                        [14.0.0], dnl version-2
				        [], dnl less than
				        [ldas_os_library_path_support="no"], dnl equal to
				        [ldas_os_library_path_support="no"] dnl greater than
		    ])
  )
  AM_CONDITIONAL([LDAS_OS_LIBRARY_PATH_SUPPORT],[test x$ldas_os_library_path_support = xyes])
]) dnl AC_DEFUN - AX_LDAS_CHECK_OS_LIBRARY_PATH_SUPPORT
