#ifndef DISKCACHE__CACHE__EXCLUDED_PATTERN_HH
#define DISKCACHE__CACHE__EXCLUDED_PATTERN_HH

#include <list>
#include <string>

#include "ldastoolsal/regex.hh"
#include "ldastoolsal/regexmatch.hh"
#include "ldastoolsal/Singleton.hh"

#include "genericAPI/Logging.hh"

#include "ExcludedDirectories.hh"

namespace diskCache
{
  namespace Cache
  {
    //-------------------------------------------------------------------
    /// \brief Manages set of filename exclusion patterns
    //-------------------------------------------------------------------
    class ExcludedPattern
      : public LDASTools::AL::Singleton< ExcludedPattern >
    {

    public:
      typedef std::list< std::string> pattern_container_type;
      typedef pattern_container_type::value_type value_type;

      ExcludedPattern( );

      ~ExcludedPattern( );

      //-----------------------------------------------------------------
      /// \brief Retrieve collection of file name patterns to exclude
      //-----------------------------------------------------------------
      static const pattern_container_type& Get( );

      //-----------------------------------------------------------------
      /// \brief Check if the file should be excluded
      ///
      /// \param[in] Filename
      ///     Name of file to be checked for exclusion
      ///
      /// \return
      ///  If Filename is to be excluded, then return true;
      ///  false otherwise
      //-----------------------------------------------------------------
      static bool IsExcluded( const value_type& Filename );

      //-----------------------------------------------------------------
      /// \brief Change the matching patterns
      ///
      /// \param[in] Patterns
      ///     List of patterns that descibe the files which should be
      ///     excluded (ex: ".*[.]tmp")
      ///
      /// \return
      ///  If Filename is to be excluded, then return true;
      ///  false otherwise
      //-----------------------------------------------------------------
      static void Update( const pattern_container_type& Patterns );

    private:
      pattern_container_type	readable_pattern;
      Regex			pattern;

      const pattern_container_type& get( ) const;

      bool is_excluded( const value_type& Filename ) const;

      void update( const pattern_container_type& Patterns );
    };

  } /* namespace - Cache */
} /* namespace - diskCache */

#endif /* DISKCACHE__CACHE__EXCLUDED_PATTERN_HH */
