#ifndef DISKCACHE__CACHE__EXCLUDED_DIRECTORIES_HH
#define DISKCACHE__CACHE__EXCLUDED_DIRECTORIES_HH

#include <list>
#include <string>

#include "ldastoolsal/regex.hh"
#include "ldastoolsal/regexmatch.hh"

namespace diskCache
{
  namespace Cache
  {
    class ExcludedDirectories
    {
    public:
      typedef std::list< std::string > directory_container_type;
      typedef directory_container_type::value_type value_type;
      typedef void (*callback_type)( );

      ExcludedDirectories( );

      bool IsExcluded( const value_type& Directory ) const;

      void Update( const directory_container_type& Directories );

      void OnUpdate( callback_type Callback );
      
    private:
      typedef std::list< callback_type > callback_container_type;

      Regex			pattern;
      callback_container_type	callbacks;
    };

    inline bool ExcludedDirectories::
    IsExcluded( const value_type& Directory ) const
    {
      RegexMatch	compare( 1 );

      //-----------------------------------------------------------------
      // If the pattern is found, then it should be excluded.
      //-----------------------------------------------------------------
      return compare.match( pattern,
			    Directory.c_str( ) );
    }

    inline void ExcludedDirectories::
    OnUpdate( callback_type Callback )
    {
      callbacks.push_back( Callback );
    }
  }
}

#endif /* DISKCACHE__CACHE__EXCLUDED_DIRECTORIES_HH */
