#include <diskcache_config.h>

#include <iostream>

#include "diskcacheAPI/Streams/ASCII.hh"

#include "diskcacheAPI/Cache/DirectoryManager.hh"

namespace diskCache
{
  namespace Cache
  {
    typedef Streams::OASCII OStream;

    template<>
    OStream& DirectoryManager::
    Write( OStream& Stream )
    {
      const directory_container_ro_type
	container( directory_container_ro( ) );

      for ( directory_container_type::const_iterator
	      cur = container.Var( ).begin( ),
	      last = container.Var( ).end( );
	    cur != last;
	    ++cur )
      {
	cur->second->Write( Stream );
      }
      return Stream;
    }

  } // namespace - diskCache::Cache
} // namespace - diskCache
