/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.openscience.jmol.app.janocchio.CoupleColourSelectionPanel;
import org.openscience.jmol.app.janocchio.CoupleParameterSelectionPanel;
import org.openscience.jmol.app.janocchio.FrameDeltaDisplay;
import org.openscience.jmol.app.janocchio.Measure;
import org.openscience.jmol.app.janocchio.MeasureCouple;
import org.openscience.jmol.app.janocchio.NMRTableCellRenderer;
import org.openscience.jmol.app.janocchio.NMR_JmolPanel;
import org.openscience.jmol.app.janocchio.NMR_Viewer;
import org.openscience.jmol.app.janocchio.NmrMolecule;

public class CoupleTable
extends JTabbedPane {
    NMR_Viewer viewer;
    int natomsPerModel;
    String[] labelArray;
    boolean molCDKuptodate = false;
    NmrMolecule calcProps;
    String[][] expCouples;
    JTable coupleTable;
    private CoupleTableModel coupleTableModel;
    private ListSelectionModel coupleSelection;
    int[] selectedCoupleRow = new int[2];
    JButton coupledeleteButton;
    JButton coupleAddAllButton;
    private JButton coupledeleteAllButton;
    final double degtorad = Math.PI / 180;
    double yellowValue = 2.0;
    double redValue = 3.0;
    FrameDeltaDisplay frameDeltaDisplay;
    String CHequation = "was";
    NMRTableCellRenderer colorCellRenderer = new NMRTableCellRenderer();
    public CoupleColourSelectionPanel coupleColourSelectionPanel;
    protected NMR_JmolPanel nmrPanel;

    public CoupleTable(NMR_JmolPanel nmrPanel, JFrame parentFrame) {
        this.nmrPanel = nmrPanel;
        this.viewer = (NMR_Viewer)nmrPanel.vwr;
        JPanel mainTable = new JPanel();
        mainTable.setLayout(new BorderLayout());
        mainTable.add((Component)this.constructCoupleTable(), "Center");
        JPanel foo = new JPanel();
        foo.setLayout(new BorderLayout());
        foo.add((Component)this.constructCoupleButtonPanel(), "West");
        mainTable.add((Component)foo, "South");
        this.addTab("Table", null, mainTable, "Table of Selected Coupling Constants");
        CoupleParameterSelectionPanel coupleParameterSelectionPanel = new CoupleParameterSelectionPanel(this);
        this.addTab("Parameters", null, coupleParameterSelectionPanel, "Parameter Setting");
        this.coupleColourSelectionPanel = new CoupleColourSelectionPanel(this);
        this.addTab("Cell Colours", null, this.coupleColourSelectionPanel, "Cell Colour Setting");
        this.selectedCoupleRow[1] = -1;
        this.selectedCoupleRow[0] = -1;
    }

    JComponent constructCoupleTable() {
        this.coupleTableModel = new CoupleTableModel();
        this.coupleTable = new JTable(this.coupleTableModel);
        TableColumn tc = this.coupleTable.getColumnModel().getColumn(1);
        this.colorCellRenderer.setYellowLevel(this.yellowValue);
        this.colorCellRenderer.setRedLevel(this.redValue);
        tc.setCellRenderer(this.colorCellRenderer);
        this.coupleTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.coupleTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        int i = 5;
        while (--i > 0) {
            this.coupleTable.getColumnModel().getColumn(i).setPreferredWidth(15);
        }
        this.coupleTable.setSelectionMode(1);
        this.coupleTable.setRowSelectionAllowed(true);
        this.coupleTable.setColumnSelectionAllowed(false);
        this.coupleSelection = this.coupleTable.getSelectionModel();
        this.coupleSelection.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    CoupleTable.this.selectedCoupleRow[1] = -1;
                    CoupleTable.this.selectedCoupleRow[0] = -1;
                    CoupleTable.this.coupledeleteButton.setEnabled(false);
                } else if (lsm.getMinSelectionIndex() != lsm.getMaxSelectionIndex()) {
                    CoupleTable.this.selectedCoupleRow[0] = lsm.getMinSelectionIndex();
                    CoupleTable.this.selectedCoupleRow[1] = lsm.getMaxSelectionIndex();
                } else {
                    CoupleTable.this.selectedCoupleRow[0] = lsm.getMinSelectionIndex();
                    CoupleTable.this.selectedCoupleRow[1] = lsm.getMaxSelectionIndex();
                    CoupleTable.this.coupledeleteButton.setEnabled(true);
                }
            }
        });
        return new JScrollPane(this.coupleTable);
    }

    JComponent constructCoupleButtonPanel() {
        JPanel coupleButtonPanel = new JPanel();
        coupleButtonPanel.setLayout(new FlowLayout(0));
        this.coupleAddAllButton = new JButton(GT.$("Add All"));
        this.coupleAddAllButton.setToolTipText("Add all 1H-1H Couplings");
        this.coupleAddAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoupleTable.this.viewer.scriptWait("measure search '{[H]}CC{[H]}'");
                CoupleTable.this.updateCoupleTableData();
            }
        });
        this.coupleAddAllButton.setEnabled(true);
        this.coupledeleteButton = new JButton(GT.$("Del"));
        this.coupledeleteButton.setToolTipText("Delete Selected Couplings");
        this.coupledeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ndelete = CoupleTable.this.selectedCoupleRow[1] - CoupleTable.this.selectedCoupleRow[0] + 1;
                int[] deletevRows = new int[ndelete];
                int j = 0;
                for (int i = CoupleTable.this.selectedCoupleRow[0]; i <= CoupleTable.this.selectedCoupleRow[1]; ++i) {
                    deletevRows[j++] = CoupleTable.this.getViewerRow(i);
                }
                Arrays.sort(deletevRows);
                int i = ndelete;
                while (--i >= 0) {
                    CoupleTable.this.viewer.deleteMeasurement(deletevRows[i]);
                }
                CoupleTable.this.updateCoupleTableData();
            }
        });
        this.coupledeleteButton.setEnabled(false);
        this.coupledeleteAllButton = new JButton(GT.$("Del All"));
        this.coupledeleteAllButton.setToolTipText("Delete All Couplings");
        this.coupledeleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = CoupleTable.this.coupleTable.getRowCount();
                while (--i >= 0) {
                    CoupleTable.this.viewer.deleteMeasurement(CoupleTable.this.getViewerRow(i));
                }
                CoupleTable.this.updateCoupleTableData();
            }
        });
        this.coupledeleteAllButton.setEnabled(false);
        coupleButtonPanel.add(this.coupleAddAllButton);
        coupleButtonPanel.add(this.coupledeleteButton);
        coupleButtonPanel.add(this.coupledeleteAllButton);
        return coupleButtonPanel;
    }

    protected int getViewerRow(int i) {
        return this.nmrPanel.getViewerRow(i, 7);
    }

    JComponent constructDismissButtonPanel() {
        JPanel dismissButtonPanel = new JPanel();
        dismissButtonPanel.setLayout(new FlowLayout(2));
        JButton dismissButton = new JButton(GT.$("Dismiss"));
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoupleTable.this.close();
            }
        });
        dismissButtonPanel.add(dismissButton);
        return dismissButtonPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    public void close() {
        this.setVisible(false);
    }

    public void activate() {
        this.updateCoupleTableData();
        this.setVisible(true);
    }

    void updateCoupleTableData() {
        this.coupledeleteAllButton.setEnabled(this.viewer.getMeasurementCount() > 0);
        this.coupleTableModel.fireTableDataChanged();
        this.calcFrameDelta();
        this.nmrPanel.clearViewerSelection();
    }

    public int getRowCount() {
        return this.coupleTableModel.getRowCount();
    }

    public int[] getMeasurementCountPlusIndices(int row) {
        return this.coupleTableModel.getMeasurementCountPlusIndicesForTableRow(row);
    }

    private void calcFrameDelta() {
        int n = this.coupleTableModel.getRowCount();
        double frameDelta = 0.0;
        for (int i = 0; i < n; ++i) {
            Measure measure = (Measure)this.coupleTableModel.getValueAt(i, 1);
            if (measure == null) continue;
            frameDelta += measure.getDiff();
        }
        this.frameDeltaDisplay.setFrameDeltaCouple(frameDelta);
    }

    public void updateTables() {
        this.updateCoupleTableData();
    }

    int calcNatomsPerModel() {
        return this.nmrPanel.getFrameAtomCount();
    }

    public void addMol() {
        this.calcProps = this.nmrPanel.getDistanceJMolecule(null, this.labelArray, false);
        this.calcProps.setCHequation(this.CHequation);
        this.molCDKuptodate = true;
    }

    public void setmolCDKuptodate(boolean value) {
        this.molCDKuptodate = value;
    }

    public void allocateLabelArray(int numAtoms) {
        this.labelArray = new String[numAtoms];
    }

    public void allocateExpCouples(int numAtoms) {
        this.expCouples = new String[numAtoms][numAtoms];
    }

    public String getExpCouple(int i, int j) {
        return this.expCouples[i][j];
    }

    public void setExpCouple(String value, int i, int j) {
        if (value.trim().length() == 0) {
            value = null;
        }
        this.expCouples[i][j] = value;
        this.expCouples[j][i] = value;
    }

    public void setLabelArray(String[] labelArray) {
        this.labelArray = labelArray;
    }

    public void setRedValue(double value) {
        this.redValue = value;
        this.colorCellRenderer.setRedLevel(this.redValue);
    }

    public void setYellowValue(double value) {
        this.yellowValue = value;
        this.colorCellRenderer.setYellowLevel(this.yellowValue);
    }

    public double getRedValue() {
        return this.redValue;
    }

    public double getYellowValue() {
        return this.yellowValue;
    }

    public void setCHequation(String eq) {
        this.CHequation = eq;
        this.setmolCDKuptodate(false);
    }

    public void setFrameDeltaDisplay(FrameDeltaDisplay frameDeltaDisplay) {
        this.frameDeltaDisplay = frameDeltaDisplay;
    }

    class CoupleTableModel
    extends AbstractTableModel {
        final String[] coupleHeaders = new String[]{GT.$("Angle"), GT.$("J"), "Atom 1", "Atom 2", "Exp J"};

        CoupleTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.coupleHeaders[col];
        }

        @Override
        public int getRowCount() {
            CoupleTable.this.natomsPerModel = CoupleTable.this.calcNatomsPerModel();
            int rowCount = 0;
            for (int i = 0; i < CoupleTable.this.viewer.getMeasurementCount(); ++i) {
                if (CoupleTable.this.nmrPanel.getViewerMeasurement(i, 7) == null) continue;
                ++rowCount;
            }
            return rowCount;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        public int[] getMeasurementCountPlusIndicesForTableRow(int row) {
            return CoupleTable.this.viewer.getMeasurementCountPlusIndices(CoupleTable.this.getViewerRow(row));
        }

        @Override
        public Object getValueAt(int row, int col) {
            int atomIndex;
            int vRow;
            Atom[] atoms;
            double[] dihecouple;
            MeasureCouple measure;
            if (!CoupleTable.this.molCDKuptodate) {
                CoupleTable.this.addMol();
            }
            MeasureCouple measureCouple = measure = (dihecouple = CoupleTable.this.calcProps.calcCouple(atoms = CoupleTable.this.nmrPanel.getViewerMeasurement(vRow = CoupleTable.this.getViewerRow(row), 7))) == null ? null : new MeasureCouple(CoupleTable.this.expCouples[CoupleTable.this.viewer.indexInFrame(atoms[0])][CoupleTable.this.viewer.indexInFrame(atoms[3])], dihecouple[1]);
            if (col == 0) {
                return Measure.formatDistance(dihecouple == null ? 0.0 : dihecouple[0] / (Math.PI / 180));
            }
            if (col == 1) {
                return measure;
            }
            if (col == 4) {
                return measure == null ? "" : measure.getExpValue();
            }
            int n = atomIndex = col == 2 ? atoms[0].i : atoms[3].i;
            if (atomIndex < 0) {
                return "";
            }
            String name = CoupleTable.this.labelArray[atomIndex];
            String reserve = "" + CoupleTable.this.viewer.getAtomNumber(atomIndex) + " " + CoupleTable.this.viewer.getAtomName(atomIndex);
            if (name == null) {
                name = reserve;
                return name;
            }
            if (name.trim().length() == 0) {
                name = reserve;
            }
            return name;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 4) {
                String val = (String)value;
                if (val.trim().length() == 0) {
                    val = null;
                }
                try {
                    Double.valueOf(val);
                }
                catch (Exception e) {
                    val = null;
                }
                int vRow = CoupleTable.this.getViewerRow(row);
                int[] countPlusIndices = CoupleTable.this.getMeasurementCountPlusIndices(vRow);
                CoupleTable.this.expCouples[countPlusIndices[1]][countPlusIndices[4]] = val;
                CoupleTable.this.expCouples[countPlusIndices[4]][countPlusIndices[1]] = val;
                CoupleTable.this.updateCoupleTableData();
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 4;
        }
    }

    class CoupleListWindowListener
    extends WindowAdapter {
        CoupleListWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            CoupleTable.this.close();
        }
    }
}

