import HsShellScript
import Maybe
import Posix
import System
import IO

main = mainwrapper main'

main' = do
   -- Call an action as a separate process. Get exit code.
   ec <- exitcode $ call (putStrLn "Hallo." >> exitWith (ExitFailure 42))
   putStrLn ("1. ec = " ++ show ec)

   -- Run external program.
   putStr ("\n2. ")
   echo run "ls" ["/"]
   putStr ("\n3. ")
   echo run "/bin/echo" ["Hallo"]
   
   -- Redirection
   -- wrong: run "sort" [] -<- "/etc/group" ->- "/tmp/sorted"
   putStrLn ("\n4. sort < /etc/fstab > /tmp/sorted")
   call (execp "sort" [] -<- "/etc/group" ->- "/tmp/sorted")

   -- Pipes
   putStrLn "\n5."
   pipe_to "some\ntext\nwith\nsome\nword\nmultiply" $ 
      call (exec "/usr/bin/sort" [] -|- exec "/usr/bin/uniq" [])

   -- Paths
   putStrLn "\nPaths:"
   print (split_path "/a/b/c")   

   -- readlink
   putStrLn "\nreadlink 1:"
   target <- mainwrapper $ readlink "/usr/local/share/statisch"
   print target
   {-putStrLn "\nreadlink 2:"
   target <- mainwrapper $ readlink "/usr/local/share"
   print target-}

   -- pwd
   putStrLn "getcwd/pwd:"
   cd "/tmp"
   symlink "." "symlink"
   cd "symlink"
   _pwd <- pwd
   _getcwd <- getCurrentDirectory
   putStrLn ("pwd =    " ++ _pwd ++ "\ngetcwd = " ++ _getcwd)
   rm "symlink"
