/* 
This file is only (potentially) used for via-C compilations of programs using HsShellScript. It is _not_ used by any part of HsShellScript.

The GHC user guide says in section 4.8.4:

"c_includes: A list of files to include for via-C compilations using this package. Typically this include file will contain function prototypes for
any C functions used in the package, in case they end up being called as a result of Haskell functions from the package being inlined." 

Thus, for via-C compilations, the prototypes - _only_ the prototypes - of the C functions are needed. C2hs puts all C code it finds in a .h file -
prototypes and function bodies alike. Therefore the c2hs output can't be used. 

This file needs to be manually keep in sync with the C code in the .chs files, therefore I might easily become outdated...
*/

#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

/* not reentrant */
char* hsshellscript_get_realpath(char* path);

/* not reentrant */
char* hsshellscript_get_readlink(char* path);

int hsshellscript_open_nonvariadic(const char *pathname, int flags, mode_t mode);

int hsshellscript_o_creat_excl(void);

int hsshellscript_eexist(void);
