---
-- This is the main module of HsShellScript. It is the only module meant to be
-- used directly by applications. The module itself copes with naming
-- stuff. It imports and exports the HsShellScript modules, as well as some system
-- modules. Most scripts should not need to to import anything besides
-- <code>HsShellScript</code>. 
-- @version 0.9
module HsShellScript (
              -- * Command Line Arguments
                module HsShellScript.Args
              -- * Specific External Commands
              , module HsShellScript.Commands
              -- * Miscellaneous
              , module HsShellScript.Misc
              -- * Parsing and Composing Paths
              , module HsShellScript.Paths
              , module HsShellScript.ProcErr
              , mainwrapper
              -- * Calling a Shell, and Quoting for Shells
              , module HsShellScript.Shell

              -- * Reexported Standard Library Stuff for Exception Handling
              , Control.Exception.Exception (..)
              , Control.Exception.IOException
              , Control.Exception.ArithException (..)
              , Control.Exception.ArrayException (..)
              , Control.Exception.AsyncException (..)
              , Control.Exception.throw
              , Control.Exception.ioError
              , Control.Exception.throwTo
              , Control.Exception.catchJust
              , Control.Exception.handle
              , Control.Exception.handleJust
              , Control.Exception.tryJust
              , Control.Exception.evaluate
              , Control.Exception.ioErrors
              , Control.Exception.arithExceptions
              , Control.Exception.errorCalls
              , Control.Exception.dynExceptions
              , Control.Exception.assertions
              , Control.Exception.asyncExceptions
              , Control.Exception.userErrors
              , Control.Exception.throwDyn
              , Control.Exception.throwDynTo
              , Control.Exception.catchDyn
              , Control.Exception.block
              , Control.Exception.unblock
              , Control.Exception.assert
              , Control.Exception.finally
              , Data.Dynamic.toDyn
              , Data.Dynamic.fromDyn
              , Data.Dynamic.fromDynamic
              , Data.Dynamic.dynApply
              , Data.Dynamic.dynApp
              , Data.Dynamic.Typeable (..)
              , Data.Dynamic.TypeRep
              , Data.Dynamic.TyCon
              , Data.Dynamic.mkTyCon
              , Data.Dynamic.mkAppTy
              , Data.Dynamic.mkFunTy
              , Data.Dynamic.applyTy
              , Directory.Permissions (..)
              , Directory.createDirectory
              , Directory.removeDirectory
              , Directory.renameDirectory
              , Directory.getDirectoryContents
              , Directory.getCurrentDirectory
              , Directory.setCurrentDirectory
              , Directory.removeFile
              , Directory.renameFile
              , Directory.doesFileExist
              , Directory.doesDirectoryExist
              , Directory.getPermissions
              , Directory.setPermissions
              , Directory.getModificationTime
              , Posix.fileAccess
              )
where

import System
import List
import Monad
import System.Console.GetOpt
import Maybe
import IO
import Random
import HsShellScript.Args
import HsShellScript.Commands
import HsShellScript.Shell
import HsShellScript.Paths
import HsShellScript.ProcErr
import HsShellScript.Misc
import Control.Exception
import Data.Dynamic
import Directory
import Posix       -- from hslibs, _not_ System.Posix
import GHC.IOBase


{- | Error reporting wrapper for the @main@ function. This catches any
   HsShellScript generated exception, and @IOError@s from the @IO@ library. prints
   an error message and exits with @exitFailure@. The @main@ function
   typically looks like this:

                         >main = mainwrapper main'

   The exceptions caught are @ArgError@, @ProcessStatus@, @IOError@.
-}
mainwrapper :: IO a     -- ^ Should be @main@
            -> IO a     -- ^ Wrapped @main@
mainwrapper io =
    io
    `catchDyn`
       (\argerror -> do
           hPutStrLn stderr $ (argerror_message argerror) ++ "\n\n" ++ (argerror_usageinfo argerror)
           exitFailure
       )
    `catchDyn`
       (\processstatus -> do
           hPutStrLn stderr $ "Process error. process status = " ++ show ( processstatus :: ProcessStatus )
           exitFailure
       )
    `IO.catch`
       (\ioe -> do
           hPutStrLn stderr (show_ioerror ioe)
           exitFailure
       )

