import HsShellScript
import Arg
import Posix
import CDs
import Monad
import System
import Maybe
import IO
import Kommandos

progname   = "cd-auslagern"
header     = progname ++ " [Optionen] Verzeichnisse"

descs      = [ d_iso, d_loop, d_blank, d_speed, d_dirs, d_overburn, d_labels, d_unecht, d_echo, d_jolietlong, d_keinjoliet, d_offen ]

d_jolietlong = 
    argdesc [ desc_at_most_once
            , desc_long "joliet-long"
            , desc_description "Parameter -joliet-long fr mkisofs" 
            ]

d_keinjoliet = 
    argdesc [ desc_at_most_once
            , desc_long "kein-joliet"
            , desc_description "kein Joliet (-J fr mkisofs) verwenden" 
            ]

d_offen = 
    argdesc [ desc_at_most_once
            , desc_long "offen"
            , desc_description "CD-Verzeichnis schreibbar halten"
            ]



main = mainwrapper main'

main' = do
   (macheiso, mounteiso, brenne, verzl, blank, geschw, labels, overburn, echt, echo, jolietlong, keinjoliet, offen) <- kzp
   bin_root <- test_root

   -- ber die zu brennenden CDs iterieren
   mapM_ (\(verz,       -- Verzeichnisname der eingelagerten CD
            loopnr,     -- loop device-Nummer, falls --loop verwendet wird
            label       -- volume label fr die CD
           ) -> do
             let iso     = "/tmp/" ++ dn ++ ".iso"
                 dn      = snd (split_path verz)
                 mkisofs = ( "/usr/bin/mkisofs"
                           , par_iso 
                             ++ (if jolietlong then ["-joliet-long"] else [])
                             ++ (if keinjoliet then [] else ["-J"])
                             ++ ["-quiet", "-r", "-V", label, verz]
                           )
                 par_iso = if macheiso then ["-o", iso] else []

                 ausf    = run_ee echt echo

                 mkdir dir = ("mkdir", [dir])


             when macheiso $ 
                -- ISO-Bild erstellen. GgF. auch brennen, siehe unten. Ausnahme falls Fehler.
                uncurry ausf mkisofs

             when mounteiso $ do
                -- ISO-Bild mounten. Kann trotzdem auch gebrannt werden.
                let mp      = "/tmp/" ++ dn
                    loopdev = "/dev/loop" ++ show loopnr
                uncurry ausf (mkdir mp)
                let mount = ("mount", ["-tiso9660", "-oro,loop=" ++ loopdev, iso, mp])
                if bin_root 
                   then uncurry ausf mount >>
                        putStrLn ("gemountet auf " ++ shell_quote mp)
                   else putStrLn ("Mounten mit " ++ uncurry shell_command mount)

             when brenne $ do
                let cdrecord     = ( "/usr/bin/cdrecord"
                                   , ["-v"] ++ par_blank ++ par_overburn ++ ["dev=0,5,0", "speed=" ++ geschw, "fs=16m"] 
                                     ++ par_track
                                   )
                    par_blank    = if blank then ["blank=fast"] else []
                    par_track    = if macheiso then [iso] else ["-"]
                    par_overburn = if overburn then ["-raw","-overburn"] else []
                if macheiso 
                   then -- Eben erstelltes ISO-Bild brennen.
                        uncurry (run_ee echt True) cdrecord
                   else -- Dateien beim Brennen aufsammeln. Kein ISO-Bild auf der Platte. Ausnahme falls Fehler.
                        do putStrLn $ "\n" ++ uncurry shell_command mkisofs ++ " \\\n| " ++ uncurry shell_command cdrecord ++ "\n"
                           -- Dadurch, da eine rechtshndige Pipe verwendet wird, wartet call auf cdrecord, und nicht auf mkisofs. 
                           -- mkisofs wiederum ist cdrecord untergeordnet, so da es bei der Fehlerbehandlung hinkommt.
                           call (uncurry exec mkisofs -|= uncurry exec cdrecord)
                             `catchDyn`
                                (\processstatus -> do
                                    -- Die Pipe ist fehlgeschlagen. cdrecord abschlieen.
                                    hPutStrLn stderr "\nFehlschlag. Ggf. --joliet-long oder --kein-joliet verwenden."
                                    hPutStrLn stderr $ "process status = " ++ show ( processstatus :: ProcessStatus ) ++ "\n"
                                    exitFailure
                                )
{-
                           call (uncurry exec mkisofs -|- uncurry exec cdrecord)
                             `catchDyn`
                                (\processstatus -> do
                                    -- Die Pipe ist fehlgeschlagen. cdrecord abschlieen.
                                    hPutStrLn stderr "mkiosfs ist fehlgeschlagen. Ggf. --joliet-long oder --kein-joliet verwenden."
                                    hPutStrLn stderr $ "process status = " ++ show ( processstatus :: ProcessStatus ) ++ "\n"
                                    -- Schiee cdrecord und mich selbst ab. Nur cdrecord kann nicht abgeschossen werden, weil die Prozekennung
                                    -- nicht bekannt ist. ber die Prozegruppe geht es auch nicht, weil der laufende Proze SIGKILL nicht abfangen
                                    -- kann. SIGKILL ist notwendig, weil cdrecord SIGTERM ignoriert. Alternativ knnte man auf cdrecord warten, aber
                                    -- dann mu der dumme Countdown erst ablaufen.
                                    -- cdrecord sollte abgeschossen werden, weil bei fehlgeschlagenem mkisofs die Ausgaben und der Countdown trotzdem 
                                    -- weiterlaufen. cdrecord merkt erst mit Ablauf des countdown, da mkisofs nicht luft.
                                    signalProcess sigKILL (fromInteger 0)
                                )
-}

                if offen 
                    then do ausf "chmod" ["-R","u=rwX,go=rX,u+s",verz]
                            ausf "chmod" ["u=rx,u+s",verz]
                            ausf "chattr" ["-R","+d",verz]
                    else do ausf "chmod" ["-R","a+rX,a-w",verz]
                            ausf "chmod" ["u-s",verz]
                            ausf "chattr" ["-R","+d",verz]

                -- CD-Name registrieren
                when echt $ cdname echo "/mnt/brenner" (Just (snd (split_path verz))) >> return ()
                     
                -- CD auswerfen
                run_ee echt echo "/usr/bin/eject" ["/mnt/brenner"]
         )
         (zip3 verzl [0..] (labverz labels verzl))


labverz :: [String]     -- Labels (ggF. unvollstndig)
        -> [String]     -- Verzeichnisse
        -> [String]     -- vervollstndigte Labels
labverz as     [] = as
labverz []     bs = map (snd . split_path) bs
labverz (a:as) (b:bs) = a : labverz as bs

kzp :: IO ( Bool	-- ISO-Bild herstellen
          , Bool	-- ISO-Bild mounten
          , Bool	-- brennen (cdrecord ausfhren)
          , [String]	-- Verzeichnisse
          , Bool	-- CD-RW lschen
          , String      -- Brenngeschwindigkeit
          , [String]    -- volume labels
          , Bool        -- overburn
          , Bool        -- echt
          , Bool        -- echo
          , Bool        -- jolietlong
          , Bool        -- keinjoliet
          , Bool        -- offen
          )
kzp = do
   args <- getargs header descs

   let iso        = arg_switch args d_iso
       loop       = arg_switch args d_loop
       blank      = arg_switch args d_blank
       speed      = optarg_req args d_speed
       verzl      = map normalise_path $ args_req args d_dirs
       labels     = args_req args d_labels
       overburn   = arg_switch args d_overburn
       unecht     = arg_switch args d_unecht
       echo       = arg_switch args d_echo
       jolietlong = arg_switch args d_jolietlong
       keinjoliet = arg_switch args d_keinjoliet
       offen      = arg_switch args d_offen
       platz      = if (offen || blank) then 650*1024*1024 else 700*1024*1024

   args_at_most_one [d_jolietlong, d_keinjoliet] args
   args_at_most_one [d_iso, d_loop] args

   mapM_ muss_ex verzl
   mapM_ (\verz -> do gr <- platz_auf_cd verz
                      when (gr > platz && not overburn) $
                         failIO $ (shell_quote verz ++ " ist zu gro.\nGre: " ++ show gr ++ "\nPlatz: " ++ show platz ++ "\nGgf. --overburn verwenden."))
         verzl

   let geschw = case (speed, blank) of
                     (Just sp, _)     -> sp
                     (Nothing, True)  -> "4"
                     (Nothing, False) -> "8"

   mapM_ 
      (\label ->
         when (length label > 32) $ 
            failIO $ "Der Label \"" ++ label ++ "\" ist zu lang (" ++ show (length label) ++ "). Hchstens 32 Zeichen. -L verwenden."
      )
      (labverz labels verzl)

   (macheiso, mounteiso, brenne) <-
       case (iso, loop) of
          (False, False) -> return (False, False, True)
          (True, False)  -> return (True, False, False)
          (False, True)  -> return (True, True, False)
          -- (True, True) oben ausgeschlossen

   return (macheiso, mounteiso, brenne, verzl, blank, geschw, labels, overburn, not unecht, echo, jolietlong, keinjoliet, offen)



muss_ex pfad = do
   ex <- path_exists pfad
   when (not ex) $ failIO ("Verzeichnis " ++ shell_quote pfad ++ " gibt es nicht.")

noch_nicht_ex pfad = do
   ex <- path_exists pfad
   when ex $ failIO (shell_quote pfad ++ " gibt es schon.")

-- Ob ich root bin.
test_root = do
   ausg <- pipe_from (exec "/usr/bin/id" ["-u"])
   return (chomp ausg == "0")
