-- GENERATED by C->Haskell Compiler, version 0.13.2 "Pressing Forward", 13 Oct 2004 (Haskell)
-- Edit the ORIGNAL .chs file instead!

{-# LINE 1 "src/lib/HsShellScript/Misc.chs" #-}
-- #hide
module HsShellScript.Misc
   ( zeros
   , chomp
   , lazy_contents
   , contents
   , path_exists, path_exists'
   , is_dir, is_file
   , getFileStatus', fileAccess'
   -- ** Creating temporary files and directories
   , tmp_file, tmp_dir, temp_file, temp_dir, temp_path, with_tmp_file, with_tmp_dir, with_temp_file, with_temp_dir
   )
   where

-- empty lines in order to work around c2hs bug

import IO hiding (bracket)
import qualified Directory
import System.Posix
import GHC.IOBase
import Random
import Bits
import Foreign
import Foreign.C
import Foreign.C.Error
import Monad
import HsShellScript.ProcErr
import Control.Exception

-- |
-- Format an @Int@ with leading zeros.
zeros :: Int            -- ^ how many characters to fill up
      -> Int            -- ^ value to represent as a string
      -> String         -- ^ string representation of the value, using the specified number of characters
zeros stellen z =
   let txt  = show z
       auff = stellen - length txt
       n    = take (if auff >= 0 then auff else 0) (repeat '0')
   in  n ++ txt


-- |
-- Remove trailing newlines. This is silimar to perl's @chomp@ procedure.
chomp :: String         -- ^ String to be chomped
      -> String         -- ^ same string, except for no newline characters at the end
chomp "" = ""
chomp "\n" = ""
chomp [x] = [x]
chomp (x:xs) = let xs' = chomp xs
               in  if xs' == "" && x == '\n' then "" else x:xs'


-- |
-- Get contents of a file or of @stdin@. This is @hGetContents@
-- applied either to a file or to @stdin@. A file name of
-- @\"-\"@ designates stdin. The contents are read lazily as
-- the string is evaluated.
--
-- The returned handle must be closed eventually, or the process will run
-- out of file handles.
lazy_contents :: String                 -- ^ either the name of a file, or @\"-\"@
              -> IO (String, Handle)    -- ^ The contents of the file (or @stdin@) and the handle used to read it.
lazy_contents pfad = do
    h   <- if pfad == "-" then return stdin else openFile pfad ReadMode
    txt <- hGetContents h
    return (txt, h)

-- |
-- Get contents of a file or of @stdin@ eagerly. This is the
-- same as @lazy_contents@, except for the contents being
-- read immediately.
contents :: String              -- ^ either the name of a file, or @\"-\"@ for @stdin@
         -> IO String           -- ^ the contents of the file or of standard input
contents pfad = do
    (txt, h) <- lazy_contents pfad
    seq (length txt) (return ())
    hClose h
    return txt


-- |
-- Test for the existence of a path. This is the disjunction of
-- @Directory.doesDirectoryExist@ and @Directory.doesFileExist@. For an dangling symlink, this will return @False@.
path_exists :: String    -- ^ Path
            -> IO Bool   -- ^ Whether the path exists in the file system
path_exists pfad = do
    de <- Directory.doesDirectoryExist pfad
    fe <- Directory.doesFileExist pfad
    return (de || fe)


-- |
-- Test for the existence of a path. This uses @System.Posix.Files.getFileStatus@ to determine whether the path exists in any form in the file system.
-- For a dangling symlink, the result is @True@.
path_exists' :: String    -- ^ Path
             -> IO Bool   -- ^ Whether the path exists in the file system
path_exists' path =
   (getFileStatus' path >> return True)
      `IO.catch` (\ioe -> if isDoesNotExistError ioe then return False else ioError ioe)


-- |
-- Test if path points to a directory. This is a shortcut for
-- @Directory.doesDirectoryExist@.
is_dir :: String        -- ^ Path
       -> IO Bool       -- ^ Whether the path exists and points to a directory.
is_dir = Directory.doesDirectoryExist


-- |
-- Test if path points to a file. This is a shortcut for
-- @Directory.doesFileExist@.
is_file :: String       -- ^ Path
        -> IO Bool      -- ^ Whether the path exists and points to a file.
is_file = Directory.doesFileExist


-- |
-- This is the @System.Posix.Files.getFileStatus@ function from the GHC libraries, with improved error reporting. The GHC function doesn't include the
-- file name in the @IOError@ when the call fails, making error messages much less useful. @getFileStatus\'@ rectifies this.
--
-- See 'System.Posix.Files.getFileStatus'.
getFileStatus' :: FilePath              -- ^ Path of the file, whose status is to be queried
               -> IO FileStatus         -- ^ Status of the file
getFileStatus' path =
   getFileStatus path
      `IO.catch` (\ioe -> ioError (ioe { ioe_filename = Just path }))


-- |
-- This is the @System.Posix.Files.fileAccess@ function from the GHC libraries, with improved error reporting. The GHC function doesn't include the
-- file name in the @IOError@ when the call fails, making error messages much less useful. @fileAccess\'@ rectifies this.
--
-- See 'System.Posix.Files.fileAccess'.
fileAccess' :: FilePath -> Bool -> Bool -> Bool -> IO Bool
fileAccess' p b c d =
   fileAccess p b c d
      `IO.catch` (\ioe -> ioError (ioe { ioe_filename = Just p }))


-- |
-- Create a temporary file. This will create a new, empty file, with a path which did not previously exist in the file system. The path consists
-- of the specified prefix, a sequence of random characters (digits and letters), and the specified suffix. The file is created with read-write
-- permissions for the user, and no permissons for the group and others. The ownership is set to the effective user ID of the process. The group
-- ownership is set either to the effective group ID of the process or to the group ID of the parent directory (depending on filesystem type and mount
-- options on Linux - see @open(2)@ for details).
--
-- See 'tmp_file', 'temp_dir', 'with_temp_file'.
temp_file :: Int                        -- ^ Number of random characters to intersperse. Must be large enough, such that most combinations can't already
                                        -- exist.
          -> String                     -- ^ Prefix for the path to generate.
          -> String                     -- ^ Suffix for the path to generate.
          -> IO FilePath                -- ^ Path of the created file.
temp_file nr prefix suffix = do
   (fd, path) <- untilIO (do path <- temp_path nr prefix suffix
                             fd <- withCString path $ \cpath ->
                                hsshellscript_open_nonvariadic cpath hsshellscript_o_creat_excl 0o600
                             return (fd, path)
                         )
                         (\(fd, path) ->
                             if fd == -1 then do errno <- getErrno
                                                 when (errno /= Errno hsshellscript_eexist) $
                                                    throwErrno' "temp_file" Nothing (Just path)
                                                 return False
                                         else return True
                         )
   res <- close fd
   when (res == -1) $ throwErrno' "temp_file" Nothing (Just path)
   return path

-- |
-- Create a temporary directory. This will create a new directory, with a path which did not previously exist in the file system. The path consists
-- of the specified prefix, a sequence of random characters (digits and letters), and the specified suffix. The directory is normally created with
-- read-write-execute permissions for the user, and no permissons for the group and others. But this may be further restricted by the process's umask
-- in the usual way.
--
-- The newly created directory will be owned by the effective uid of the process.  If the directory containing the it has the  set  group
-- id  bit  set, or if the filesystem is mounted with BSD group semantics, the new directory will inherit the group ownership from its parent;
-- otherwise it will be owned by the effective gid of the process. (See @mkdir(2)@)
--
-- See 'tmp_dir', 'temp_file', 'with_temp_dir'.
temp_dir :: Int                        -- ^ Number of random characters to intersperse. Must be large enough, such that most combinations can't already
                                       -- exist.
         -> String                     -- ^ Prefix for the path to generate.
         -> String                     -- ^ Suffix for the path to generate.
         -> IO FilePath                -- ^ Generated path.
temp_dir nr prefix suffix = do
   (_, path) <- untilIO (do path <- temp_path nr prefix suffix
                            ret <- withCString path $ \cpath -> mkdir cpath 0o700
                            return (ret, path)
                        )
                        (\(ret, path) ->
                            if ret == -1 then do errno <- getErrno
                                                 when (errno /= Errno hsshellscript_eexist) $
                                                    throwErrno' "temp_dir" Nothing (Just path)
                                                 return False
                                         else return True
                        )
   return path

-- |
-- Create a temporary file. This will create a new, empty file, with read-write permissions for the user, and no permissons for the group and others.
-- The path consists of the specified prefix, a dot, and six random characters (digits and letters).
--
-- @tmp_file prefix = temp_file 6 (prefix ++ \".\") \"\"@
--
-- See 'temp_file', 'tmp_dir', 'with_tmp_file'.
tmp_file :: String                     -- ^ Prefix for the path to generate.
         -> IO FilePath                -- ^ Path of the created file.
tmp_file prefix = temp_file 6 (prefix ++ ".") ""


-- |
-- Create a temporary directory. This will create a new directory, with read-write-execute permissions for the user (unless further restricted by the
-- process's umask), and no permissons for the group and others.
-- The path consists of the specified prefix, a dot, and six random characters (digits and letters).
--
-- @tmp_dir prefix = temp_dir 6 (prefix ++ \".\") \"\"@
--
-- See 'temp_dir', 'tmp_file', 'with_tmp_dir'.
tmp_dir :: String                     -- ^ Prefix for the path to generate.
        -> IO FilePath                -- ^ Path of the created directory.
tmp_dir prefix = temp_dir 6 (prefix ++ ".") ""


-- |
-- Create and open a temporary file, perform some action with it, and delete it afterwards. This is a front end to the 'temp_file' function. The file
-- and its path are created in the same way. The IO action is passed a handle of the new file. When it finishes - normally or with an exception -
-- the file is deleted.
--
-- This works with all kinds of exceptions (ordinary or dynamic).
--
-- See 'temp_file', 'with_tmp_file', 'with_temp_dir'.
with_temp_file :: Int                        -- ^ Number of random characters to intersperse. Must be large enough, such that most combinations can't already
                                             -- exist.
               -> String                     -- ^ Prefix for the path to generate.
               -> String                     -- ^ Suffix for the path to generate.
               -> (Handle -> IO a)           -- ^ Action to perform.
               -> IO a                       -- ^ Returns the value returned by the action.
with_temp_file nr prefix suffix io =
   bracket (do path <- temp_file nr prefix suffix
               h <- openFile path ReadWriteMode
               return (path, h)
           )
           (\(path,h) -> do
               hClose h
               Directory.removeFile path
           )
           (\(path,h) ->
               io h
           )

-- |
-- Create a temporary directory, perform some action with it, and delete it afterwards. This is a front end to the 'temp_dir' function. The directory
-- and its path are created in the same way. The IO action is passed the path of the new directory. When it finishes - normally or with an exception -
-- the directory is deleted. 
--
-- The action must clean up any files it creates inside the directory by itself. @with_temp_dir@ doesn't delete any files inside, so the directory could
-- be deleted. If the directory isn't empty, an @IOError@ results (thrown by @Directory.removeDirectory@, with the path filled in).
--
-- This works with all kinds of exceptions (ordinary or dynamic).
--
-- See 'temp_dir', 'with_tmp_dir', 'with_temp_file'.
with_temp_dir :: Int                        -- ^ Number of random characters to intersperse. Must be large enough, such that most combinations can't already
                                            -- exist.
              -> String                     -- ^ Prefix for the path to generate.
              -> String                     -- ^ Suffix for the path to generate.
              -> (FilePath -> IO a)         -- ^ Action to perform.
              -> IO a                       -- ^ Returns the value returned by the action.
with_temp_dir nr prefix suffix io =
   bracket (temp_dir nr prefix suffix)
           (\path ->
               Directory.removeDirectory path 
                  `IO.catch` (\ioe -> ioError (ioe { ioe_filename = Just path }))
           )
           io


-- |
-- Create and open a temporary file, perform some action with it, and delete it afterwards. This is a front end to the 'tmp_file' function. The file
-- and its path are created in the same way. The IO action is passed a handle of the new file. When it finishes - normally or with an exception -
-- the file is deleted.
--
-- This works with all kinds of exceptions (ordinary or dynamic).
--
-- See 'tmp_file', 'with_temp_file', 'with_tmp_dir'.
with_tmp_file :: String                     -- ^ Prefix for the path to generate.
              -> (Handle -> IO a)           -- ^ Action to perform.
              -> IO a                       -- ^ Returns the value returned by the action.
with_tmp_file prefix io =
   bracket (do path <- tmp_file prefix
               h <- openFile path ReadWriteMode
               return (path, h)
           )
           (\(path,h) -> do
               hClose h
               Directory.removeFile path
           )
           (\(path,h) ->
               io h
           )

-- |
-- Create a temporary directory, perform some action with it, and delete it afterwards. This is a front end to the 'tmp_dir' function. The directory
-- and its path are created in the same way. The IO action is passed the path of the new directory. When it finishes - normally or with an exception -
-- the directory is deleted. 
--
-- The action must clean up any files it creates inside the directory by itself. @with_tmp_dir@ doesn't delete any files inside, so the directory could
-- be deleted. If the directory isn't empty, an @IOError@ results (thrown by @Directory.removeDirectory@, with the path filled in).
--
-- This works with all kinds of exceptions (ordinary or dynamic).
--
-- See 'tmp_dir', 'with_temp_dir', 'with_tmp_file'.
with_tmp_dir :: String                     -- ^ Prefix for the path to generate.
             -> (FilePath -> IO a)         -- ^ Action to perform.
             -> IO a                       -- ^ Returns the value returned by the action.
with_tmp_dir prefix io =
   bracket (tmp_dir prefix)
           (\path ->
               Directory.removeDirectory path 
                  `IO.catch` (\ioe -> ioError (ioe { ioe_filename = Just path }))
           )
           io


-- |
-- Create a temporary path. This will generate a path which does not yet exist in the file system. It consists of the specified prefix, a
-- sequence of random characters (digits and letters), and the specified suffix.
--
-- /Avoid relying on the generated path not to exist in the file system./ Or else you'll get a potential race condition, since some other process might
-- create the path after @temp_path@, before you use it. This is a security risk. The global random number generator (@Random.randomRIO@) is used to
-- generate the random characters. These might not be that random after all, and could potentially be guessed. Rather use @temp_file@ or @temp_dir@.
--
-- See 'temp_file', 'temp_dir'.
temp_path :: Int                        -- ^ Number of random characters to intersperse. Must be large enough, such that most combinations can't already
                                        -- exist.
          -> String                     -- ^ Prefix for the path to generate.
          -> String                     -- ^ Suffix for the path to generate.
          -> IO FilePath                -- ^ Generated path.
temp_path nr prefix suffix = do
   untilIO (do rand <- sequence (take nr (repeat (fmap char (randomRIO (0, 10+2*26 - 1)))))
               return (prefix ++ rand ++ suffix)
           )
           (\path -> fmap not (path_exists' path))

   where char nr = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ" !! nr


-- Execute action until condition is met.
untilIO io cond = do
   res <- io
   u <- cond res
   if u then return res
        else untilIO io cond


{- 1. open(2) is defined in fcntl.h as "extern int open (__const char *__file, int __oflag, ...)", with variable number of arguments, which isn's
      supported by the FFI.
   2. c2hs doesn't yet provide a way to import C macros, nor variables
-}
foreign import ccall safe "build/HsShellScript/Misc.h hsshellscript_open_nonvariadic"
  hsshellscript_open_nonvariadic :: ((Ptr CChar) -> (CInt -> (CUInt -> (IO CInt))))

foreign import ccall unsafe "build/HsShellScript/Misc.h hsshellscript_o_creat_excl"
  hsshellscript_o_creat_excl :: CInt

foreign import ccall unsafe "build/HsShellScript/Misc.h hsshellscript_eexist"
  hsshellscript_eexist :: CInt

foreign import ccall safe "build/HsShellScript/Misc.h close"
  close :: (CInt -> (IO CInt))

foreign import ccall safe "build/HsShellScript/Misc.h mkdir"
  mkdir :: ((Ptr CChar) -> (CUInt -> (IO CInt)))
