-- GENERATED by C->Haskell Compiler, version 0.13.2 "Pressing Forward", 13 Oct 2004 (Haskell)
-- Edit the ORIGNAL .chs file instead!

{-# LINE 1 "src/lib/HsShellScript/Commands.chs" #-}
-- #hide
module HsShellScript.Commands ( 
      realpath, realpath_s, symlink, is_symlink, readlink, du, mkdir, rmdir, rm, cd, chmod, chown, cp, mv, pwd, 
      mt_status, HsShellScript.Commands.rename, force_rename, force_mv, force_cmd, readlink', fdupes
   ) where
-- Here are packaged some calls to external programs. This is not really
-- meant as final or library like. 

-- empty lines in order to work around c2hs bug
import Control.Exception
import Data.Bits      -- for FileMode's
import Directory
import Foreign.C
import Foreign.C.Error
import Foreign.Ptr
import GHC.IOBase     -- for ioe_type
import System.Console.GetOpt
import HsShellScript.Misc
import HsShellScript.Misc
import HsShellScript.Paths
import HsShellScript.ProcErr
import HsShellScript.Shell
import IO
import List
import Maybe
import Monad
import Text.ParserCombinators.Parsec as Parsec
import Posix
import PosixUtil
import Random
import System

-- |
-- Do a call to the @realpath(3)@ system library function. This makes the path absolute, normalizes it and expands all symbolic links. In case of an
-- error (such as path not found), an @IOError@ is thrown. The path is included in the @IOError@ and can be accessed with @ioeGetFileName@ from the
-- Haskell standard library @IO@.
realpath :: String      -- ^ path
         -> IO String	-- ^ noramlized, absolute path, with symbolic links expanded
realpath path = 
   withCString path $ \cpath -> do
      res <- hsshellscript_get_realpath cpath
      if res == nullPtr 
         then throwErrno' "realpath" Nothing (Just path)
         else peekCString res

-- | Determine the target of a symbolic link. This uses the @readlink(2)@ system call. The result is a path which is either absolute, or relative to
-- the directory which the symlink is in. In case of an error, an @IOError@ is thrown. The path is included and can be accessed with
-- @IO.ioeGetFileName@. Note that, if the path to the symlink ends with a slash, this path denotes the directory pointed to, /not/ the symlink. In
-- this case the call to will fail because of \"Invalid argument\".
readlink :: String      -- ^ Path of the symbolic link
         -> IO String	-- ^ The link target - where the symbolic link points to
readlink path = 
   withCString path $ \cpath -> do
      res <- hsshellscript_get_readlink cpath
      if res == nullPtr 
         then throwErrno' "readlink" Nothing (Just path)
         else peekCString res

-- |
-- Determine the target of a symbolic link. This uses the @readlink(2)@ system call. The target is converted, such that it is relative to the current
-- working directory, if it isn't absolute. Note that, it the path to the symlink ends with a slash, this path denotes the directory pointed to, /not/ the
-- symlink. In this case the call to @readlink@ will fail with an @IOError@ because of "Invalid argument". In case of any
-- error, an @IOError@ is thrown. The path is included in the @IOError@ and can be accessed with @ioeGetFileName@ from the
-- Haskell standard library @IO@.
readlink' :: String     -- ^ path of the symbolic link
          -> IO String	-- ^ target; where the symbolic link points to
readlink' symlink = do
   target <- readlink symlink
   return (absolute_path' target (fst (split_path symlink)))

-- | 
-- Determine whether a path is a symbolic link. The path must exist in the file system. Otherwise, an @IOError@ which makes @isDoesNotExistError@
-- (from the standard library @IO@) true will be thrown. Its GHC @IOErrorType@ is @NoSuchThing@. However, the symlink may dangle. In this case the
-- result is @True@. This function calls @readlink(2)@. Any error which may occur, results in an @IOError@ thrown. The path is included in the @IOError@ and
-- can be accessed with @ioeGetFileName@ from the Haskell standard library @IO@.
is_symlink :: String    -- ^ path
           -> IO Bool   -- ^ Whether the path is a symbolic link.
is_symlink path = 
    do readlink path
       return True
    `IO.catch`
       (\ioe -> if (ioe_type ioe == InvalidArgument) then return False else ioError ioe)


-- |
-- Call the @realpath@ program, with the @-s@
-- option. Return its output. See realpath(1).
realpath_s :: String    -- ^ path
           -> IO String -- ^ noramlized, absolute path, with symbolic links not expanded
realpath_s pfad = fmap chomp $ pipe_from (exec "/usr/bin/realpath" ["-s", pfad])


-- |
-- Make a symbolic link. This is the @symlink(2)@ function. Any error results in an @IOError@ thrown. The path of the intended symlink is included in
-- the @IOError@ and 
-- can be accessed with @ioeGetFileName@ from the Haskell standard library @IO@.
symlink :: String       -- ^ contents of the symlink (/from/)
        -> String       -- ^ path of the symlink (/to/)
        -> IO ()        
symlink oldpath newpath = do
   o <- newCString oldpath
   n <- newCString newpath
   res <- foreign_symlink o n
   when (res == -1) $ throwErrno' ("symlink " ++ shell_quote oldpath ++ " to " ++ shell_quote newpath) Nothing (Just newpath)


-- |
-- Call the @du@ program. See du(1).
du :: (Integral int, Read int)
   => int               -- ^ block size, this is the @--block-size@ option.
   -> String            -- ^ path of the file or directory to determine the size of
   -> IO int            -- ^ size in blocks
du block_gr pfad =
    let par = ["--summarize", "--block-size=" ++ show block_gr, pfad]
        parsen ausg =
           case reads ausg of
              [(groesse, _)] -> return groesse
              _              -> putStrLn ("Kann du-Ausgabe nicht parsen: \n" ++ ausg ++ "\nShell command: " ++ shell_command "du" par)
                                >> fail ("Parsfehler: " ++ ausg)
    in pipe_from (exec "/usr/bin/du" par) >>= parsen


-- |
-- Create directory. This is @Directory.createDirectory@ from the Haskell standard
-- library. In case of an error, the path is included in the @IOError@, which GHC's implementation neglects to do.
mkdir :: String         -- ^ path
      -> IO ()
mkdir path = Directory.createDirectory path `IO.catch` (\ioe -> ioError (ioe { ioe_filename = Just path }))

-- |
-- Remove directory. This is 
-- @Directory.removeDirectory@ from the Haskell standard
-- library. In case of an error, the path is included in the @IOError@, which GHC's implementation neglects to do.
rmdir :: String         -- ^ path
      -> IO ()
rmdir path = Directory.removeDirectory path `IO.catch` (\ioe -> ioError (ioe { ioe_filename = Just path }))


-- |
-- Remove file. This is 
-- @Directory.removeFile@ from the Haskell standard
-- library. In case of an error, the path is included in the @IOError@, which GHC's implementation neglects to do.
rm :: String         -- ^ path
   -> IO ()
rm path = Directory.removeFile path `IO.catch` (\ioe -> ioError (ioe { ioe_filename = Just path }))


-- |
-- Change directory.This is an alias for
-- @Directory.setCurrentDirectory@ from the Haskell standard
-- library. In case of an error, the path is included in the @IOError@, which GHC's implementation neglects to do.
cd :: String         -- ^ path
   -> IO ()
cd path = setCurrentDirectory path `IO.catch` (\ioe -> ioError (ioe { ioe_filename = Just path }))


-- |
-- Get program start working directory. This is the @PWD@ environent
-- variable, which is kept by the shell (bash, at least). It records the
-- directory path in which the program has been started. Symbolic links in
-- this path aren't expanded. In this way, it differs from
-- @getCurrentDirectory@ from the Haskell standard library.
pwd :: IO String
pwd = getEnv "PWD"


{- | Execute @/bin/chmod@

>chmod = run "/bin/chmod"
-}
chmod :: [String]       -- ^ Command line arguments
      -> IO ()
chmod = run "/bin/chmod"


{- | Execute @/bin/chown@

>chown = run "/bin/chown"
-}
chown :: [String]       -- ^ Command line arguments
      -> IO ()
chown = run "/bin/chown"


-- |
-- Execute the cp program
cp :: String    -- ^ source 
   -> String    -- ^ destination
   -> IO ()
cp from to =
   run "cp" [from, to]


-- |
-- Execute the mv program
mv :: String    -- ^ source 
   -> String    -- ^ destination
   -> IO ()
mv from to = run "mv" ["--", from, to]


number  :: Parser Int
number  = do sgn <- ( (char '-' >> return (-1))
                      <|> return 1
                    )
             ds <- many1 digit
             return (sgn * read ds)
          <?> "number"

-- Parser for the output of the "mt status" command.
parse_mt_status :: Parser ( Int    -- file number
                          , Int    -- block number
                          )
parse_mt_status = 
   do (fn,bn) <- parse_mt_status' (Nothing, Nothing)
      return (fromJust fn, fromJust bn)
   where
      try = Parsec.try

      parse_mt_status' :: (Maybe Int, Maybe Int) -> Parser (Maybe Int, Maybe Int)
      parse_mt_status' st = do
         st' <- parse_mt_status1' st
         ( parse_mt_status' st' <|> return st' )

      parse_mt_status1' :: (Maybe Int, Maybe Int) -> Parser (Maybe Int, Maybe Int)
      parse_mt_status1' st@(fn,bn) =
             try (do string "file number = "
                     nr <- number
                     newline
                     return (Just nr, bn)
                 )
         <|> try (do string "block number = "
                     nr <- number
                     newline
                     return (fn, Just nr)
                 )
         <|> (manyTill anyChar newline >> return st)

-- |
-- Run the command @mt status@ for querying the tape drive status, and
-- parse its output.
mt_status :: IO (Int, Int)      -- ^ file and block number
mt_status = do
   out <- pipe_from (exec "/bin/mt" ["status"])
   case (parse parse_mt_status "" out) of
      Left err -> ioError (userError ("parse error at " ++ show err))
      Right x  -> return x


-- |
-- The @rename(2)@ system call to rename and\/or move a file. The @renameFile@ action from the Haskell standard library doesn\'t do it, because 
-- the two paths may not refer to a directories. Failure results in an @IOError@ thrown. The /new/ path is included in
-- the @IOError@ and 
-- can be accessed with @ioeGetFileName@ from the Haskell standard library @IO@.
rename :: String        -- ^ Old path 
       -> String        -- ^ New path or target directory
       -> IO ()
rename oldpath newpath = do
   withCString oldpath $ \coldpath ->
      withCString newpath $ \cnewpath -> do
         res <- foreign_rename coldpath cnewpath
         when (res == -1) $ throwErrno' ("rename " ++ shell_quote oldpath ++ " to " ++ shell_quote newpath) Nothing (Just newpath)


{- | Rename a file or directory, and cope with read only issues. 

This renames a file or directory, using @rename@, sets the necessary write permissions beforehand, and restores them afterwards. This is more
efficient than @force_mv@, because no external program needs to be called, but it can rename files only inside the same file system. See @force_cmd@
for a detailed description.

The new path may be an existing directory. In this case, it is assumed that the old file is to be moved into this directory (like with @mv@). The
new path is then completed with the file name component of the old path. You won't get an \"already exists\" error.

>force_rename = force_cmd rename

See 'force_cmd', 'rename'.
-}
force_rename :: String        -- ^ Old path
             -> String        -- ^ New path or target directory
             -> IO ()
force_rename = force_cmd HsShellScript.Commands.rename


{- | Move a file or directory, and cope with read only issues. 

This moves a file or directory, using the external command @mv@, sets the necessary write permissions beforehand, and restores them afterwards.
This is less efficient than @force_rename@, because the external program @mv@ needs to be called, but it can move files between file systems. See
@force_cmd@ for a detailed description.

>force_mv src tgt = force_cmd (\src tgt -> run "/bin/mv" ["--", src, tgt]) src tgt

See 'force_cmd', 'force_mv'.
-}
force_mv :: String        -- ^ Old path
         -> String        -- ^ New path
         -> IO ()
force_mv src tgt = force_cmd (\src tgt -> run "/bin/mv" ["--", src, tgt]) src tgt


{- | Call a command which moves a file or directory, and cope with read only issues. 

This function is for calling a command, which renames files. Beforehand, write permissions are set in order to enable the
operation, and afterwards the permissions are restored. The command is meant to be something like @rename@ or @run \"\/bin\/mv\"@. 

In order to change the name of a file or dirctory, but leave it in the super directory
it is in, the super directory must be writeable. In order to move a file or directory to a different super directory, both super directories and
the file\/directory to be moved must be writeable. I don't know what this behaviour is supposed to be good for. 

This function copes with the case that the file\/directory to be moved or renamed, or the super directories are read only. It makes the necessary
places writeable, calls the command, and makes them read only again, if they were before. The user needs the necessary permissions for changing the
corresponding write permissions. If an error occurs (such as file not found, or insufficient permissions), then the write permissions are restored
to the state before, before the exception is passed through to the caller.

The command must take two arguments, the old path and the new path. It is expected to create the new path in the file system, such that the correct
write permissions of the new path can be set by @force_cmd@ after executing it.

The new path may be an existing directory. In this case, it is assumed that the old file is to be moved into this directory (like with @mv@). The
new path is completed with the file name component of the old path, before it is passed to the command, such that the command is supplied the
complete new path.

Examples:

>force_cmd rename from to
>force_cmd (\from to -> run "/bin/mv" ["-i", "-v", "--", from, to]) from to

See 'force_rename', 'force_mv', 'rename'.
-}
force_cmd :: (String -> String -> IO ())        -- ^ Command to execute after preparing the permissions
          -> String                             -- ^ Old path
          -> String                             -- ^ New path or target directory
          -> IO ()
force_cmd cmd oldpath newpath0 = do
   isdir <- is_dir newpath0
   let newpath = if isdir then newpath0 ++ "/" ++ snd (split_path oldpath) else newpath0

   old_abs <- absolute_path oldpath
   new_abs <- absolute_path newpath
   let (olddir, _) = split_path old_abs
       (newdir, _) = split_path new_abs
   if olddir == newdir 
      then -- Don't need to make the file/directory writeable.
           with olddir olddir (cmd oldpath newpath)
      else -- Need to make both the file/dirctory and both super directories writeable.
           with olddir olddir (with newdir newdir (with oldpath newpath (cmd oldpath newpath)))
   where
      with :: String -> String -> IO () -> IO ()
      with path_before path_after io = do
         writeable <- fileAccess' path_before False True False
         when (not writeable) $ set_user_writeable path_before
         finally io (when (not writeable) $ set_user_readonly path_after)

      finally io cleanup = (io >> cleanup) `IO.catch` (\ioe -> cleanup >> ioError ioe)

      set_user_writeable path = do 
         filemode <- fmap fileMode (getFileStatus' path)
         setFileMode path (filemode .|. ownerWriteMode)

      set_user_readonly path = do 
         filemode <- fmap fileMode (getFileStatus' path)
         setFileMode path (filemode .&. ((complement 0) `xor` ownerWriteMode))


-- |
-- Call the @fdupes@ program in order to find identical files. It outputs a
-- list of groups of file names, such that the files in each group are
-- identical. Each of these groups is further analysed by the @fdupes@
-- action. It is split to a list of lists of paths, such that each list
-- of paths corresponds to one of the directories which have been searched
-- by the @fdupes@ program. If you just want groups of identical files, then apply @map concat@ to the result. 
--
-- The paths are normalised (using 'normalise_path').
fdupes :: [String]              -- ^ Options for the fdupes program
       -> [String]              -- ^ Directories with files to compare
       -> IO [[[String]]]       -- ^ For each set of identical files, and each of the specified directories, the paths of the identical files in this 
                                --   directory.
fdupes opts paths = do
   let paths'  = map normalise_path paths
       paths'' = map (++"/") paths'
   out <- fmap lines $ pipe_from (run "/usr/bin/fdupes" (opts ++ ["--"] ++ paths'))
   let grps = groups out
   return (map (sortgrp paths'') grps)
   where
      groups [] = []
      groups l = 
         let l' = dropWhile (== "") l
             (g,rest) = span (/= "") l'
         in if g == [] then [] else (g : groups rest)

      split p [] = ([], [])
      split p (x:xs) = 
         let (yes, no) = split p xs
         in  if p x then (x:yes, no) 
                    else (yes, x:no)

      -- result: ( <paths within the directory>, <rest of paths> )
      path1 grp dir = split (isPrefixOf dir) grp

      -- super directories -> Group of identical files -> list of lists of files in each directory
      sortgrp dirs [] = map (const []) dirs
      sortgrp [] grp = error ("Bug: found paths which don't belong to any of the directories:\n" ++ show grp)
      sortgrp (dir:dirs) grp = let (paths1, grp_rest) = path1 grp dir
                               in  (paths1 : sortgrp dirs grp_rest)


foreign import ccall safe "build/HsShellScript/Commands.h hsshellscript_get_realpath"
  hsshellscript_get_realpath :: ((Ptr CChar) -> (IO (Ptr CChar)))

foreign import ccall safe "build/HsShellScript/Commands.h hsshellscript_get_readlink"
  hsshellscript_get_readlink :: ((Ptr CChar) -> (IO (Ptr CChar)))

foreign import ccall safe "build/HsShellScript/Commands.h symlink"
  foreign_symlink :: ((Ptr CChar) -> ((Ptr CChar) -> (IO CInt)))

foreign import ccall safe "build/HsShellScript/Commands.h rename"
  foreign_rename :: ((Ptr CChar) -> ((Ptr CChar) -> (IO CInt)))
