#------------------------------------------------------------------------------
# sources.cmake
# Module : G4hadronic_hetcpp_utils
# Package: Geant4.src.G4processes.G4hadronic.G4hadronic_models.G4had_hetcpp.G4hadronic_hetcpp_utils
#
# Sources description for a library.
# Lists the sources and headers of the code explicitely.
# Lists include paths needed.
# Lists the internal granular and global dependencies of the library.
# Source specific properties should be added at the end.
#
# Generated on : 24/9/2010
#
# $Id: sources.cmake 106381 2017-10-09 09:31:33Z gcosmo $
#
#------------------------------------------------------------------------------

# List external includes needed.
include_directories(${CLHEP_INCLUDE_DIRS})

# List internal includes needed.
include_directories(${CMAKE_SOURCE_DIR}/source/geometry/management/include)
include_directories(${CMAKE_SOURCE_DIR}/source/geometry/volumes/include)
include_directories(${CMAKE_SOURCE_DIR}/source/global/HEPGeometry/include)
include_directories(${CMAKE_SOURCE_DIR}/source/global/HEPRandom/include)
include_directories(${CMAKE_SOURCE_DIR}/source/global/management/include)
include_directories(${CMAKE_SOURCE_DIR}/source/materials/include)
include_directories(${CMAKE_SOURCE_DIR}/source/particles/bosons/include)
include_directories(${CMAKE_SOURCE_DIR}/source/particles/hadrons/barions/include)
include_directories(${CMAKE_SOURCE_DIR}/source/particles/hadrons/ions/include)
include_directories(${CMAKE_SOURCE_DIR}/source/particles/hadrons/mesons/include)
include_directories(${CMAKE_SOURCE_DIR}/source/particles/leptons/include)
include_directories(${CMAKE_SOURCE_DIR}/source/particles/management/include)
include_directories(${CMAKE_SOURCE_DIR}/source/processes/hadronic/cross_sections/include)
include_directories(${CMAKE_SOURCE_DIR}/source/processes/hadronic/management/include)
include_directories(${CMAKE_SOURCE_DIR}/source/processes/hadronic/models/binary_cascade/include)
include_directories(${CMAKE_SOURCE_DIR}/source/processes/hadronic/models/im_r_matrix/include)
include_directories(${CMAKE_SOURCE_DIR}/source/processes/hadronic/models/management/include)
include_directories(${CMAKE_SOURCE_DIR}/source/processes/hadronic/util/include)
include_directories(${CMAKE_SOURCE_DIR}/source/processes/management/include)
include_directories(${CMAKE_SOURCE_DIR}/source/track/include)
include_directories(${CMAKE_SOURCE_DIR}/source/intercoms/include)

#
# Define the Geant4 Module.
#
include(Geant4MacroDefineModule)
GEANT4_DEFINE_MODULE(NAME G4hadronic_inclxx_physics
    HEADERS
        G4INCLAvatarDumpAction.hh
        G4INCLBinaryCollisionAvatar.hh
        G4INCLCascade.hh
        G4INCLCascadeAction.hh
        G4INCLCDPP.hh
        G4INCLCluster.hh
        G4INCLClusterDecay.hh
        G4INCLClustering.hh
        G4INCLClusteringModelIntercomparison.hh
        G4INCLClusteringModelNone.hh
        G4INCLConstantRandom.hh
        G4INCLCoulombDistortion.hh
        G4INCLCoulombNone.hh
        G4INCLCoulombNonRelativistic.hh
        G4INCLCrossSections.hh
        G4INCLCrossSectionsINCL46.hh
        G4INCLCrossSectionsMultiPions.hh
        G4INCLCrossSectionsMultiPionsAndResonances.hh
        G4INCLCrossSectionsStrangeness.hh
        G4INCLCrossSectionsTruncatedMultiPions.hh
        G4INCLDecayAvatar.hh
        G4INCLDeJongSpin.hh
        G4INCLDeltaDecayChannel.hh
        G4INCLDeltaProductionChannel.hh
        G4INCLDeuteronDensity.hh
        G4INCLElasticChannel.hh
        G4INCLEtaNElasticChannel.hh
        G4INCLEtaNToPiNChannel.hh
        G4INCLEtaNToPiPiNChannel.hh
        G4INCLIClusteringModel.hh
        G4INCLICoulomb.hh
        G4INCLICrossSections.hh
        G4INCLInteractionAvatar.hh
        G4INCLINuclearPotential.hh
        G4INCLIPauli.hh
        G4INCLIPhaseSpaceGenerator.hh
        G4INCLIPropagationModel.hh
        G4INCLKinematicsUtils.hh
        G4INCLNDeltaEtaProductionChannel.hh
        G4INCLNDeltaOmegaProductionChannel.hh
        G4INCLNDeltaToDeltaLKChannel.hh
        G4INCLNDeltaToDeltaSKChannel.hh
        G4INCLNDeltaToNLKChannel.hh
        G4INCLNDeltaToNNKKbChannel.hh
        G4INCLNDeltaToNSKChannel.hh
        G4INCLNDFGaussian.hh
        G4INCLNDFHardSphere.hh
        G4INCLNDFModifiedHarmonicOscillator.hh
        G4INCLNDFParis.hh
        G4INCLNDFWoodsSaxon.hh
        G4INCLNeutralKaonDecayChannel.hh
        G4INCLNKbElasticChannel.hh
        G4INCLNKbToL2piChannel.hh
        G4INCLNKbToLpiChannel.hh
        G4INCLNKbToNKb2piChannel.hh
        G4INCLNKbToNKbChannel.hh
        G4INCLNKbToNKbpiChannel.hh
        G4INCLNKbToS2piChannel.hh
        G4INCLNKbToSpiChannel.hh
        G4INCLNKElasticChannel.hh
        G4INCLNKToNK2piChannel.hh
        G4INCLNKToNKChannel.hh
        G4INCLNKToNKpiChannel.hh
        G4INCLNLToNSChannel.hh
        G4INCLNNEtaToMultiPionsChannel.hh
        G4INCLNNOmegaToMultiPionsChannel.hh
        G4INCLNNToMissingStrangenessChannel.hh
        G4INCLNNToMultiPionsChannel.hh
        G4INCLNNToNLK2piChannel.hh
        G4INCLNNToNLKChannel.hh
        G4INCLNNToNLKpiChannel.hh
        G4INCLNNToNNEtaChannel.hh
        G4INCLNNToNNKKbChannel.hh
        G4INCLNNToNNOmegaChannel.hh
        G4INCLNNToNSK2piChannel.hh
        G4INCLNNToNSKChannel.hh
        G4INCLNNToNSKpiChannel.hh
        G4INCLNpiToLK2piChannel.hh
        G4INCLNpiToLKChannel.hh
        G4INCLNpiToLKpiChannel.hh
        G4INCLNpiToMissingStrangenessChannel.hh
        G4INCLNpiToNKKbChannel.hh
        G4INCLNpiToSK2piChannel.hh
        G4INCLNpiToSKChannel.hh
        G4INCLNpiToSKpiChannel.hh
        G4INCLNSToNLChannel.hh
        G4INCLNSToNSChannel.hh
        G4INCLNuclearDensity.hh
        G4INCLNuclearDensityFactory.hh
        G4INCLNuclearPotentialConstant.hh
        G4INCLNuclearPotentialEnergyIsospin.hh
        G4INCLNuclearPotentialEnergyIsospinSmooth.hh
        G4INCLNuclearPotentialIsospin.hh
        G4INCLNucleus.hh
        G4INCLNYElasticChannel.hh
        G4INCLOmegaNElasticChannel.hh
        G4INCLOmegaNToPiNChannel.hh
        G4INCLOmegaNToPiPiNChannel.hh
        G4INCLParticleEntryAvatar.hh
        G4INCLParticleEntryChannel.hh
        G4INCLParticleSampler.hh
        G4INCLPauliBlocking.hh
        G4INCLPauliGlobal.hh
        G4INCLPauliStandard.hh
        G4INCLPauliStrict.hh
        G4INCLPauliStrictStandard.hh
        G4INCLPhaseSpaceGenerator.hh
        G4INCLPhaseSpaceKopylov.hh
        G4INCLPhaseSpaceRauboldLynch.hh
        G4INCLPiNElasticChannel.hh
        G4INCLPiNToDeltaChannel.hh
        G4INCLPiNToEtaChannel.hh
        G4INCLPiNToMultiPionsChannel.hh
        G4INCLPiNToOmegaChannel.hh
        G4INCLPionResonanceDecayChannel.hh
        G4INCLProjectileRemnant.hh
        G4INCLRecombinationChannel.hh
        G4INCLReflectionChannel.hh
        G4INCLSigmaZeroDecayChannel.hh
        G4INCLStandardPropagationModel.hh
        G4INCLStore.hh
        G4INCLStrangeAbsorbtionChannel.hh
        G4INCLSurfaceAvatar.hh
        G4INCLTransmissionChannel.hh

    SOURCES
        G4INCLAvatarDumpAction.cc
        G4INCLBinaryCollisionAvatar.cc
        G4INCLCascade.cc
        G4INCLCascadeAction.cc
        G4INCLCDPP.cc
        G4INCLCluster.cc
        G4INCLClusterDecay.cc
        G4INCLClustering.cc
        G4INCLClusteringModelIntercomparison.cc
        G4INCLCoulombDistortion.cc
        G4INCLCoulombNone.cc
        G4INCLCoulombNonRelativistic.cc
        G4INCLCrossSections.cc
        G4INCLCrossSectionsINCL46.cc
        G4INCLCrossSectionsMultiPions.cc
        G4INCLCrossSectionsMultiPionsAndResonances.cc
        G4INCLCrossSectionsStrangeness.cc
        G4INCLCrossSectionsTruncatedMultiPions.cc
        G4INCLDecayAvatar.cc
        G4INCLDeJongSpin.cc
        G4INCLDeltaDecayChannel.cc
        G4INCLDeltaProductionChannel.cc
        G4INCLDeuteronDensity.cc
        G4INCLElasticChannel.cc
        G4INCLEtaNElasticChannel.cc
        G4INCLEtaNToPiNChannel.cc
        G4INCLEtaNToPiPiNChannel.cc
        G4INCLInteractionAvatar.cc
        G4INCLINuclearPotential.cc
        G4INCLKinematicsUtils.cc
        G4INCLNDeltaEtaProductionChannel.cc
        G4INCLNDeltaOmegaProductionChannel.cc
        G4INCLNDeltaToDeltaLKChannel.cc
        G4INCLNDeltaToDeltaSKChannel.cc
        G4INCLNDeltaToNLKChannel.cc
        G4INCLNDeltaToNNKKbChannel.cc
        G4INCLNDeltaToNSKChannel.cc
        G4INCLNeutralKaonDecayChannel.cc
        G4INCLNKbElasticChannel.cc
        G4INCLNKbToL2piChannel.cc
        G4INCLNKbToLpiChannel.cc
        G4INCLNKbToNKb2piChannel.cc
        G4INCLNKbToNKbChannel.cc
        G4INCLNKbToNKbpiChannel.cc
        G4INCLNKbToS2piChannel.cc
        G4INCLNKbToSpiChannel.cc
        G4INCLNKElasticChannel.cc
        G4INCLNKToNK2piChannel.cc
        G4INCLNKToNKChannel.cc
        G4INCLNKToNKpiChannel.cc
        G4INCLNLToNSChannel.cc
        G4INCLNNEtaToMultiPionsChannel.cc
        G4INCLNNOmegaToMultiPionsChannel.cc
        G4INCLNNToMissingStrangenessChannel.cc
        G4INCLNNToMultiPionsChannel.cc
        G4INCLNNToNLK2piChannel.cc
        G4INCLNNToNLKChannel.cc
        G4INCLNNToNLKpiChannel.cc
        G4INCLNNToNNEtaChannel.cc
        G4INCLNNToNNKKbChannel.cc
        G4INCLNNToNNOmegaChannel.cc
        G4INCLNNToNSK2piChannel.cc
        G4INCLNNToNSKChannel.cc
        G4INCLNNToNSKpiChannel.cc
        G4INCLNpiToLK2piChannel.cc
        G4INCLNpiToLKChannel.cc
        G4INCLNpiToLKpiChannel.cc
        G4INCLNpiToMissingStrangenessChannel.cc
        G4INCLNpiToNKKbChannel.cc
        G4INCLNpiToSK2piChannel.cc
        G4INCLNpiToSKChannel.cc
        G4INCLNpiToSKpiChannel.cc
        G4INCLNSToNLChannel.cc
        G4INCLNSToNSChannel.cc
        G4INCLNuclearDensity.cc
        G4INCLNuclearDensityFactory.cc
        G4INCLNuclearPotentialConstant.cc
        G4INCLNuclearPotentialEnergyIsospin.cc
        G4INCLNuclearPotentialEnergyIsospinSmooth.cc
        G4INCLNuclearPotentialIsospin.cc
        G4INCLNucleus.cc
        G4INCLNYElasticChannel.cc
        G4INCLOmegaNElasticChannel.cc
        G4INCLOmegaNToPiNChannel.cc
        G4INCLOmegaNToPiPiNChannel.cc
        G4INCLParticleEntryAvatar.cc
        G4INCLParticleEntryChannel.cc
        G4INCLParticleSampler.cc
        G4INCLPauliBlocking.cc
        G4INCLPauliGlobal.cc
        G4INCLPauliStandard.cc
        G4INCLPauliStrict.cc
        G4INCLPauliStrictStandard.cc
        G4INCLPhaseSpaceGenerator.cc
        G4INCLPhaseSpaceKopylov.cc
        G4INCLPhaseSpaceRauboldLynch.cc
        G4INCLPiNElasticChannel.cc
        G4INCLPiNToDeltaChannel.cc
        G4INCLPiNToEtaChannel.cc
        G4INCLPiNToMultiPionsChannel.cc
        G4INCLPiNToOmegaChannel.cc
        G4INCLPionResonanceDecayChannel.cc
        G4INCLProjectileRemnant.cc
        G4INCLRecombinationChannel.cc
        G4INCLReflectionChannel.cc
        G4INCLSigmaZeroDecayChannel.cc
        G4INCLStandardPropagationModel.cc
        G4INCLStore.cc
        G4INCLStrangeAbsorbtionChannel.cc
        G4INCLSurfaceAvatar.cc
        G4INCLTransmissionChannel.cc

    GRANULAR_DEPENDENCIES
        G4baryons
        G4bosons
        G4geometrymng
        G4globman
        G4hadronic_mgt
        G4hadronic_util
        G4hadronic_xsect
        G4ions
        G4leptons
        G4materials
        G4mesons
        G4partman
        G4procman
        G4track
        G4volumes
        G4intercoms
        G4had_preequ_exciton
        G4hadronic_deex_evaporation
        G4hadronic_deex_fermi_breakup
        G4hadronic_deex_handler
        G4hadronic_deex_management
        G4hadronic_deex_multifragmentation
        G4hadronic_deex_photon_evaporation
        G4hadronic_deex_util
        G4hadronic_inclxx_utils

    GLOBAL_DEPENDENCIES
        G4geometry
        G4global
        G4materials
        G4particles
        G4track
        G4intercoms

LINK_LIBRARIES)# List any source specific properties here