//$Id: DAWNSourceFrame.java,v 1.2 2004/09/24 08:50:51 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;
import java.awt.*;


import java.awt.event.*;


import java.io.*;


import java.util.*;


import javax.swing.filechooser.*;


import GPE.ExampleFileFilter;





import javax.swing.text.*;


import javax.swing.event.*;


import javax.swing.*;





class DAWNSourceFrame extends JFrame implements ActionListener {


  private JMenuItem close, save, cut, copy, paste;


  private String fileName;


  public JTextArea dawnEditor;


//  protected FileDialog fileDialog;


  private JFileChooser fileChooser;


  DAWNSourceFrame(){


    super(" DAWN Text Editor");


    getContentPane().setLayout(new BorderLayout());


    dawnEditor = new JTextArea();


    //editor.setFont(new Font("Courier", Font.PLAIN, 12));


    JScrollPane scroller = new JScrollPane();


    //scroller.setVerticalScrollBarPolicy(JScrollPane.SCROLLBARS_ALWAYS);


    JViewport port = scroller.getViewport();


    port.add(dawnEditor);


    //    port.setBackingStoreEnabled(false);  // 1.3 DEPRECATED
    setJMenuBar( createMenubar() );


    getContentPane().add("Center", scroller);


    pack();


    setSize(350, 350);


//    show();


  }





    JMenuBar createMenubar(){


    JMenu file, edit;


    JMenuBar mb = new JMenuBar();


    file = new JMenu("File");


    file.add(close = new JMenuItem("Close"));


    file.add(save = new JMenuItem("Save"));





    edit = new JMenu("Edit"); 


    edit.add(cut = new JMenuItem("Cut"));


    edit.add(copy = new JMenuItem("Copy"));


    edit.add(paste = new JMenuItem("Paste"));


    mb.add(file);


    mb.add(edit);





    close.addActionListener(this);


    save.addActionListener(this);


    cut.addActionListener(this);


    copy.addActionListener(this);


    paste.addActionListener(this);


    return mb;


  }





    // 2001 POh no!! it was uncommented

    //  public static void main(String[] args) {


    //new DAWNSourceFrame();


    // }


  public void actionPerformed(ActionEvent e) {


    Object o = e.getSource();


    if (o == save){saveAction(); return;}


    if (o == close){setVisible(false);}


    if (o == cut){dawnEditor.cut(); return;}


    if (o == copy){dawnEditor.copy(); return;}


    if (o == paste){dawnEditor.paste(); return;}


  }


  void saveAction(){


    String saveText;


    if (fileChooser == null) {


      fileChooser = new JFileChooser(".");


    }


    fileChooser.setDialogTitle("Save C++ Source Code");


    fileChooser.setDialogType(1);


    ExampleFileFilter primFile = new ExampleFileFilter("prim","PRIM Source Code");


    fileChooser.setFileFilter(primFile);


    fileChooser.showDialog(this, null);


    fileChooser.getSelectedFile();


    


    File f = fileChooser.getSelectedFile();


    fileName = f.getPath();


    try{


      FileOutputStream fo = new FileOutputStream(fileName);


      PrintWriter outf = new PrintWriter(new DataOutputStream(fo));


      outf.println(dawnEditor.getText());


      outf.close();


    }catch(IOException e){ System.err.println(e.getMessage()); }


  } 


}









































