//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: G4NuclearLevelData.cc 86536 2014-11-13 19:05:21Z vnivanch $
//
// -------------------------------------------------------------------
//
//      GEANT4 source file 
//
//      File name:     G4NuclearLevelData
//
//      Author:        V.Ivanchenko
// 
//      Creation date: 10 February 2015
//
//      Modifications:
//      
// -------------------------------------------------------------------

#include "G4NuclearLevelData.hh"
#include "G4LevelReader.hh"
#include "G4LevelManager.hh"
#include "G4Element.hh"
#include "G4ElementTable.hh"
#include "G4DeexPrecoParameters.hh"
#include "G4PairingCorrection.hh"
#include "G4ShellCorrection.hh"
#include <iomanip>

G4NuclearLevelData* G4NuclearLevelData::theInstance = nullptr;

const G4int G4NuclearLevelData::AMIN[] = {1,
    1,3,4,5,7,8,10,12,14,16,                // Z= 1-10
   20,19,21,22,25,27,29,31,35,35,           // Z= 11-20
   39,39,42,42,44,45,50,48,53,54,           // Z= 21-30
   60,60,63,64,69,69,73,73,76,78,           // Z= 31-40
   81,83,85,88,90,91,93,96,98,100,          // Z= 41-50
  104,105,108,109,112,114,117,121,121,125,  // Z= 51-60
  128,129,130,134,135,139,140,143,144,149,  // Z= 61-70
  150,153,155,158,159,161,164,166,170,171,  // Z= 71-80
  176,178,184,186,191,193,199,201,206,208,  // Z= 81-90
  212,217,225,228,230,233,234,237,241,241,  // Z= 91-100
  245,248,252,253,255,258,260,263,266,269,  // Z=101-110
  272,277,282,0,289,0,293};                 // Z=111-117
const G4int G4NuclearLevelData::AMAX[] = {1,
    6,10,11,14,17,22,24,26,30,30,           // Z= 1-10
   37,40,42,44,46,48,51,53,56,58,           // Z= 11-20
   61,63,66,68,71,74,76,79,82,85,           // Z= 21-30
   87,90,92,95,98,101,103,107,109,112,      // Z= 31-40
  114,117,120,124,126,128,129,133,135,138,  // Z= 41-50
  140,143,145,148,151,152,153,155,155,161,  // Z= 51-60
  163,165,167,169,171,173,175,177,179,181,  // Z= 61-70
  184,189,192,194,198,202,204,205,210,216,  // Z= 71-80,
  217,220,224,227,229,229,233,234,235,238,  // Z= 81-90,
  239,242,244,247,248,252,253,256,257,259,  // Z= 91-100
  260,262,266,265,270,269,274,277,278,277,  // Z=101-110
  282,281,286,0,290,0,294};                 // Z=111-117
const G4int G4NuclearLevelData::LEVELIDX[] = {0,
     0,      6,     14,     22,     32,     43,     58,     73,     88,    105,     // Z= 1-10
   120,    138,    160,    182,    205,    227,    249,    272,    295,    317,     // Z= 11-20
   341,    364,    389,    414,    441,    469,    499,    526,    558,    588,     // Z= 21-30
   620,    648,    679,    709,    741,    771,    804,    835,    870,    904,     // Z= 31-40
   939,    973,   1008,   1044,   1081,   1118,   1156,   1193,   1231,   1269,     // Z= 41-50
  1308,   1345,   1384,   1422,   1462,   1502,   1541,   1578,   1613,   1648,     // Z= 51-60
  1685,   1721,   1758,   1796,   1832,   1869,   1904,   1940,   1975,   2011,     // Z= 61-70
  2044,   2079,   2116,   2154,   2191,   2231,   2273,   2314,   2354,   2395,     // Z= 71-80
  2441,   2483,   2526,   2567,   2609,   2648,   2685,   2720,   2754,   2784,     // Z= 81-90
  2815,   2843,   2869,   2889,   2909,   2928,   2948,   2968,   2988,   3005,     // Z= 91-100
  3024,   3040,   3055,   3070,   3083,   3099,   3111,   3126,   3141,   3154,     // Z= 101-110
  3163,   3174,   3179,   3184,   3184,   3186,   3186};                            // Z= 111-117

// obtained from PhotonEvaporation4.3.2
static const G4float LEVELMAX[3188] = {0.0f,
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //1-10
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  5.366f,   4.63f,  2.255f,  2.691f,    0.0f, //11-20
    0.0f,    0.0f,    0.0f,0.42908f, 27.494f, 17.495f,  7.371f,0.32004f,    0.0f,    0.0f, //21-30
    0.0f,    0.0f,   2.32f, 17.076f,  8.895f, 9.2717f,  2.723f,  4.131f,    0.0f,    0.0f, //31-40
    0.0f,    0.0f,    0.0f,    0.0f, 3.3537f, 10.679f,  16.57f, 15.108f, 11.306f,   0.74f, //41-50
  4.142f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //51-60
   15.3f,  11.05f,  13.39f,0.39727f,  5.772f, 2.6144f,    0.0f,    0.0f,  4.195f,    0.0f, //61-70
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 11.846f,  13.09f, 11.079f,  8.282f, 3.9449f, //71-80
  6.555f,  3.073f,  6.936f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //81-90
 11.193f,  7.584f, 10.411f, 6.6475f,  4.584f, 2.5722f,  6.873f, 1.8313f,   5.45f,  0.665f, //91-100
  1.281f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 3.6164f,  4.635f,  18.43f, 11.989f, //101-110
 11.533f, 4.4361f,  8.393f,   4.07f, 3.6913f,  0.885f,  3.904f,  0.931f,  2.235f,    0.0f, //111-120
 4.4679f,  9.813f, 12.592f,  6.578f,  4.289f, 0.2336f, 9.1867f, 3.5125f,  4.166f, 2.1136f, //121-130
  1.162f,  0.569f,  1.117f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //131-140
 6.2542f,  9.596f,  15.15f, 13.332f, 12.479f, 5.9258f, 8.4394f, 3.9857f, 5.4129f, 3.8145f, //141-150
  5.203f, 1.2424f,   2.12f,   0.67f,   0.66f,    0.0f,  2.016f,    0.0f,    0.0f,    0.0f, //151-160
    0.0f,   0.55f, 0.4258f,   7.97f,  6.695f,  8.952f, 7.4088f, 5.9936f, 9.3731f, 5.1495f, //161-170
  3.202f, 4.7304f,  0.657f,   1.02f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //171-180
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  5.677f, 8.3758f, 13.744f, 10.252f, 15.529f, //181-190
 6.5874f,  6.705f,  4.931f, 6.0233f, 2.1682f,  3.692f,  1.437f,  1.084f,    0.0f,  1.831f, //191-200
    0.0f,   0.77f,    0.0f,    0.0f,    0.0f,    0.0f,   1.12f,  2.104f,  8.379f, 8.0143f, //201-210
 13.879f, 7.9356f, 7.9666f, 7.9201f, 6.2205f,  2.281f,  7.897f,    0.0f,  2.167f,    0.0f, //211-220
   1.56f,    0.0f,  0.184f,    0.0f,    0.0f,    0.0f,    0.0f,  1.507f,  2.887f,  5.136f, //221-230
 10.146f, 12.048f, 10.779f, 16.649f, 6.9861f, 7.2719f, 4.3036f, 6.0053f,    0.0f, 5.0094f, //231-240
  0.904f,   0.89f,   0.94f,  3.257f,    0.0f,  0.952f,    0.0f,    0.0f,    0.0f,    0.0f, //241-250
    0.0f, 5.0463f, 5.5484f, 8.3055f, 12.572f, 8.5798f, 17.009f,  4.836f, 4.3544f, 4.0871f, //251-260
  2.451f, 3.0304f,  1.829f,  0.475f,  1.616f,  1.024f,    0.0f,    0.0f,    0.0f,    0.0f, //261-270
    0.0f,    0.0f,  1.867f,  3.819f,  5.542f, 12.276f, 22.365f, 8.7912f, 21.662f, 5.5355f, //271-280
 10.857f,  4.271f, 4.6339f, 4.2469f, 5.3515f, 4.3261f,  1.577f,    0.0f,  3.279f,    0.0f, //281-290
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 1.9179f, 5.0498f, 10.981f, 18.612f, 7.4724f, //291-300
 9.7407f,  5.978f, 3.7142f, 2.5743f, 4.5691f, 1.9443f, 5.8424f,  2.177f, 2.1042f, 0.1714f, //301-310
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  3.045f,  3.842f, 4.3837f, //311-320
   7.75f,  22.06f,  7.146f,  10.45f, 6.2237f, 12.188f, 4.9997f,  6.626f, 5.5034f, 9.5457f, //321-330
 5.6802f, 6.8692f,   3.53f, 2.5631f,    2.2f,  3.699f,    0.0f,    0.0f,    0.0f,    0.0f, //331-340
    0.0f,    0.0f,  6.148f, 6.2534f, 7.3549f, 9.1411f, 16.462f, 5.5415f,  10.31f, 6.6775f, //341-350
 15.662f, 1.8478f,  6.184f, 4.2657f,  3.382f,  0.247f,    0.0f, 0.7749f,    0.0f,    0.0f, //351-360
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  3.744f, 3.0664f,  14.55f,  13.03f, //361-370
 13.169f, 8.0051f,  9.977f, 8.8816f, 10.939f, 4.8821f, 9.0862f, 8.1317f, 6.4321f, 5.4631f, //371-380
 4.2098f,    0.0f,  2.881f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //381-390
    0.0f, 7.1595f, 13.631f, 15.258f, 13.282f, 9.1953f,   8.59f, 11.604f, 5.0389f, 4.0852f, //391-400
 2.2979f, 2.1528f,    0.0f, 2.4756f,  0.114f,    0.0f, 0.2021f,    0.0f,    0.0f,    0.0f, //401-410
  0.081f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  0.494f, 8.1625f, 10.022f, 17.378f, //411-420
   10.7f, 17.958f, 9.2616f, 12.795f, 11.291f,  12.54f, 7.4333f, 5.6033f,  12.95f, 4.6797f, //421-430
  0.503f, 4.6814f,  1.027f,  1.175f,    0.0f,  1.141f,    0.0f,    0.0f,    0.0f,    0.0f, //431-440
    0.0f,    0.0f,    0.0f,    0.0f, 6.2931f, 10.724f, 8.2774f, 19.636f, 12.066f, 11.159f, //441-450
 4.9981f, 10.559f, 7.4078f, 4.7103f, 9.8311f, 1.3507f,  9.235f, 2.3782f,    1.5f,    0.0f, //451-460
  0.188f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //461-470
    0.0f,    0.0f,  0.153f, 6.9944f,  12.65f, 7.3819f, 12.593f, 15.062f, 10.243f, 11.964f, //471-480
  8.323f, 12.813f, 4.9852f, 17.956f,  0.861f,  5.474f, 2.2231f, 4.6284f, 2.2919f,  1.407f, //481-490
  0.387f,  1.389f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //491-500
    0.0f, 4.1151f, 10.507f, 14.882f,   18.6f, 11.292f, 8.6251f, 9.5531f, 8.1224f, 4.8042f, //501-510
 2.3097f, 4.1671f,  1.561f, 3.2712f,  0.642f,    0.0f, 1.8165f,    0.0f,    0.0f,    0.0f, //511-520
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  3.247f, //521-530
 1.4534f, 6.4574f, 4.4831f, 22.459f, 8.3457f, 42.007f,  22.24f, 22.997f,   7.82f, 10.596f, //531-540
  4.461f,   8.24f, 4.0111f, 6.5798f,  2.155f, 5.7752f,    2.7f, 3.3612f, 1.2734f,  3.593f, //541-550
    0.0f,  1.763f,    0.0f,   2.42f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //551-560
    0.0f,  2.398f, 22.747f, 31.964f, 8.1327f, 9.4062f, 10.884f, 9.8643f, 4.7634f, 8.4843f, //561-570
 5.0772f, 3.4636f, 0.9563f,  3.828f, 1.9801f, 5.3307f, 2.5968f,  2.386f,    0.0f, 0.0662f, //571-580
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //581-590
    0.0f,  3.378f, 3.3862f, 33.899f, 32.617f, 42.521f,  9.774f, 24.869f, 19.887f, 7.6933f, //591-600
  4.684f, 18.016f,  2.378f, 6.1158f,  2.377f, 4.7703f, 2.0089f,  5.628f,  5.022f, 2.9744f, //601-610
 4.6053f,  3.106f,  3.304f,  1.492f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //611-620
  2.903f, 6.8423f, 14.465f, 5.6291f, 15.981f, 5.1092f, 10.083f, 7.7252f, 10.257f, 2.8864f, //621-630
 4.1652f,0.74133f, 2.9895f, 1.0857f, 4.1479f, 2.6024f, 3.9459f, 3.5539f, 3.3348f,   3.38f, //631-640
 1.6216f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  2.285f, //641-650
    0.0f, 9.2999f, 8.1524f,  18.08f,  4.848f, 22.959f, 9.1823f, 13.173f, 7.4159f, 8.8679f, //651-660
 2.3614f, 8.3611f, 6.5056f, 6.0652f, 6.0714f, 5.0782f, 4.2777f, 6.1553f, 4.4705f,  4.402f, //661-670
 1.9415f, 1.6704f, 2.3482f,  0.527f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //671-680
    0.0f, 9.7929f, 7.7913f, 8.4997f, 18.181f, 8.9417f, 9.6844f,  6.088f, 7.8614f,  1.129f, //681-690
  9.399f, 1.0645f, 4.4563f,  2.024f, 1.9648f, 1.8731f, 3.5627f,  1.092f, 4.8418f, 1.1983f, //691-700
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //701-710
  0.929f,    0.0f, 21.201f, 13.363f, 20.245f, 6.0355f, 20.798f, 10.468f, 13.202f, 10.243f, //711-720
 5.4325f, 7.4197f, 5.7838f, 3.6768f, 7.8185f, 3.2227f, 5.6886f, 4.9884f, 6.6046f, 5.1648f, //721-730
  3.302f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //731-740
    0.0f, 21.412f, 14.959f, 18.968f, 25.968f, 7.6143f, 13.682f,  9.415f, 11.344f, 6.0869f, //741-750
 8.8115f, 4.4501f, 3.7987f, 2.2433f,  5.635f, 2.7416f, 5.3906f,  3.814f, 3.9871f, 3.1541f, //751-760
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //761-770
    0.0f,    0.0f,    0.0f,  23.62f, 23.237f, 30.936f, 19.135f, 14.735f, 17.354f, 17.296f, //771-780
 11.822f, 11.484f, 5.7594f, 6.0117f, 6.3734f, 7.6532f, 4.7906f, 10.116f, 5.8215f, 7.9695f, //781-790
 4.7073f, 5.7301f, 4.4529f, 5.0788f, 3.1999f,   2.52f, 0.1955f, 0.5541f,    0.0f,    0.0f, //791-800
    0.0f,    0.0f,    0.0f,    0.0f, 21.612f, 32.365f, 2.0191f, 18.376f, 9.7229f, 15.984f, //801-810
 13.176f, 10.027f, 6.0137f,  9.342f, 7.3827f, 7.1071f,  8.651f, 3.3085f,  5.905f, 7.3913f, //811-820
 3.8813f, 6.2389f, 4.7881f, 6.7256f, 3.9442f,  0.835f, 1.1346f,    0.0f,    0.0f,    0.0f, //821-830
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  1.043f,    0.0f,  14.23f, 13.943f, 17.764f, //831-840
 8.1749f, 21.818f,  24.46f, 18.674f, 19.803f,  15.08f, 7.5549f, 10.874f, 7.0323f, 12.026f, //841-850
 7.9844f, 5.8279f,  5.742f,  7.363f, 6.7074f, 6.0637f,  6.176f, 7.5265f, 6.3059f, 3.6224f, //851-860
 2.3208f, 3.3456f, 1.3629f,  0.126f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //861-870
    0.0f,  0.787f,  5.702f,  12.46f,  17.67f, 18.897f,  19.47f,   17.8f, 11.099f, 12.415f, //871-880
 7.0166f, 9.6184f, 11.991f, 4.8351f, 6.8961f, 4.0479f,  4.314f, 2.9699f, 5.8102f, 1.9836f, //881-890
 3.5226f,  1.897f, 3.3895f,    1.7f, 2.6959f, 1.6896f,    0.0f,    0.0f,    0.0f,    0.0f, //891-900
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  3.789f, 7.7086f,  16.12f, 23.223f, 36.877f, //901-910
 11.141f, 20.532f, 10.092f,   11.2f, 9.6011f,  13.11f, 12.773f, 9.7222f, 7.2941f, 8.9806f, //911-920
 6.5618f, 6.8213f, 7.2959f, 6.5436f,  6.567f, 7.6149f, 6.5062f, 7.4517f,  4.028f, 4.2239f, //921-930
    0.0f,  0.607f,    0.0f, 0.5216f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,   1.18f, //931-940
  1.723f,  9.093f, 15.145f, 20.786f, 18.374f, 9.7372f, 7.2726f, 3.0718f, 10.137f, 3.7969f, //941-950
 10.955f,  6.496f, 8.6952f, 1.6147f, 2.2475f,    0.0f, 2.3363f, 0.7036f, 3.3966f, 2.2864f, //951-960
 3.6071f, 0.5143f, 1.0456f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //961-970
    0.0f,    0.0f,    0.0f, 4.2764f, 5.5996f, 12.766f, 11.838f, 14.058f, 7.5901f, 14.486f, //971-980
 10.749f, 11.215f,   9.67f, 11.588f, 10.509f, 9.8824f, 5.5025f, 4.6101f,  8.118f, 8.1137f, //981-990
  5.031f, 6.2005f,  6.308f, 7.2832f, 6.0757f,   7.66f,  5.057f, 5.3475f, 1.4436f, 2.5319f, //991-1000
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  1.524f,  1.599f, //1001-1010
 4.9129f, 20.291f, 11.246f, 20.862f, 7.8331f, 13.258f, 9.1864f, 14.461f, 10.047f, 8.3451f, //1011-1020
 3.1294f, 4.1779f, 4.3581f,  4.231f,0.35986f,  4.069f, 1.0173f, 2.7664f, 2.3395f, 4.3206f, //1021-1030
  2.359f, 4.2009f, 3.6771f, 3.9519f,   0.35f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //1031-1040
    0.0f,    0.0f,    0.0f, 3.4808f, 6.2392f, 6.3879f,   9.63f, 11.311f,  11.95f, 18.321f, //1041-1050
 12.161f, 11.601f, 17.292f, 17.237f, 19.254f, 20.198f, 9.8262f, 12.222f,  5.127f,  5.357f, //1051-1060
 3.6412f, 4.4457f, 3.7652f, 5.1544f, 2.7331f, 8.1598f, 7.5439f, 7.7493f, 3.4822f, 4.3195f, //1061-1070
 0.0617f, 2.1664f,    0.0f, 1.4156f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //1071-1080
    0.0f, 7.0196f,  9.744f, 6.9245f, 10.426f, 13.876f,   5.56f, 9.2422f, 9.4964f, 10.282f, //1081-1090
 14.519f, 17.234f, 15.978f, 7.9989f, 4.4759f, 4.7022f,  6.671f, 3.8021f, 2.2865f, 3.3456f, //1091-1100
 1.7662f, 4.2482f, 2.7694f,  4.006f, 2.0203f, 2.2801f,    0.0f,    0.0f,    0.0f,    0.0f, //1101-1110
 0.1572f,    0.0f,  0.271f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 2.5358f, 7.6629f, //1111-1120
 7.7002f, 10.418f,   7.04f,  7.523f, 10.863f, 4.5178f, 16.108f, 6.4882f, 15.414f, 17.357f, //1121-1130
 12.707f, 16.909f,  5.895f, 10.676f, 6.8279f,  4.958f, 4.4841f,  3.831f, 5.2219f, 4.5176f, //1131-1140
 5.2557f, 4.0712f, 7.8188f,  3.886f, 3.3024f,    0.0f, 3.4705f,  0.135f,  1.164f,    0.0f, //1141-1150
    1.3f,    0.0f, 2.1097f,    0.0f,  2.151f,    0.0f,    0.0f,   4.86f,    0.0f, 6.9485f, //1151-1160
 4.4757f, 7.7702f,  8.699f, 10.706f, 6.1075f, 8.2579f,  7.159f, 12.619f, 6.7608f, 8.7181f, //1161-1170
 4.3106f, 5.4145f, 2.6661f, 2.3527f, 1.8189f,0.78316f, 1.8858f,  3.239f,  2.672f, 0.3239f, //1171-1180
0.72042f,  0.326f, 0.8058f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //1181-1190
    0.0f,    0.0f,    0.0f,    0.0f, 2.4275f, 7.0998f, 9.3882f, 7.1789f, 10.514f, 11.878f, //1191-1200
 18.243f, 10.851f, 15.863f, 11.852f, 20.979f, 11.133f, 14.206f, 9.4072f, 9.3942f, 4.2015f, //1201-1210
 4.6052f, 3.8328f, 4.9689f, 4.5389f,  4.367f, 3.9881f, 5.5227f, 3.3902f, 3.1702f, 2.9102f, //1211-1220
 3.6636f, 3.6065f,  3.151f, 3.2399f,  1.429f,   1.94f,   2.13f,    0.0f,    0.0f,    0.0f, //1221-1230
    0.0f,    0.0f,  2.721f, 6.0742f, 9.0586f, 6.3034f, 6.1527f, 15.283f, 5.4832f,  6.989f, //1231-1240
 8.7931f, 6.3857f, 12.745f, 13.503f,  8.328f,  11.96f,  5.485f, 4.5831f, 1.4511f, 4.1875f, //1241-1250
    0.2f, 4.0259f,    0.0f,   3.89f,    0.0f, 2.7235f,0.24268f, 2.8633f,0.68823f, 3.5895f, //1251-1260
 1.1729f, 4.5789f, 5.3908f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 0.1717f, //1261-1270
  1.969f, 1.7846f,  9.998f, 10.288f, 19.932f, 6.0447f,  25.56f, 24.742f, 11.516f, 17.813f, //1271-1280
 12.965f,  18.22f, 17.871f, 9.0696f, 9.3219f, 4.0436f,   7.01f, 3.1033f,  8.993f,  3.228f, //1281-1290
 4.2838f,  3.306f, 8.4335f, 2.6235f, 4.9902f, 3.8995f,  4.898f, 3.9925f, 5.2628f, 6.6536f, //1291-1300
 7.2441f, 2.0046f, 2.5089f,    0.0f,  1.295f,    0.0f,  1.344f,    0.0f, 3.9738f, 6.7841f, //1301-1310
 14.217f, 7.2145f, 25.458f, 27.548f, 23.013f, 18.439f, 21.104f, 16.268f, 10.306f, 4.2456f, //1311-1320
 8.1846f, 2.9184f, 6.1139f, 2.8847f, 3.9728f,0.92057f, 7.3097f, 1.0596f, 5.3651f, 0.1279f, //1321-1330
 5.3543f,  0.833f, 3.2807f, 2.9831f, 3.5687f, 5.1092f, 6.9509f,  5.324f,  3.263f,    0.0f, //1331-1340
    0.0f,    0.0f,    0.0f,    0.0f,   0.15f,  3.127f,  0.721f, 10.546f, 13.752f, 20.637f, //1341-1350
 9.9578f, 28.646f, 8.7643f, 32.926f, 14.783f, 23.721f, 10.426f, 11.851f, 9.6987f, 6.0391f, //1351-1360
 8.5832f, 6.9141f, 8.0304f, 5.7514f, 3.5642f, 7.9153f, 6.2876f,  7.724f, 6.0824f, 7.6365f, //1361-1370
 5.1722f, 4.8903f, 6.1635f, 7.7224f, 6.6692f,   5.16f, 3.6273f, 2.7603f, 2.2105f,    0.0f, //1371-1380
    0.0f,    0.0f,    0.0f,    0.0f, 4.6208f,  7.075f, 13.017f, 8.7122f, 31.621f,  8.576f, //1381-1390
 19.449f, 11.403f, 21.128f, 2.8059f, 11.823f, 6.3618f, 11.143f, 8.3232f, 8.9855f, 5.5555f, //1391-1400
 3.8679f, 1.1022f, 3.3503f, 4.1498f,  3.408f, 1.0791f, 2.3522f,0.27786f, 4.0473f, 1.1065f, //1401-1410
 5.8492f, 4.0745f, 3.8528f,    0.0f, 3.3323f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //1411-1420
    0.0f,    0.0f, 1.8897f,    0.0f, 4.4691f, 13.218f, 34.591f, 11.183f, 23.483f, 24.255f, //1421-1430
 15.399f, 20.542f,  12.15f, 13.651f, 13.473f, 9.4266f,  16.53f, 37.618f, 8.7448f,  9.523f, //1431-1440
 5.5734f, 3.8291f, 6.9713f, 3.1859f, 4.1884f, 2.1237f, 3.4923f, 3.1699f,  6.624f, 5.1702f, //1441-1450
  5.814f, 5.0965f, 5.5036f, 3.3657f, 4.5112f, 1.9627f, 2.3027f,    0.0f,    0.0f,    0.0f, //1451-1460
    0.0f, 2.1434f,   8.29f, 6.1544f,    0.0f, 10.381f, 14.396f,    0.0f,  4.891f,  7.126f, //1461-1470
 12.184f,  7.873f, 11.233f,  6.127f,  11.31f,  8.687f, 5.8654f, 4.9467f, 8.0995f, 4.0405f, //1471-1480
 5.7351f, 5.6965f, 2.8342f, 2.2537f, 1.6329f,    0.0f, 5.4942f, 2.5084f, 4.2277f, 2.9303f, //1481-1490
 4.3457f, 4.0013f, 3.1181f,  1.426f, 1.5108f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //1491-1500
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  6.446f, 19.082f, 20.601f, 9.0649f,  10.75f, //1501-1510
 13.551f, 25.371f, 11.179f, 16.895f, 13.477f, 18.217f, 10.388f, 8.0228f, 6.4409f, 8.3104f, //1511-1520
  8.052f, 5.2309f, 5.8502f, 4.1374f, 4.7644f, 6.4343f, 3.9508f, 5.7653f, 4.9317f, 5.2804f, //1521-1530
 3.9443f, 5.0276f,  4.623f, 4.0718f, 2.3652f,  2.867f,    0.0f,    0.0f,    0.0f,    0.0f, //1531-1540
    0.0f,    0.0f,    0.0f,    0.0f,  7.718f,    0.0f, 17.663f, 14.185f, 14.391f, 6.4758f, //1541-1550
 21.268f,  9.255f, 16.478f, 9.7134f, 17.252f, 5.2166f, 6.2833f,  7.179f, 7.1596f,  5.479f, //1551-1560
 5.9853f, 1.7885f, 8.5821f, 3.0101f, 2.7443f, 1.5393f,   4.35f, 1.2402f, 4.1525f, 2.1657f, //1561-1570
  3.677f,  2.226f, 0.8939f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 3.6427f, 5.8331f, //1571-1580
 11.735f, 15.066f, 16.603f, 9.8191f, 17.839f, 18.905f, 25.065f, 28.556f, 38.188f, 22.002f, //1581-1590
 17.039f, 8.0346f, 8.6258f, 7.6612f, 8.8731f, 3.7014f, 5.6601f, 2.5231f, 6.8799f, 2.8251f, //1591-1600
 3.9736f, 4.5905f,   4.69f,   3.47f, 5.3112f,  3.634f, 4.3673f, 2.5818f, 2.9249f,    0.0f, //1601-1610
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 12.279f, 17.151f,  8.429f,  9.552f, //1611-1620
  7.858f, 12.411f, 12.757f, 15.734f, 16.356f, 13.656f, 10.745f, 7.8242f,  7.434f,  4.617f, //1621-1630
 4.8626f,  4.718f, 8.8805f, 1.1757f, 1.3974f,0.13352f, 1.6088f,0.50295f, 2.2496f,0.76546f, //1631-1640
 3.1859f,  0.897f, 2.5919f, 3.0022f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //1641-1650
 2.6538f, 15.765f, 13.081f, 16.107f, 21.847f, 19.906f, 21.007f, 21.889f, 27.517f, 23.972f, //1651-1660
 21.439f,  6.508f,  26.69f, 9.3653f, 12.159f, 11.788f,  8.946f,  6.081f,  7.364f, 5.2072f, //1661-1670
 3.8609f, 1.1665f, 3.2796f, 3.2208f,  4.001f, 2.9363f, 3.3993f,    0.0f,  2.737f,    0.0f, //1671-1680
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  6.537f, 4.9648f, 9.8777f, //1681-1690
 7.4389f, 6.8243f, 12.955f, 6.2838f, 6.8641f, 10.592f, 5.0213f, 7.3537f, 7.0303f, 10.535f, //1691-1700
 8.5958f, 7.2168f, 6.8764f, 7.9774f, 0.8006f, 2.1223f, 0.3693f,  2.434f, 0.6599f, 2.1725f, //1701-1710
   1.69f, 2.7706f, 0.6187f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //1711-1720
    0.0f,  0.122f,    0.0f,  4.245f, 7.0015f,  2.594f, 12.599f, 19.618f,   9.54f,  13.31f, //1721-1730
 11.115f, 8.1008f, 11.238f,  23.37f, 12.248f, 12.739f, 15.283f, 6.1768f, 3.4678f, 11.525f, //1731-1740
  5.802f, 9.7369f,  4.574f, 4.7496f, 3.4675f, 6.4652f, 1.3621f,  3.335f, 1.6945f, 2.3349f, //1741-1750
  3.142f, 2.2584f,    0.0f,    0.0f,    0.0f, 1.4855f,    0.0f,    0.0f,    0.0f,    0.0f, //1751-1760
    0.0f,    0.0f,    0.0f,    0.0f,  4.645f, 6.6324f, 7.2656f, 7.3347f, 9.0354f, 16.899f, //1761-1770
 26.393f, 18.711f, 11.234f, 3.4709f,  21.43f, 18.293f, 7.6842f, 6.1919f, 5.7769f, 2.5922f, //1771-1780
 4.9286f,  0.952f, 2.1987f,0.51329f, 1.4631f,    0.0f, 1.0518f,    0.0f,    0.0f,    0.0f, //1781-1790
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  7.443f, //1791-1800
 10.498f, 6.4229f,  13.32f,  14.58f, 14.532f, 22.262f,  19.34f, 17.885f,   22.1f, 22.449f, //1801-1810
 35.996f, 23.397f, 24.919f, 18.722f, 7.0352f, 7.3531f, 6.2406f, 6.5826f,  3.842f, 3.9233f, //1811-1820
 1.5209f,   3.55f,   1.49f, 2.8571f,    0.0f, 2.3769f,    0.0f, 1.6015f,    0.0f,    0.0f, //1821-1830
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 3.0429f,  6.712f, 6.7863f, 10.126f, //1831-1840
 5.3799f, 14.119f, 2.1568f, 14.344f, 14.091f, 19.595f, 21.805f, 35.544f, 18.003f,  7.447f, //1841-1850
   7.45f,  17.07f, 15.907f, 6.5819f, 0.3884f,  3.794f,0.76797f, 1.8569f,0.44211f,  0.373f, //1851-1860
    0.0f,    0.0f, 1.0155f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 2.1661f, //1861-1870
    0.0f, 3.2412f, 8.4975f, 4.6021f, 2.7442f,  6.095f, 3.6506f, 14.235f, 14.233f, 16.291f, //1871-1880
 21.825f,  34.66f, 21.565f, 22.435f,  18.45f, 30.241f,  12.72f,  7.454f, 13.897f, 7.2306f, //1881-1890
  5.799f,  7.276f, 5.0034f, 4.2123f, 3.9791f,  3.119f, 0.0978f,  1.315f,    0.0f,  0.235f, //1891-1900
    0.0f,    0.0f,    0.0f,    0.0f, 4.0846f,    0.0f,  0.318f, 4.6911f, 2.6816f,    0.0f, //1901-1910
 8.6613f, 3.7894f, 5.0987f, 10.753f, 9.9587f, 12.939f, 18.466f,  5.435f, 8.5161f, 10.248f, //1911-1920
 15.876f, 13.422f,  5.331f,   5.77f,  5.949f,  5.882f, 4.3429f,  0.581f, 4.1095f, 1.1901f, //1921-1930
  1.919f,0.63041f, 1.5782f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //1931-1940
   0.33f,    0.0f,    0.0f,  5.008f, 9.5907f, 3.2427f, 9.5086f, 10.287f, 14.945f, 8.4096f, //1941-1950
  16.03f, 17.086f, 16.583f, 19.505f, 24.115f, 17.888f, 22.788f, 26.143f, 27.581f, 13.865f, //1951-1960
 11.549f, 1.6218f,  3.498f, 3.7561f,  3.921f,  4.549f, 7.5314f, 2.1041f, 1.3967f,    0.0f, //1961-1970
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 3.3115f,    0.0f, 3.5235f,    0.0f,    0.0f, //1971-1980
 0.6713f, 6.9085f, 2.5551f, 9.1688f, 6.1412f, 0.6142f,  4.773f, 13.242f, 10.357f, 8.1322f, //1981-1990
  8.635f, 11.582f, 15.865f, 14.882f, 5.8891f, 10.051f, 9.3388f,  2.799f,  4.951f, 5.5983f, //1991-2000
 3.8641f, 1.4006f,0.79742f, 1.2129f, 0.7729f, 1.3677f,    0.0f,    0.0f,    0.0f,    0.0f, //2001-2010
    0.0f,    0.0f,  2.448f, 2.7445f, 2.5782f, 7.6099f, 2.2813f, 10.232f, 6.9884f,  13.96f, //2011-2020
 11.971f, 15.403f, 15.709f, 12.392f,  6.081f, 12.931f, 11.848f, 12.716f, 16.767f, 16.846f, //2021-2030
 10.961f, 5.0848f, 4.8797f,  3.863f,  2.018f,   4.61f,  4.425f,  4.729f, 2.9788f,   2.77f, //2031-2040
    0.0f,    0.0f,    0.0f,    0.0f, 3.9984f,    0.0f, 2.6329f, 2.4313f,  4.528f, 5.2867f, //2041-2050
 8.5435f,    0.0f, 6.4758f, 5.1397f, 15.943f, 9.3446f, 18.436f, 19.112f, 16.462f, 4.6733f, //2051-2060
 16.821f,  6.293f, 6.9628f, 8.3751f, 10.907f,  0.602f, 1.8369f, 1.8828f,  3.524f, 3.0213f, //2061-2070
 2.4978f, 0.3908f, 1.5862f, 0.9816f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  2.671f, //2071-2080
    0.0f, 5.0193f, 6.4994f, 9.1066f, 7.0098f, 7.7475f, 11.599f, 14.178f, 11.972f, 11.219f, //2081-2090
 9.9276f, 16.006f, 11.941f, 19.176f, 15.295f,   19.1f, 14.368f, 12.644f,  15.62f,  16.46f, //2091-2100
 26.178f, 4.8635f, 5.0647f, 5.3886f, 4.2047f, 5.0575f, 3.0969f, 4.7339f, 1.6048f, 1.2722f, //2101-2110
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 1.9116f, //2111-2120
    0.0f,  6.764f,    0.0f, 7.2134f, 3.3507f, 6.1682f, 3.9721f, 14.483f,  5.177f, 11.993f, //2121-2130
 4.9183f,  9.817f, 4.7857f, 4.7272f, 7.5245f, 5.6101f,  6.562f, 6.4373f, 5.8217f, 5.9537f, //2131-2140
 4.1868f, 6.4177f, 6.0629f, 1.7843f, 0.6172f, 1.2585f,    0.0f,    0.0f,    0.0f,    0.0f, //2141-2150
  0.175f,    0.0f,    0.0f,    0.0f,    0.0f, 4.8611f,    0.0f,   0.45f,  7.737f, 9.2967f, //2151-2160
 7.4704f, 10.076f,  9.662f, 11.128f,  7.224f,  11.37f, 9.7766f, 9.0844f, 3.8879f, 4.6062f, //2161-2170
 4.0387f, 6.9217f, 7.2047f, 13.394f, 6.7925f,  7.632f,  8.655f, 5.6669f, 3.6661f, 6.7601f, //2171-2180
 3.2769f,  6.417f, 3.3438f, 1.5382f,    0.0f,  2.381f,    0.0f,  0.219f,    0.0f,    0.0f, //2181-2190
    0.0f,    0.0f, 4.4008f,    0.0f,    0.0f,    0.0f,    0.0f,  0.175f,  0.092f, 0.3492f, //2191-2200
 4.7279f, 0.3701f, 7.3785f, 0.9063f,  7.566f,  6.042f, 12.733f, 7.8227f, 10.824f, 5.9987f, //2201-2210
  5.408f, 4.8181f, 7.5907f,  5.858f, 2.3926f, 2.9915f,  4.799f,0.99784f, 2.1996f,0.75766f, //2211-2220
 0.4824f, 0.3197f,    0.0f,  0.267f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2221-2230
    0.0f, 2.1895f,    0.0f, 2.8393f, 2.6094f, 3.9108f, 3.9845f, 5.1584f,  3.625f, 6.7068f, //2231-2240
 6.2602f, 8.6901f,  7.541f, 10.545f, 7.0075f,  6.683f,  5.612f, 13.518f,  11.02f, 11.147f, //2241-2250
 12.741f, 13.482f, 4.1802f, 10.671f, 7.3585f, 7.7774f, 1.2104f, 4.5075f, 1.4723f, 5.1304f, //2251-2260
   2.64f, 4.1138f, 1.4595f,  2.541f, 1.4647f,    0.0f,    0.0f, 3.1985f,    0.0f,    0.0f, //2261-2270
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  0.072f, 3.4415f, 2.0874f, 3.6317f, //2271-2280
 0.1684f,  6.254f,    0.0f,  6.076f,   7.14f, 9.1252f, 9.2007f, 6.8299f, 5.0893f, 7.0521f, //2281-2290
 3.8694f,  6.987f, 3.1382f, 5.0544f, 4.7856f,  5.497f, 0.9235f, 2.3332f,  1.181f, 2.3121f, //2291-2300
 6.1981f,  2.404f,0.54259f,0.94375f,0.52237f,    0.0f, 0.1164f,    0.0f,    0.0f,    0.0f, //2301-2310
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 2.0332f,  0.545f, 2.6366f, 3.5166f,  4.218f, //2311-2320
  4.085f,  3.449f,  4.231f, 6.8786f, 4.6838f, 6.6012f, 8.1748f,  7.434f, 7.0384f, 7.3969f, //2321-2330
 5.2578f, 7.7332f, 4.9136f, 7.4078f, 5.5103f, 6.5531f, 2.8648f, 4.2143f, 6.1489f, 4.9507f, //2331-2340
 3.1292f, 4.5298f, 2.5926f, 3.4243f,0.74782f,  3.017f,  0.424f, 3.2266f, 1.4555f, 1.7885f, //2341-2350
    0.0f,  3.153f,    0.0f,    0.0f,    0.0f, 1.8274f, 2.1985f,    0.0f, 5.4301f, 1.7992f, //2351-2360
 6.1583f,    0.0f, 7.1722f,    0.0f, 5.7177f, 4.5791f, 7.8795f, 6.3223f,  7.038f,  3.954f, //2361-2370
   7.22f, 5.3252f, 9.5804f, 5.3789f, 10.935f, 4.6355f, 4.0632f, 2.1848f,  2.792f, 1.6729f, //2371-2380
  1.242f, 1.5604f, 1.7705f,0.46871f,   1.76f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2381-2390
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 2.2786f,    0.0f,    0.0f,  2.523f, 2.8744f, //2391-2400
 1.7955f, 5.5345f, 5.2669f, 5.8034f, 2.9527f, 5.1081f, 4.7019f, 7.3176f, 4.7027f,  8.873f, //2401-2410
 4.8702f, 7.9412f, 6.8197f, 10.031f, 8.7932f, 11.427f, 11.406f, 18.664f, 11.574f, 8.6523f, //2411-2420
 4.0612f, 5.2842f, 3.0684f, 6.1621f, 1.1878f,  4.922f, 1.4883f, 3.6893f, 2.5795f, 6.2766f, //2421-2430
    0.0f, 1.2969f,    0.0f,  1.366f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2431-2440
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  3.657f,   0.52f,  3.915f, 0.3198f, 4.6724f, //2441-2450
 0.9716f,  5.608f, 0.8768f, 6.3331f, 1.8545f, 6.9284f, 7.4519f, 13.772f,  6.815f, 8.8743f, //2451-2460
 3.6298f, 3.9657f, 4.0664f, 2.6432f, 2.5481f, 2.7474f, 2.0448f, 6.4188f, 6.6548f, 8.4086f, //2461-2470
 2.6431f,  4.418f,  1.728f, 0.8683f, 0.2536f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2471-2480
    0.0f,    0.0f,    0.0f,    0.0f,  2.138f,    0.0f, 2.8122f,    0.0f, 1.6634f,  0.278f, //2481-2490
 3.3139f,  1.723f, 4.1665f, 3.1024f, 5.3303f,  5.142f, 9.6693f,  7.932f,  12.37f,  7.538f, //2491-2500
 13.516f, 10.406f, 12.699f,  10.66f, 8.6305f, 8.6548f, 9.2054f, 5.5718f, 8.1261f, 6.8658f, //2501-2510
 8.7056f,  7.306f, 13.675f,  4.142f,  4.133f, 5.5574f, 0.8049f,    0.0f,  1.365f,    0.0f, //2511-2520
  1.459f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  1.063f,    0.0f, //2521-2530
  2.973f,  0.273f, 1.7366f,    0.0f,  3.401f,  0.396f, 2.9226f, 5.4847f, 4.0248f, 3.9636f, //2531-2540
 4.2969f, 3.5777f, 5.2835f, 7.2753f, 5.8247f,  3.809f, 6.7188f, 4.3053f, 4.5599f, 5.6266f, //2541-2550
  7.632f,  5.996f,  6.191f, 0.4945f, 0.7589f,0.88804f, 1.9598f,    0.0f,  1.436f,    0.0f, //2551-2560
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  0.194f, //2561-2570
 3.0402f,  1.671f, 2.2946f, 1.1297f, 3.3265f, 2.0207f, 3.6467f, 1.6862f, 5.1133f,  3.931f, //2571-2580
 5.2269f, 3.7108f, 5.5289f, 4.3583f, 5.9111f, 4.6288f, 9.7247f, 4.3463f, 9.6437f, 4.3542f, //2581-2590
 10.084f,  4.911f,  2.922f, 1.3282f, 3.2624f, 2.1595f, 2.2338f, 0.2647f, 2.2868f,    0.0f, //2591-2600
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2601-2610
    0.0f,    0.0f,  1.636f, 0.1579f,  0.324f,    0.0f,  0.573f,  0.344f, 2.0774f, 0.3917f, //2611-2620
 2.7011f, 2.3462f,  4.546f, 2.9023f, 2.1495f, 4.3669f,  4.695f, 9.0673f, 10.016f, 4.7716f, //2621-2630
  2.926f, 0.7284f,  0.517f, 0.4793f, 0.8919f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2631-2640
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2641-2650
    0.0f,    0.0f, 2.3838f,    0.0f, 2.7762f,    0.0f, 2.7755f, 4.7208f, 4.5832f, 4.0594f, //2651-2660
 4.1298f,  3.013f, 5.9306f, 7.3077f, 12.026f, 11.232f, 10.612f, 8.8319f,  5.051f, 2.2871f, //2661-2670
 4.2997f, 0.6189f, 5.1678f, 0.7328f, 3.9615f,    0.0f, 3.6961f,    0.0f,    0.0f,    0.0f, //2671-2680
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2681-2690
    0.0f,  0.531f, 1.8852f,  0.827f,    0.0f,  5.292f,   8.23f, 8.5334f, 8.0948f,  8.658f, //2691-2700
 3.4623f,  1.973f, 3.0023f, 3.0451f,  0.778f, 0.5111f, 0.8242f,    0.0f, 1.6954f,    0.0f, //2701-2710
 1.7498f,    0.0f,0.95506f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2711-2720
    0.0f,    0.0f,    0.0f,    0.0f, 2.0101f,    0.0f, 2.1474f,    0.0f,  4.257f, 1.1981f, //2721-2730
 3.9294f,   1.77f,   7.87f, 6.2832f, 6.2661f,     5.f, 6.6788f, 4.3458f, 6.2555f, 1.3758f, //2731-2740
 3.2877f, 1.0289f, 2.3687f, 0.7241f,  2.382f, 1.4748f, 3.4189f, 1.7205f, 2.4183f, 1.7739f, //2741-2750
   1.05f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 0.1336f, //2751-2760
  1.884f, 0.0918f,  2.438f,  0.322f,  2.013f, 2.5077f, 3.7208f, 3.4056f, 2.5144f,    0.0f, //2761-2770
 0.1675f,  0.452f,0.25704f,    0.0f, 0.8747f,0.03307f, 0.3355f,0.63577f, 2.9997f, 0.4785f, //2771-2780
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  2.181f, //2781-2790
 1.4213f, 3.6814f, 0.6738f,  2.104f,  2.322f,  4.892f, 2.4215f, 5.0979f, 1.7025f,  2.864f, //2791-2800
 2.4944f, 3.0971f, 2.1663f, 3.2834f,0.77929f,  3.819f,  1.173f,  5.164f,  4.512f, 3.7751f, //2801-2810
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2811-2820
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2821-2830
    0.0f, 0.8408f,    0.0f,   2.14f,    0.0f, 4.0515f,0.18673f,0.75575f,0.67811f,    0.0f, //2831-2840
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2841-2850
    0.0f,  1.847f,    0.0f,    0.0f,    0.0f,  3.243f, 1.2681f, 2.6598f,  3.174f,  4.807f, //2851-2860
 4.0407f,  5.077f,  4.835f,  5.513f,  3.107f, 1.2761f,    0.0f,    0.0f,    0.0f,    0.0f, //2861-2870
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 1.2433f,    0.0f,  3.401f,    0.0f, //2871-2880
 4.6146f,0.64676f, 1.1971f, 0.2998f,    0.0f, 0.6406f,    0.0f,    0.0f,    0.0f,    0.0f, //2881-2890
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 1.1188f,  1.786f, 1.0006f, 4.2652f,  4.413f, //2891-2900
 6.0963f, 1.3577f,  4.172f, 5.0342f,  6.123f,  0.766f, 1.1408f,    0.0f,    0.0f,    0.0f, //2901-2910
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,  0.557f,    0.0f, 5.9809f, //2911-2920
    2.2f, 0.5324f, 0.8789f, 1.1856f,0.29937f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2921-2930
    0.0f,    0.0f,    0.0f,    0.0f,  0.038f, 0.4202f,  0.288f, 0.0874f, 1.1059f, 1.1023f, //2931-2940
 4.0332f, 0.5817f, 5.6807f, 4.7135f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2941-2950
    0.0f,    0.0f,    0.0f,   0.24f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2951-2960
 0.4894f,   0.59f, 1.2275f,  0.471f, 0.9784f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //2961-2970
    0.0f,    0.0f,    0.0f,  0.315f,    0.0f,  0.055f,    0.0f,  0.738f, 0.7373f,  3.315f, //2971-2980
 1.6952f,   1.25f, 0.9698f,  0.417f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 0.2096f, //2981-2990
    0.0f, 0.2532f,    0.0f,    0.0f,    0.0f, 0.3532f,    0.0f,  1.357f,    0.6f,  0.435f, //2991-3000
 0.4692f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3001-3010
    0.0f,  2.372f,  0.669f,    0.0f,0.55843f,    0.0f,  0.398f,0.73365f, 0.2311f, 1.5602f, //3011-3020
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 3.1278f, //3021-3030
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3031-3040
    0.0f,    0.0f, 1.6997f, 2.8792f,  3.465f,  2.839f,    0.0f,    0.0f,    0.0f,    0.0f, //3041-3050
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, 1.8999f,    0.0f,    0.0f, //3051-3060
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3061-3070
    0.0f,  0.656f,  2.868f,  1.157f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3071-3080
    0.0f,    0.0f,    0.0f,    0.0f,    0.6f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3081-3090
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3091-3100
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3101-3110
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3111-3120
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3121-3130
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3131-3140
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3141-3150
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3151-3160
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3161-3170
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f, //3171-3180
    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f,    0.0f};

#ifdef G4MULTITHREADED
G4Mutex G4NuclearLevelData::nuclearLevelDataMutex = G4MUTEX_INITIALIZER;
#endif

G4NuclearLevelData* G4NuclearLevelData::GetInstance()
{
  if (!theInstance)  { 
#ifdef G4MULTITHREADED
    G4MUTEXLOCK(&nuclearLevelDataMutex);
    if (!theInstance)  { 
#endif
      static G4NuclearLevelData theData;
      theInstance = &theData; 
#ifdef G4MULTITHREADED
    }
    G4MUTEXUNLOCK(&nuclearLevelDataMutex);
#endif
  }
  return theInstance;
}   

G4NuclearLevelData::G4NuclearLevelData()
{
  fDeexPrecoParameters = new G4DeexPrecoParameters();
  fLevelReader = new G4LevelReader(this);
  for(G4int Z=0; Z<ZMAX; ++Z) {
    (fLevelManagers[Z]).resize(AMAX[Z]-AMIN[Z]+1,nullptr);
    (fLevelManagerFlags[Z]).resize(AMAX[Z]-AMIN[Z]+1,false);
  }
  fShellCorrection = new G4ShellCorrection();
  fPairingCorrection = new G4PairingCorrection();
}

G4NuclearLevelData::~G4NuclearLevelData()
{
  delete fLevelReader;
  delete fDeexPrecoParameters;
  delete fShellCorrection;
  delete fPairingCorrection;
  for(G4int Z=1; Z<ZMAX; ++Z) {
    size_t nn = (fLevelManagers[Z]).size();
    for(size_t j=0; j<nn; ++j) { 
      //G4cout << " G4NuclearLevelData delete Z= " << Z 
      //       << " A= " << AMIN[Z]+j << G4endl;
      delete (fLevelManagers[Z])[j]; 
    }
  }
}

const G4LevelManager* 
G4NuclearLevelData::GetLevelManager(G4int Z, G4int A)
{
  const G4LevelManager* man = nullptr;
  //G4cout << "G4NuclearLevelData: Z= " << Z << " A= " << A << G4endl;  
  if(0 < Z && Z < ZMAX && A >= AMIN[Z] && A <= AMAX[Z]) {
    if(!(fLevelManagerFlags[Z])[A - AMIN[Z]]) {
      InitialiseForIsotope(Z, A);
    }
    man = (fLevelManagers[Z])[A - AMIN[Z]];
  }
  //G4cout << man << G4endl;
  return man;
}

G4bool 
G4NuclearLevelData::AddPrivateData(G4int Z, G4int A, const G4String& filename)
{
  G4bool res = false; 
#ifdef G4MULTITHREADED
  G4MUTEXLOCK(&nuclearLevelDataMutex);
#endif
  if(Z > 0 && Z < ZMAX && A >= AMIN[Z] && A <= AMAX[Z]) { 
    const G4LevelManager* newman = 
      fLevelReader->MakeLevelManager(Z, A, filename);
    if(newman) { 
      delete (fLevelManagers[Z])[A - AMIN[Z]]; 
      (fLevelManagers[Z])[A - AMIN[Z]] = newman;
      (fLevelManagerFlags[Z])[A - AMIN[Z]] = true;
      res = true;
    }
  } else {
    G4ExceptionDescription ed;
    ed << "private nuclear level data for Z= " << Z << " A= " << A
       << " outside allowed limits ";
    G4Exception("G4NuclearLevelData::AddPrivateData","had0433",FatalException,
		ed,"Stop execution");
  }
  G4cout << "AddPrivateData done" << G4endl;
#ifdef G4MULTITHREADED
  G4MUTEXUNLOCK(&nuclearLevelDataMutex);
#endif
  return res;
}

G4int G4NuclearLevelData::GetMinA(G4int Z) const
{
  return (Z >= 0 && Z < ZMAX) ? AMIN[Z] : 0;
}

G4int G4NuclearLevelData::GetMaxA(G4int Z) const
{
  return (Z >= 0 && Z < ZMAX) ? AMAX[Z] : 0; 
}

void G4NuclearLevelData::InitialiseForIsotope(G4int Z, G4int A)
{
#ifdef G4MULTITHREADED
  G4MUTEXLOCK(&nuclearLevelDataMutex);
#endif
  if(!(fLevelManagerFlags[Z])[A - AMIN[Z]]) {
    (fLevelManagers[Z])[A - AMIN[Z]] = 
      fLevelReader->CreateLevelManager(Z, A);
    (fLevelManagerFlags[Z])[A - AMIN[Z]] = true;
  }
#ifdef G4MULTITHREADED
  G4MUTEXUNLOCK(&nuclearLevelDataMutex);
#endif
}

G4double G4NuclearLevelData::GetMaxLevelEnergy(G4int Z, G4int A) const
{
  return (0 < Z && Z < ZMAX && A >= AMIN[Z] && A <= AMAX[Z]) ?
    (G4double)(LEVELMAX[LEVELIDX[Z] + A - AMIN[Z]]) : 0.0;
}

G4float G4NuclearLevelData::MaxLevelEnergy(G4int Z, G4int A) const
{
  return (0 < Z && Z < ZMAX && A >= AMIN[Z] && A <= AMAX[Z]) ?
    (LEVELMAX[LEVELIDX[Z] + A - AMIN[Z]]) : 0.0f;
}

G4double G4NuclearLevelData::GetLevelEnergy(G4int Z, G4int A, G4double energy)
{
  G4double e = energy;
  if(e <= GetMaxLevelEnergy(Z, A)) {
    const G4LevelManager* man = GetLevelManager(Z, A);
    if(man != nullptr) { 
      e = (G4double)man->NearestLevelEnergy(e, man->NumberOfTransitions()); 
    }
  }
  return e;
}

G4double 
G4NuclearLevelData::GetLowEdgeLevelEnergy(G4int Z, G4int A, G4double energy)
{
  G4double e = GetMaxLevelEnergy(Z, A);
  if(energy < e) { 
    const G4LevelManager* man = GetLevelManager(Z, A);
    if(man != nullptr) { 
      e = (G4double)man->NearestLowEdgeLevelEnergy(energy); 
    }
  }
  return e;
}

G4double 
G4NuclearLevelData::FindLevel(G4int Z, G4int A, G4double resMass, 
		              G4double Mass, G4double partMass, G4double ekin)
{
  G4double T = ekin;
  G4double E2 = (Mass - partMass)*(Mass - partMass);
  G4double Eex = std::sqrt(E2 - 2.0*Mass*T) - resMass;
  if(Eex <= GetMaxLevelEnergy(Z, A)) {
    if(Eex <= 0.0) { 
      Eex = 0.0;
      T = (E2 - resMass*resMass)*0.5/Mass; 
    } else {
      const G4LevelManager* man = GetLevelManager(Z, A);
      if(man != nullptr) {
        size_t idx = man->NearestLevelIndex(Eex, man->NumberOfTransitions());
	for(;;) {
	  Eex = (G4double)man->LevelEnergy(idx);
	  T = (E2 - (resMass+Eex)*(resMass+Eex))*0.5/Mass;
	  if(T >= 0.0 || 0 == idx) { break; }
          --idx; 
	}
      }
    }
    T = std::max(T, 0.0);	
  }
  return T;
}

G4DeexPrecoParameters* G4NuclearLevelData::GetParameters()
{
  return fDeexPrecoParameters;
}

G4PairingCorrection* G4NuclearLevelData::GetPairingCorrection()
{
  return fPairingCorrection;
}

G4ShellCorrection* G4NuclearLevelData::GetShellCorrection()
{
  return fShellCorrection;
}

void G4NuclearLevelData::StreamLevels(std::ostream& os, 
                                      G4int Z, G4int A) const
{
  if(0 < Z && Z < ZMAX && A >= AMIN[Z] && A <= AMAX[Z]) {
    const G4LevelManager* man = (fLevelManagers[Z])[A - AMIN[Z]];
    if(man) { 
      os << "Level data for Z= " << Z << " A= " << A << "  " 
	 << man->NumberOfTransitions() + 1 << " levels \n";
      man->StreamInfo(os);
    }
  }
}
