// $Id$
// The example class categories definitions for Doxygen

/// \file Doxymodules_parallel.h
/// \brief The page that defines the extended/parallel examples modules 


/** @defgroup extended_parallel parallel
 *  Extended examples parallel classes
 *  @{
 */


/** @defgroup extended_parallel_MPI MPI
 *  Extended examples parallel MPI classes
 *  @{
 */


/** @defgroup extended_parallel_MPI_exMPI01 exMPI01
 *  Parallel MPI exMPI01 example has its 
 *  <a href="../html_exMPI01/html/index.html">standalone documentation </a>
 *  @ingroup extended_parallel_MPI
 *  @{
 */

/** @} */

/** @defgroup extended_parallel_MPI_exMPI02 exMPI02
 *  Parallel MPI exMPI02 example has its 
 *  <a href="../html_exMPI02/html/index.html">standalone documentation </a>
 *  @ingroup extended_parallel_MPI
 *  @{
 */

/** @} */

/** @defgroup extended_parallel_MPI_exMPI03 exMPI03
 *  Parallel MPI exMPI03 example has its 
 *  <a href="../html_exMPI03/html/index.html">standalone documentation </a>
 *  @ingroup extended_parallel_MPI
 *  @{
 */

/** @} */

/** @defgroup extended_parallel_MPI_libG4mpi libG4mpi
 *  Library libG4mpi
 *  @ingroup extended_parallel_MPI
 *  @{
 */

  class G4MPIbatch {};
  class G4MPIhistoMerger {};
  class G4MPImanager {};
  class G4MPImessenger {};
  class G4MPIrandomSeedGenerator {};
  class G4MPIrunMerger {};
  class G4MPIscorerMerger {};
  class G4MPIsession {};
  class G4MPIstatus {};
  class G4MPIutils {};
  class G4UImpish {};
  class G4VMPIseedGenerator {};
  class G4VMPIsession {};
  class G4VUserMPIrunMerger {};
 
/** @} */

/** @} */

/** @defgroup extended_parallel_TBB TBB
 *  Extended examples parallel TBB classes
 *  @{
 */

/** @defgroup extended_parallel_TBB_B2b TBB B2b
 *  Example TBB B2b 
 *  @ingroup extended_parallel_TBB
 *  @{
 */

  class B2ActionInitialization {};
  class B2bChamberParameterisation {};
  class B2bDetectorConstruction {};
  class B2bDetectorMessenger {};
  class B2EventAction {};
  class B2PrimaryGeneratorAction {};
  class B2RunAction {};
  class B2TrackerHit {};
  class B2TrackerSD {};
  class tbbMasterRunManager {};
  class tbbTask {};
  class tbbUserWorkerInitialization {};
  class tbbWorkerRunManager {};

/** @} */

/** @} */

/** @defgroup extended_parallel_TopC TopC
 *  Extended examples parallel TopC classes
 *  @{
 */


/** @defgroup extended_parallel_ParN02 ParN02
 *  Parallel ParN02 example has its 
 *  <a href="../html_ParN02/html/index.html">standalone documentation </a>
 *  @ingroup extended_parallel_TopC
 *  @{
 */

/** @} */

/** @defgroup extended_parallel_ParN04 ParN04
 *  Parallel ParN04 example has its 
 *  <a href="../html_ParN04/html/index.html">standalone documentation </a>
 *  @ingroup extended_parallel_TopC
 *  @{
 */

/** @} */

/** @} */

/** @defgroup extended_parallel_ThreadsafeScorers ThreadsafeScorers
 *  Example ThreadsafeScorers
 *  @ingroup extended_parallel
 *  @{
 */

  class G4TAtomicHitsCollection {};
  class G4TAtomicHitsMap {};
  class G4atomic {};
  class G4atomic_defines {};
  class TSActionInitialization {};
  class TSDetectorConstruction {};
  class TSPhysicsList {};
  class TSPrimaryGeneratorAction {};
  class TSRun {};
  class TSRunAction {};

/** @} */



/** @} */
