//$Id: MOMOpipe.java,v 1.2 2004/09/24 08:50:51 suzuki Exp $
//1999 Jan 5
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//

import java.io.*;

class MOMOpipe{
  private Process ps;
  private BufferedReader inpS, errS;
  private PrintWriter outS;
  private String errMsg;
  private boolean isErr;
  public boolean isMaking;

  MOMOpipe(String cmdMAKE){
    errMsg = null; isErr = false;
    try{
       ps = Runtime.getRuntime().exec(cmdMAKE);
    }catch(IOException e){
       isErr = true;
       errMsg = e.getMessage();
       return;
    }
    //    isMaking = true;
    inpS = new BufferedReader(new InputStreamReader(ps.getInputStream()));
    errS = new BufferedReader(new InputStreamReader(ps.getErrorStream()));
    outS = new PrintWriter(new DataOutputStream(ps.getOutputStream()));
  }
  String readStdLine(){
    String stdLine = null;
    try{
       stdLine = inpS.readLine();
    }catch(IOException e){
       isErr = true;
       errMsg = e.getMessage();
    }
    return stdLine;
  }
  String readErrLine(){
    String errLine = null;
    try{
      errLine = errS.readLine();
    }catch(IOException e){
       isErr = true;
       errMsg = e.getMessage();
       System.err.println(errMsg);
    }
    return errLine;
  }
  synchronized boolean writeLine(String st){
    outS.println(st);
    return outS.checkError();
  }
  synchronized void processKill(){
      //isMaking = false;
    ps.destroy();
  }
  boolean isError(){
    return isErr;
  }
  String getErrorMsg(){
    if (!isErr) return "";
    return errMsg;
  }
}






