//$Id: ParamPanel.java,v 1.5 2004/10/14 02:42:50 suzuki Exp $
// GAG (Geant4 Adaptive GUI)
// Requires : JDK 1.6
// 
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GAG;

import javax.swing.*;

//FileFilter of Swing1.0.2
import GAG.ExampleFileFilter;

import java.util.*;
import java.awt.*;
import java.io.*;
import java.awt.event.*;
import javax.swing.filechooser.*;
import java.util.Vector.*;

public class ParamPanel extends JPanel implements ActionListener, ItemListener {
  private GAG                gag;
  private GridBagLayout gbl; GridBagConstraints gbc;
  private JPanel             paramArea;
  private JButton            def, current, clear, ok, fileBrowser;
  private JComboBox          history;
  private int                posY;
  private GAGcommandItem     ci;
  private Component          paraBox[];
  private boolean            isExecuting;
  private JFileChooser       fileChooser;

  private ExampleFileFilter  g4mFilter, macroFilter, g4macroFilter,
                             txtFilter;
  //2004 test
  public String macroPath;

public  ParamPanel(GAG gag){
    isExecuting = false;                       //
    this.gag = gag;
    macroPath = gag.workdirpath;

    setLayout( new BorderLayout() );

    gbc = new GridBagConstraints();
    gbl = new GridBagLayout();

    paramArea = new JPanel();
    paramArea.setLayout(gbl);
    paramArea.setBackground(new Color(255, 250, 230));
    add("Center", new JScrollPane(paramArea));

    JPanel buttons = new JPanel();
    buttons.setLayout(new GridLayout( 1, 0, 2, 2));

//  Yoshida set colors of buttons
	def     = new JButton("Default");
	current = new JButton("Current");
	clear   = new JButton("Clear");
	ok      = new JButton("Execute");

	ok.setBackground(Color.green);
	def.setBackground(Color.blue);
	current.setBackground(Color.orange);
	clear.setBackground(SystemColor.white);

	buttons.add( def );
	buttons.add( current );
	buttons.add( clear );
	buttons.add( ok );

	add("South", buttons);

    history = new JComboBox();
        history.setEnabled(true);
        String titleHist = "#Command History List";    // dummy first line
        history.addItem(titleHist);
	history.addItemListener(this);
	//DEBUG  sometimes history becomes inactive...........??? 
	history.addActionListener(this);  //DEBUG listen to Item and Action
	add("North", history);

//yoshida setinvisible and setdisable default button
    def.setVisible(false);
    def.setEnabled(false);
    def.setMargin(new Insets(1,3,1,3));
    def.addActionListener(this);

//yoshida set visibility of current value button
    current.setVisible(false);
    current.setEnabled(false);
    current.setMargin(new Insets(1,3,1,3));
    current.addActionListener(this);

//yoshida set clear button
    clear.setVisible(false);
    clear.setEnabled(false);
    clear.setMargin(new Insets(1,3,1,3));
    clear.addActionListener(this);

//yoshida set execute button
    ok.setVisible(false);
    ok.setEnabled(false);
    ok.setMargin(new Insets(1,3,1,3));
    ok.addActionListener(this);

    fileBrowser = new JButton("Open a Macro File");
    fileBrowser.addActionListener(this);
    fileChooser = new JFileChooser(".");/// was macroPath
	fileChooser.setDialogTitle("Macro File");
        macroFilter = new ExampleFileFilter("mac", "Geant4 macro");
        g4mFilter = new ExampleFileFilter("g4m", "Geant4 macro");
        txtFilter = new ExampleFileFilter("txt", "Geant4 macro");
        fileChooser.addChoosableFileFilter(macroFilter);
	//        fileChooser.addChoosableFileFilter(g4mFilter);
	//        fileChooser.addChoosableFileFilter(txtFilter);


}     // end of constructor


  void setParamBox(GAGcommandItem ci, boolean enable){
      paramArea.removeAll();
      this.ci = ci;
      posY = 0;
      JLabel lab;
      if (!enable){
	  lab = new JLabel("This command is not available.");
	  lab.setForeground(Color.red);
	  addComponent(lab);
      }

      addComponent(new JLabel(ci.getCommandName()));
      String guide[] = ci.getCommandGuide(); 
      for (int i=0; i<guide.length; i++){
	  addComponent(new JLabel(guide[i]));
      }
      if (!ci.getCommandRange().equals("")){
	  lab = new JLabel(ci.getCommandRange());
	  lab.setForeground(Color.green);
	  addComponent(lab);
      }
      if (ci.getParamEntries() > 0){
	  def.setEnabled(true);

	  def.setVisible(true);
	  current.setEnabled(!isExecuting && enable);

	  current.setVisible(!isExecuting && enable);
	  clear.setEnabled(true);

	  clear.setVisible(true);
	  paraBox = new JComponent[ci.getParamEntries()];
	  String candidateList;
	  for (int i=0; i<ci.getParamEntries(); i++){
	      candidateList = ci.getParamCandidate(i);
	      if (candidateList.equals("")){
		  if (ci.getParamType(i).equals("b")){
		      paraBox[i] = new BooleanCombo(ci.getParamDefault(i));
		  }else{
		      paraBox[i] = new JTextField(20);
		      ((JTextField)paraBox[i]).setText(ci.getParamDefault(i));
		  }  
	      }else{
		  paraBox[i] = new JComboBox();
		  StringTokenizer st = new StringTokenizer(candidateList);
		  while(st.hasMoreTokens()){
		      ((JComboBox)paraBox[i]).addItem(st.nextToken());
		  }
		  if (!ci.getParamDefault(i).equals("")){
		      ((JComboBox)paraBox[i]).setSelectedItem(ci.getParamDefault(i));
		  }
	      }
	      addComponent(new JLabel(ci.getParamName(i)), paraBox[i], new JLabel("("+ci.getParamType(i) +") "+ci.getParamGuide(i) ));
	      if (ci.getParamName(i).equals("fileName")) addComponent(new JLabel(), fileBrowser);
	  }
      }else{

//yoshida setinvisible and then setdisable
	  def.setVisible(false);
	  def.setEnabled(false);
	  current.setVisible(false);
	  current.setEnabled(false);
	  clear.setVisible(false);
	  clear.setEnabled(false);
      }

      ok.setEnabled(!isExecuting && enable);
//yoshida OK button order of enable and visible is important
      ok.setVisible(!isExecuting && enable);

      validate();
      repaint();
      return;
  }



  void setTreeHelp(String dirHelp, JLabel helps[][]){
//yoshida setinvisible then setdisable
	ok.setVisible(false);
	ok.setEnabled(false);
	def.setVisible(false);
	def.setEnabled(false);
	current.setVisible(false);
	current.setEnabled(false);
	clear.setVisible(false);
	clear.setEnabled(false);
//
	paramArea.removeAll();
	posY = 0; ci = null;
	JLabel title = new JLabel(dirHelp);
	title.setForeground(Color.green);
	addComponent(title);
	for (int i=0; i<helps[0].length; i++){
	    addComponent(helps[0][i], helps[1][i]);
	}
	validate();
	repaint();
	return;
  }



    private String makeCommandLine(){
	StringBuffer param = new StringBuffer(ci.getCommandName());
	if (ci.getParamEntries() > 0){
	    String val;
	    for (int i=0; i<ci.getParamEntries(); i++){
		if (paraBox[i] instanceof JTextField){
		    val = (((JTextField)paraBox[i]).getText()).trim();
		    if (val.equals("")){
			if (!ci.isOmittable(i)){
			    JOptionPane.showMessageDialog(this, ci.getParamName(i)+
			     "\nThis parameter cannot be omitted.", "Error",
				 JOptionPane.WARNING_MESSAGE);
			    return null;
			}else{
			    if (!ci.getParamDefault(i).equals(""))
				val = ci.getParamDefault(i);
			    else{
				JOptionPane.showMessageDialog(this, ci.getParamName(i)+
				"\nThis omittable parameter has not default value.", 
				"Error", JOptionPane.WARNING_MESSAGE);
				return null;
			    }
			}
		    } //else if ( val.indexOf(" ") >= 0){
		      //JOptionPane.showMessageDialog(this, ci.getParamName(i)+
		      //	"\nThis parameter cannot include SPACE character", "Error",
			 //JOptionPane.WARNING_MESSAGE);
			//return null;
		    //}
		}else{
		    val = (String)((JComboBox)paraBox[i]).getSelectedItem(); 
		}
		param.append(" "+val);
	    } // end of loop 
//yoshida
	    current.setVisible(false);
	    current.setEnabled(false);
	}
//yoshida
	ok.setVisible(false);
	ok.setEnabled(false);
	history.addItem(param.toString());
	return param.toString();
    }


    //the first method

  private void addComponent(Component compo){
      gbc.gridx = 0; gbc.gridy = posY++;
      gbc.gridwidth = 3; gbc.gridheight = 1;
      gbc.weightx = 1.0; gbc.weighty = 0.0;
      gbc.anchor = GridBagConstraints.WEST;
      gbl.setConstraints(compo, gbc);
      paramArea.add(compo);
  }

    // the second method

  private void addComponent(Component compo1, Component compo2){
    gbc.gridx = 0; gbc.gridy = posY;
    gbc.gridwidth = 1; gbc.gridheight = 1;
    gbc.weightx = 0.0; gbc.weighty = 0.0;
    gbc.anchor = GridBagConstraints.EAST;
    gbl.setConstraints(compo1, gbc);
    paramArea.add(compo1);
    gbc.gridx = 1;
    gbc.anchor = GridBagConstraints.WEST;
    gbl.setConstraints(compo2, gbc);
    paramArea.add(compo2);
    posY++;
  }

    // the third method with title

  private void addComponent(Component title, Component compo1, Component compo2){
    gbc.gridx = 0; gbc.gridy = posY;
    gbc.gridwidth = 1; gbc.gridheight = 1;
    gbc.weightx = 0.0; gbc.weighty = 0.0;
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.EAST;
    gbl.setConstraints(title, gbc);
    paramArea.add(title);
    gbc.gridx = 1;
    gbc.fill = GridBagConstraints.HORIZONTAL;
    gbl.setConstraints(compo1, gbc);
    paramArea.add(compo1);
    gbc.gridx = 2;
    gbc.fill = GridBagConstraints.NONE;
    gbc.anchor = GridBagConstraints.WEST;
    gbl.setConstraints(compo2, gbc);
    paramArea.add(compo2);
    posY++;
  }



  private void loadValue(int i, String str){
    if (paraBox[i] instanceof JTextField){
      ((JTextField)paraBox[i]).setText(str);
    }
    if (paraBox[i] instanceof JComboBox){
      ((JComboBox)paraBox[i]).setSelectedItem(str);
    }
  }


    ///////////////////////////// history ////////////////////////////

  public void addHistory(String line){
    if (line.startsWith("/")) history.addItem(line);
  }

    public void clearAllHistory(){
       history.removeAllItems();    //bad. must keep 0-th title item   
       history.addItem("#Command History List");
  }

  public void clearOneHistory(){
    int ix = history.getSelectedIndex();
    if (ix > 0) history.removeItemAt(ix);    // 0-th must be kept
  }

    // to get history entries for save in a file

  public  Vector getHistoryItems(){           // use Vector in stead of array

    int no = history.getItemCount();
    Vector item = new Vector(no);

    for (int i=0; i<no; i++){
      item.add((String)history.getItemAt(i));
    }
    return item;
  }

  void loadCurrentValues(String line){
    StringTokenizer st = new StringTokenizer( line );
    st.nextToken();
    int i=0;
    while(st.hasMoreTokens()){
      loadValue(i++, st.nextToken());
    }
  }

    // history item was selected  2001  => Need DEBUG???? /vis/draw/current

  public void itemStateChanged(ItemEvent ie){
    if (isExecuting) return;
    if (ie.getStateChange() != ItemEvent.SELECTED) return;

    //    System.out.println("DEBUG : ItemEvent SELECTED");     //DEBUG 2001

    String str = (String)ie.getItem();
    if ( !str.startsWith("/") ) return;
    StringTokenizer st = new StringTokenizer( str );
    if (!gag.setParamPanel(st.nextToken())) return;
    int i=0;
    while(st.hasMoreTokens()){
      loadValue(i++, st.nextToken());
      if (i >= ci.getParamEntries()) return;
    }
  }

  public void actionPerformed(ActionEvent ev){
    Object source = ev.getSource();
    if ( source == ok ){
	// OK == green and No selected leaf  ==> panic
	//      System.out.println("DEBUG: Execute PUSHED");

      String p = makeCommandLine();

      //      System.out.println("DEBUG: Execute>>>>>>" + p);

      if (p == null) return;
      isExecuting = true;
      gag.sendCommand(p);

//yoshida  instead of sandwatch, ok button becomes invisible
      //	ok.setVisible(false);   // remove 2000
      //	ok.setEnabled(false);
// Be careful!  mouse may freeze, if setinvisible but not setdisabled!! 

      return;
    }else if (source == def){
      for (int i=0; ci.getParamEntries()>i; i++){
	loadValue(i, ci.getParamDefault(i));
      }
      return;
    }else if (source == current){
      gag.reqCurrent(ci.getCommandName());
      return;
    }else if (source == clear){
      for (int i=0; ci.getParamEntries()>i; i++){
	if (paraBox[i] instanceof JTextField){
	  ((JTextField)paraBox[i]).setText("");
	}
      }
      return;
    }else if (source == fileBrowser){
//swing102 filechooser showDialog(this, null) or the next
      //if (fileChooser.showOpenDialog(this) == -1 ) return;
      if (fileChooser.showOpenDialog(this) !=JFileChooser.APPROVE_OPTION)return;
      File f = fileChooser.getSelectedFile();
      if (f.isFile()) {
	if (paraBox[0] instanceof JTextField){
	  ((JTextField)paraBox[0]).setText(f.getPath());
	}
      }
      return;
    }
  }

    void toReady(){                     //executed in GAG.java when @@READY
	isExecuting = false;
	//ok.setEnabled(true);   //OK==green and No selected command is BAD
	//ok.setVisible(true);  // So, setenable must be after ci!=null etc.
	//repaint();
    if (ci == null) return;
    if (ci.getParamEntries() == 0) return;
	isExecuting = false;
	ok.setEnabled(true);   //yoshida setenable then setvisible
	ok.setVisible(true);
        current.setEnabled(true);
//yoshida
	current.setVisible(true);
	repaint();
  }
}

class BooleanCombo extends JComboBox {
  BooleanCombo(String str){
    String def = str.toUpperCase();
    if (def.equals("0") || def.equals("1")){
      addItem("0");
      addItem("1");
    }else if (def.equals("Y") || def.equals("N")){
      addItem("Y");
      addItem("N");
    }else if (def.equals("YES") || def.equals("NO")){
      addItem("YES");
      addItem("NO");
    }else if (def.equals("T") || def.equals("F")){
      addItem("T");
      addItem("F");
    } else {
      addItem("FALSE");
      addItem("TRUE");
    }
    if (!def.equals("")){
      setSelectedItem(def);
    }
  }
}














