//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: G4VMolecularDissociationDisplacer.cc 74551 2013-10-14 12:59:14Z gcosmo $
//
#include "G4VMolecularDissociationDisplacer.hh"
#include "G4Molecule.hh"

/*G4ThreadLocal*/ DisplacementType *G4VMolecularDecayDisplacer::Last = 0;
const DisplacementType G4VMolecularDecayDisplacer::NoDisplacement = G4VMolecularDecayDisplacer::AddDisplacement();

G4VMolecularDecayDisplacer::G4VMolecularDecayDisplacer()
{
    if (!Last) Last = new DisplacementType ( 0) ;
    fVerbose = 0;
}

G4VMolecularDecayDisplacer::~G4VMolecularDecayDisplacer()
{
    ;
}

DisplacementType G4VMolecularDecayDisplacer::AddDisplacement()
{
    if (!Last) Last = new DisplacementType ( 0) ;
    DisplacementType output = *Last;
    (*Last)++;
    return output;
}
